/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.pg.common.OracleCommonIteratorBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.rdbms.OracleElementIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraphException;
import oracle.pg.rdbms.Parameters;

public abstract class OracleCommonIteratorImpl
extends OracleCommonIteratorBase {
    static SimpleLog ms_log = SimpleLog.getLog(OracleCommonIteratorImpl.class);
    static boolean ms_bShowProgress = Parameters.getInstance().showProgress();
    protected boolean m_bTreatTimestampTzAsStr = Parameters.getInstance().getTreatTimestampTzAsStr();
    protected ResultSet rs = null;
    protected int queryFetchSize = 1000;

    protected OracleCommonIteratorImpl() {
    }

    public void setQueryFetchSize(int size) throws SQLException {
        this.queryFetchSize = size;
        if (this.rs != null) {
            this.rs.setFetchSize(size);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)("setQueryFetchSize: size " + size));
            }
        }
    }

    int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    protected boolean hasNextInternal() {
        boolean b;
        if (ms_log.isDebugEnabled() && Parameters.getInstance().isSuperVerboseOn()) {
            ms_log.debug((Object)"hasNextInternal: start");
        }
        try {
            if (this.m_bTimedOut && this.m_gracefulTimeout) {
                ms_log.debug((Object)"hasNextInternal: graceful timeout kicks in ");
                return false;
            }
            if (this.m_gracefulTimeout) {
                this.m_bTimedOut = this.checkGracefulTimeout();
            } else {
                this.checkQueryExecutionTimeOut();
            }
            if (this.rs == null) {
                ms_log.debug((Object)"hasNextInternal: rs is null");
                return false;
            }
            if (!this.bNextInovked) {
                if (ms_log.isDebugEnabled() && Parameters.getInstance().isSuperVerboseOn()) {
                    ms_log.debug((Object)"hasNextInternal: move cursor");
                }
                if (!(b = this.rs.next())) {
                    ms_log.debug((Object)"hasNextInternal: close statement");
                    this.safeCloseAndDeregisterIfNeeded(this.rs);
                    this.rs = null;
                }
            } else {
                if (ms_log.isDebugEnabled() && Parameters.getInstance().isSuperVerboseOn()) {
                    ms_log.debug((Object)"hasNextInternal: not move cursor");
                }
                return !this.bNextExhausted;
            }
            this.bNextInovked = true;
        }
        catch (Exception e) {
            SQLException sqle;
            this.safeCloseAndDeregisterIfNeeded(this.rs);
            this.rs = null;
            if (e instanceof SQLException && 1013 == (sqle = (SQLException)e).getErrorCode()) {
                this.m_bHitTimeoutAlready = true;
                if (this.m_gracefulTimeout) {
                    ms_log.debug((Object)"hasNextInternal: hit 1013 in gracefulTimeout. return false for hasNext");
                    return false;
                }
                throw new OraclePropertyGraphException((SQLException)e);
            }
            ms_log.debug((Object)"hasNextInternal: exception ", (Throwable)e);
            throw new OraclePropertyGraphException(e);
        }
        return b;
    }

    void safeCloseAndDeregisterIfNeeded(ResultSet rs) {
        ms_log.debug((Object)"safeCloseAndDeregisterIfNeeded: start");
        if (rs == null) {
            return;
        }
        ms_log.debug((Object)"safeCloseAndDeregisterIfNeeded: no need to deregister. Just close rs and statement");
        OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs);
    }

    void moveCursor() throws SQLException {
        if (ms_log.isDebugEnabled() && Parameters.getInstance().isSuperVerboseOn()) {
            ms_log.debug((Object)"moveCursor: start");
        }
        try {
            boolean bl = this.bNextExhausted = !this.rs.next();
            if (this.bNextExhausted) {
                this.bNextInovked = false;
            }
        }
        catch (SQLException sqle) {
            this.safeCloseAndDeregisterIfNeeded(this.rs);
            this.rs = null;
            this.bNextInovked = false;
            throw sqle;
        }
        try {
            if (this.rs != null && (this.rs.isAfterLast() || this.bNextExhausted)) {
                this.safeCloseAndDeregisterIfNeeded(this.rs);
                if (ms_bShowProgress) {
                    ms_log.debug((Object)"moveCursor: closed result set");
                }
                this.bNextInovked = false;
                this.rs = null;
            }
        }
        catch (Throwable t) {
            if (ms_log.isFatalEnabled()) {
                ms_log.fatal((Object)"moveCursor: close  ", t);
            }
            throw new OraclePropertyGraphException(t);
        }
        if (ms_log.isDebugEnabled() && Parameters.getInstance().isSuperVerboseOn()) {
            ms_log.debug((Object)"moveCursor: end");
        }
    }
}

