/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;

class InternalDS
implements DataSource {
    DataSource m_ds = null;

    private InternalDS(DataSource ds) {
        this.m_ds = ds;
    }

    static InternalDS getInstance(DataSource ds) {
        InternalDS ids = new InternalDS(ds);
        return ids;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = null;
        try {
            conn = this.m_ds.getConnection();
            return this.getConnectionAsOracleConnection(conn);
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            throw e;
        }
    }

    public OracleConnection getConnectionAsOracleConnection(Connection conn) throws SQLException {
        if (conn == null) {
            return null;
        }
        try {
            if (conn instanceof OracleConnection) {
                return (OracleConnection)conn;
            }
            return conn.unwrap(OracleConnection.class);
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            throw e;
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection conn = null;
        try {
            conn = this.m_ds.getConnection(username, password);
            return this.getConnectionAsOracleConnection(conn);
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            throw e;
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_ds.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_ds.getLogWriter();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_ds.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_ds.setLogWriter(out);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.m_ds.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.m_ds.unwrap(iface);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }
}

