/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import oracle.pg.common.SimpleLog;
import oracle.pg.common.messages.MesgConsts;
import oracle.pg.common.messages.Message;

public abstract class DataChange
implements MesgConsts {
    protected static final SimpleLog LOG = SimpleLog.getLog(DataChange.class);
    protected final ChangeAction changeAction;
    protected final Long elementId;
    protected final String propertyKey;
    protected final Object value;
    protected final Long startScn;
    protected final Long endScn;
    protected final String xId;

    protected DataChange(ChangeAction changeAction, Long elementId, String propertyKey, Object value, Long startScn, Long endScn, String xId) {
        this.changeAction = changeAction;
        this.propertyKey = propertyKey;
        this.elementId = elementId;
        this.value = value;
        this.startScn = startScn;
        this.endScn = endScn;
        this.xId = xId;
    }

    public ChangeAction getChangeAction() {
        return this.changeAction;
    }

    public String getKey() {
        return this.propertyKey;
    }

    public Long getID() {
        return this.elementId;
    }

    public Object getValue() {
        return this.value;
    }

    public Long getStartSCN() {
        return this.startScn;
    }

    public Long getEndSCN() {
        return this.endScn;
    }

    public String getXID() {
        return this.xId;
    }

    public static String pad(Long l, int length, char c) {
        if (l == null) {
            return DataChange.pad((String)null, length, c);
        }
        return DataChange.pad(l.toString(), length, c);
    }

    public static String pad(String s, int length, char c) {
        StringBuilder sb;
        block3: {
            block2: {
                sb = new StringBuilder();
                if (s != null) break block2;
                for (int idx = 0; idx < length; ++idx) {
                    sb.append(c);
                }
                break block3;
            }
            if (s.length() >= length) break block3;
            sb.append(s);
            for (int idx = 0; idx < length - s.length(); ++idx) {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static ChangeAction translateIntoChangeAction(String s) {
        if (s == null) {
            Message msg = new Message("ERR_INPUT_NOT_NULL");
            throw new IllegalArgumentException(msg.toString());
        }
        if ("I".equals(s)) {
            return ChangeAction.ADD;
        }
        if ("D".equals(s)) {
            return ChangeAction.REMOVE;
        }
        if ("U".equals(s)) {
            return ChangeAction.UPDATE;
        }
        Message msg = new Message("ERR_INVALID_CHANGE_ACTION", (Object)s);
        throw new IllegalArgumentException(msg.toString());
    }

    public static enum ChangeAction {
        ADD,
        REMOVE,
        UPDATE;

    }
}

