/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.pgx.common.auth.PgxRole;
import oracle.pgx.common.auth.PgxUser;

public class SerializationHelper {
    public static PgxUser parseUser(String userName, String userRoles, String userContext) throws IOException, ClassNotFoundException {
        String name = new String();
        if (!userName.isEmpty()) {
            name = (String)SerializationHelper.deserializeObject(userName);
        }
        HashSet roles = new HashSet();
        if (!userRoles.isEmpty()) {
            Set roleNames = (Set)SerializationHelper.deserializeObject(userRoles);
            roleNames.forEach(roleName -> roles.add(new PgxRole(roleName)));
        }
        Map context = new HashMap();
        if (!userContext.isEmpty()) {
            context = (Map)SerializationHelper.deserializeObject(userContext);
        }
        return new PgxUser(name, roles, context);
    }

    public static String serializeObject(Serializable obj) throws IOException {
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutStream = new ObjectOutputStream(byteOutStream);
        objectOutStream.writeObject(obj);
        objectOutStream.close();
        return Base64.getEncoder().encodeToString(byteOutStream.toByteArray());
    }

    public static Object deserializeObject(String str) throws IOException, ClassNotFoundException {
        byte[] bytes = Base64.getDecoder().decode(str);
        ObjectInputStream objectInStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object obj = objectInStream.readObject();
        objectInStream.close();
        return obj;
    }
}

