/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.hypermedia.uri;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.pgx.common.util.ErrorMessages;

final class UriComponent {
    private static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private static final String[] SCHEME = new String[]{"0-9", "A-Z", "a-z", "+", "-", "."};
    private static final String[] UNRESERVED = new String[]{"0-9", "A-Z", "a-z", "-", ".", "_", "~"};
    private static final String[] SUB_DELIMS = new String[]{"!", "$", "&", "'", "(", ")", "*", "+", ",", ";", "="};
    private static final boolean[][] ENCODING_TABLES = UriComponent.initEncodingTables();
    private static final int[] HEX_TABLE = UriComponent.initHexTable();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private UriComponent() {
    }

    private static boolean[][] initEncodingTables() {
        boolean[][] tables = new boolean[Type.values().length][];
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(Arrays.asList(SCHEME));
        tables[Type.SCHEME.ordinal()] = UriComponent.initEncodingTable(l);
        l.clear();
        l.addAll(Arrays.asList(UNRESERVED));
        tables[Type.UNRESERVED.ordinal()] = UriComponent.initEncodingTable(l);
        l.addAll(Arrays.asList(SUB_DELIMS));
        tables[Type.HOST.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.PORT.ordinal()] = UriComponent.initEncodingTable(Arrays.asList("0-9"));
        l.add(":");
        tables[Type.USER_INFO.ordinal()] = UriComponent.initEncodingTable(l);
        l.add("@");
        tables[Type.AUTHORITY.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.PATH_SEGMENT.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.PATH_SEGMENT.ordinal()][59] = false;
        tables[Type.MATRIX_PARAM.ordinal()] = (boolean[])tables[Type.PATH_SEGMENT.ordinal()].clone();
        tables[Type.MATRIX_PARAM.ordinal()][61] = false;
        l.add("/");
        tables[Type.PATH.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.QUERY.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.QUERY.ordinal()][33] = false;
        tables[Type.QUERY.ordinal()][42] = false;
        tables[Type.QUERY.ordinal()][39] = false;
        tables[Type.QUERY.ordinal()][40] = false;
        tables[Type.QUERY.ordinal()][41] = false;
        tables[Type.QUERY.ordinal()][59] = false;
        tables[Type.QUERY.ordinal()][58] = false;
        tables[Type.QUERY.ordinal()][64] = false;
        tables[Type.QUERY.ordinal()][36] = false;
        tables[Type.QUERY.ordinal()][44] = false;
        tables[Type.QUERY.ordinal()][47] = false;
        tables[Type.QUERY.ordinal()][63] = false;
        tables[Type.QUERY_PARAM.ordinal()] = Arrays.copyOf(tables[Type.QUERY.ordinal()], tables[Type.QUERY.ordinal()].length);
        tables[Type.QUERY_PARAM.ordinal()][61] = false;
        tables[Type.QUERY_PARAM.ordinal()][43] = false;
        tables[Type.QUERY_PARAM.ordinal()][38] = false;
        tables[Type.QUERY_PARAM_SPACE_ENCODED.ordinal()] = tables[Type.QUERY_PARAM.ordinal()];
        tables[Type.FRAGMENT.ordinal()] = tables[Type.QUERY.ordinal()];
        return tables;
    }

    private static boolean[] initEncodingTable(List<String> allowed) {
        boolean[] table = new boolean[128];
        for (String range : allowed) {
            if (range.length() == 1) {
                table[range.charAt((int)0)] = true;
                continue;
            }
            if (range.length() != 3 || range.charAt(1) != '-') continue;
            for (int i = range.charAt(0); i <= range.charAt(2); ++i) {
                table[i] = true;
            }
        }
        return table;
    }

    public static void validate(String s, Type t) {
        UriComponent.validate(s, t, false);
    }

    public static void validate(String s, Type t, boolean template) {
        int i = UriComponent.validUri(s, t, template);
        if (i > -1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_COMPONENT_INVALID_CHARACTER", (Object[])new Object[]{s, t, Character.valueOf(s.charAt(i)), i}));
        }
    }

    public static boolean valid(String s, Type t) {
        return UriComponent.valid(s, t, false);
    }

    public static boolean valid(String s, Type t, boolean template) {
        return UriComponent.validUri(s, t, template) == -1;
    }

    private static int validUri(String s, Type t, boolean template) {
        boolean[] table = ENCODING_TABLES[t.ordinal()];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c >= '\u0080' || c == '%' || table[c]) && c < '\u0080' || template && (c == '{' || c == '}')) continue;
            return i;
        }
        return -1;
    }

    public static String encodeTemplateNames(String s) {
        int i = s.indexOf(123);
        if (i != -1) {
            s = s.replace("{", "%7B");
        }
        if ((i = s.indexOf(125)) != -1) {
            s = s.replace("}", "%7D");
        }
        return s;
    }

    private static String encodeUri(String s, Type t, boolean template, boolean contextualEncode) {
        int codePoint;
        boolean[] table = ENCODING_TABLES[t.ordinal()];
        boolean insideTemplateParam = false;
        StringBuilder sb = null;
        for (int offset = 0; offset < s.length(); offset += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(offset);
            if (codePoint < 128 && table[codePoint]) {
                if (sb == null) continue;
                sb.append((char)codePoint);
                continue;
            }
            if (template) {
                boolean leavingTemplateParam = false;
                if (codePoint == 123) {
                    insideTemplateParam = true;
                } else if (codePoint == 125) {
                    insideTemplateParam = false;
                    leavingTemplateParam = true;
                }
                if (insideTemplateParam || leavingTemplateParam) {
                    if (sb == null) continue;
                    sb.append(Character.toChars(codePoint));
                    continue;
                }
            }
            if (contextualEncode && codePoint == 37 && offset + 2 < s.length() && UriComponent.isHexCharacter(s.charAt(offset + 1)) && UriComponent.isHexCharacter(s.charAt(offset + 2))) {
                if (sb != null) {
                    sb.append('%').append(s.charAt(offset + 1)).append(s.charAt(offset + 2));
                }
                offset += 2;
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(s.substring(0, offset));
            }
            if (codePoint < 128) {
                if (codePoint == 32 && t == Type.QUERY_PARAM) {
                    sb.append('+');
                    continue;
                }
                UriComponent.appendPercentEncodedOctet(sb, (char)codePoint);
                continue;
            }
            UriComponent.appendUTF8EncodedCharacter(sb, codePoint);
        }
        return sb == null ? s : sb.toString();
    }

    private static int[] initHexTable() {
        int c;
        int[] table = new int[128];
        Arrays.fill(table, -1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            table[c] = c - 48;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            table[c] = c - 65 + 10;
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            table[c] = c - 97 + 10;
        }
        return table;
    }

    public static boolean isHexCharacter(char c) {
        return c < '\u0080' && HEX_TABLE[c] != -1;
    }

    private static void appendPercentEncodedOctet(StringBuilder sb, int b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4]);
        sb.append(HEX_DIGITS[b & 0xF]);
    }

    private static void appendUTF8EncodedCharacter(StringBuilder sb, int codePoint) {
        CharBuffer chars = CharBuffer.wrap(Character.toChars(codePoint));
        ByteBuffer bytes = UTF_8_CHARSET.encode(chars);
        while (bytes.hasRemaining()) {
            UriComponent.appendPercentEncodedOctet(sb, bytes.get() & 0xFF);
        }
    }

    public static String contextualEncode(String s, Type t) {
        return UriComponent.encodeUri(s, t, false, true);
    }

    public static String contextualEncode(String s, Type t, boolean template) {
        return UriComponent.encodeUri(s, t, template, true);
    }

    public static String encode(String s, Type t) {
        return UriComponent.encodeUri(s, t, false, false);
    }

    public static String encode(String s, Type t, boolean template) {
        return UriComponent.encodeUri(s, t, template, false);
    }

    public static enum Type {
        UNRESERVED,
        SCHEME,
        AUTHORITY,
        USER_INFO,
        HOST,
        PORT,
        PATH,
        PATH_SEGMENT,
        MATRIX_PARAM,
        QUERY,
        QUERY_PARAM,
        QUERY_PARAM_SPACE_ENCODED,
        FRAGMENT;

    }
}

