import os
import logging
import yaml
import json
from jsonschema import Draft7Validator

schemaVersion = "0.0.1"

schema = {   "type": "object",
            "required":["id"],
            "properties": {
               "hasDocumentation": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "keywords": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasGrid": {
                  "items": {
                     "$ref": "#/Grid"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "softwareRequirements": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasImplementationScriptLocation": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasDownloadURL": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "type": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasInstallationInstructions": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "compatibleVisualizationSoftware": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasRegion": {
                  "items": {
                     "$ref": "#/Region"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasFAQ": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "logo": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasContactPerson": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "id": {
                  "type": "string"
               },
               "identifier": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasSampleExecution": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasSampleResult": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "author": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasConstraint": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "shortDescription": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasExecutionCommand": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "datePublished": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "license": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasSourceCode": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasSetup": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasExplanationDiagram": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasExample": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "publisher": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasOutput": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasOutputTimeInterval": {
                  "items": {
                     "$ref": "#/TimeInterval"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasFunding": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasComponentLocation": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasProcess": {
                  "items": {
                     "$ref": "#/Process"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "supportDetails": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasVersion": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasTypicalDataSource": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "referencePublication": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "description": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "screenshot": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasModelCategory": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hadPrimarySource": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasSoftwareImage": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "dateCreated": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "contributor": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasModelResultTable": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasPurpose": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasSampleVisualization": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasCausalDiagram": {
                  "items": {
                     "$ref": "#/CausalDiagram"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "memoryRequirements": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "website": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "citation": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "processorRequirements": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasUsageNotes": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasSupportScriptLocation": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "label": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasAssumption": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasParameter": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "operatingSystems": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasEquation": {
                  "items": {
                     "$ref": "#/Equation"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "usefulForCalculatingIndex": {
                  "items": {
                     "$ref": "#/NumericalIndex"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasInput": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               }
            }
         ,
         "Grid": {
            "properties": {
               "hasDimensionality": {
                  "items": {
                     "type": "number"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasFormat": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasFileStructure": {
                  "nullable": True,
                  "type": "object"
               },
               "description": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasPresentation": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "label": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "type": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasFixedResource": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasCoordinateSystem": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasSpatialResolution": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasShape": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasDimension": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "position": {
                  "items": {
                     "type": "number"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "id": {
                  "nullable": False,
                  "type": "string"
               }
            },
            "type": "object"
         },
         "Region": {
            "properties": {
               "geo": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "description": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "country": {
                  "items": {
                     "$ref": "#/components/schemas/Region"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "id": {
                  "nullable": False,
                  "type": "string"
               },
               "label": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "type": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               }
            },
            "type": "object"
         },
         "TimeInterval": {
            "properties": {
               "description": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "id": {
                  "nullable": False,
                  "type": "string"
               },
               "label": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "type": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "intervalValue": {
                  "items": {
                     "type": "number"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "intervalUnit": {
                  "items": {
                     "type": "object"
                  },
                  "nullable": True,
                  "type": "array"
               }
            },
            "type": "object"
         },
         "Process": {
            "properties": {
               "description": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "id": {
                  "nullable": False,
                  "type": "string"
               },
               "label": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "type": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "influences": {
                  "items": {
                     "$ref": "#/Process"
                  },
                  "nullable": True,
                  "type": "array"
               }
            },
            "type": "object"
         },
         "CausalDiagram": {
            "properties": {
               "description": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "id": {
                  "nullable": False,
                  "type": "string"
               },
               "label": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "type": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "hasPart": {
                  "items": {
                     "type": ["object","string"]
                  },
                  "nullable": True,
                  "type": "array"
               }
            },
            "type": ["object"]
         },
         "Equation": {
            "properties": {
               "description": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "id": {
                  "nullable": False,
                  "type": "string"
               },
               "label": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "type": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               }
            },
            "type": "object"
         },
         "NumericalIndex": {
            "properties": {
               "description": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "id": {
                  "nullable": False,
                  "type": "string"
               },
               "label": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               },
               "type": {
                  "items": {
                     "type": "string"
                  },
                  "nullable": True,
                  "type": "array"
               }
            },
            "type": "object"
         }
      }


def get_hr_metadata():
    return """# This is a basic yaml example. Remove any unneeded \"optional\" parameters
modelName: # String name of model
modelVersion: # String version number
configuration: # String configuration
setup: # String set up
#shortName maps to label.
shortName: # String short name
description:
   - # String description
author:
   - name: # String name. Assumes type is person unless a type:Organization is added.
contributor: # Optional contributors to model
   - 
      name:  # Name of contributor
   - 
      name: # Multiple contributers supported
      email: # Emails can also be added
hasComponentLocation: # URL to executable components
   - https://Link-to-location/
hasSoftwareImage: # Docker Image Id (ie: mintproject/economic:v2)
keywords:
   - comma; seperated; keywords
hasGrid: # Optional
   - 
      shortName:  # String name
      description:
         - # String description
      hasDimension:  # Dimensionality (ie: 0D)
      hasShape:  # Shape (ie: Point)
      hasSpatialResolution:  # String spatial resolution (ie: Point)
hasModelCategory: # Optional
   - # String category (ie: Hydrology)
hasRegion: # Optional
   - 
      description:
         - # String description
      shortName: # String name
hasSourceCode: # Optional metadata about source code
   - codeRepository: https://link-to-code-repo/
hasOutputTimeInterval: # Optional
   - 
      shortName: name of time interval
      description:
         - Enter description for time interval here
      intervalUnit: # Unit for time interval (e.g., day) 
      intervalValue: # Value of time interval (e.g., 1)
hasProcess: # each will be mapped to an object.
  - process 1
  - process 2
  - process n\n"""


# Creates human readable inputs text block
def get_hr_inputs(num):
    return """  # Details of input %i
  - shortName: Name of input %i
    description:
      - Enter description for input %i here
    position: %i
    hasValue:  # Complete if this input should use data from a given URL
       - shortName:  # Value Name
         url:  # http://URL-to-value/
    type:  # https://URL-to-type/ This field is optional
    variables:  # Optional (only if variables are known)
       - shortName:  # Name of var
          description:
            - Description of var
          hasLongName: long name of var  # string
          hasStandardName:  # is there a standard name this variable maps to?
          usesUnit:  # units\n\n""" % (num, num, num, num)


# Creates human readable output text block
def get_hr_outputs(num):
    return """  #output %i
  - shortName: # String name of output %i
    description:
      - Enter description for output %i
    hasDimensionality: # Int of dimensionality
    hasFormat: # String format (ie: csv)
    position: %i
    type:
       - https://link-to-type
    variables:
       - shortName: exampleVar1
         description:
            - description for exampleVar1
       - short_name: exampleVar2
         description:
            - description for exampleVar2\n\n""" % (num, num, num, num)


# Creates human readable parameter text block
def get_hr_parameters(num):
    return """  # Parameter %i
  - shortName: # String name of parameter %i
    description:
       - Description of parameter %i
    usesUnit: # String unit (ie "km")
    value: # Optional: If the parameter has fixed value in this setup, add it here\n\n""" % (num, num, num)




v = Draft7Validator(schema)


def get_schema():
    return schema


def get_schema_version():
    return schemaVersion


def _msg(e):
    """Generate a user friendly error message."""
    return e.message


def check_package_spec(spec):
    """Check package specification."""
    err = []
    for e in v.iter_errors(spec):
        err.append(_msg(e))
        logging.error(_msg(e))
    
    if err:
        raise ValueError("Invalid component specification.")
    logging.info("Metadata YAML is validated successfully.")
   

def validate_file(metadata_path):
    with open(metadata_path, 'r') as metadata_stream:
        metadata_loaded = json.load(metadata_stream)
    
    with open("./files/temp.yaml", "w") as f:
        f.write(yaml.dump(metadata_loaded))
    
    with open("./files/temp.yaml", "r") as fp:
        metadata_yaml = yaml.safe_load(fp)
        check_package_spec(metadata_yaml)
