"""
Copyright (c) 2019-2021 Cypress Semiconductor Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
from abc import ABC, abstractmethod


class PolicyValidatorBase(ABC):
    """
    Base class for the classes that implement policy validator.
    Each device-specific policy validator must implement its methods.
    """

    skip_validation = False

    @abstractmethod
    def validate(self, skip=None, skip_prompts=False):
        """ Validates policy file """
