
# This file is automatically generated by setup.py
"""
Version info for dask_traj.

``full_version`` gives the most information about the current state. It is
always the short (PEP440) version string, followed by a git hash as
``+gGITHASH``. If the install is not in a live git repository, that hash is
followed by ``.install``, and represents the commit that was installed. In a
live repository, it represents the active state.
"""

import os
import subprocess

# this is automatically generated from the code in setup.py
def get_git_version():
    """
    Return the git hash as a string.

    Apparently someone got this from numpy's setup.py. It has since been
    modified a few times.
    """
    # Return the git revision as a string
    # copied from numpy setup.py
    def _minimal_ext_cmd(cmd):
        # construct minimal environment
        env = {}
        for k in ["SYSTEMROOT", "PATH"]:
            v = os.environ.get(k)
            if v is not None:
                env[k] = v
        # LANGUAGE is used on win32
        env["LANGUAGE"] = "C"
        env["LANG"] = "C"
        env["LC_ALL"] = "C"
        with open(os.devnull, "w") as err_out:
            out = subprocess.Popen(
                cmd,
                stdout=subprocess.PIPE,
                stderr=err_out,  # maybe debug later?
                env=env,
            ).communicate()[0]
        return out

    try:
        git_dir = os.path.dirname(os.path.realpath(__file__))
        out = _minimal_ext_cmd(["git", "-C", git_dir, "rev-parse", "HEAD"])
        GIT_REVISION = out.strip().decode("ascii")
    except OSError:
        GIT_REVISION = "Unknown"

    return GIT_REVISION


short_version = '0.2.1'
version = '0.2.1'
installed_git_hash = '2c986bb835145b4ffbed187b7daa9db827deacc6'
full_version = version + '+g' + installed_git_hash[:7] + '.install'
release = True
git_hash = 'Unknown'  # default

if not release:
    git_hash = get_git_version()
    if git_hash != '' and git_hash != 'Unknown':
        full_version = version + '+g' + git_hash[:7]

    version = full_version
