# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Metrics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Metrics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'order': 'int',
            'metric_definition_name': 'str',
            'metric_definition_id': 'str',
            'external_metric_definition_id': 'str',
            'unit_type': 'str',
            'enabled': 'bool',
            'template_name': 'str',
            'max_points': 'int',
            'performance_profile_id': 'str',
            'unit_definition': 'str',
            'precision': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'order': 'order',
            'metric_definition_name': 'metricDefinitionName',
            'metric_definition_id': 'metricDefinitionId',
            'external_metric_definition_id': 'externalMetricDefinitionId',
            'unit_type': 'unitType',
            'enabled': 'enabled',
            'template_name': 'templateName',
            'max_points': 'maxPoints',
            'performance_profile_id': 'performanceProfileId',
            'unit_definition': 'unitDefinition',
            'precision': 'precision',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._order = None
        self._metric_definition_name = None
        self._metric_definition_id = None
        self._external_metric_definition_id = None
        self._unit_type = None
        self._enabled = None
        self._template_name = None
        self._max_points = None
        self._performance_profile_id = None
        self._unit_definition = None
        self._precision = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Metrics.
        The globally unique identifier for the object.

        :return: The id of this Metrics.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Metrics.
        The globally unique identifier for the object.

        :param id: The id of this Metrics.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Metrics.


        :return: The name of this Metrics.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Metrics.


        :param name: The name of this Metrics.
        :type: str
        """
        
        self._name = name

    @property
    def order(self):
        """
        Gets the order of this Metrics.
        The order of metric within a performance profile

        :return: The order of this Metrics.
        :rtype: int
        """
        return self._order

    @order.setter
    def order(self, order):
        """
        Sets the order of this Metrics.
        The order of metric within a performance profile

        :param order: The order of this Metrics.
        :type: int
        """
        
        self._order = order

    @property
    def metric_definition_name(self):
        """
        Gets the metric_definition_name of this Metrics.
        The name of associated metric definition

        :return: The metric_definition_name of this Metrics.
        :rtype: str
        """
        return self._metric_definition_name

    @metric_definition_name.setter
    def metric_definition_name(self, metric_definition_name):
        """
        Sets the metric_definition_name of this Metrics.
        The name of associated metric definition

        :param metric_definition_name: The metric_definition_name of this Metrics.
        :type: str
        """
        
        self._metric_definition_name = metric_definition_name

    @property
    def metric_definition_id(self):
        """
        Gets the metric_definition_id of this Metrics.
        The id of associated metric definition

        :return: The metric_definition_id of this Metrics.
        :rtype: str
        """
        return self._metric_definition_id

    @metric_definition_id.setter
    def metric_definition_id(self, metric_definition_id):
        """
        Sets the metric_definition_id of this Metrics.
        The id of associated metric definition

        :param metric_definition_id: The metric_definition_id of this Metrics.
        :type: str
        """
        
        self._metric_definition_id = metric_definition_id

    @property
    def external_metric_definition_id(self):
        """
        Gets the external_metric_definition_id of this Metrics.
        The id of associated external metric definition

        :return: The external_metric_definition_id of this Metrics.
        :rtype: str
        """
        return self._external_metric_definition_id

    @external_metric_definition_id.setter
    def external_metric_definition_id(self, external_metric_definition_id):
        """
        Sets the external_metric_definition_id of this Metrics.
        The id of associated external metric definition

        :param external_metric_definition_id: The external_metric_definition_id of this Metrics.
        :type: str
        """
        
        self._external_metric_definition_id = external_metric_definition_id

    @property
    def unit_type(self):
        """
        Gets the unit_type of this Metrics.
        Corresponding unit type for this metric

        :return: The unit_type of this Metrics.
        :rtype: str
        """
        return self._unit_type

    @unit_type.setter
    def unit_type(self, unit_type):
        """
        Sets the unit_type of this Metrics.
        Corresponding unit type for this metric

        :param unit_type: The unit_type of this Metrics.
        :type: str
        """
        allowed_values = ["None", "Percent", "Currency", "Seconds", "Number", "AttendanceStatus", "Unit"]
        if unit_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for unit_type -> " + unit_type)
            self._unit_type = "outdated_sdk_version"
        else:
            self._unit_type = unit_type

    @property
    def enabled(self):
        """
        Gets the enabled of this Metrics.
        A flag for whether this metric is enabled for a performance profile

        :return: The enabled of this Metrics.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this Metrics.
        A flag for whether this metric is enabled for a performance profile

        :param enabled: The enabled of this Metrics.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def template_name(self):
        """
        Gets the template_name of this Metrics.
        The name of associated objective template

        :return: The template_name of this Metrics.
        :rtype: str
        """
        return self._template_name

    @template_name.setter
    def template_name(self, template_name):
        """
        Sets the template_name of this Metrics.
        The name of associated objective template

        :param template_name: The template_name of this Metrics.
        :type: str
        """
        
        self._template_name = template_name

    @property
    def max_points(self):
        """
        Gets the max_points of this Metrics.
        Achievable maximum points for this metric

        :return: The max_points of this Metrics.
        :rtype: int
        """
        return self._max_points

    @max_points.setter
    def max_points(self, max_points):
        """
        Sets the max_points of this Metrics.
        Achievable maximum points for this metric

        :param max_points: The max_points of this Metrics.
        :type: int
        """
        
        self._max_points = max_points

    @property
    def performance_profile_id(self):
        """
        Gets the performance_profile_id of this Metrics.
        Performance profile id of this metric

        :return: The performance_profile_id of this Metrics.
        :rtype: str
        """
        return self._performance_profile_id

    @performance_profile_id.setter
    def performance_profile_id(self, performance_profile_id):
        """
        Sets the performance_profile_id of this Metrics.
        Performance profile id of this metric

        :param performance_profile_id: The performance_profile_id of this Metrics.
        :type: str
        """
        
        self._performance_profile_id = performance_profile_id

    @property
    def unit_definition(self):
        """
        Gets the unit_definition of this Metrics.
        Unit definition of linked external metric

        :return: The unit_definition of this Metrics.
        :rtype: str
        """
        return self._unit_definition

    @unit_definition.setter
    def unit_definition(self, unit_definition):
        """
        Sets the unit_definition of this Metrics.
        Unit definition of linked external metric

        :param unit_definition: The unit_definition of this Metrics.
        :type: str
        """
        
        self._unit_definition = unit_definition

    @property
    def precision(self):
        """
        Gets the precision of this Metrics.
        Precision of linked external metric

        :return: The precision of this Metrics.
        :rtype: int
        """
        return self._precision

    @precision.setter
    def precision(self, precision):
        """
        Sets the precision of this Metrics.
        Precision of linked external metric

        :param precision: The precision of this Metrics.
        :type: int
        """
        
        self._precision = precision

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Metrics.
        The URI for this object

        :return: The self_uri of this Metrics.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Metrics.
        The URI for this object

        :param self_uri: The self_uri of this Metrics.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

