import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MysqlServiceInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#availability_domain MysqlServiceInstance#availability_domain}
    */
    readonly availabilityDomain?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#backup_destination MysqlServiceInstance#backup_destination}
    */
    readonly backupDestination?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#description MysqlServiceInstance#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#id MysqlServiceInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#ip_network MysqlServiceInstance#ip_network}
    */
    readonly ipNetwork?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#metering_frequency MysqlServiceInstance#metering_frequency}
    */
    readonly meteringFrequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#name MysqlServiceInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#notification_email MysqlServiceInstance#notification_email}
    */
    readonly notificationEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#region MysqlServiceInstance#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#shape MysqlServiceInstance#shape}
    */
    readonly shape: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#ssh_public_key MysqlServiceInstance#ssh_public_key}
    */
    readonly sshPublicKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#subnet MysqlServiceInstance#subnet}
    */
    readonly subnet?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#vm_user MysqlServiceInstance#vm_user}
    */
    readonly vmUser?: string;
    /**
    * backups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#backups MysqlServiceInstance#backups}
    */
    readonly backups?: MysqlServiceInstanceBackups;
    /**
    * mysql_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#mysql_configuration MysqlServiceInstance#mysql_configuration}
    */
    readonly mysqlConfiguration: MysqlServiceInstanceMysqlConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#timeouts MysqlServiceInstance#timeouts}
    */
    readonly timeouts?: MysqlServiceInstanceTimeouts;
}
export interface MysqlServiceInstanceBackups {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#cloud_storage_container MysqlServiceInstance#cloud_storage_container}
    */
    readonly cloudStorageContainer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#cloud_storage_password MysqlServiceInstance#cloud_storage_password}
    */
    readonly cloudStoragePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#cloud_storage_username MysqlServiceInstance#cloud_storage_username}
    */
    readonly cloudStorageUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#create_if_missing MysqlServiceInstance#create_if_missing}
    */
    readonly createIfMissing?: boolean | cdktf.IResolvable;
}
export declare function mysqlServiceInstanceBackupsToTerraform(struct?: MysqlServiceInstanceBackupsOutputReference | MysqlServiceInstanceBackups): any;
export declare class MysqlServiceInstanceBackupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlServiceInstanceBackups | undefined;
    set internalValue(value: MysqlServiceInstanceBackups | undefined);
    private _cloudStorageContainer?;
    get cloudStorageContainer(): string;
    set cloudStorageContainer(value: string);
    get cloudStorageContainerInput(): string | undefined;
    private _cloudStoragePassword?;
    get cloudStoragePassword(): string;
    set cloudStoragePassword(value: string);
    resetCloudStoragePassword(): void;
    get cloudStoragePasswordInput(): string | undefined;
    private _cloudStorageUsername?;
    get cloudStorageUsername(): string;
    set cloudStorageUsername(value: string);
    resetCloudStorageUsername(): void;
    get cloudStorageUsernameInput(): string | undefined;
    private _createIfMissing?;
    get createIfMissing(): boolean | cdktf.IResolvable;
    set createIfMissing(value: boolean | cdktf.IResolvable);
    resetCreateIfMissing(): void;
    get createIfMissingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#em_agent_password MysqlServiceInstance#em_agent_password}
    */
    readonly emAgentPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#em_agent_username MysqlServiceInstance#em_agent_username}
    */
    readonly emAgentUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#em_password MysqlServiceInstance#em_password}
    */
    readonly emPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#em_port MysqlServiceInstance#em_port}
    */
    readonly emPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#em_username MysqlServiceInstance#em_username}
    */
    readonly emUsername?: string;
}
export declare function mysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationToTerraform(struct?: MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationOutputReference | MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfiguration): any;
export declare class MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfiguration | undefined;
    set internalValue(value: MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfiguration | undefined);
    private _emAgentPassword?;
    get emAgentPassword(): string;
    set emAgentPassword(value: string);
    resetEmAgentPassword(): void;
    get emAgentPasswordInput(): string | undefined;
    private _emAgentUsername?;
    get emAgentUsername(): string;
    set emAgentUsername(value: string);
    resetEmAgentUsername(): void;
    get emAgentUsernameInput(): string | undefined;
    private _emPassword?;
    get emPassword(): string;
    set emPassword(value: string);
    resetEmPassword(): void;
    get emPasswordInput(): string | undefined;
    private _emPort?;
    get emPort(): number;
    set emPort(value: number);
    resetEmPort(): void;
    get emPortInput(): number | undefined;
    private _emUsername?;
    get emUsername(): string;
    set emUsername(value: string);
    resetEmUsername(): void;
    get emUsernameInput(): string | undefined;
}
export interface MysqlServiceInstanceMysqlConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#db_name MysqlServiceInstance#db_name}
    */
    readonly dbName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#db_storage MysqlServiceInstance#db_storage}
    */
    readonly dbStorage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#mysql_charset MysqlServiceInstance#mysql_charset}
    */
    readonly mysqlCharset?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#mysql_collation MysqlServiceInstance#mysql_collation}
    */
    readonly mysqlCollation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#mysql_password MysqlServiceInstance#mysql_password}
    */
    readonly mysqlPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#mysql_port MysqlServiceInstance#mysql_port}
    */
    readonly mysqlPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#mysql_username MysqlServiceInstance#mysql_username}
    */
    readonly mysqlUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#snapshot_name MysqlServiceInstance#snapshot_name}
    */
    readonly snapshotName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#source_service_name MysqlServiceInstance#source_service_name}
    */
    readonly sourceServiceName?: string;
    /**
    * enterprise_monitor_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#enterprise_monitor_configuration MysqlServiceInstance#enterprise_monitor_configuration}
    */
    readonly enterpriseMonitorConfiguration?: MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfiguration;
}
export declare function mysqlServiceInstanceMysqlConfigurationToTerraform(struct?: MysqlServiceInstanceMysqlConfigurationOutputReference | MysqlServiceInstanceMysqlConfiguration): any;
export declare class MysqlServiceInstanceMysqlConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlServiceInstanceMysqlConfiguration | undefined;
    set internalValue(value: MysqlServiceInstanceMysqlConfiguration | undefined);
    get connectString(): string;
    private _dbName?;
    get dbName(): string;
    set dbName(value: string);
    resetDbName(): void;
    get dbNameInput(): string | undefined;
    private _dbStorage?;
    get dbStorage(): number;
    set dbStorage(value: number);
    resetDbStorage(): void;
    get dbStorageInput(): number | undefined;
    get ipAddress(): string;
    private _mysqlCharset?;
    get mysqlCharset(): string;
    set mysqlCharset(value: string);
    resetMysqlCharset(): void;
    get mysqlCharsetInput(): string | undefined;
    private _mysqlCollation?;
    get mysqlCollation(): string;
    set mysqlCollation(value: string);
    resetMysqlCollation(): void;
    get mysqlCollationInput(): string | undefined;
    private _mysqlPassword?;
    get mysqlPassword(): string;
    set mysqlPassword(value: string);
    resetMysqlPassword(): void;
    get mysqlPasswordInput(): string | undefined;
    private _mysqlPort?;
    get mysqlPort(): number;
    set mysqlPort(value: number);
    resetMysqlPort(): void;
    get mysqlPortInput(): number | undefined;
    private _mysqlUsername?;
    get mysqlUsername(): string;
    set mysqlUsername(value: string);
    resetMysqlUsername(): void;
    get mysqlUsernameInput(): string | undefined;
    get publicIpAddress(): string;
    private _snapshotName?;
    get snapshotName(): string;
    set snapshotName(value: string);
    resetSnapshotName(): void;
    get snapshotNameInput(): string | undefined;
    private _sourceServiceName?;
    get sourceServiceName(): string;
    set sourceServiceName(value: string);
    resetSourceServiceName(): void;
    get sourceServiceNameInput(): string | undefined;
    private _enterpriseMonitorConfiguration;
    get enterpriseMonitorConfiguration(): MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationOutputReference;
    putEnterpriseMonitorConfiguration(value: MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfiguration): void;
    resetEnterpriseMonitorConfiguration(): void;
    get enterpriseMonitorConfigurationInput(): MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfiguration | undefined;
}
export interface MysqlServiceInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#create MysqlServiceInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance#delete MysqlServiceInstance#delete}
    */
    readonly delete?: string;
}
export declare function mysqlServiceInstanceTimeoutsToTerraform(struct?: MysqlServiceInstanceTimeoutsOutputReference | MysqlServiceInstanceTimeouts | cdktf.IResolvable): any;
export declare class MysqlServiceInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlServiceInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MysqlServiceInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance oraclepaas_mysql_service_instance}
*/
export declare class MysqlServiceInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "oraclepaas_mysql_service_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance oraclepaas_mysql_service_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MysqlServiceInstanceConfig
    */
    constructor(scope: Construct, id: string, config: MysqlServiceInstanceConfig);
    private _availabilityDomain?;
    get availabilityDomain(): string;
    set availabilityDomain(value: string);
    resetAvailabilityDomain(): void;
    get availabilityDomainInput(): string | undefined;
    private _backupDestination?;
    get backupDestination(): string;
    set backupDestination(value: string);
    resetBackupDestination(): void;
    get backupDestinationInput(): string | undefined;
    get baseReleaseVersion(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get emUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipNetwork?;
    get ipNetwork(): string;
    set ipNetwork(value: string);
    resetIpNetwork(): void;
    get ipNetworkInput(): string | undefined;
    private _meteringFrequency?;
    get meteringFrequency(): string;
    set meteringFrequency(value: string);
    resetMeteringFrequency(): void;
    get meteringFrequencyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notificationEmail?;
    get notificationEmail(): string;
    set notificationEmail(value: string);
    resetNotificationEmail(): void;
    get notificationEmailInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get releaseVersion(): string;
    get serviceVersion(): string;
    private _shape?;
    get shape(): string;
    set shape(value: string);
    get shapeInput(): string | undefined;
    private _sshPublicKey?;
    get sshPublicKey(): string;
    set sshPublicKey(value: string);
    get sshPublicKeyInput(): string | undefined;
    private _subnet?;
    get subnet(): string;
    set subnet(value: string);
    resetSubnet(): void;
    get subnetInput(): string | undefined;
    private _vmUser?;
    get vmUser(): string;
    set vmUser(value: string);
    resetVmUser(): void;
    get vmUserInput(): string | undefined;
    private _backups;
    get backups(): MysqlServiceInstanceBackupsOutputReference;
    putBackups(value: MysqlServiceInstanceBackups): void;
    resetBackups(): void;
    get backupsInput(): MysqlServiceInstanceBackups | undefined;
    private _mysqlConfiguration;
    get mysqlConfiguration(): MysqlServiceInstanceMysqlConfigurationOutputReference;
    putMysqlConfiguration(value: MysqlServiceInstanceMysqlConfiguration): void;
    get mysqlConfigurationInput(): MysqlServiceInstanceMysqlConfiguration | undefined;
    private _timeouts;
    get timeouts(): MysqlServiceInstanceTimeoutsOutputReference;
    putTimeouts(value: MysqlServiceInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MysqlServiceInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
