# IRNL RDT Correction 

[![Cron Testing](https://github.com/pylhc/irnl_rdt_correction/workflows/Cron%20Testing/badge.svg)](https://github.com/pylhc/irnl_rdt_correction/actions?query=workflow%3A%22Cron+Testing%22)
[![Code Climate coverage](https://img.shields.io/codeclimate/coverage/pylhc/irnl_rdt_correction.svg?style=popout)](https://codeclimate.com/github/pylhc/irnl_rdt_correction)
[![Code Climate maintainability (percentage)](https://img.shields.io/codeclimate/maintainability-percentage/pylhc/irnl_rdt_correction.svg?style=popout)](https://codeclimate.com/github/pylhc/irnl_rdt_correction)
[![GitHub last commit](https://img.shields.io/github/last-commit/pylhc/irnl_rdt_correction.svg?style=popout)](https://github.com/pylhc/irnl_rdt_correction/)
[![GitHub release](https://img.shields.io/github/release/pylhc/irnl_rdt_correction.svg?style=popout)](https://github.com/pylhc/irnl_rdt_correction/)

Performs local correction of the Resonance Driving Terms (RDTs)
in the Insertion Regions (IRs) based on the principle described in
[[1]](#1) with the addition of correcting
feed-down and using feed-down to correct lower order RDTs.
Details can be found in [[2]](#2) .


## Documentation

- Autogenerated docs via `Sphinx` can be found at <https://pylhc.github.io/irnl_rdt_correction/>.
- General documentation of the OMC-Team is located at <https://pylhc.github.io/>

## Installing

This package is `Python 3.7+` compatible, and can be installed through `pip`:
```bash
python -m pip install irnl-rdt-correction
```

After installing, scripts can be run with either `python -m irnl_rdt_correction --FLAG ARGUMENT` or by calling the Python files directly.

For development purposes, we recommend creating a new virtual environment and installing from VCS in editable mode with all extra dependencies:
```bash
git clone https://github.com/pylhc/irnl_rdt_correction
python -m pip install --editable "irnl_rdt_correction[all]"
```

## Main Script 

-  [**irnl_rdt_correction.py**](irnl_rdt_correction/irnl_rdt_correction.py) - Script to compute RDT correction in the (HL)LHC IRs including feed-down effects.

## License

This project is licensed under the `MIT` License - see the [LICENSE](LICENSE) file for details.


## References

<a id="1">[1]</a> :
O. Bruening et al.,
Dynamic aperture studies for the LHC separation dipoles. (2004)
https://cds.cern.ch/record/742967

<a id="2">[2]</a> :
J. Dilly et al.,
Corrections of high-order nonlinear errors in the LHC and HL-LHC insertion regions. (2022)


