"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const cdk = require("@aws-cdk/core");
const ssm = require("../lib");
class CreatingStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        new ssm.StringParameter(this, 'String', {
            parameterName: '/My/Public/Parameter',
            stringValue: 'abcdef'
        });
    }
}
class UsingStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        // Retrieve the latest value of the non-secret parameter
        // with name "/My/String/Parameter".
        const stringValue = ssm.StringParameter.fromStringParameterAttributes(this, 'MyValue', {
            parameterName: '/My/Public/Parameter',
        }).stringValue;
        // Retrieve a specific version of the secret (SecureString) parameter.
        // 'version' is always required.
        const secretValue = ssm.StringParameter.fromSecureStringParameterAttributes(this, 'MySecureValue', {
            parameterName: '/My/Secret/Parameter',
            version: 5
        });
        /// !hide
        new cdk.CfnResource(this, 'Dummy', { type: 'AWS::SNS::Topic' });
        new cdk.CfnOutput(this, 'TheValue', { value: stringValue });
        // Cannot be provisioned so cannot be actually used
        Array.isArray(secretValue);
    }
}
const app = new cdk.App();
const creating = new CreatingStack(app, 'sspms-creating');
const using = new UsingStack(app, 'sspms-using');
using.addDependency(creating);
app.synth();
//# sourceMappingURL=data:application/json;base64,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