# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['peinan_utils']

package_data = \
{'': ['*'], 'peinan_utils': ['fonts/*']}

install_requires = \
['ipadic>=1.0.0,<2.0.0',
 'loguru>=0.5.3,<0.6.0',
 'matplotlib>=3.4.2,<4.0.0',
 'mecab-python3>=1.0.4,<2.0.0']

setup_kwargs = {
    'name': 'peinan-utils',
    'version': '0.1.1',
    'description': 'An util package for myself. (Mostly about NLP)',
    'long_description': "# An util package for myself\n\n![](https://img.shields.io/badge/version-0.1.1-green.svg?style=flat-square) ![](https://img.shields.io/badge/python-3.6+-green.svg?style=flat-square) ![](https://img.shields.io/badge/license-MIT-blue.svg?style=flat-square)\n\nMostly about NLP.\n\n## Install\n\n```bash\npip install peinan-utils\n```\n\n## Usages & Features\n\n### Parser\n\n```python\n# sample text\n>>> text = 'こんにちは！今日はいい天気ですね。これからどちらへ？'\n\n>>> from peinan_utils import Parser\n>>> p = Parser()\n\n# just parse input texts and get information about surfaces and features\n>>> p.parse(text)\n[{'surface': 'こんにちは',\n  'features': ['感動詞', '*', '*', '*', '*', '*', 'こんにちは', 'コンニチハ', 'コンニチワ']},\n {'surface': '！', 'features': ['記号', '一般', '*', '*', '*', '*', '！', '！', '！']},\n {'surface': '今日',\n  'features': ['名詞', '副詞可能', '*', '*', '*', '*', '今日', 'キョウ', 'キョー']},\n {'surface': 'は',\n  'features': ['助詞', '係助詞', '*', '*', '*', '*', 'は', 'ハ', 'ワ']},\n {'surface': 'いい',\n  'features': ['形容詞', '自立', '*', '*', '形容詞・イイ', '基本形', 'いい', 'イイ', 'イイ']},\n {'surface': '天気',\n  'features': ['名詞', '一般', '*', '*', '*', '*', '天気', 'テンキ', 'テンキ']},\n {'surface': 'です',\n  'features': ['助動詞', '*', '*', '*', '特殊・デス', '基本形', 'です', 'デス', 'デス']},\n {'surface': 'ね',\n  'features': ['助詞', '終助詞', '*', '*', '*', '*', 'ね', 'ネ', 'ネ']},\n {'surface': '。', 'features': ['記号', '句点', '*', '*', '*', '*', '。', '。', '。']},\n {'surface': 'これから',\n  'features': ['副詞', '助詞類接続', '*', '*', '*', '*', 'これから', 'コレカラ', 'コレカラ']},\n {'surface': 'どちら',\n  'features': ['名詞', '代名詞', '一般', '*', '*', '*', 'どちら', 'ドチラ', 'ドチラ']},\n {'surface': 'へ',\n  'features': ['助詞', '格助詞', '一般', '*', '*', '*', 'へ', 'ヘ', 'エ']},\n {'surface': '？', 'features': ['記号', '一般', '*', '*', '*', '*', '？', '？', '？']}]\n\n# get surfaces of input text\n>>> p.get_surfaces(text)\n['こんにちは', '！', '今日', 'は', 'いい', '天気', 'です', 'ね', '。', 'これから', 'どちら', 'へ', '？']\n\n# get only content words of input text\n>>> p.get_surfaces(text, only_content_words=True)\n['今日', 'いい', '天気', 'これから', 'どちら']\n\n# split input text into lines\n>>> p.split_to_lines(text)\n['こんにちは！', '今日はいい天気ですね。', 'これからどちらへ？']\n\n# change dictonary path\n>>> sumomo = 'すもももももももものうち'\n>>> p.get_surfaces(sumomo)\n['すもも', 'も', 'もも', 'も', 'もも', 'の', 'うち']\n\n>>> p.set_dict('/usr/local/lib/mecab/dic/mecab-ipadic-neologd', is_dict_path=True)\n>>> p.get_surfaces(sumomo)\n['すもももももももものうち']\n```\n\n### Vectorizer\n\n```python\n# sample text\n>>> text = '今日はいい天気ですね。これからどちらへ？'\n\n>>> from peinan_utils import Vectorizer\n>>> v = Vectorizer()\n\n# make word ngram (the default n is 2)\n>>> v.make_word_ngram(text)\n[[('今日', 'は'), ('は', 'いい'), ('いい', '天気'), ('天気', 'です'), ('です', 'ね'), ('ね', '。')], [('これから', 'どちら'), ('どちら', 'へ'), ('へ', '？')]]\n\n# specify n\n>>> v.make_word_ngram(text, n=3)\n[[('今日', 'は', 'いい'), ('は', 'いい', '天気'), ('いい', '天気', 'です'), ('天気', 'です', 'ね'), ('です', 'ね', '。')], [('これから', 'どちら', 'へ'), ('どちら', 'へ', '？')]]\n\n# use BOS and EOS (the default BOS and EOS are '<s>' and </s>, respectively)\n>>> v.make_word_ngram(text, n=3, bos=v.BOS, eos=v.EOS)\n[[('<s>', '今日', 'は'), ('今日', 'は', 'いい'), ('は', 'いい', '天気'), ('いい', '天気', 'です'), ('天気', 'です', 'ね'), ('です', 'ね', '。'), ('ね', '。', '</s>')], [('<s>', 'これから', 'どちら'), ('これから', 'どちら', 'へ'), ('どちら', 'へ', '？'), ('へ', '？', '</s>')]]\n\n# make character ngram (the default n is 2)\n>>> v.make_char_ngram(text, n=2)\n[[('今', '日'), ('日', 'は'), ('は', 'い'), ('い', 'い'), ('い', '天'), ('天', '気'), ('気', 'で'), ('で', 'す'), ('す', 'ね'), ('ね', '。')], [('こ', 'れ'), ('れ', 'か'), ('か', 'ら'), ('ら', 'ど'), ('ど', 'ち'), ('ち', 'ら'), ('ら', 'へ'), ('へ', '？')]]\n```\n\n### Statist\n\nsample.txt\n\n```\nあのイーハトーヴォのすきとおった風、夏でも底に冷たさをもつ青いそら、うつくしい森で飾られたモリーオ市、 郊外のぎらぎらひかる草の波。\nまたそのなかでいっしょになったたくさんのひとたち、ファゼーロとロザーロ、羊飼のミーロや、顔の赤いこども たち、地主のテーモ、山猫博士のボーガント・デストゥパーゴなど、いまこの暗い巨きな石の建物のなかで考えて いると、みんなむかし風のなつかしい青い幻燈のように思われます。\nでは、わたくしはいつかの小さなみだしをつけながら、しずかにあの年のイーハトーヴォの五月から十月までを書 きつけましょう。\n```\n\n```python\nIn : from peinan_utils import Statist\nIn : s = Statist('./sample.txt')\n# you can put data directly such as below\n# In : s = Statist('あのイーハトーヴォのすきとおった風、夏でも底に冷たさをもつ青いそら、うつくしい森で飾られたモリーオ市、 郊外のぎらぎらひかる草の波。')\n# In : s = Statist([\n#          'あのイーハトーヴォのすきとおった風、夏でも底に冷たさをもつ青いそら、うつくしい森で飾られたモリーオ市、 郊外のぎらぎらひかる草の波。',\n#          'またそのなかでいっしょになったたくさんのひとたち、ファゼーロとロザーロ、羊飼のミーロや、顔の赤いこども たち、地主のテーモ、山猫博士のボーガント・デストゥパーゴなど、いまこの暗い巨きな石の建物のなかで考えて いると、みんなむかし風のなつかしい青い幻燈のように思われます。',\n#          'では、わたくしはいつかの小さなみだしをつけながら、しずかにあの年のイーハトーヴォの五月から十月までを書 きつけましょう。'\n#      ])\n\n# show all stats\nIn : s.all_stats()\nOut: {'word_stats': {'num_token': 137, 'num_vocab': 90},  # num_token == 延べ語数, num_vocab == 異なり語数\n      'char_stats': {'num_token': 260, 'num_vocab': 109}}\n \n# show word stats with verbose mode\nIn : s.calc_word_stats(verbose=True)\nCounter({'の': 15, '、': 12, 'で': 5, 'に': 4, 'た': 3, 'を': 3, '。': 3, 'あの': 2, 'イーハトーヴォ': 2, '風': 2, '青い': 2, 'れ': 2, 'なか': 2, 'たち': 2, 'と': 2, 'は': 2, 'すきとおっ': 1, '夏': 1, 'も': 1, '底': 1, '冷た': 1, 'さ': 1, 'もつ': 1, 'そら': 1, 'うつくしい': 1, '森': 1, '飾ら': 1, 'モリーオ': 1, '市': 1, '郊外': 1, 'ぎらぎら': 1, 'ひかる': 1, '草': 1, '波': 1, 'また': 1, 'その': 1, 'いっしょ': 1, 'なっ': 1, 'たくさん': 1, 'ひと': 1, 'ファゼーロ': 1, 'ロザーロ': 1, '羊': 1, '飼': 1, 'ミーロ': 1, 'や': 1, '顔': 1, '赤い': 1, 'こども': 1, '地主': 1, 'テーモ': 1, '山猫': 1, '博士': 1, 'ボーガント・デスト ゥパーゴ': 1, 'など': 1, 'いま': 1, 'この': 1, '暗い': 1, '巨': 1, 'き': 1, 'な': 1, '石': 1, '建物': 1, '考え': 1, 'て': 1, 'いる': 1, 'みんな': 1, 'むかし': 1, 'なつかしい': 1, '幻': 1, '燈': 1, 'よう': 1, '思わ': 1, 'ます': 1, 'わたくし': 1, 'いつか': 1, '小さな': 1, 'み': 1, 'だし': 1, 'つけ': 1, 'ながら': 1, 'しずか': 1, '年': 1, '五月': 1, 'から': 1, '十月': 1, 'まで': 1, '書きつけ': 1, 'ましょ': 1, 'う': 1})\nOut: {'num_token': 137, 'num_vocab': 90}\n```\n\n### Matplotlib Utils\n\n```python\n# just import this package and then you can plot with Japanese font\n>>> import matplotlib.pyplot as plt\n>>> import peinan_utils\n\n# set background face color\n>>> fig = plt.figure()\n>>> fig.patch.set_facecolor('white')\n\n# plot with Japanese labels\n>>> plt.plot([1,2,3], [1,2,3])\n>>> plt.xlabel('x軸')\n>>> plt.ylabel('y軸')\n>>> plt.show()\n```\n\n![](https://raw.githubusercontent.com/peinan/peinan-utils-py/master/images/plot_result.png)\n",
    'author': 'Peinan ZHANG',
    'author_email': 'peinan7@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/peinan/peinan-utils-py',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
