# <img src="https://raw.githubusercontent.com/jupyter/jupyter-book/master/jupyter_book/book_template/content/images/logo/logo.png" width=40 /> Jupyter Book

[![CircleCI](https://circleci.com/gh/jupyter/jupyter-book.svg?style=svg)](https://circleci.com/gh/jupyter/jupyter-book)
[![codecov](https://codecov.io/gh/jupyter/jupyter-book/branch/master/graph/badge.svg)](https://codecov.io/gh/jupyter/jupyter-book)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.2799972.svg)](https://doi.org/10.5281/zenodo.2799972)

This is a guide and template for hosting your own book using
Jupyter Notebooks and Jekyll.

Here are some highlights:

* All course content is written in markdown and Jupyter Notebooks, stored in `notebooks/`
* This site comes packaged with helper scripts to convert these into Jekyll pages (in `scripts/`)
* Pages can have [Binder](https://mybinder.org) or JupyterHub links automatically added for interactivity.
* The website itself is based on Jekyll, and is highly extensible and can be freely-hosted on GitHub.

This repository comes with some sample textbook files from the Data 8 course
for Data Science at UC Berkeley. You can update these materials and all site
content with your own, and have a Jupyter-based textbook ready to go shortly!

Here are a few links of interest:

* **[A demo of the hosted textbook](https://jupyterbook.org/ )**
* **[A short guide to deploying your own textbook](https://jupyterbook.org/guide/01_overview)**
* **[The markdown version of the guide in this repo](jupyter_book/book_template/content/guide/)**

## Explore this book

This website is an example of a Jupyter Book. You can explore the chapters of the book
by clicking on links in the sidebar to the left. Or, you can move linearly forward and
backwards by clicking the left/right arrow on your computer.

## Governance of this project

Jupyter Book is still developing relatively rapidly, so please be patient if things change
or features iterate and change quickly. Once Jupyter Book hits 1.0, it will slow down
considerably!

## Contribute or improve the book

Notice some inefficient CSS? A typo in the text? Want to add a cool feature so that others
can enjoy the improvements to Jupyter Books? Check out the [Jupyter Book Contributor's
Guide](https://jupyterbook.org/contributing.html). We'd love your help!

We ask that all contributions to Jupyter Book respect the
[Jupyter code of conduct](https://github.com/jupyter/governance/blob/master/conduct/code_of_conduct.md).

## Acknowledgements

Jupyter Books was originally created by [Sam Lau][sam] and [Chris Holdgraf][chris]
with support of the **UC Berkeley Data Science Education Program and the Berkeley
Institute for Data Science**.

[sam]: http://www.samlau.me/
[chris]: https://predictablynoisy.com
