# 342 API methods

# NOTE: Do not edit this file generated by Looker SDK Codegen for Looker 7.4 API 4.0
import datetime
from typing import MutableMapping, Optional, Sequence, Union

from . import models
from looker_sdk.rtl import api_methods
from looker_sdk.rtl import transport


class Looker40SDK(api_methods.APIMethods):

    # Accepts the legal agreement for a given integration hub. This only works for integration hubs that have legal_agreement_required set to true and legal_agreement_signed set to false.
    #
    # POST /integration_hubs/{integration_hub_id}/accept_legal_agreement -> models.IntegrationHub
    def accept_integration_hub_legal_agreement(
        self,
        # Id of integration_hub
        integration_hub_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.IntegrationHub:
        """Accept Integration Hub Legal Agreement"""
        response = self.post(
            f"/integration_hubs/{integration_hub_id}/accept_legal_agreement",
            models.IntegrationHub,
            transport_options=transport_options,
        )
        assert isinstance(response, models.IntegrationHub)
        return response

    # ### Get active themes
    #
    # Returns an array of active themes.
    #
    # If the `name` parameter is specified, it will return an array with one theme if it's active and found.
    #
    # The optional `ts` parameter can specify a different timestamp than "now."
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or support@looker.com to update your license for this feature.
    #
    # GET /themes/active -> Sequence[models.Theme]
    def active_themes(
        self,
        # Name of theme
        name: Optional[str] = None,
        # Timestamp representing the target datetime for the active period. Defaults to 'now'
        ts: Optional[datetime.datetime] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Theme]:
        """Get Active Themes"""
        response = self.get(
            f"/themes/active",
            Sequence[models.Theme],
            query_params={"name": name, "ts": ts, "fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Adds a new group to a group.
    #
    # POST /groups/{group_id}/groups -> models.Group
    def add_group_group(
        self,
        # Id of group
        group_id: int,
        body: models.GroupIdForGroupInclusion,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Group:
        """Add a Group to Group"""
        assert isinstance(body, models.GroupIdForGroupInclusion)
        response = self.post(
            f"/groups/{group_id}/groups",
            models.Group,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Group)
        return response

    # ### Adds a new user to a group.
    #
    # POST /groups/{group_id}/users -> models.User
    def add_group_user(
        self,
        # Id of group
        group_id: int,
        body: models.GroupIdForGroupUserInclusion,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.User:
        """Add a User to Group"""
        assert isinstance(body, models.GroupIdForGroupUserInclusion)
        response = self.post(
            f"/groups/{group_id}/users",
            models.User,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.User)
        return response

    # ### Get an array of all existing Color Collections
    # Get a **single** color collection by id with [ColorCollection](#!/ColorCollection/color_collection)
    #
    # Get all **standard** color collections with [ColorCollection](#!/ColorCollection/color_collections_standard)
    #
    # Get all **custom** color collections with [ColorCollection](#!/ColorCollection/color_collections_custom)
    #
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # GET /color_collections -> Sequence[models.ColorCollection]
    def all_color_collections(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ColorCollection]:
        """Get all Color Collections"""
        response = self.get(
            f"/color_collections",
            Sequence[models.ColorCollection],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all connections.
    #
    # GET /connections -> Sequence[models.DBConnection]
    def all_connections(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.DBConnection]:
        """Get All Connections"""
        response = self.get(
            f"/connections",
            Sequence[models.DBConnection],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### All content metadata access records for a content metadata item.
    #
    # GET /content_metadata_access -> Sequence[models.ContentMetaGroupUser]
    def all_content_metadata_accesses(
        self,
        # Id of content metadata
        content_metadata_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ContentMetaGroupUser]:
        """Get All Content Metadata Accesses"""
        response = self.get(
            f"/content_metadata_access",
            Sequence[models.ContentMetaGroupUser],
            query_params={"content_metadata_id": content_metadata_id, "fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all content metadata in a space.
    #
    # GET /content_metadata -> Sequence[models.ContentMeta]
    def all_content_metadatas(
        self,
        # Parent space of content.
        parent_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ContentMeta]:
        """Get All Content Metadatas"""
        response = self.get(
            f"/content_metadata",
            Sequence[models.ContentMeta],
            query_params={"parent_id": parent_id, "fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all active dashboards.
    #
    # Returns an array of **abbreviated dashboard objects**. Dashboards marked as deleted are excluded from this list.
    #
    # Get the **full details** of a specific dashboard by id with [dashboard()](#!/Dashboard/dashboard)
    #
    # Find **deleted dashboards** with [search_dashboards()](#!/Dashboard/search_dashboards)
    #
    # GET /dashboards -> Sequence[models.DashboardBase]
    def all_dashboards(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.DashboardBase]:
        """Get All Dashboards"""
        response = self.get(
            f"/dashboards",
            Sequence[models.DashboardBase],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all datagroups.
    #
    # GET /datagroups -> Sequence[models.Datagroup]
    def all_datagroups(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Datagroup]:
        """Get All Datagroups"""
        response = self.get(
            f"/datagroups",
            Sequence[models.Datagroup],
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all dialects.
    #
    # GET /dialect_info -> Sequence[models.DialectInfo]
    def all_dialect_infos(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.DialectInfo]:
        """Get All Dialect Infos"""
        response = self.get(
            f"/dialect_info",
            Sequence[models.DialectInfo],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all folders.
    #
    # GET /folders -> Sequence[models.Folder]
    def all_folders(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Folder]:
        """Get All Folders"""
        response = self.get(
            f"/folders",
            Sequence[models.Folder],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get All Git Branches
    #
    # Returns a list of git branches in the project repository
    #
    # GET /projects/{project_id}/git_branches -> Sequence[models.GitBranch]
    def all_git_branches(
        self,
        # Project Id
        project_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.GitBranch]:
        """Get All Git Branches"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}/git_branches",
            Sequence[models.GitBranch],
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get All Git Connection Tests
    #
    # dev mode required.
    #   - Call `update_session` to select the 'dev' workspace.
    #
    # Returns a list of tests which can be run against a project's (or the dependency project for the provided remote_url) git connection. Call [Run Git Connection Test](#!/Project/run_git_connection_test) to execute each test in sequence.
    #
    # Tests are ordered by increasing specificity. Tests should be run in the order returned because later tests require functionality tested by tests earlier in the test list.
    #
    # For example, a late-stage test for write access is meaningless if connecting to the git server (an early test) is failing.
    #
    # GET /projects/{project_id}/git_connection_tests -> Sequence[models.GitConnectionTest]
    def all_git_connection_tests(
        self,
        # Project Id
        project_id: str,
        # (Optional: leave blank for root project) The remote url for remote dependency to test.
        remote_url: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.GitConnectionTest]:
        """Get All Git Connection Tests"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}/git_connection_tests",
            Sequence[models.GitConnectionTest],
            query_params={"remote_url": remote_url},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all the groups in a group
    #
    # GET /groups/{group_id}/groups -> Sequence[models.Group]
    def all_group_groups(
        self,
        # Id of group
        group_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Group]:
        """Get All Groups in Group"""
        response = self.get(
            f"/groups/{group_id}/groups",
            Sequence[models.Group],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all the users directly included in a group.
    #
    # GET /groups/{group_id}/users -> Sequence[models.User]
    def all_group_users(
        self,
        # Id of group
        group_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        # Requested page.
        page: Optional[int] = None,
        # Results per page.
        per_page: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.User]:
        """Get All Users in Group"""
        response = self.get(
            f"/groups/{group_id}/users",
            Sequence[models.User],
            query_params={
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "sorts": sorts,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all groups.
    #
    # GET /groups -> Sequence[models.Group]
    def all_groups(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Requested page.
        page: Optional[int] = None,
        # Results per page.
        per_page: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Optional of ids to get specific groups.
        ids: Optional[models.DelimSequence[int]] = None,
        # Id of content metadata to which groups must have access.
        content_metadata_id: Optional[int] = None,
        # Select only groups that either can/cannot be given access to content.
        can_add_to_content_metadata: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Group]:
        """Get All Groups"""
        response = self.get(
            f"/groups",
            Sequence[models.Group],
            query_params={
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "sorts": sorts,
                "ids": ids,
                "content_metadata_id": content_metadata_id,
                "can_add_to_content_metadata": can_add_to_content_metadata,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all homepage items.
    #
    # GET /homepage_items -> Sequence[models.HomepageItem]
    def all_homepage_items(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Filter to a specific homepage section
        homepage_section_id: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.HomepageItem]:
        """Get All Homepage Items"""
        response = self.get(
            f"/homepage_items",
            Sequence[models.HomepageItem],
            query_params={
                "fields": fields,
                "sorts": sorts,
                "homepage_section_id": homepage_section_id,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all homepage sections.
    #
    # GET /homepage_sections -> Sequence[models.HomepageSection]
    def all_homepage_sections(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.HomepageSection]:
        """Get All Homepage sections"""
        response = self.get(
            f"/homepage_sections",
            Sequence[models.HomepageSection],
            query_params={"fields": fields, "sorts": sorts},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all homepages.
    #
    # GET /homepages -> Sequence[models.Homepage]
    def all_homepages(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Homepage]:
        """Get All Homepages"""
        response = self.get(
            f"/homepages",
            Sequence[models.Homepage],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all Integration Hubs.
    #
    # GET /integration_hubs -> Sequence[models.IntegrationHub]
    def all_integration_hubs(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.IntegrationHub]:
        """Get All Integration Hubs"""
        response = self.get(
            f"/integration_hubs",
            Sequence[models.IntegrationHub],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all Integrations.
    #
    # GET /integrations -> Sequence[models.Integration]
    def all_integrations(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Filter to a specific provider
        integration_hub_id: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Integration]:
        """Get All Integrations"""
        response = self.get(
            f"/integrations",
            Sequence[models.Integration],
            query_params={"fields": fields, "integration_hub_id": integration_hub_id},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get all legacy features.
    #
    # GET /legacy_features -> Sequence[models.LegacyFeature]
    def all_legacy_features(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.LegacyFeature]:
        """Get All Legacy Features"""
        response = self.get(
            f"/legacy_features",
            Sequence[models.LegacyFeature],
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get a list of locales that Looker supports.
    #
    # GET /locales -> Sequence[models.Locale]
    def all_locales(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Locale]:
        """Get All Locales"""
        response = self.get(
            f"/locales", Sequence[models.Locale], transport_options=transport_options
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all lookml models.
    #
    # GET /lookml_models -> Sequence[models.LookmlModel]
    def all_lookml_models(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.LookmlModel]:
        """Get All LookML Models"""
        response = self.get(
            f"/lookml_models",
            Sequence[models.LookmlModel],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get All LookML Tests
    #
    # Returns a list of tests which can be run to validate a project's LookML code and/or the underlying data,
    # optionally filtered by the file id.
    # Call [Run LookML Test](#!/Project/run_lookml_test) to execute tests.
    #
    # GET /projects/{project_id}/lookml_tests -> Sequence[models.LookmlTest]
    def all_lookml_tests(
        self,
        # Project Id
        project_id: str,
        # File Id
        file_id: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.LookmlTest]:
        """Get All LookML Tests"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}/lookml_tests",
            Sequence[models.LookmlTest],
            query_params={"file_id": file_id},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all active Looks
    #
    # Returns an array of **abbreviated Look objects** describing all the looks that the caller has access to. Soft-deleted Looks are **not** included.
    #
    # Get the **full details** of a specific look by id with [look(id)](#!/Look/look)
    #
    # Find **soft-deleted looks** with [search_looks()](#!/Look/search_looks)
    #
    # GET /looks -> Sequence[models.Look]
    def all_looks(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Look]:
        """Get All Looks"""
        response = self.get(
            f"/looks",
            Sequence[models.Look],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all model sets.
    #
    # GET /model_sets -> Sequence[models.ModelSet]
    def all_model_sets(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ModelSet]:
        """Get All Model Sets"""
        response = self.get(
            f"/model_sets",
            Sequence[models.ModelSet],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all permission sets.
    #
    # GET /permission_sets -> Sequence[models.PermissionSet]
    def all_permission_sets(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.PermissionSet]:
        """Get All Permission Sets"""
        response = self.get(
            f"/permission_sets",
            Sequence[models.PermissionSet],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get all supported permissions.
    #
    # GET /permissions -> Sequence[models.Permission]
    def all_permissions(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Permission]:
        """Get All Permissions"""
        response = self.get(
            f"/permissions",
            Sequence[models.Permission],
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get All Project Files
    #
    # Returns a list of the files in the project
    #
    # GET /projects/{project_id}/files -> Sequence[models.ProjectFile]
    def all_project_files(
        self,
        # Project Id
        project_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ProjectFile]:
        """Get All Project Files"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}/files",
            Sequence[models.ProjectFile],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get All Projects
    #
    # Returns all projects visible to the current user
    #
    # GET /projects -> Sequence[models.Project]
    def all_projects(
        self,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Project]:
        """Get All Projects"""
        response = self.get(
            f"/projects",
            Sequence[models.Project],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all roles.
    #
    # GET /roles -> Sequence[models.Role]
    def all_roles(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Optional list of ids to get specific roles.
        ids: Optional[models.DelimSequence[int]] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Role]:
        """Get All Roles"""
        response = self.get(
            f"/roles",
            Sequence[models.Role],
            query_params={"fields": fields, "ids": ids},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # Get information about all running queries.
    #
    # GET /running_queries -> Sequence[models.RunningQueries]
    def all_running_queries(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.RunningQueries]:
        """Get All Running Queries"""
        response = self.get(
            f"/running_queries",
            Sequence[models.RunningQueries],
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### List All Scheduled Plans
    #
    # Returns all scheduled plans which belong to the caller or given user.
    #
    # If no user_id is provided, this function returns the scheduled plans owned by the caller.
    #
    #
    # To list all schedules for all users, pass `all_users=true`.
    #
    #
    # The caller must have `see_schedules` permission to see other users' scheduled plans.
    #
    # GET /scheduled_plans -> Sequence[models.ScheduledPlan]
    def all_scheduled_plans(
        self,
        # Return scheduled plans belonging to this user_id. If not provided, returns scheduled plans owned by the caller.
        user_id: Optional[int] = None,
        # Comma delimited list of field names. If provided, only the fields specified will be included in the response
        fields: Optional[str] = None,
        # Return scheduled plans belonging to all users (caller needs see_schedules permission)
        all_users: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ScheduledPlan]:
        """Get All Scheduled Plans"""
        response = self.get(
            f"/scheduled_plans",
            Sequence[models.ScheduledPlan],
            query_params={"user_id": user_id, "fields": fields, "all_users": all_users},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all spaces.
    #
    # GET /spaces -> Sequence[models.SpaceBase]
    def all_spaces(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.SpaceBase]:
        """Get All Spaces"""
        response = self.get(
            f"/spaces",
            Sequence[models.SpaceBase],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get an array of all existing themes
    #
    # Get a **single theme** by id with [Theme](#!/Theme/theme)
    #
    # This method returns an array of all existing themes. The active time for the theme is not considered.
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or support@looker.com to update your license for this feature.
    #
    # GET /themes -> Sequence[models.Theme]
    def all_themes(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Theme]:
        """Get All Themes"""
        response = self.get(
            f"/themes",
            Sequence[models.Theme],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get a list of timezones that Looker supports (e.g. useful for scheduling tasks).
    #
    # GET /timezones -> Sequence[models.Timezone]
    def all_timezones(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Timezone]:
        """Get All Timezones"""
        response = self.get(
            f"/timezones",
            Sequence[models.Timezone],
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Returns all values of a user attribute defined by user groups, in precedence order.
    #
    # A user may be a member of multiple groups which define different values for a given user attribute.
    # The order of group-values in the response determines precedence for selecting which group-value applies
    # to a given user.  For more information, see [Set User Attribute Group Values](#!/UserAttribute/set_user_attribute_group_values).
    #
    # Results will only include groups that the caller's user account has permission to see.
    #
    # GET /user_attributes/{user_attribute_id}/group_values -> Sequence[models.UserAttributeGroupValue]
    def all_user_attribute_group_values(
        self,
        # Id of user attribute
        user_attribute_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.UserAttributeGroupValue]:
        """Get User Attribute Group Values"""
        response = self.get(
            f"/user_attributes/{user_attribute_id}/group_values",
            Sequence[models.UserAttributeGroupValue],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all user attributes.
    #
    # GET /user_attributes -> Sequence[models.UserAttribute]
    def all_user_attributes(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Fields to order the results by. Sortable fields include: name, label
        sorts: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.UserAttribute]:
        """Get All User Attributes"""
        response = self.get(
            f"/user_attributes",
            Sequence[models.UserAttribute],
            query_params={"fields": fields, "sorts": sorts},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### API 3 login information for the specified user. This is for the newer API keys that can be added for any user.
    #
    # GET /users/{user_id}/credentials_api3 -> Sequence[models.CredentialsApi3]
    def all_user_credentials_api3s(
        self,
        # id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.CredentialsApi3]:
        """Get All API 3 Credentials"""
        response = self.get(
            f"/users/{user_id}/credentials_api3",
            Sequence[models.CredentialsApi3],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Embed login information for the specified user.
    #
    # GET /users/{user_id}/credentials_embed -> Sequence[models.CredentialsEmbed]
    def all_user_credentials_embeds(
        self,
        # id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.CredentialsEmbed]:
        """Get All Embedding Credentials"""
        response = self.get(
            f"/users/{user_id}/credentials_embed",
            Sequence[models.CredentialsEmbed],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get currently locked-out users.
    #
    # GET /user_login_lockouts -> Sequence[models.UserLoginLockout]
    def all_user_login_lockouts(
        self,
        # Include only these fields in the response
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.UserLoginLockout]:
        """Get All User Login Lockouts"""
        response = self.get(
            f"/user_login_lockouts",
            Sequence[models.UserLoginLockout],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Web login session for the specified user.
    #
    # GET /users/{user_id}/sessions -> Sequence[models.Session]
    def all_user_sessions(
        self,
        # id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Session]:
        """Get All Web Login Sessions"""
        response = self.get(
            f"/users/{user_id}/sessions",
            Sequence[models.Session],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all users.
    #
    # GET /users -> Sequence[models.User]
    def all_users(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Requested page.
        page: Optional[int] = None,
        # Results per page.
        per_page: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Optional list of ids to get specific users.
        ids: Optional[models.DelimSequence[int]] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.User]:
        """Get All Users"""
        response = self.get(
            f"/users",
            Sequence[models.User],
            query_params={
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "sorts": sorts,
                "ids": ids,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get All Workspaces
    #
    # Returns all workspaces available to the calling user.
    #
    # GET /workspaces -> Sequence[models.Workspace]
    def all_workspaces(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Workspace]:
        """Get All Workspaces"""
        response = self.get(
            f"/workspaces",
            Sequence[models.Workspace],
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get the current Looker internal database backup configuration.
    #
    # GET /backup_configuration -> models.BackupConfiguration
    def backup_configuration(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.BackupConfiguration:
        """Get Backup Configuration"""
        response = self.get(
            f"/backup_configuration",
            models.BackupConfiguration,
            transport_options=transport_options,
        )
        assert isinstance(response, models.BackupConfiguration)
        return response

    # ### Get a Color Collection by ID
    #
    # Use this to retrieve a specific Color Collection.
    # Get a **single** color collection by id with [ColorCollection](#!/ColorCollection/color_collection)
    #
    # Get all **standard** color collections with [ColorCollection](#!/ColorCollection/color_collections_standard)
    #
    # Get all **custom** color collections with [ColorCollection](#!/ColorCollection/color_collections_custom)
    #
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # GET /color_collections/{collection_id} -> models.ColorCollection
    def color_collection(
        self,
        # Id of Color Collection
        collection_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ColorCollection:
        """Get Color Collection by ID"""
        collection_id = self.encode_path_param(collection_id)
        response = self.get(
            f"/color_collections/{collection_id}",
            models.ColorCollection,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ColorCollection)
        return response

    # ### Get an array of all existing **Custom** Color Collections
    # Get a **single** color collection by id with [ColorCollection](#!/ColorCollection/color_collection)
    #
    # Get all **standard** color collections with [ColorCollection](#!/ColorCollection/color_collections_standard)
    #
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # GET /color_collections/custom -> Sequence[models.ColorCollection]
    def color_collections_custom(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ColorCollection]:
        """Get all Custom Color Collections"""
        response = self.get(
            f"/color_collections/custom",
            Sequence[models.ColorCollection],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get an array of all existing **Standard** Color Collections
    # Get a **single** color collection by id with [ColorCollection](#!/ColorCollection/color_collection)
    #
    # Get all **custom** color collections with [ColorCollection](#!/ColorCollection/color_collections_custom)
    #
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # GET /color_collections/standard -> Sequence[models.ColorCollection]
    def color_collections_standard(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ColorCollection]:
        """Get all Standard Color Collections"""
        response = self.get(
            f"/color_collections/standard",
            Sequence[models.ColorCollection],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about a connection.
    #
    # GET /connections/{connection_name} -> models.DBConnection
    def connection(
        self,
        # Name of connection
        connection_name: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DBConnection:
        """Get Connection"""
        connection_name = self.encode_path_param(connection_name)
        response = self.get(
            f"/connections/{connection_name}",
            models.DBConnection,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.DBConnection)
        return response

    # ### Get favorite content by its id
    #
    # GET /content_favorite/{content_favorite_id} -> models.ContentFavorite
    def content_favorite(
        self,
        # Id of favorite content
        content_favorite_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ContentFavorite:
        """Get Favorite Content"""
        response = self.get(
            f"/content_favorite/{content_favorite_id}",
            models.ContentFavorite,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ContentFavorite)
        return response

    # ### Get information about an individual content metadata record.
    #
    # GET /content_metadata/{content_metadata_id} -> models.ContentMeta
    def content_metadata(
        self,
        # Id of content metadata
        content_metadata_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ContentMeta:
        """Get Content Metadata"""
        response = self.get(
            f"/content_metadata/{content_metadata_id}",
            models.ContentMeta,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ContentMeta)
        return response

    # ### Validate All Content
    # Requires Content Validation Labs Feature be enabled
    #
    # Performs validation of all looks and dashboards
    # Returns a list of errors found as well as metadata about the content validation run.
    #
    # GET /content_validation -> models.ContentValidation
    def content_validation(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ContentValidation:
        """Validate Content"""
        response = self.get(
            f"/content_validation",
            models.ContentValidation,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ContentValidation)
        return response

    # ### Create a custom color collection with the specified information
    #
    # Creates a new custom color collection object, returning the details, including the created id.
    #
    # **Update** an existing color collection with [Update Color Collection](#!/ColorCollection/update_color_collection)
    #
    # **Permanently delete** an existing custom color collection with [Delete Color Collection](#!/ColorCollection/delete_color_collection)
    #
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # POST /color_collections -> models.ColorCollection
    def create_color_collection(
        self,
        body: models.WriteColorCollection,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ColorCollection:
        """Create ColorCollection"""
        assert isinstance(body, models.WriteColorCollection)
        response = self.post(
            f"/color_collections",
            models.ColorCollection,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ColorCollection)
        return response

    # ### Create a connection using the specified configuration.
    #
    # POST /connections -> models.DBConnection
    def create_connection(
        self,
        body: models.WriteDBConnection,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DBConnection:
        """Create Connection"""
        assert isinstance(body, models.WriteDBConnection)
        response = self.post(
            f"/connections",
            models.DBConnection,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DBConnection)
        return response

    # ### Create favorite content
    #
    # POST /content_favorite -> models.ContentFavorite
    def create_content_favorite(
        self,
        body: models.WriteContentFavorite,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ContentFavorite:
        """Create Favorite Content"""
        assert isinstance(body, models.WriteContentFavorite)
        response = self.post(
            f"/content_favorite",
            models.ContentFavorite,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ContentFavorite)
        return response

    # ### Create content metadata access.
    #
    # POST /content_metadata_access -> models.ContentMetaGroupUser
    def create_content_metadata_access(
        self,
        body: models.ContentMetaGroupUser,
        # Optionally sends notification email when granting access to a board.
        send_boards_notification_email: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ContentMetaGroupUser:
        """Create Content Metadata Access"""
        assert isinstance(body, models.ContentMetaGroupUser)
        response = self.post(
            f"/content_metadata_access",
            models.ContentMetaGroupUser,
            query_params={
                "send_boards_notification_email": send_boards_notification_email
            },
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ContentMetaGroupUser)
        return response

    # ### Create a new dashboard
    #
    # Creates a new dashboard object and returns the details of the newly created dashboard.
    #
    # `Title`, `user_id`, and `space_id` are all required fields.
    # `Space_id` and `user_id` must contain the id of an existing space or user, respectively.
    # A dashboard's `title` must be unique within the space in which it resides.
    #
    # If you receive a 422 error response when creating a dashboard, be sure to look at the
    # response body for information about exactly which fields are missing or contain invalid data.
    #
    # You can **update** an existing dashboard with [update_dashboard()](#!/Dashboard/update_dashboard)
    #
    # You can **permanently delete** an existing dashboard with [delete_dashboard()](#!/Dashboard/delete_dashboard)
    #
    # POST /dashboards -> models.Dashboard
    def create_dashboard(
        self,
        body: models.WriteDashboard,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Dashboard:
        """Create Dashboard"""
        assert isinstance(body, models.WriteDashboard)
        response = self.post(
            f"/dashboards",
            models.Dashboard,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Dashboard)
        return response

    # ### Create a dashboard element on the dashboard with a specific id.
    #
    # POST /dashboard_elements -> models.DashboardElement
    def create_dashboard_element(
        self,
        body: models.WriteDashboardElement,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardElement:
        """Create DashboardElement"""
        assert isinstance(body, models.WriteDashboardElement)
        response = self.post(
            f"/dashboard_elements",
            models.DashboardElement,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardElement)
        return response

    # ### Create a dashboard filter on the dashboard with a specific id.
    #
    # POST /dashboard_filters -> models.DashboardFilter
    def create_dashboard_filter(
        self,
        body: models.WriteCreateDashboardFilter,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardFilter:
        """Create Dashboard Filter"""
        assert isinstance(body, models.WriteCreateDashboardFilter)
        response = self.post(
            f"/dashboard_filters",
            models.DashboardFilter,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardFilter)
        return response

    # ### Create a dashboard layout on the dashboard with a specific id.
    #
    # POST /dashboard_layouts -> models.DashboardLayout
    def create_dashboard_layout(
        self,
        body: models.WriteDashboardLayout,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardLayout:
        """Create DashboardLayout"""
        assert isinstance(body, models.WriteDashboardLayout)
        response = self.post(
            f"/dashboard_layouts",
            models.DashboardLayout,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardLayout)
        return response

    # ### Create a new task to render a dashboard to a document or image.
    #
    # Returns a render task object.
    # To check the status of a render task, pass the render_task.id to [Get Render Task](#!/RenderTask/get_render_task).
    # Once the render task is complete, you can download the resulting document or image using [Get Render Task Results](#!/RenderTask/get_render_task_results).
    #
    # POST /render_tasks/dashboards/{dashboard_id}/{result_format} -> models.RenderTask
    def create_dashboard_render_task(
        self,
        # Id of dashboard to render
        dashboard_id: int,
        # Output type: pdf, png, or jpg
        result_format: str,
        body: models.CreateDashboardRenderTask,
        # Output width in pixels
        width: int,
        # Output height in pixels
        height: int,
        # Requested fields.
        fields: Optional[str] = None,
        # Paper size for pdf
        pdf_paper_size: Optional[str] = None,
        # Whether to render pdf in landscape
        pdf_landscape: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.RenderTask:
        """Create Dashboard Render Task"""
        result_format = self.encode_path_param(result_format)
        assert isinstance(body, models.CreateDashboardRenderTask)
        response = self.post(
            f"/render_tasks/dashboards/{dashboard_id}/{result_format}",
            models.RenderTask,
            query_params={
                "width": width,
                "height": height,
                "fields": fields,
                "pdf_paper_size": pdf_paper_size,
                "pdf_landscape": pdf_landscape,
            },
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.RenderTask)
        return response

    # ### Trigger the generation of digest email records and send them to Looker's internal system. This does not send
    # any actual emails, it generates records containing content which may be of interest for users who have become inactive.
    # Emails will be sent at a later time from Looker's internal system if the Digest Emails feature is enabled in settings.
    #
    # POST /digest_email_send -> models.DigestEmailSend
    def create_digest_email_send(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DigestEmailSend:
        """Deliver digest email contents"""
        response = self.post(
            f"/digest_email_send",
            models.DigestEmailSend,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DigestEmailSend)
        return response

    # ### Create a folder with specified information.
    #
    # Caller must have permission to edit the parent folder and to create folders, otherwise the request
    # returns 404 Not Found.
    #
    # POST /folders -> models.Folder
    def create_folder(
        self,
        body: models.CreateFolder,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Folder:
        """Create Folder"""
        assert isinstance(body, models.CreateFolder)
        response = self.post(
            f"/folders", models.Folder, body=body, transport_options=transport_options
        )
        assert isinstance(response, models.Folder)
        return response

    # ### Create and Checkout a Git Branch
    #
    # Creates and checks out a new branch in the given project repository
    # Only allowed in development mode
    #   - Call `update_session` to select the 'dev' workspace.
    #
    # Optionally specify a branch name, tag name or commit SHA as the start point in the ref field.
    #   If no ref is specified, HEAD of the current branch will be used as the start point for the new branch.
    #
    # POST /projects/{project_id}/git_branch -> models.GitBranch
    def create_git_branch(
        self,
        # Project Id
        project_id: str,
        body: models.WriteGitBranch,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.GitBranch:
        """Checkout New Git Branch"""
        project_id = self.encode_path_param(project_id)
        assert isinstance(body, models.WriteGitBranch)
        response = self.post(
            f"/projects/{project_id}/git_branch",
            models.GitBranch,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.GitBranch)
        return response

    # ### Create Git Deploy Key
    #
    # Create a public/private key pair for authenticating ssh git requests from Looker to a remote git repository
    # for a particular Looker project.
    #
    # Returns the public key of the generated ssh key pair.
    #
    # Copy this public key to your remote git repository's ssh keys configuration so that the remote git service can
    # validate and accept git requests from the Looker server.
    #
    # POST /projects/{project_id}/git/deploy_key -> str
    def create_git_deploy_key(
        self,
        # Project Id
        project_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Create Deploy Key"""
        project_id = self.encode_path_param(project_id)
        response = self.post(
            f"/projects/{project_id}/git/deploy_key",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Creates a new group (admin only).
    #
    # POST /groups -> models.Group
    def create_group(
        self,
        body: models.WriteGroup,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Group:
        """Create Group"""
        assert isinstance(body, models.WriteGroup)
        response = self.post(
            f"/groups",
            models.Group,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Group)
        return response

    # ### Create a new homepage.
    #
    # POST /homepages -> models.Homepage
    def create_homepage(
        self,
        body: models.WriteHomepage,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Homepage:
        """Create Homepage"""
        assert isinstance(body, models.WriteHomepage)
        response = self.post(
            f"/homepages",
            models.Homepage,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Homepage)
        return response

    # ### Create a new homepage item.
    #
    # POST /homepage_items -> models.HomepageItem
    def create_homepage_item(
        self,
        body: models.WriteHomepageItem,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.HomepageItem:
        """Create Homepage Item"""
        assert isinstance(body, models.WriteHomepageItem)
        response = self.post(
            f"/homepage_items",
            models.HomepageItem,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.HomepageItem)
        return response

    # ### Create a new homepage section.
    #
    # POST /homepage_sections -> models.HomepageSection
    def create_homepage_section(
        self,
        body: models.WriteHomepageSection,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.HomepageSection:
        """Create Homepage section"""
        assert isinstance(body, models.WriteHomepageSection)
        response = self.post(
            f"/homepage_sections",
            models.HomepageSection,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.HomepageSection)
        return response

    # ### Create a new Integration Hub.
    #
    # This API is rate limited to prevent it from being used for SSRF attacks
    #
    # POST /integration_hubs -> models.IntegrationHub
    def create_integration_hub(
        self,
        body: models.WriteIntegrationHub,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.IntegrationHub:
        """Create Integration Hub"""
        assert isinstance(body, models.WriteIntegrationHub)
        response = self.post(
            f"/integration_hubs",
            models.IntegrationHub,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.IntegrationHub)
        return response

    # ### Create a Look
    #
    # To create a look to display query data, first create the query with [create_query()](#!/Query/create_query)
    # then assign the query's id to the `query_id` property in the call to `create_look()`.
    #
    # To place the look into a particular space, assign the space's id to the `space_id` property
    # in the call to `create_look()`.
    #
    # POST /looks -> models.LookWithQuery
    def create_look(
        self,
        body: models.WriteLookWithQuery,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LookWithQuery:
        """Create Look"""
        assert isinstance(body, models.WriteLookWithQuery)
        response = self.post(
            f"/looks",
            models.LookWithQuery,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.LookWithQuery)
        return response

    # ### Create a new task to render a look to an image.
    #
    # Returns a render task object.
    # To check the status of a render task, pass the render_task.id to [Get Render Task](#!/RenderTask/get_render_task).
    # Once the render task is complete, you can download the resulting document or image using [Get Render Task Results](#!/RenderTask/get_render_task_results).
    #
    # POST /render_tasks/looks/{look_id}/{result_format} -> models.RenderTask
    def create_look_render_task(
        self,
        # Id of look to render
        look_id: int,
        # Output type: png, or jpg
        result_format: str,
        # Output width in pixels
        width: int,
        # Output height in pixels
        height: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.RenderTask:
        """Create Look Render Task"""
        result_format = self.encode_path_param(result_format)
        response = self.post(
            f"/render_tasks/looks/{look_id}/{result_format}",
            models.RenderTask,
            query_params={"width": width, "height": height, "fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.RenderTask)
        return response

    # ### Create a new task to render a lookml dashboard to a document or image.
    #
    # Returns a render task object.
    # To check the status of a render task, pass the render_task.id to [Get Render Task](#!/RenderTask/get_render_task).
    # Once the render task is complete, you can download the resulting document or image using [Get Render Task Results](#!/RenderTask/get_render_task_results).
    #
    # POST /render_tasks/lookml_dashboards/{dashboard_id}/{result_format} -> models.RenderTask
    def create_lookml_dashboard_render_task(
        self,
        # Id of lookml dashboard to render
        dashboard_id: str,
        # Output type: pdf, png, or jpg
        result_format: str,
        body: models.CreateDashboardRenderTask,
        # Output width in pixels
        width: int,
        # Output height in pixels
        height: int,
        # Requested fields.
        fields: Optional[str] = None,
        # Paper size for pdf
        pdf_paper_size: Optional[str] = None,
        # Whether to render pdf in landscape
        pdf_landscape: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.RenderTask:
        """Create Lookml Dashboard Render Task"""
        dashboard_id = self.encode_path_param(dashboard_id)
        result_format = self.encode_path_param(result_format)
        assert isinstance(body, models.CreateDashboardRenderTask)
        response = self.post(
            f"/render_tasks/lookml_dashboards/{dashboard_id}/{result_format}",
            models.RenderTask,
            query_params={
                "width": width,
                "height": height,
                "fields": fields,
                "pdf_paper_size": pdf_paper_size,
                "pdf_landscape": pdf_landscape,
            },
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.RenderTask)
        return response

    # ### Create a lookml model using the specified configuration.
    #
    # POST /lookml_models -> models.LookmlModel
    def create_lookml_model(
        self,
        body: models.WriteLookmlModel,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LookmlModel:
        """Create LookML Model"""
        assert isinstance(body, models.WriteLookmlModel)
        response = self.post(
            f"/lookml_models",
            models.LookmlModel,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.LookmlModel)
        return response

    # ### Create Merge Query
    #
    # Creates a new merge query object.
    #
    # A merge query takes the results of one or more queries and combines (merges) the results
    # according to field mapping definitions. The result is similar to a SQL left outer join.
    #
    # A merge query can merge results of queries from different SQL databases.
    #
    # The order that queries are defined in the source_queries array property is significant. The
    # first query in the array defines the primary key into which the results of subsequent
    # queries will be merged.
    #
    # Like model/view query objects, merge queries are immutable and have structural identity - if
    # you make a request to create a new merge query that is identical to an existing merge query,
    # the existing merge query will be returned instead of creating a duplicate. Conversely, any
    # change to the contents of a merge query will produce a new object with a new id.
    #
    # POST /merge_queries -> models.MergeQuery
    def create_merge_query(
        self,
        body: Optional[models.WriteMergeQuery] = None,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.MergeQuery:
        """Create Merge Query"""
        if body:
            assert isinstance(body, models.WriteMergeQuery)
        response = self.post(
            f"/merge_queries",
            models.MergeQuery,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.MergeQuery)
        return response

    # ### Create a model set with the specified information. Model sets are used by Roles.
    #
    # POST /model_sets -> models.ModelSet
    def create_model_set(
        self,
        body: models.WriteModelSet,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ModelSet:
        """Create Model Set"""
        assert isinstance(body, models.WriteModelSet)
        response = self.post(
            f"/model_sets",
            models.ModelSet,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ModelSet)
        return response

    # ### Create a OIDC test configuration.
    #
    # POST /oidc_test_configs -> models.OIDCConfig
    def create_oidc_test_config(
        self,
        body: models.WriteOIDCConfig,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.OIDCConfig:
        """Create OIDC Test Configuration"""
        assert isinstance(body, models.WriteOIDCConfig)
        response = self.post(
            f"/oidc_test_configs",
            models.OIDCConfig,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.OIDCConfig)
        return response

    # ### Create a permission set with the specified information. Permission sets are used by Roles.
    #
    # POST /permission_sets -> models.PermissionSet
    def create_permission_set(
        self,
        body: models.WritePermissionSet,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.PermissionSet:
        """Create Permission Set"""
        assert isinstance(body, models.WritePermissionSet)
        response = self.post(
            f"/permission_sets",
            models.PermissionSet,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.PermissionSet)
        return response

    # ### Create A Project
    #
    # dev mode required.
    # - Call `update_session` to select the 'dev' workspace.
    #
    # `name` is required.
    # `git_remote_url` is not allowed. To configure Git for the newly created project, follow the instructions in `update_project`.
    #
    # POST /projects -> models.Project
    def create_project(
        self,
        body: models.WriteProject,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Project:
        """Create Project"""
        assert isinstance(body, models.WriteProject)
        response = self.post(
            f"/projects", models.Project, body=body, transport_options=transport_options
        )
        assert isinstance(response, models.Project)
        return response

    # ### Create a query.
    #
    # This allows you to create a new query that you can later run. Looker queries are immutable once created
    # and are not deleted. If you create a query that is exactly like an existing query then the existing query
    # will be returned and no new query will be created. Whether a new query is created or not, you can use
    # the 'id' in the returned query with the 'run' method.
    #
    # The query parameters are passed as json in the body of the request.
    #
    # POST /queries -> models.Query
    def create_query(
        self,
        body: models.WriteQuery,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Query:
        """Create Query"""
        assert isinstance(body, models.WriteQuery)
        response = self.post(
            f"/queries",
            models.Query,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Query)
        return response

    # ### Create a new task to render an existing query to an image.
    #
    # Returns a render task object.
    # To check the status of a render task, pass the render_task.id to [Get Render Task](#!/RenderTask/get_render_task).
    # Once the render task is complete, you can download the resulting document or image using [Get Render Task Results](#!/RenderTask/get_render_task_results).
    #
    # POST /render_tasks/queries/{query_id}/{result_format} -> models.RenderTask
    def create_query_render_task(
        self,
        # Id of the query to render
        query_id: int,
        # Output type: png or jpg
        result_format: str,
        # Output width in pixels
        width: int,
        # Output height in pixels
        height: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.RenderTask:
        """Create Query Render Task"""
        result_format = self.encode_path_param(result_format)
        response = self.post(
            f"/render_tasks/queries/{query_id}/{result_format}",
            models.RenderTask,
            query_params={"width": width, "height": height, "fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.RenderTask)
        return response

    # ### Create an async query task
    #
    # Creates a query task (job) to run a previously created query asynchronously. Returns a Query Task ID.
    #
    # Use [query_task(query_task_id)](#!/Query/query_task) to check the execution status of the query task.
    # After the query task status reaches "Complete", use [query_task_results(query_task_id)](#!/Query/query_task_results) to fetch the results of the query.
    #
    # POST /query_tasks -> models.QueryTask
    def create_query_task(
        self,
        body: models.WriteCreateQueryTask,
        # Row limit (may override the limit in the saved query).
        limit: Optional[int] = None,
        # Apply model-specified formatting to each result.
        apply_formatting: Optional[bool] = None,
        # Apply visualization options to results.
        apply_vis: Optional[bool] = None,
        # Get results from cache if available.
        cache: Optional[bool] = None,
        # Render width for image formats.
        image_width: Optional[int] = None,
        # Render height for image formats.
        image_height: Optional[int] = None,
        # Generate drill links (only applicable to 'json_detail' format.
        generate_drill_links: Optional[bool] = None,
        # Force use of production models even if the user is in development mode.
        force_production: Optional[bool] = None,
        # Retrieve any results from cache even if the results have expired.
        cache_only: Optional[bool] = None,
        # Prefix to use for drill links (url encoded).
        path_prefix: Optional[str] = None,
        # Rebuild PDTS used in query.
        rebuild_pdts: Optional[bool] = None,
        # Perform table calculations on query results
        server_table_calcs: Optional[bool] = None,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.QueryTask:
        """Run Query Async"""
        assert isinstance(body, models.WriteCreateQueryTask)
        response = self.post(
            f"/query_tasks",
            models.QueryTask,
            query_params={
                "limit": limit,
                "apply_formatting": apply_formatting,
                "apply_vis": apply_vis,
                "cache": cache,
                "image_width": image_width,
                "image_height": image_height,
                "generate_drill_links": generate_drill_links,
                "force_production": force_production,
                "cache_only": cache_only,
                "path_prefix": path_prefix,
                "rebuild_pdts": rebuild_pdts,
                "server_table_calcs": server_table_calcs,
                "fields": fields,
            },
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.QueryTask)
        return response

    # ### Create a role with the specified information.
    #
    # POST /roles -> models.Role
    def create_role(
        self,
        body: models.WriteRole,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Role:
        """Create Role"""
        assert isinstance(body, models.WriteRole)
        response = self.post(
            f"/roles", models.Role, body=body, transport_options=transport_options
        )
        assert isinstance(response, models.Role)
        return response

    # ### Create a SAML test configuration.
    #
    # POST /saml_test_configs -> models.SamlConfig
    def create_saml_test_config(
        self,
        body: models.WriteSamlConfig,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.SamlConfig:
        """Create SAML Test Configuration"""
        assert isinstance(body, models.WriteSamlConfig)
        response = self.post(
            f"/saml_test_configs",
            models.SamlConfig,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.SamlConfig)
        return response

    # ### Create a Scheduled Plan
    #
    # Create a scheduled plan to render a Look or Dashboard on a recurring schedule.
    #
    # To create a scheduled plan, you MUST provide values for the following fields:
    # `name`
    # and
    # `look_id`, `dashboard_id`, `lookml_dashboard_id`, or `query_id`
    # and
    # `cron_tab` or `datagroup`
    # and
    # at least one scheduled_plan_destination
    #
    # A scheduled plan MUST have at least one scheduled_plan_destination defined.
    #
    # When `look_id` is set, `require_no_results`, `require_results`, and `require_change` are all required.
    #
    # If `create_scheduled_plan` fails with a 422 error, be sure to look at the error messages in the response which will explain exactly what fields are missing or values that are incompatible.
    #
    # The queries that provide the data for the look or dashboard are run in the context of user account that owns the scheduled plan.
    #
    # When `run_as_recipient` is `false` or not specified, the queries that provide the data for the
    # look or dashboard are run in the context of user account that owns the scheduled plan.
    #
    # When `run_as_recipient` is `true` and all the email recipients are Looker user accounts, the
    # queries are run in the context of each recipient, so different recipients may see different
    # data from the same scheduled render of a look or dashboard. For more details, see [Run As Recipient](https://looker.com/docs/r/admin/run-as-recipient).
    #
    # Admins can create and modify scheduled plans on behalf of other users by specifying a user id.
    # Non-admin users may not create or modify scheduled plans by or for other users.
    #
    # #### Email Permissions:
    #
    # For details about permissions required to schedule delivery to email and the safeguards
    # Looker offers to protect against sending to unauthorized email destinations, see [Email Domain Whitelist for Scheduled Looks](https://docs.looker.com/r/api/embed-permissions).
    #
    #
    # #### Scheduled Plan Destination Formats
    #
    # Scheduled plan destinations must specify the data format to produce and send to the destination.
    #
    # Formats:
    #
    # | format | Description
    # | :-----------: | :--- |
    # | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata.
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination.
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | xlsx | MS Excel spreadsheet
    # | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document
    # | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document
    # | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image
    # ||
    #
    # Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.
    #
    # POST /scheduled_plans -> models.ScheduledPlan
    def create_scheduled_plan(
        self,
        body: models.WriteScheduledPlan,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ScheduledPlan:
        """Create Scheduled Plan"""
        assert isinstance(body, models.WriteScheduledPlan)
        response = self.post(
            f"/scheduled_plans",
            models.ScheduledPlan,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ScheduledPlan)
        return response

    # ### Create a space with specified information.
    #
    # Caller must have permission to edit the parent space and to create spaces, otherwise the request
    # returns 404 Not Found.
    #
    # POST /spaces -> models.Space
    def create_space(
        self,
        body: models.CreateSpace,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Space:
        """Create Space"""
        assert isinstance(body, models.CreateSpace)
        response = self.post(
            f"/spaces", models.Space, body=body, transport_options=transport_options
        )
        assert isinstance(response, models.Space)
        return response

    # ### Create a SQL Runner Query
    #
    # Either the `connection_name` or `model_name` parameter MUST be provided.
    #
    # POST /sql_queries -> models.SqlQuery
    def create_sql_query(
        self,
        body: models.SqlQueryCreate,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.SqlQuery:
        """Create SQL Runner Query"""
        assert isinstance(body, models.SqlQueryCreate)
        response = self.post(
            f"/sql_queries",
            models.SqlQuery,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.SqlQuery)
        return response

    # ### Create SSO Embed URL
    #
    # Creates an SSO embed URL and cryptographically signs it with an embed secret.
    # This signed URL can then be used to instantiate a Looker embed session in a PBL web application.
    # Do not make any modifications to this URL - any change may invalidate the signature and
    # cause the URL to fail to load a Looker embed session.
    #
    # A signed SSO embed URL can only be used once. After it has been used to request a page from the
    # Looker server, the URL is invalid. Future requests using the same URL will fail. This is to prevent
    # 'replay attacks'.
    #
    # The `target_url` property must be a complete URL of a Looker UI page - scheme, hostname, path and query params.
    # To load a dashboard with id 56 and with a filter of `Date=1 years`, the looker URL would look like `https:/myname.looker.com/dashboards/56?Date=1%20years`.
    # The best way to obtain this target_url is to navigate to the desired Looker page in your web browser,
    # copy the URL shown in the browser address bar and paste it into the `target_url` property as a quoted string value in this API request.
    #
    # Permissions for the embed user are defined by the groups in which the embed user is a member (group_ids property)
    # and the lists of models and permissions assigned to the embed user.
    # At a minimum, you must provide values for either the group_ids property, or both the models and permissions properties.
    # These properties are additive; an embed user can be a member of certain groups AND be granted access to models and permissions.
    #
    # The embed user's access is the union of permissions granted by the group_ids, models, and permissions properties.
    #
    # This function does not strictly require all group_ids, user attribute names, or model names to exist at the moment the
    # SSO embed url is created. Unknown group_id, user attribute names or model names will be passed through to the output URL.
    # To diagnose potential problems with an SSO embed URL, you can copy the signed URL into the Embed URI Validator text box in `<your looker instance>/admin/embed`.
    #
    # The `secret_id` parameter is optional. If specified, its value must be the id of an active secret defined in the Looker instance.
    # if not specified, the URL will be signed using the newest active secret defined in the Looker instance.
    #
    # #### Security Note
    # Protect this signed URL as you would an access token or password credentials - do not write
    # it to disk, do not pass it to a third party, and only pass it through a secure HTTPS
    # encrypted transport.
    #
    # POST /embed/sso_url -> models.EmbedSsoUrl
    def create_sso_embed_url(
        self,
        body: models.EmbedSsoUrlParams,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.EmbedSsoUrl:
        """Create SSO Embed Url"""
        assert isinstance(body, models.EmbedSsoUrlParams)
        response = self.post(
            f"/embed/sso_url",
            models.EmbedSsoUrl,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.EmbedSsoUrl)
        return response

    # ### Create a theme
    #
    # Creates a new theme object, returning the theme details, including the created id.
    #
    # If `settings` are not specified, the default theme settings will be copied into the new theme.
    #
    # The theme `name` can only contain alphanumeric characters or underscores. Theme names should not contain any confidential information, such as customer names.
    #
    # **Update** an existing theme with [Update Theme](#!/Theme/update_theme)
    #
    # **Permanently delete** an existing theme with [Delete Theme](#!/Theme/delete_theme)
    #
    # For more information, see [Creating and Applying Themes](https://looker.com/docs/r/admin/themes).
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or support@looker.com to update your license for this feature.
    #
    # POST /themes -> models.Theme
    def create_theme(
        self,
        body: models.WriteTheme,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Theme:
        """Create Theme"""
        assert isinstance(body, models.WriteTheme)
        response = self.post(
            f"/themes", models.Theme, body=body, transport_options=transport_options
        )
        assert isinstance(response, models.Theme)
        return response

    # ### Create a user with the specified information.
    #
    # POST /users -> models.User
    def create_user(
        self,
        body: Optional[models.WriteUser] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.User:
        """Create User"""
        if body:
            assert isinstance(body, models.WriteUser)
        response = self.post(
            f"/users",
            models.User,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.User)
        return response

    # ### Create a new user attribute
    #
    # Permission information for a user attribute is conveyed through the `can` and `user_can_edit` fields.
    # The `user_can_edit` field indicates whether an attribute is user-editable _anywhere_ in the application.
    # The `can` field gives more granular access information, with the `set_value` child field indicating whether
    # an attribute's value can be set by [Setting the User Attribute User Value](#!/User/set_user_attribute_user_value).
    #
    # Note: `name` and `label` fields must be unique across all user attributes in the Looker instance.
    # Attempting to create a new user attribute with a name or label that duplicates an existing
    # user attribute will fail with a 422 error.
    #
    # POST /user_attributes -> models.UserAttribute
    def create_user_attribute(
        self,
        body: models.WriteUserAttribute,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.UserAttribute:
        """Create User Attribute"""
        assert isinstance(body, models.WriteUserAttribute)
        response = self.post(
            f"/user_attributes",
            models.UserAttribute,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.UserAttribute)
        return response

    # ### API 3 login information for the specified user. This is for the newer API keys that can be added for any user.
    #
    # POST /users/{user_id}/credentials_api3 -> models.CredentialsApi3
    def create_user_credentials_api3(
        self,
        # id of user
        user_id: int,
        body: Optional[models.CredentialsApi3] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsApi3:
        """Create API 3 Credential"""
        if body:
            assert isinstance(body, models.CredentialsApi3)
        response = self.post(
            f"/users/{user_id}/credentials_api3",
            models.CredentialsApi3,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsApi3)
        return response

    # ### Email/password login information for the specified user.
    #
    # POST /users/{user_id}/credentials_email -> models.CredentialsEmail
    def create_user_credentials_email(
        self,
        # id of user
        user_id: int,
        body: models.WriteCredentialsEmail,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsEmail:
        """Create Email/Password Credential"""
        assert isinstance(body, models.WriteCredentialsEmail)
        response = self.post(
            f"/users/{user_id}/credentials_email",
            models.CredentialsEmail,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsEmail)
        return response

    # ### Create a password reset token.
    # This will create a cryptographically secure random password reset token for the user.
    # If the user already has a password reset token then this invalidates the old token and creates a new one.
    # The token is expressed as the 'password_reset_url' of the user's email/password credential object.
    # This takes an optional 'expires' param to indicate if the new token should be an expiring token.
    # Tokens that expire are typically used for self-service password resets for existing users.
    # Invitation emails for new users typically are not set to expire.
    # The expire period is always 60 minutes when expires is enabled.
    # This method can be called with an empty body.
    #
    # POST /users/{user_id}/credentials_email/password_reset -> models.CredentialsEmail
    def create_user_credentials_email_password_reset(
        self,
        # Id of user
        user_id: int,
        # Expiring token.
        expires: Optional[bool] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsEmail:
        """Create Password Reset Token"""
        response = self.post(
            f"/users/{user_id}/credentials_email/password_reset",
            models.CredentialsEmail,
            query_params={"expires": expires, "fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsEmail)
        return response

    # ### Two-factor login information for the specified user.
    #
    # POST /users/{user_id}/credentials_totp -> models.CredentialsTotp
    def create_user_credentials_totp(
        self,
        # id of user
        user_id: int,
        body: Optional[models.CredentialsTotp] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsTotp:
        """Create Two-Factor Credential"""
        if body:
            assert isinstance(body, models.CredentialsTotp)
        response = self.post(
            f"/users/{user_id}/credentials_totp",
            models.CredentialsTotp,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsTotp)
        return response

    # ### Get the current status and content of custom welcome emails
    #
    # GET /custom_welcome_email -> models.CustomWelcomeEmail
    def custom_welcome_email(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CustomWelcomeEmail:
        """Get Custom Welcome Email"""
        response = self.get(
            f"/custom_welcome_email",
            models.CustomWelcomeEmail,
            transport_options=transport_options,
        )
        assert isinstance(response, models.CustomWelcomeEmail)
        return response

    # ### Get information about a dashboard
    #
    # Returns the full details of the identified dashboard object
    #
    # Get a **summary list** of all active dashboards with [all_dashboards()](#!/Dashboard/all_dashboards)
    #
    # You can **Search** for dashboards with [search_dashboards()](#!/Dashboard/search_dashboards)
    #
    # GET /dashboards/{dashboard_id} -> models.Dashboard
    def dashboard(
        self,
        # Id of dashboard
        dashboard_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Dashboard:
        """Get Dashboard"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = self.get(
            f"/dashboards/{dashboard_id}",
            models.Dashboard,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Dashboard)
        return response

    # ### Get information about all the dashboard elements on a dashboard with a specific id.
    #
    # GET /dashboards/{dashboard_id}/dashboard_elements -> Sequence[models.DashboardElement]
    def dashboard_dashboard_elements(
        self,
        # Id of dashboard
        dashboard_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.DashboardElement]:
        """Get All DashboardElements"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = self.get(
            f"/dashboards/{dashboard_id}/dashboard_elements",
            Sequence[models.DashboardElement],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all the dashboard filters on a dashboard with a specific id.
    #
    # GET /dashboards/{dashboard_id}/dashboard_filters -> Sequence[models.DashboardFilter]
    def dashboard_dashboard_filters(
        self,
        # Id of dashboard
        dashboard_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.DashboardFilter]:
        """Get All Dashboard Filters"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = self.get(
            f"/dashboards/{dashboard_id}/dashboard_filters",
            Sequence[models.DashboardFilter],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all the dashboard elements on a dashboard with a specific id.
    #
    # GET /dashboards/{dashboard_id}/dashboard_layouts -> Sequence[models.DashboardLayout]
    def dashboard_dashboard_layouts(
        self,
        # Id of dashboard
        dashboard_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.DashboardLayout]:
        """Get All DashboardLayouts"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = self.get(
            f"/dashboards/{dashboard_id}/dashboard_layouts",
            Sequence[models.DashboardLayout],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about the dashboard element with a specific id.
    #
    # GET /dashboard_elements/{dashboard_element_id} -> models.DashboardElement
    def dashboard_element(
        self,
        # Id of dashboard element
        dashboard_element_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardElement:
        """Get DashboardElement"""
        dashboard_element_id = self.encode_path_param(dashboard_element_id)
        response = self.get(
            f"/dashboard_elements/{dashboard_element_id}",
            models.DashboardElement,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardElement)
        return response

    # ### Get information about the dashboard filters with a specific id.
    #
    # GET /dashboard_filters/{dashboard_filter_id} -> models.DashboardFilter
    def dashboard_filter(
        self,
        # Id of dashboard filters
        dashboard_filter_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardFilter:
        """Get Dashboard Filter"""
        dashboard_filter_id = self.encode_path_param(dashboard_filter_id)
        response = self.get(
            f"/dashboard_filters/{dashboard_filter_id}",
            models.DashboardFilter,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardFilter)
        return response

    # ### Get information about the dashboard layouts with a specific id.
    #
    # GET /dashboard_layouts/{dashboard_layout_id} -> models.DashboardLayout
    def dashboard_layout(
        self,
        # Id of dashboard layouts
        dashboard_layout_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardLayout:
        """Get DashboardLayout"""
        dashboard_layout_id = self.encode_path_param(dashboard_layout_id)
        response = self.get(
            f"/dashboard_layouts/{dashboard_layout_id}",
            models.DashboardLayout,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardLayout)
        return response

    # ### Get information about the dashboard elements with a specific id.
    #
    # GET /dashboard_layout_components/{dashboard_layout_component_id} -> models.DashboardLayoutComponent
    def dashboard_layout_component(
        self,
        # Id of dashboard layout component
        dashboard_layout_component_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardLayoutComponent:
        """Get DashboardLayoutComponent"""
        dashboard_layout_component_id = self.encode_path_param(
            dashboard_layout_component_id
        )
        response = self.get(
            f"/dashboard_layout_components/{dashboard_layout_component_id}",
            models.DashboardLayoutComponent,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardLayoutComponent)
        return response

    # ### Get information about all the dashboard layout components for a dashboard layout with a specific id.
    #
    # GET /dashboard_layouts/{dashboard_layout_id}/dashboard_layout_components -> Sequence[models.DashboardLayoutComponent]
    def dashboard_layout_dashboard_layout_components(
        self,
        # Id of dashboard layout component
        dashboard_layout_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.DashboardLayoutComponent]:
        """Get All DashboardLayoutComponents"""
        dashboard_layout_id = self.encode_path_param(dashboard_layout_id)
        response = self.get(
            f"/dashboard_layouts/{dashboard_layout_id}/dashboard_layout_components",
            Sequence[models.DashboardLayoutComponent],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get lookml of a UDD
    #
    # Returns a JSON object that contains the dashboard id and the full lookml
    #
    # GET /dashboards/lookml/{dashboard_id} -> models.DashboardLookml
    def dashboard_lookml(
        self,
        # Id of dashboard
        dashboard_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardLookml:
        """Get lookml of a UDD"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = self.get(
            f"/dashboards/lookml/{dashboard_id}",
            models.DashboardLookml,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardLookml)
        return response

    # ### Get information about a datagroup.
    #
    # GET /datagroups/{datagroup_id} -> models.Datagroup
    def datagroup(
        self,
        # ID of datagroup.
        datagroup_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Datagroup:
        """Get Datagroup"""
        response = self.get(
            f"/datagroups/{datagroup_id}",
            models.Datagroup,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Datagroup)
        return response

    # ### Get the default color collection
    #
    # Use this to retrieve the default Color Collection.
    #
    # Set the default color collection with [ColorCollection](#!/ColorCollection/set_default_color_collection)
    #
    # GET /color_collections/default -> models.ColorCollection
    def default_color_collection(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ColorCollection:
        """Get Default Color Collection"""
        response = self.get(
            f"/color_collections/default",
            models.ColorCollection,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ColorCollection)
        return response

    # ### Get the default theme
    #
    # Returns the active theme object set as the default.
    #
    # The **default** theme name can be set in the UI on the Admin|Theme UI page
    #
    # The optional `ts` parameter can specify a different timestamp than "now." If specified, it returns the default theme at the time indicated.
    #
    # GET /themes/default -> models.Theme
    def default_theme(
        self,
        # Timestamp representing the target datetime for the active period. Defaults to 'now'
        ts: Optional[datetime.datetime] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Theme:
        """Get Default Theme"""
        response = self.get(
            f"/themes/default",
            models.Theme,
            query_params={"ts": ts},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Theme)
        return response

    # ### Delete a custom color collection by id
    #
    # This operation permanently deletes the identified **Custom** color collection.
    #
    # **Standard** color collections cannot be deleted
    #
    # Because multiple color collections can have the same label, they must be deleted by ID, not name.
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # DELETE /color_collections/{collection_id} -> str
    def delete_color_collection(
        self,
        # Id of Color Collection
        collection_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete ColorCollection"""
        collection_id = self.encode_path_param(collection_id)
        response = self.delete(
            f"/color_collections/{collection_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Delete a connection.
    #
    # DELETE /connections/{connection_name} -> str
    def delete_connection(
        self,
        # Name of connection
        connection_name: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Connection"""
        connection_name = self.encode_path_param(connection_name)
        response = self.delete(
            f"/connections/{connection_name}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete a connection override.
    #
    # DELETE /connections/{connection_name}/connection_override/{override_context} -> str
    def delete_connection_override(
        self,
        # Name of connection
        connection_name: str,
        # Context of connection override
        override_context: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Connection Override"""
        connection_name = self.encode_path_param(connection_name)
        override_context = self.encode_path_param(override_context)
        response = self.delete(
            f"/connections/{connection_name}/connection_override/{override_context}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Delete favorite content
    #
    # DELETE /content_favorite/{content_favorite_id} -> str
    def delete_content_favorite(
        self,
        # Id of favorite content
        content_favorite_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Favorite Content"""
        response = self.delete(
            f"/content_favorite/{content_favorite_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Remove content metadata access.
    #
    # DELETE /content_metadata_access/{content_metadata_access_id} -> str
    def delete_content_metadata_access(
        self,
        # Id of content metadata access
        content_metadata_access_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Content Metadata Access"""
        response = self.delete(
            f"/content_metadata_access/{content_metadata_access_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Delete the dashboard with the specified id
    #
    # Permanently **deletes** a dashboard. (The dashboard cannot be recovered after this operation.)
    #
    # "Soft" delete or hide a dashboard by setting its `deleted` status to `True` with [update_dashboard()](#!/Dashboard/update_dashboard).
    #
    # Note: When a dashboard is deleted in the UI, it is soft deleted. Use this API call to permanently remove it, if desired.
    #
    # DELETE /dashboards/{dashboard_id} -> str
    def delete_dashboard(
        self,
        # Id of dashboard
        dashboard_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Dashboard"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = self.delete(
            f"/dashboards/{dashboard_id}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete a dashboard element with a specific id.
    #
    # DELETE /dashboard_elements/{dashboard_element_id} -> str
    def delete_dashboard_element(
        self,
        # Id of dashboard element
        dashboard_element_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete DashboardElement"""
        dashboard_element_id = self.encode_path_param(dashboard_element_id)
        response = self.delete(
            f"/dashboard_elements/{dashboard_element_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Delete a dashboard filter with a specific id.
    #
    # DELETE /dashboard_filters/{dashboard_filter_id} -> str
    def delete_dashboard_filter(
        self,
        # Id of dashboard filter
        dashboard_filter_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Dashboard Filter"""
        dashboard_filter_id = self.encode_path_param(dashboard_filter_id)
        response = self.delete(
            f"/dashboard_filters/{dashboard_filter_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Delete a dashboard layout with a specific id.
    #
    # DELETE /dashboard_layouts/{dashboard_layout_id} -> str
    def delete_dashboard_layout(
        self,
        # Id of dashboard layout
        dashboard_layout_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete DashboardLayout"""
        dashboard_layout_id = self.encode_path_param(dashboard_layout_id)
        response = self.delete(
            f"/dashboard_layouts/{dashboard_layout_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Delete the folder with a specific id including any children folders.
    # **DANGER** this will delete all looks and dashboards in the folder.
    #
    # DELETE /folders/{folder_id} -> str
    def delete_folder(
        self,
        # Id of folder
        folder_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Folder"""
        folder_id = self.encode_path_param(folder_id)
        response = self.delete(
            f"/folders/{folder_id}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete the specified Git Branch
    #
    # Delete git branch specified in branch_name path param from local and remote of specified project repository
    #
    # DELETE /projects/{project_id}/git_branch/{branch_name} -> str
    def delete_git_branch(
        self,
        # Project Id
        project_id: str,
        # Branch Name
        branch_name: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete a Git Branch"""
        project_id = self.encode_path_param(project_id)
        branch_name = self.encode_path_param(branch_name)
        response = self.delete(
            f"/projects/{project_id}/git_branch/{branch_name}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Deletes a group (admin only).
    #
    # DELETE /groups/{group_id} -> str
    def delete_group(
        self,
        # Id of group
        group_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Group"""
        response = self.delete(
            f"/groups/{group_id}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Removes a group from a group.
    #
    # DELETE /groups/{group_id}/groups/{deleting_group_id} -> None
    def delete_group_from_group(
        self,
        # Id of group
        group_id: int,
        # Id of group to delete
        deleting_group_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> None:
        """Deletes a Group from Group"""
        response = self.delete(
            f"/groups/{group_id}/groups/{deleting_group_id}",
            None,
            transport_options=transport_options,
        )
        assert response is None
        return response

    # ### Removes a user from a group.
    #
    # DELETE /groups/{group_id}/users/{user_id} -> None
    def delete_group_user(
        self,
        # Id of group
        group_id: int,
        # Id of user to remove from group
        user_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> None:
        """Remove a User from Group"""
        response = self.delete(
            f"/groups/{group_id}/users/{user_id}",
            None,
            transport_options=transport_options,
        )
        assert response is None
        return response

    # ### Delete a homepage.
    #
    # DELETE /homepages/{homepage_id} -> str
    def delete_homepage(
        self,
        # Id of homepage
        homepage_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Homepage"""
        response = self.delete(
            f"/homepages/{homepage_id}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete a homepage item.
    #
    # DELETE /homepage_items/{homepage_item_id} -> str
    def delete_homepage_item(
        self,
        # Id of homepage_item
        homepage_item_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Homepage Item"""
        response = self.delete(
            f"/homepage_items/{homepage_item_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Delete a homepage section.
    #
    # DELETE /homepage_sections/{homepage_section_id} -> str
    def delete_homepage_section(
        self,
        # Id of homepage_section
        homepage_section_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Homepage section"""
        response = self.delete(
            f"/homepage_sections/{homepage_section_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Delete a Integration Hub.
    #
    # DELETE /integration_hubs/{integration_hub_id} -> str
    def delete_integration_hub(
        self,
        # Id of integration_hub
        integration_hub_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Integration Hub"""
        response = self.delete(
            f"/integration_hubs/{integration_hub_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Permanently Delete a Look
    #
    # This operation **permanently** removes a look from the Looker database.
    #
    # NOTE: There is no "undo" for this kind of delete.
    #
    # For information about soft-delete (which can be undone) see [update_look()](#!/Look/update_look).
    #
    # DELETE /looks/{look_id} -> str
    def delete_look(
        self,
        # Id of look
        look_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Look"""
        response = self.delete(
            f"/looks/{look_id}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete a lookml model.
    #
    # DELETE /lookml_models/{lookml_model_name} -> str
    def delete_lookml_model(
        self,
        # Name of lookml model.
        lookml_model_name: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete LookML Model"""
        lookml_model_name = self.encode_path_param(lookml_model_name)
        response = self.delete(
            f"/lookml_models/{lookml_model_name}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Delete the model set with a specific id.
    #
    # DELETE /model_sets/{model_set_id} -> str
    def delete_model_set(
        self,
        # id of model set
        model_set_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Model Set"""
        response = self.delete(
            f"/model_sets/{model_set_id}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete a OIDC test configuration.
    #
    # DELETE /oidc_test_configs/{test_slug} -> str
    def delete_oidc_test_config(
        self,
        # Slug of test config
        test_slug: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete OIDC Test Configuration"""
        test_slug = self.encode_path_param(test_slug)
        response = self.delete(
            f"/oidc_test_configs/{test_slug}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete the permission set with a specific id.
    #
    # DELETE /permission_sets/{permission_set_id} -> str
    def delete_permission_set(
        self,
        # Id of permission set
        permission_set_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Permission Set"""
        response = self.delete(
            f"/permission_sets/{permission_set_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Repository Credential for a remote dependency
    #
    # Admin required.
    #
    # `root_project_id` is required.
    # `credential_id` is required.
    #
    # DELETE /projects/{root_project_id}/credential/{credential_id} -> str
    def delete_repository_credential(
        self,
        # Root Project Id
        root_project_id: str,
        # Credential Id
        credential_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Repository Credential"""
        root_project_id = self.encode_path_param(root_project_id)
        credential_id = self.encode_path_param(credential_id)
        response = self.delete(
            f"/projects/{root_project_id}/credential/{credential_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Delete the role with a specific id.
    #
    # DELETE /roles/{role_id} -> str
    def delete_role(
        self,
        # id of role
        role_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Role"""
        response = self.delete(
            f"/roles/{role_id}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete a SAML test configuration.
    #
    # DELETE /saml_test_configs/{test_slug} -> str
    def delete_saml_test_config(
        self,
        # Slug of test config
        test_slug: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete SAML Test Configuration"""
        test_slug = self.encode_path_param(test_slug)
        response = self.delete(
            f"/saml_test_configs/{test_slug}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete a Scheduled Plan
    #
    # Normal users can only delete their own scheduled plans.
    # Admins can delete other users' scheduled plans.
    # This delete cannot be undone.
    #
    # DELETE /scheduled_plans/{scheduled_plan_id} -> str
    def delete_scheduled_plan(
        self,
        # Scheduled Plan Id
        scheduled_plan_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Scheduled Plan"""
        response = self.delete(
            f"/scheduled_plans/{scheduled_plan_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Delete the space with a specific id including any children spaces.
    # **DANGER** this will delete all looks and dashboards in the space.
    #
    # DELETE /spaces/{space_id} -> str
    def delete_space(
        self,
        # Id of space
        space_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Space"""
        space_id = self.encode_path_param(space_id)
        response = self.delete(
            f"/spaces/{space_id}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete a specific theme by id
    #
    # This operation permanently deletes the identified theme from the database.
    #
    # Because multiple themes can have the same name (with different activation time spans) themes can only be deleted by ID.
    #
    # All IDs associated with a theme name can be retrieved by searching for the theme name with [Theme Search](#!/Theme/search).
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or support@looker.com to update your license for this feature.
    #
    # DELETE /themes/{theme_id} -> str
    def delete_theme(
        self,
        # Id of theme
        theme_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Theme"""
        theme_id = self.encode_path_param(theme_id)
        response = self.delete(
            f"/themes/{theme_id}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete the user with a specific id.
    #
    # **DANGER** this will delete the user and all looks and other information owned by the user.
    #
    # DELETE /users/{user_id} -> str
    def delete_user(
        self,
        # Id of user
        user_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete User"""
        response = self.delete(
            f"/users/{user_id}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Delete a user attribute (admin only).
    #
    # DELETE /user_attributes/{user_attribute_id} -> str
    def delete_user_attribute(
        self,
        # Id of user_attribute
        user_attribute_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete User Attribute"""
        response = self.delete(
            f"/user_attributes/{user_attribute_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Remove a user attribute value from a group.
    #
    # DELETE /groups/{group_id}/attribute_values/{user_attribute_id} -> None
    def delete_user_attribute_group_value(
        self,
        # Id of group
        group_id: int,
        # Id of user attribute
        user_attribute_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> None:
        """Delete User Attribute Group Value"""
        response = self.delete(
            f"/groups/{group_id}/attribute_values/{user_attribute_id}",
            None,
            transport_options=transport_options,
        )
        assert response is None
        return response

    # ### Delete a user attribute value from a user's account settings.
    #
    # After the user attribute value is deleted from the user's account settings, subsequent requests
    # for the user attribute value for this user will draw from the user's groups or the default
    # value of the user attribute. See [Get User Attribute Values](#!/User/user_attribute_user_values) for more
    # information about how user attribute values are resolved.
    #
    # DELETE /users/{user_id}/attribute_values/{user_attribute_id} -> None
    def delete_user_attribute_user_value(
        self,
        # Id of user
        user_id: int,
        # Id of user attribute
        user_attribute_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> None:
        """Delete User Attribute User Value"""
        response = self.delete(
            f"/users/{user_id}/attribute_values/{user_attribute_id}",
            None,
            transport_options=transport_options,
        )
        assert response is None
        return response

    # ### API 3 login information for the specified user. This is for the newer API keys that can be added for any user.
    #
    # DELETE /users/{user_id}/credentials_api3/{credentials_api3_id} -> str
    def delete_user_credentials_api3(
        self,
        # id of user
        user_id: int,
        # id of API 3 Credential
        credentials_api3_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete API 3 Credential"""
        response = self.delete(
            f"/users/{user_id}/credentials_api3/{credentials_api3_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Email/password login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_email -> str
    def delete_user_credentials_email(
        self,
        # id of user
        user_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Email/Password Credential"""
        response = self.delete(
            f"/users/{user_id}/credentials_email",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Embed login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_embed/{credentials_embed_id} -> str
    def delete_user_credentials_embed(
        self,
        # id of user
        user_id: int,
        # id of Embedding Credential
        credentials_embed_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Embedding Credential"""
        response = self.delete(
            f"/users/{user_id}/credentials_embed/{credentials_embed_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Google authentication login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_google -> str
    def delete_user_credentials_google(
        self,
        # id of user
        user_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Google Auth Credential"""
        response = self.delete(
            f"/users/{user_id}/credentials_google",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### LDAP login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_ldap -> str
    def delete_user_credentials_ldap(
        self,
        # id of user
        user_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete LDAP Credential"""
        response = self.delete(
            f"/users/{user_id}/credentials_ldap",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Looker Openid login information for the specified user. Used by Looker Analysts.
    #
    # DELETE /users/{user_id}/credentials_looker_openid -> str
    def delete_user_credentials_looker_openid(
        self,
        # id of user
        user_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Looker OpenId Credential"""
        response = self.delete(
            f"/users/{user_id}/credentials_looker_openid",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### OpenID Connect (OIDC) authentication login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_oidc -> str
    def delete_user_credentials_oidc(
        self,
        # id of user
        user_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete OIDC Auth Credential"""
        response = self.delete(
            f"/users/{user_id}/credentials_oidc",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Saml authentication login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_saml -> str
    def delete_user_credentials_saml(
        self,
        # id of user
        user_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Saml Auth Credential"""
        response = self.delete(
            f"/users/{user_id}/credentials_saml",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Two-factor login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_totp -> str
    def delete_user_credentials_totp(
        self,
        # id of user
        user_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Two-Factor Credential"""
        response = self.delete(
            f"/users/{user_id}/credentials_totp",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Removes login lockout for the associated user.
    #
    # DELETE /user_login_lockout/{key} -> str
    def delete_user_login_lockout(
        self,
        # The key associated with the locked user
        key: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete User Login Lockout"""
        key = self.encode_path_param(key)
        response = self.delete(
            f"/user_login_lockout/{key}", str, transport_options=transport_options
        )
        assert isinstance(response, str)
        return response

    # ### Web login session for the specified user.
    #
    # DELETE /users/{user_id}/sessions/{session_id} -> str
    def delete_user_session(
        self,
        # id of user
        user_id: int,
        # id of Web Login Session
        session_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Delete Web Login Session"""
        response = self.delete(
            f"/users/{user_id}/sessions/{session_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Deploy LookML from this Development Mode Project to Production
    #
    # Git must have been configured, must be in dev mode and deploy permission required
    #
    # Deploy is a two / three step process
    # 1. Push commits in current branch of dev mode project to the production branch (origin/master).
    #    Note a. This step is skipped in read-only projects.
    #    Note b. If this step is unsuccessful for any reason (e.g. rejected non-fastforward because production branch has
    #              commits not in current branch), subsequent steps will be skipped.
    # 2. If this is the first deploy of this project, create the production project with git repository.
    # 3. Pull the production branch into the production project.
    #
    # POST /projects/{project_id}/deploy_to_production -> str
    def deploy_to_production(
        self,
        # Id of project
        project_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Deploy To Production"""
        project_id = self.encode_path_param(project_id)
        response = self.post(
            f"/projects/{project_id}/deploy_to_production",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Retrieve the value for whether or not digest emails is enabled
    #
    # GET /digest_emails_enabled -> models.DigestEmails
    def digest_emails_enabled(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DigestEmails:
        """Get Digest_emails"""
        response = self.get(
            f"/digest_emails_enabled",
            models.DigestEmails,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DigestEmails)
        return response

    # ### Fetch the given url and parse it as a SAML IdP metadata document and return the result.
    # Note that this requires that the url be public or at least at a location where the Looker instance
    # can fetch it without requiring any special authentication.
    #
    # POST /fetch_and_parse_saml_idp_metadata -> models.SamlMetadataParseResult
    def fetch_and_parse_saml_idp_metadata(
        self,
        body: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.SamlMetadataParseResult:
        """Parse SAML IdP Url"""
        assert isinstance(body, str)
        response = self.post(
            f"/fetch_and_parse_saml_idp_metadata",
            models.SamlMetadataParseResult,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.SamlMetadataParseResult)
        return response

    # Returns the Integration form for presentation to the user.
    #
    # POST /integrations/{integration_id}/form -> models.DataActionForm
    def fetch_integration_form(
        self,
        # Id of integration
        integration_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DataActionForm:
        """Fetch Remote Integration Form"""
        integration_id = self.encode_path_param(integration_id)
        response = self.post(
            f"/integrations/{integration_id}/form",
            models.DataActionForm,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DataActionForm)
        return response

    # For some data actions, the remote server may supply a form requesting further user input. This endpoint takes a data action, asks the remote server to generate a form for it, and returns that form to you for presentation to the user.
    #
    # POST /data_actions/form -> models.DataActionForm
    def fetch_remote_data_action_form(
        self,
        body: MutableMapping[str, str],
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DataActionForm:
        """Fetch Remote Data Action Form"""
        assert isinstance(body, MutableMapping)
        response = self.post(
            f"/data_actions/form",
            models.DataActionForm,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DataActionForm)
        return response

    # ### Get the specified Git Branch
    #
    # Returns the git branch specified in branch_name path param if it exists in the given project repository
    #
    # GET /projects/{project_id}/git_branch/{branch_name} -> models.GitBranch
    def find_git_branch(
        self,
        # Project Id
        project_id: str,
        # Branch Name
        branch_name: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.GitBranch:
        """Find a Git Branch"""
        project_id = self.encode_path_param(project_id)
        branch_name = self.encode_path_param(branch_name)
        response = self.get(
            f"/projects/{project_id}/git_branch/{branch_name}",
            models.GitBranch,
            transport_options=transport_options,
        )
        assert isinstance(response, models.GitBranch)
        return response

    # ### Get information about the folder with a specific id.
    #
    # GET /folders/{folder_id} -> models.Folder
    def folder(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Folder:
        """Get Folder"""
        folder_id = self.encode_path_param(folder_id)
        response = self.get(
            f"/folders/{folder_id}",
            models.Folder,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Folder)
        return response

    # ### Get the ancestors of a folder
    #
    # GET /folders/{folder_id}/ancestors -> Sequence[models.Folder]
    def folder_ancestors(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Folder]:
        """Get Folder Ancestors"""
        folder_id = self.encode_path_param(folder_id)
        response = self.get(
            f"/folders/{folder_id}/ancestors",
            Sequence[models.Folder],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get the children of a folder.
    #
    # GET /folders/{folder_id}/children -> Sequence[models.Folder]
    def folder_children(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        # Requested page.
        page: Optional[int] = None,
        # Results per page.
        per_page: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Folder]:
        """Get Folder Children"""
        folder_id = self.encode_path_param(folder_id)
        response = self.get(
            f"/folders/{folder_id}/children",
            Sequence[models.Folder],
            query_params={
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "sorts": sorts,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search the children of a folder
    #
    # GET /folders/{folder_id}/children/search -> Sequence[models.Folder]
    def folder_children_search(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match folder name.
        name: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Folder]:
        """Search Folder Children"""
        folder_id = self.encode_path_param(folder_id)
        response = self.get(
            f"/folders/{folder_id}/children/search",
            Sequence[models.Folder],
            query_params={"fields": fields, "sorts": sorts, "name": name},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get the dashboards in a folder
    #
    # GET /folders/{folder_id}/dashboards -> Sequence[models.Dashboard]
    def folder_dashboards(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Dashboard]:
        """Get Folder Dashboards"""
        folder_id = self.encode_path_param(folder_id)
        response = self.get(
            f"/folders/{folder_id}/dashboards",
            Sequence[models.Dashboard],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get the looks in a folder
    #
    # GET /folders/{folder_id}/looks -> Sequence[models.LookWithQuery]
    def folder_looks(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.LookWithQuery]:
        """Get Folder Looks"""
        folder_id = self.encode_path_param(folder_id)
        response = self.get(
            f"/folders/{folder_id}/looks",
            Sequence[models.LookWithQuery],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get the parent of a folder
    #
    # GET /folders/{folder_id}/parent -> models.Folder
    def folder_parent(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Folder:
        """Get Folder Parent"""
        folder_id = self.encode_path_param(folder_id)
        response = self.get(
            f"/folders/{folder_id}/parent",
            models.Folder,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Folder)
        return response

    # ### Force all credentials_email users to reset their login passwords upon their next login.
    #
    # PUT /password_config/force_password_reset_at_next_login_for_all_users -> str
    def force_password_reset_at_next_login_for_all_users(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Force password reset"""
        response = self.put(
            f"/password_config/force_password_reset_at_next_login_for_all_users",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Get all Repository Credentials for a project
    #
    # `root_project_id` is required.
    #
    # GET /projects/{root_project_id}/credentials -> Sequence[models.RepositoryCredential]
    def get_all_repository_credentials(
        self,
        # Root Project Id
        root_project_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.RepositoryCredential]:
        """Get All Repository Credentials"""
        root_project_id = self.encode_path_param(root_project_id)
        response = self.get(
            f"/projects/{root_project_id}/credentials",
            Sequence[models.RepositoryCredential],
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get the Current Git Branch
    #
    # Returns the git branch currently checked out in the given project repository
    #
    # GET /projects/{project_id}/git_branch -> models.GitBranch
    def git_branch(
        self,
        # Project Id
        project_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.GitBranch:
        """Get Active Git Branch"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}/git_branch",
            models.GitBranch,
            transport_options=transport_options,
        )
        assert isinstance(response, models.GitBranch)
        return response

    # ### Git Deploy Key
    #
    # Returns the ssh public key previously created for a project's git repository.
    #
    # GET /projects/{project_id}/git/deploy_key -> str
    def git_deploy_key(
        self,
        # Project Id
        project_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Git Deploy Key"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}/git/deploy_key",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Get information about a group.
    #
    # GET /groups/{group_id} -> models.Group
    def group(
        self,
        # Id of group
        group_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Group:
        """Get Group"""
        response = self.get(
            f"/groups/{group_id}",
            models.Group,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Group)
        return response

    # ### Get information about a homepage.
    #
    # GET /homepages/{homepage_id} -> models.Homepage
    def homepage(
        self,
        # Id of homepage
        homepage_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Homepage:
        """Get Homepage"""
        response = self.get(
            f"/homepages/{homepage_id}",
            models.Homepage,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Homepage)
        return response

    # ### Get information about a homepage item.
    #
    # GET /homepage_items/{homepage_item_id} -> models.HomepageItem
    def homepage_item(
        self,
        # Id of homepage item
        homepage_item_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.HomepageItem:
        """Get Homepage Item"""
        response = self.get(
            f"/homepage_items/{homepage_item_id}",
            models.HomepageItem,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.HomepageItem)
        return response

    # ### Get information about a homepage section.
    #
    # GET /homepage_sections/{homepage_section_id} -> models.HomepageSection
    def homepage_section(
        self,
        # Id of homepage section
        homepage_section_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.HomepageSection:
        """Get Homepage section"""
        response = self.get(
            f"/homepage_sections/{homepage_section_id}",
            models.HomepageSection,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.HomepageSection)
        return response

    # ### Import a LookML dashboard to a space as a UDD
    # Creates a UDD (a dashboard which exists in the Looker database rather than as a LookML file) from the LookML dashboard
    # and puts it in the space specified. The created UDD will have a lookml_link_id which links to the original LookML dashboard.
    #
    # To give the imported dashboard specify a (e.g. title: "my title") in the body of your request, otherwise the imported
    # dashboard will have the same title as the original LookML dashboard.
    #
    # For this operation to succeed the user must have permission to see the LookML dashboard in question, and have permission to
    # create content in the space the dashboard is being imported to.
    #
    # **Sync** a linked UDD with [sync_lookml_dashboard()](#!/Dashboard/sync_lookml_dashboard)
    # **Unlink** a linked UDD by setting lookml_link_id to null with [update_dashboard()](#!/Dashboard/update_dashboard)
    #
    # POST /dashboards/{lookml_dashboard_id}/import/{space_id} -> models.Dashboard
    def import_lookml_dashboard(
        self,
        # Id of LookML dashboard
        lookml_dashboard_id: str,
        # Id of space to import the dashboard to
        space_id: str,
        body: Optional[models.WriteDashboard] = None,
        # If true, and this dashboard is localized, export it with the raw keys, not localized.
        raw_locale: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Dashboard:
        """Import LookML Dashboard"""
        lookml_dashboard_id = self.encode_path_param(lookml_dashboard_id)
        space_id = self.encode_path_param(space_id)
        if body:
            assert isinstance(body, models.WriteDashboard)
        response = self.post(
            f"/dashboards/{lookml_dashboard_id}/import/{space_id}",
            models.Dashboard,
            query_params={"raw_locale": raw_locale},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Dashboard)
        return response

    # ### Get information about a Integration.
    #
    # GET /integrations/{integration_id} -> models.Integration
    def integration(
        self,
        # Id of integration
        integration_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Integration:
        """Get Integration"""
        integration_id = self.encode_path_param(integration_id)
        response = self.get(
            f"/integrations/{integration_id}",
            models.Integration,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Integration)
        return response

    # ### Get information about a Integration Hub.
    #
    # GET /integration_hubs/{integration_hub_id} -> models.IntegrationHub
    def integration_hub(
        self,
        # Id of Integration Hub
        integration_hub_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.IntegrationHub:
        """Get Integration Hub"""
        response = self.get(
            f"/integration_hubs/{integration_hub_id}",
            models.IntegrationHub,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.IntegrationHub)
        return response

    # ### Get and set the options for internal help resources
    #
    # GET /internal_help_resources_enabled -> models.InternalHelpResources
    def internal_help_resources(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.InternalHelpResources:
        """Get Internal Help Resources"""
        response = self.get(
            f"/internal_help_resources_enabled",
            models.InternalHelpResources,
            transport_options=transport_options,
        )
        assert isinstance(response, models.InternalHelpResources)
        return response

    # ### Set the menu item name and content for internal help resources
    #
    # GET /internal_help_resources_content -> models.InternalHelpResourcesContent
    def internal_help_resources_content(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.InternalHelpResourcesContent:
        """Get Internal Help Resources Content"""
        response = self.get(
            f"/internal_help_resources_content",
            models.InternalHelpResourcesContent,
            transport_options=transport_options,
        )
        assert isinstance(response, models.InternalHelpResourcesContent)
        return response

    # Kill a query with a specific query_task_id.
    #
    # DELETE /running_queries/{query_task_id} -> str
    def kill_query(
        self,
        # Query task id.
        query_task_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Kill Running Query"""
        query_task_id = self.encode_path_param(query_task_id)
        response = self.delete(
            f"/running_queries/{query_task_id}",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Get the LDAP configuration.
    #
    # Looker can be optionally configured to authenticate users against an Active Directory or other LDAP directory server.
    # LDAP setup requires coordination with an administrator of that directory server.
    #
    # Only Looker administrators can read and update the LDAP configuration.
    #
    # Configuring LDAP impacts authentication for all users. This configuration should be done carefully.
    #
    # Looker maintains a single LDAP configuration. It can be read and updated.       Updates only succeed if the new state will be valid (in the sense that all required fields are populated);       it is up to you to ensure that the configuration is appropriate and correct).
    #
    # LDAP is enabled or disabled for Looker using the **enabled** field.
    #
    # Looker will never return an **auth_password** field. That value can be set, but never retrieved.
    #
    # See the [Looker LDAP docs](https://www.looker.com/docs/r/api/ldap_setup) for additional information.
    #
    # GET /ldap_config -> models.LDAPConfig
    def ldap_config(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LDAPConfig:
        """Get LDAP Configuration"""
        response = self.get(
            f"/ldap_config", models.LDAPConfig, transport_options=transport_options
        )
        assert isinstance(response, models.LDAPConfig)
        return response

    # ### Get information about the legacy feature with a specific id.
    #
    # GET /legacy_features/{legacy_feature_id} -> models.LegacyFeature
    def legacy_feature(
        self,
        # id of legacy feature
        legacy_feature_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LegacyFeature:
        """Get Legacy Feature"""
        legacy_feature_id = self.encode_path_param(legacy_feature_id)
        response = self.get(
            f"/legacy_features/{legacy_feature_id}",
            models.LegacyFeature,
            transport_options=transport_options,
        )
        assert isinstance(response, models.LegacyFeature)
        return response

    # login() using api3credentials is automated in the client

    def login_user(self, user_id: int) -> api_methods.APIMethods:
        return super().login_user(user_id)

    def logout(self) -> None:
        super().logout()

    # ### Get a Look.
    #
    # Returns detailed information about a Look and its associated Query.
    #
    # GET /looks/{look_id} -> models.LookWithQuery
    def look(
        self,
        # Id of look
        look_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LookWithQuery:
        """Get Look"""
        response = self.get(
            f"/looks/{look_id}",
            models.LookWithQuery,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.LookWithQuery)
        return response

    # ### Get information about a lookml model.
    #
    # GET /lookml_models/{lookml_model_name} -> models.LookmlModel
    def lookml_model(
        self,
        # Name of lookml model.
        lookml_model_name: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LookmlModel:
        """Get LookML Model"""
        lookml_model_name = self.encode_path_param(lookml_model_name)
        response = self.get(
            f"/lookml_models/{lookml_model_name}",
            models.LookmlModel,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.LookmlModel)
        return response

    # ### Get information about a lookml model explore.
    #
    # GET /lookml_models/{lookml_model_name}/explores/{explore_name} -> models.LookmlModelExplore
    def lookml_model_explore(
        self,
        # Name of lookml model.
        lookml_model_name: str,
        # Name of explore.
        explore_name: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LookmlModelExplore:
        """Get LookML Model Explore"""
        lookml_model_name = self.encode_path_param(lookml_model_name)
        explore_name = self.encode_path_param(explore_name)
        response = self.get(
            f"/lookml_models/{lookml_model_name}/explores/{explore_name}",
            models.LookmlModelExplore,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.LookmlModelExplore)
        return response

    # ### Get A Projects Manifest object
    #
    # Returns the project with the given project id
    #
    # GET /projects/{project_id}/manifest -> models.Manifest
    def manifest(
        self,
        # Project Id
        project_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Manifest:
        """Get Manifest"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}/manifest",
            models.Manifest,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Manifest)
        return response

    # ### Get information about the current user; i.e. the user account currently calling the API.
    #
    # GET /user -> models.User
    def me(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.User:
        """Get Current User"""
        response = self.get(
            f"/user",
            models.User,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.User)
        return response

    # ### Get Merge Query
    #
    # Returns a merge query object given its id.
    #
    # GET /merge_queries/{merge_query_id} -> models.MergeQuery
    def merge_query(
        self,
        # Merge Query Id
        merge_query_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.MergeQuery:
        """Get Merge Query"""
        merge_query_id = self.encode_path_param(merge_query_id)
        response = self.get(
            f"/merge_queries/{merge_query_id}",
            models.MergeQuery,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.MergeQuery)
        return response

    # ### Get information about the model set with a specific id.
    #
    # GET /model_sets/{model_set_id} -> models.ModelSet
    def model_set(
        self,
        # Id of model set
        model_set_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ModelSet:
        """Get Model Set"""
        response = self.get(
            f"/model_sets/{model_set_id}",
            models.ModelSet,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ModelSet)
        return response

    # ### Get the OIDC configuration.
    #
    # Looker can be optionally configured to authenticate users against an OpenID Connect (OIDC)
    # authentication server. OIDC setup requires coordination with an administrator of that server.
    #
    # Only Looker administrators can read and update the OIDC configuration.
    #
    # Configuring OIDC impacts authentication for all users. This configuration should be done carefully.
    #
    # Looker maintains a single OIDC configuation. It can be read and updated.       Updates only succeed if the new state will be valid (in the sense that all required fields are populated);       it is up to you to ensure that the configuration is appropriate and correct).
    #
    # OIDC is enabled or disabled for Looker using the **enabled** field.
    #
    # GET /oidc_config -> models.OIDCConfig
    def oidc_config(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.OIDCConfig:
        """Get OIDC Configuration"""
        response = self.get(
            f"/oidc_config", models.OIDCConfig, transport_options=transport_options
        )
        assert isinstance(response, models.OIDCConfig)
        return response

    # ### Get a OIDC test configuration by test_slug.
    #
    # GET /oidc_test_configs/{test_slug} -> models.OIDCConfig
    def oidc_test_config(
        self,
        # Slug of test config
        test_slug: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.OIDCConfig:
        """Get OIDC Test Configuration"""
        test_slug = self.encode_path_param(test_slug)
        response = self.get(
            f"/oidc_test_configs/{test_slug}",
            models.OIDCConfig,
            transport_options=transport_options,
        )
        assert isinstance(response, models.OIDCConfig)
        return response

    # ### Parse the given xml as a SAML IdP metadata document and return the result.
    #
    # POST /parse_saml_idp_metadata -> models.SamlMetadataParseResult
    def parse_saml_idp_metadata(
        self,
        body: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.SamlMetadataParseResult:
        """Parse SAML IdP XML"""
        assert isinstance(body, str)
        response = self.post(
            f"/parse_saml_idp_metadata",
            models.SamlMetadataParseResult,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.SamlMetadataParseResult)
        return response

    # ### Get password config.
    #
    # GET /password_config -> models.PasswordConfig
    def password_config(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.PasswordConfig:
        """Get Password Config"""
        response = self.get(
            f"/password_config",
            models.PasswordConfig,
            transport_options=transport_options,
        )
        assert isinstance(response, models.PasswordConfig)
        return response

    # Perform a data action. The data action object can be obtained from query results, and used to perform an arbitrary action.
    #
    # POST /data_actions -> models.DataActionResponse
    def perform_data_action(
        self,
        body: models.DataActionRequest,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DataActionResponse:
        """Send a Data Action"""
        assert isinstance(body, models.DataActionRequest)
        response = self.post(
            f"/data_actions",
            models.DataActionResponse,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DataActionResponse)
        return response

    # ### Get information about the permission set with a specific id.
    #
    # GET /permission_sets/{permission_set_id} -> models.PermissionSet
    def permission_set(
        self,
        # Id of permission set
        permission_set_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.PermissionSet:
        """Get Permission Set"""
        response = self.get(
            f"/permission_sets/{permission_set_id}",
            models.PermissionSet,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.PermissionSet)
        return response

    # ### Get A Project
    #
    # Returns the project with the given project id
    #
    # GET /projects/{project_id} -> models.Project
    def project(
        self,
        # Project Id
        project_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Project:
        """Get Project"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}",
            models.Project,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Project)
        return response

    # ### Get Project File Info
    #
    # Returns information about a file in the project
    #
    # GET /projects/{project_id}/files/file -> models.ProjectFile
    def project_file(
        self,
        # Project Id
        project_id: str,
        # File Id
        file_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ProjectFile:
        """Get Project File"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}/files/file",
            models.ProjectFile,
            query_params={"file_id": file_id, "fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ProjectFile)
        return response

    # ### Get Cached Project Validation Results
    #
    # Returns the cached results of a previous project validation calculation, if any.
    # Returns http status 204 No Content if no validation results exist.
    #
    # Validating the content of all the files in a project can be computationally intensive
    # for large projects. Use this API to simply fetch the results of the most recent
    # project validation rather than revalidating the entire project from scratch.
    #
    # A value of `"stale": true` in the response indicates that the project has changed since
    # the cached validation results were computed. The cached validation results may no longer
    # reflect the current state of the project.
    #
    # GET /projects/{project_id}/validate -> models.ProjectValidationCache
    def project_validation_results(
        self,
        # Project Id
        project_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ProjectValidationCache:
        """Cached Project Validation Results"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}/validate",
            models.ProjectValidationCache,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ProjectValidationCache)
        return response

    # ### Get Project Workspace
    #
    # Returns information about the state of the project files in the currently selected workspace
    #
    # GET /projects/{project_id}/current_workspace -> models.ProjectWorkspace
    def project_workspace(
        self,
        # Project Id
        project_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ProjectWorkspace:
        """Get Project Workspace"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}/current_workspace",
            models.ProjectWorkspace,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ProjectWorkspace)
        return response

    # ### Get a previously created query by id.
    #
    # A Looker query object includes the various parameters that define a database query that has been run or
    # could be run in the future. These parameters include: model, view, fields, filters, pivots, etc.
    # Query *results* are not part of the query object.
    #
    # Query objects are unique and immutable. Query objects are created automatically in Looker as users explore data.
    # Looker does not delete them; they become part of the query history. When asked to create a query for
    # any given set of parameters, Looker will first try to find an existing query object with matching
    # parameters and will only create a new object when an appropriate object can not be found.
    #
    # This 'get' method is used to get the details about a query for a given id. See the other methods here
    # to 'create' and 'run' queries.
    #
    # Note that some fields like 'filter_config' and 'vis_config' etc are specific to how the Looker UI
    # builds queries and visualizations and are not generally useful for API use. They are not required when
    # creating new queries and can usually just be ignored.
    #
    # GET /queries/{query_id} -> models.Query
    def query(
        self,
        # Id of query
        query_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Query:
        """Get Query"""
        response = self.get(
            f"/queries/{query_id}",
            models.Query,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Query)
        return response

    # ### Get the query for a given query slug.
    #
    # This returns the query for the 'slug' in a query share URL.
    #
    # The 'slug' is a randomly chosen short string that is used as an alternative to the query's id value
    # for use in URLs etc. This method exists as a convenience to help you use the API to 'find' queries that
    # have been created using the Looker UI.
    #
    # You can use the Looker explore page to build a query and then choose the 'Share' option to
    # show the share url for the query. Share urls generally look something like 'https://looker.yourcompany/x/vwGSbfc'.
    # The trailing 'vwGSbfc' is the share slug. You can pass that string to this api method to get details about the query.
    # Those details include the 'id' that you can use to run the query. Or, you can copy the query body
    # (perhaps with your own modification) and use that as the basis to make/run new queries.
    #
    # This will also work with slugs from Looker explore urls like
    # 'https://looker.yourcompany/explore/ecommerce/orders?qid=aogBgL6o3cKK1jN3RoZl5s'. In this case
    # 'aogBgL6o3cKK1jN3RoZl5s' is the slug.
    #
    # GET /queries/slug/{slug} -> models.Query
    def query_for_slug(
        self,
        # Slug of query
        slug: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Query:
        """Get Query for Slug"""
        slug = self.encode_path_param(slug)
        response = self.get(
            f"/queries/slug/{slug}",
            models.Query,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Query)
        return response

    # ### Get Query Task details
    #
    # Use this function to check the status of an async query task. After the status
    # reaches "Complete", you can call [query_task_results(query_task_id)](#!/Query/query_task_results) to
    # retrieve the results of the query.
    #
    # Use [create_query_task()](#!/Query/create_query_task) to create an async query task.
    #
    # GET /query_tasks/{query_task_id} -> models.QueryTask
    def query_task(
        self,
        # ID of the Query Task
        query_task_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.QueryTask:
        """Get Async Query Info"""
        query_task_id = self.encode_path_param(query_task_id)
        response = self.get(
            f"/query_tasks/{query_task_id}",
            models.QueryTask,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.QueryTask)
        return response

    # ### Fetch results of multiple async queries
    #
    # Returns the results of multiple async queries in one request.
    #
    # For Query Tasks that are not completed, the response will include the execution status of the Query Task but will not include query results.
    # Query Tasks whose results have expired will have a status of 'expired'.
    # If the user making the API request does not have sufficient privileges to view a Query Task result, the result will have a status of 'missing'
    #
    # GET /query_tasks/multi_results -> MutableMapping[str, str]
    def query_task_multi_results(
        self,
        # List of Query Task IDs
        query_task_ids: models.DelimSequence[str],
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> MutableMapping[str, str]:
        """Get Multiple Async Query Results"""
        response = self.get(
            f"/query_tasks/multi_results",
            MutableMapping[str, str],
            query_params={"query_task_ids": query_task_ids},
            transport_options=transport_options,
        )
        assert isinstance(response, dict)
        return response

    # ### Get Async Query Results
    #
    # Returns the results of an async query task if the query has completed.
    #
    # If the query task is still running or waiting to run, this function returns 204 No Content.
    #
    # If the query task ID is invalid or the cached results of the query task have expired, this function returns 404 Not Found.
    #
    # Use [query_task(query_task_id)](#!/Query/query_task) to check the execution status of the query task
    # Call query_task_results only after the query task status reaches "Complete".
    #
    # You can also use [query_task_multi_results()](#!/Query/query_task_multi_results) retrieve the
    # results of multiple async query tasks at the same time.
    #
    # #### SQL Error Handling:
    # If the query fails due to a SQL db error, how this is communicated depends on the result_format you requested in `create_query_task()`.
    #
    # For `json_detail` result_format: `query_task_results()` will respond with HTTP status '200 OK' and db SQL error info
    # will be in the `errors` property of the response object. The 'data' property will be empty.
    #
    # For all other result formats: `query_task_results()` will respond with HTTP status `400 Bad Request` and some db SQL error info
    # will be in the message of the 400 error response, but not as detailed as expressed in `json_detail.errors`.
    # These data formats can only carry row data, and error info is not row data.
    #
    # GET /query_tasks/{query_task_id}/results -> str
    def query_task_results(
        self,
        # ID of the Query Task
        query_task_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Get Async Query Results"""
        query_task_id = self.encode_path_param(query_task_id)
        response = self.get(
            f"/query_tasks/{query_task_id}/results",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Get information about a render task.
    #
    # Returns a render task object.
    # To check the status of a render task, pass the render_task.id to [Get Render Task](#!/RenderTask/get_render_task).
    # Once the render task is complete, you can download the resulting document or image using [Get Render Task Results](#!/RenderTask/get_render_task_results).
    #
    # GET /render_tasks/{render_task_id} -> models.RenderTask
    def render_task(
        self,
        # Id of render task
        render_task_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.RenderTask:
        """Get Render Task"""
        render_task_id = self.encode_path_param(render_task_id)
        response = self.get(
            f"/render_tasks/{render_task_id}",
            models.RenderTask,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.RenderTask)
        return response

    # ### Get the document or image produced by a completed render task.
    #
    # Note that the PDF or image result will be a binary blob in the HTTP response, as indicated by the
    # Content-Type in the response headers. This may require specialized (or at least different) handling than text
    # responses such as JSON. You may need to tell your HTTP client that the response is binary so that it does not
    # attempt to parse the binary data as text.
    #
    # If the render task exists but has not finished rendering the results, the response HTTP status will be
    # **202 Accepted**, the response body will be empty, and the response will have a Retry-After header indicating
    # that the caller should repeat the request at a later time.
    #
    # Returns 404 if the render task cannot be found, if the cached result has expired, or if the caller
    # does not have permission to view the results.
    #
    # For detailed information about the status of the render task, use [Render Task](#!/RenderTask/render_task).
    # Polling loops waiting for completion of a render task would be better served by polling **render_task(id)** until
    # the task status reaches completion (or error) instead of polling **render_task_results(id)** alone.
    #
    # GET /render_tasks/{render_task_id}/results -> bytes
    def render_task_results(
        self,
        # Id of render task
        render_task_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> bytes:
        """Render Task Results"""
        render_task_id = self.encode_path_param(render_task_id)
        response = self.get(
            f"/render_tasks/{render_task_id}/results",
            bytes,
            transport_options=transport_options,
        )
        assert isinstance(response, bytes)
        return response

    # ### Reset a project to the revision of the project that is in production.
    #
    # **DANGER** this will delete any changes that have not been pushed to a remote repository.
    #
    # POST /projects/{project_id}/reset_to_production -> str
    def reset_project_to_production(
        self,
        # Id of project
        project_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Reset To Production"""
        project_id = self.encode_path_param(project_id)
        response = self.post(
            f"/projects/{project_id}/reset_to_production",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Reset a project development branch to the revision of the project that is on the remote.
    #
    # **DANGER** this will delete any changes that have not been pushed to a remote repository.
    #
    # POST /projects/{project_id}/reset_to_remote -> str
    def reset_project_to_remote(
        self,
        # Id of project
        project_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Reset To Remote"""
        project_id = self.encode_path_param(project_id)
        response = self.post(
            f"/projects/{project_id}/reset_to_remote",
            str,
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Get information about the role with a specific id.
    #
    # GET /roles/{role_id} -> models.Role
    def role(
        self,
        # id of role
        role_id: int,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Role:
        """Get Role"""
        response = self.get(
            f"/roles/{role_id}", models.Role, transport_options=transport_options
        )
        assert isinstance(response, models.Role)
        return response

    # ### Get information about all the groups with the role that has a specific id.
    #
    # GET /roles/{role_id}/groups -> Sequence[models.Group]
    def role_groups(
        self,
        # id of role
        role_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Group]:
        """Get Role Groups"""
        response = self.get(
            f"/roles/{role_id}/groups",
            Sequence[models.Group],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about all the users with the role that has a specific id.
    #
    # GET /roles/{role_id}/users -> Sequence[models.User]
    def role_users(
        self,
        # id of user
        role_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        # Get only users associated directly with the role: exclude those only associated through groups.
        direct_association_only: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.User]:
        """Get Role Users"""
        response = self.get(
            f"/roles/{role_id}/users",
            Sequence[models.User],
            query_params={
                "fields": fields,
                "direct_association_only": direct_association_only,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Run a git connection test
    #
    # Run the named test on the git service used by this project (or the dependency project for the provided remote_url) and return the result. This
    # is intended to help debug git connections when things do not work properly, to give
    # more helpful information about why a git url is not working with Looker.
    #
    # Tests should be run in the order they are returned by [Get All Git Connection Tests](#!/Project/all_git_connection_tests).
    #
    # GET /projects/{project_id}/git_connection_tests/{test_id} -> models.GitConnectionTestResult
    def run_git_connection_test(
        self,
        # Project Id
        project_id: str,
        # Test Id
        test_id: str,
        # (Optional: leave blank for root project) The remote url for remote dependency to test.
        remote_url: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.GitConnectionTestResult:
        """Run Git Connection Test"""
        project_id = self.encode_path_param(project_id)
        test_id = self.encode_path_param(test_id)
        response = self.get(
            f"/projects/{project_id}/git_connection_tests/{test_id}",
            models.GitConnectionTestResult,
            query_params={"remote_url": remote_url},
            transport_options=transport_options,
        )
        assert isinstance(response, models.GitConnectionTestResult)
        return response

    # ### Run the query that is specified inline in the posted body.
    #
    # This allows running a query as defined in json in the posted body. This combines
    # the two actions of posting & running a query into one step.
    #
    # Here is an example body in json:
    # ```
    # {
    #   "model":"thelook",
    #   "view":"inventory_items",
    #   "fields":["category.name","inventory_items.days_in_inventory_tier","products.count"],
    #   "filters":{"category.name":"socks"},
    #   "sorts":["products.count desc 0"],
    #   "limit":"500",
    #   "query_timezone":"America/Los_Angeles"
    # }
    # ```
    #
    # When using the Ruby SDK this would be passed as a Ruby hash like:
    # ```
    # {
    #  :model=>"thelook",
    #  :view=>"inventory_items",
    #  :fields=>
    #   ["category.name",
    #    "inventory_items.days_in_inventory_tier",
    #    "products.count"],
    #  :filters=>{:"category.name"=>"socks"},
    #  :sorts=>["products.count desc 0"],
    #  :limit=>"500",
    #  :query_timezone=>"America/Los_Angeles",
    # }
    # ```
    #
    # This will return the result of running the query in the format specified by the 'result_format' parameter.
    #
    # Supported formats:
    #
    # | result_format | Description
    # | :-----------: | :--- |
    # | json | Plain json
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | md | Simple markdown
    # | xlsx | MS Excel spreadsheet
    # | sql | Returns the generated SQL rather than running the query
    # | png | A PNG image of the visualization of the query
    # | jpg | A JPG image of the visualization of the query
    #
    # POST /queries/run/{result_format} -> Union[str, bytes]
    def run_inline_query(
        self,
        # Format of result
        result_format: str,
        body: models.WriteQuery,
        # Row limit (may override the limit in the saved query).
        limit: Optional[int] = None,
        # Apply model-specified formatting to each result.
        apply_formatting: Optional[bool] = None,
        # Apply visualization options to results.
        apply_vis: Optional[bool] = None,
        # Get results from cache if available.
        cache: Optional[bool] = None,
        # Render width for image formats.
        image_width: Optional[int] = None,
        # Render height for image formats.
        image_height: Optional[int] = None,
        # Generate drill links (only applicable to 'json_detail' format.
        generate_drill_links: Optional[bool] = None,
        # Force use of production models even if the user is in development mode.
        force_production: Optional[bool] = None,
        # Retrieve any results from cache even if the results have expired.
        cache_only: Optional[bool] = None,
        # Prefix to use for drill links (url encoded).
        path_prefix: Optional[str] = None,
        # Rebuild PDTS used in query.
        rebuild_pdts: Optional[bool] = None,
        # Perform table calculations on query results
        server_table_calcs: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Union[str, bytes]:
        """Run Inline Query"""
        result_format = self.encode_path_param(result_format)
        assert isinstance(body, models.WriteQuery)
        response = self.post(
            f"/queries/run/{result_format}",
            Union[str, bytes],  # type: ignore
            query_params={
                "limit": limit,
                "apply_formatting": apply_formatting,
                "apply_vis": apply_vis,
                "cache": cache,
                "image_width": image_width,
                "image_height": image_height,
                "generate_drill_links": generate_drill_links,
                "force_production": force_production,
                "cache_only": cache_only,
                "path_prefix": path_prefix,
                "rebuild_pdts": rebuild_pdts,
                "server_table_calcs": server_table_calcs,
            },
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, (str, bytes))
        return response

    # ### Run a Look
    #
    # Runs a given look's query and returns the results in the requested format.
    #
    # Supported formats:
    #
    # | result_format | Description
    # | :-----------: | :--- |
    # | json | Plain json
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | md | Simple markdown
    # | xlsx | MS Excel spreadsheet
    # | sql | Returns the generated SQL rather than running the query
    # | png | A PNG image of the visualization of the query
    # | jpg | A JPG image of the visualization of the query
    #
    # GET /looks/{look_id}/run/{result_format} -> Union[str, bytes]
    def run_look(
        self,
        # Id of look
        look_id: int,
        # Format of result
        result_format: str,
        # Row limit (may override the limit in the saved query).
        limit: Optional[int] = None,
        # Apply model-specified formatting to each result.
        apply_formatting: Optional[bool] = None,
        # Apply visualization options to results.
        apply_vis: Optional[bool] = None,
        # Get results from cache if available.
        cache: Optional[bool] = None,
        # Render width for image formats.
        image_width: Optional[int] = None,
        # Render height for image formats.
        image_height: Optional[int] = None,
        # Generate drill links (only applicable to 'json_detail' format.
        generate_drill_links: Optional[bool] = None,
        # Force use of production models even if the user is in development mode.
        force_production: Optional[bool] = None,
        # Retrieve any results from cache even if the results have expired.
        cache_only: Optional[bool] = None,
        # Prefix to use for drill links (url encoded).
        path_prefix: Optional[str] = None,
        # Rebuild PDTS used in query.
        rebuild_pdts: Optional[bool] = None,
        # Perform table calculations on query results
        server_table_calcs: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Union[str, bytes]:
        """Run Look"""
        result_format = self.encode_path_param(result_format)
        response = self.get(
            f"/looks/{look_id}/run/{result_format}",
            Union[str, bytes],  # type: ignore
            query_params={
                "limit": limit,
                "apply_formatting": apply_formatting,
                "apply_vis": apply_vis,
                "cache": cache,
                "image_width": image_width,
                "image_height": image_height,
                "generate_drill_links": generate_drill_links,
                "force_production": force_production,
                "cache_only": cache_only,
                "path_prefix": path_prefix,
                "rebuild_pdts": rebuild_pdts,
                "server_table_calcs": server_table_calcs,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, (str, bytes))
        return response

    # ### Run LookML Tests
    #
    # Runs all tests in the project, optionally filtered by file, test, and/or model.
    #
    # GET /projects/{project_id}/lookml_tests/run -> Sequence[models.LookmlTestResult]
    def run_lookml_test(
        self,
        # Project Id
        project_id: str,
        # File Name
        file_id: Optional[str] = None,
        # Test Name
        test: Optional[str] = None,
        # Model Name
        model: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.LookmlTestResult]:
        """Run LookML Test"""
        project_id = self.encode_path_param(project_id)
        response = self.get(
            f"/projects/{project_id}/lookml_tests/run",
            Sequence[models.LookmlTestResult],
            query_params={"file_id": file_id, "test": test, "model": model},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Run a saved query.
    #
    # This runs a previously saved query. You can use this on a query that was generated in the Looker UI
    # or one that you have explicitly created using the API. You can also use a query 'id' from a saved 'Look'.
    #
    # The 'result_format' parameter specifies the desired structure and format of the response.
    #
    # Supported formats:
    #
    # | result_format | Description
    # | :-----------: | :--- |
    # | json | Plain json
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | md | Simple markdown
    # | xlsx | MS Excel spreadsheet
    # | sql | Returns the generated SQL rather than running the query
    # | png | A PNG image of the visualization of the query
    # | jpg | A JPG image of the visualization of the query
    #
    # GET /queries/{query_id}/run/{result_format} -> Union[str, bytes]
    def run_query(
        self,
        # Id of query
        query_id: int,
        # Format of result
        result_format: str,
        # Row limit (may override the limit in the saved query).
        limit: Optional[int] = None,
        # Apply model-specified formatting to each result.
        apply_formatting: Optional[bool] = None,
        # Apply visualization options to results.
        apply_vis: Optional[bool] = None,
        # Get results from cache if available.
        cache: Optional[bool] = None,
        # Render width for image formats.
        image_width: Optional[int] = None,
        # Render height for image formats.
        image_height: Optional[int] = None,
        # Generate drill links (only applicable to 'json_detail' format.
        generate_drill_links: Optional[bool] = None,
        # Force use of production models even if the user is in development mode.
        force_production: Optional[bool] = None,
        # Retrieve any results from cache even if the results have expired.
        cache_only: Optional[bool] = None,
        # Prefix to use for drill links (url encoded).
        path_prefix: Optional[str] = None,
        # Rebuild PDTS used in query.
        rebuild_pdts: Optional[bool] = None,
        # Perform table calculations on query results
        server_table_calcs: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Union[str, bytes]:
        """Run Query"""
        result_format = self.encode_path_param(result_format)
        response = self.get(
            f"/queries/{query_id}/run/{result_format}",
            Union[str, bytes],  # type: ignore
            query_params={
                "limit": limit,
                "apply_formatting": apply_formatting,
                "apply_vis": apply_vis,
                "cache": cache,
                "image_width": image_width,
                "image_height": image_height,
                "generate_drill_links": generate_drill_links,
                "force_production": force_production,
                "cache_only": cache_only,
                "path_prefix": path_prefix,
                "rebuild_pdts": rebuild_pdts,
                "server_table_calcs": server_table_calcs,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, (str, bytes))
        return response

    # Execute a SQL Runner query in a given result_format.
    #
    # POST /sql_queries/{slug}/run/{result_format} -> Union[str, bytes]
    def run_sql_query(
        self,
        # slug of query
        slug: str,
        # Format of result, options are: ["json", "json_detail", "json_fe", "csv", "html", "md", "txt", "xlsx", "gsxml", "json_label"]
        result_format: str,
        # Defaults to false. If set to true, the HTTP response will have content-disposition and other headers set to make the HTTP response behave as a downloadable attachment instead of as inline content.
        download: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Union[str, bytes]:
        """Run SQL Runner Query"""
        slug = self.encode_path_param(slug)
        result_format = self.encode_path_param(result_format)
        response = self.post(
            f"/sql_queries/{slug}/run/{result_format}",
            Union[str, bytes],  # type: ignore
            query_params={"download": download},
            transport_options=transport_options,
        )
        assert isinstance(response, (str, bytes))
        return response

    # ### Run an URL encoded query.
    #
    # This requires the caller to encode the specifiers for the query into the URL query part using
    # Looker-specific syntax as explained below.
    #
    # Generally, you would want to use one of the methods that takes the parameters as json in the POST body
    # for creating and/or running queries. This method exists for cases where one really needs to encode the
    # parameters into the URL of a single 'GET' request. This matches the way that the Looker UI formats
    # 'explore' URLs etc.
    #
    # The parameters here are very similar to the json body formatting except that the filter syntax is
    # tricky. Unfortunately, this format makes this method not currently callible via the 'Try it out!' button
    # in this documentation page. But, this is callable  when creating URLs manually or when using the Looker SDK.
    #
    # Here is an example inline query URL:
    #
    # ```
    # https://looker.mycompany.com:19999/api/3.0/queries/models/thelook/views/inventory_items/run/json?fields=category.name,inventory_items.days_in_inventory_tier,products.count&f[category.name]=socks&sorts=products.count+desc+0&limit=500&query_timezone=America/Los_Angeles
    # ```
    #
    # When invoking this endpoint with the Ruby SDK, pass the query parameter parts as a hash. The hash to match the above would look like:
    #
    # ```ruby
    # query_params =
    # {
    #   :fields => "category.name,inventory_items.days_in_inventory_tier,products.count",
    #   :"f[category.name]" => "socks",
    #   :sorts => "products.count desc 0",
    #   :limit => "500",
    #   :query_timezone => "America/Los_Angeles"
    # }
    # response = ruby_sdk.run_url_encoded_query('thelook','inventory_items','json', query_params)
    #
    # ```
    #
    # Again, it is generally easier to use the variant of this method that passes the full query in the POST body.
    # This method is available for cases where other alternatives won't fit the need.
    #
    # Supported formats:
    #
    # | result_format | Description
    # | :-----------: | :--- |
    # | json | Plain json
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | md | Simple markdown
    # | xlsx | MS Excel spreadsheet
    # | sql | Returns the generated SQL rather than running the query
    # | png | A PNG image of the visualization of the query
    # | jpg | A JPG image of the visualization of the query
    #
    # GET /queries/models/{model_name}/views/{view_name}/run/{result_format} -> Union[str, bytes]
    def run_url_encoded_query(
        self,
        # Model name
        model_name: str,
        # View name
        view_name: str,
        # Format of result
        result_format: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Union[str, bytes]:
        """Run Url Encoded Query"""
        model_name = self.encode_path_param(model_name)
        view_name = self.encode_path_param(view_name)
        result_format = self.encode_path_param(result_format)
        response = self.get(
            f"/queries/models/{model_name}/views/{view_name}/run/{result_format}",
            Union[str, bytes],  # type: ignore
            transport_options=transport_options,
        )
        assert isinstance(response, (str, bytes))
        return response

    # ### Get the SAML configuration.
    #
    # Looker can be optionally configured to authenticate users against a SAML authentication server.
    # SAML setup requires coordination with an administrator of that server.
    #
    # Only Looker administrators can read and update the SAML configuration.
    #
    # Configuring SAML impacts authentication for all users. This configuration should be done carefully.
    #
    # Looker maintains a single SAML configuation. It can be read and updated.       Updates only succeed if the new state will be valid (in the sense that all required fields are populated);       it is up to you to ensure that the configuration is appropriate and correct).
    #
    # SAML is enabled or disabled for Looker using the **enabled** field.
    #
    # GET /saml_config -> models.SamlConfig
    def saml_config(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.SamlConfig:
        """Get SAML Configuration"""
        response = self.get(
            f"/saml_config", models.SamlConfig, transport_options=transport_options
        )
        assert isinstance(response, models.SamlConfig)
        return response

    # ### Get a SAML test configuration by test_slug.
    #
    # GET /saml_test_configs/{test_slug} -> models.SamlConfig
    def saml_test_config(
        self,
        # Slug of test config
        test_slug: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.SamlConfig:
        """Get SAML Test Configuration"""
        test_slug = self.encode_path_param(test_slug)
        response = self.get(
            f"/saml_test_configs/{test_slug}",
            models.SamlConfig,
            transport_options=transport_options,
        )
        assert isinstance(response, models.SamlConfig)
        return response

    # ### Get Information About a Scheduled Plan
    #
    # Admins can fetch information about other users' Scheduled Plans.
    #
    # GET /scheduled_plans/{scheduled_plan_id} -> models.ScheduledPlan
    def scheduled_plan(
        self,
        # Scheduled Plan Id
        scheduled_plan_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ScheduledPlan:
        """Get Scheduled Plan"""
        response = self.get(
            f"/scheduled_plans/{scheduled_plan_id}",
            models.ScheduledPlan,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ScheduledPlan)
        return response

    # ### Run a Scheduled Plan Immediately
    #
    # Create a scheduled plan that runs only once, and immediately.
    #
    # This can be useful for testing a Scheduled Plan before committing to a production schedule.
    #
    # Admins can create scheduled plans on behalf of other users by specifying a user id.
    #
    # This API is rate limited to prevent it from being used for relay spam or DoS attacks
    #
    # #### Email Permissions:
    #
    # For details about permissions required to schedule delivery to email and the safeguards
    # Looker offers to protect against sending to unauthorized email destinations, see [Email Domain Whitelist for Scheduled Looks](https://docs.looker.com/r/api/embed-permissions).
    #
    #
    # #### Scheduled Plan Destination Formats
    #
    # Scheduled plan destinations must specify the data format to produce and send to the destination.
    #
    # Formats:
    #
    # | format | Description
    # | :-----------: | :--- |
    # | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata.
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination.
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | xlsx | MS Excel spreadsheet
    # | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document
    # | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document
    # | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image
    # ||
    #
    # Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.
    #
    # POST /scheduled_plans/run_once -> models.ScheduledPlan
    def scheduled_plan_run_once(
        self,
        body: models.WriteScheduledPlan,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ScheduledPlan:
        """Run Scheduled Plan Once"""
        assert isinstance(body, models.WriteScheduledPlan)
        response = self.post(
            f"/scheduled_plans/run_once",
            models.ScheduledPlan,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ScheduledPlan)
        return response

    # ### Run a Scheduled Plan By Id Immediately
    # This function creates a run-once schedule plan based on an existing scheduled plan,
    # applies modifications (if any) to the new scheduled plan, and runs the new schedule plan immediately.
    # This can be useful for testing modifications to an existing scheduled plan before committing to a production schedule.
    #
    # This function internally performs the following operations:
    # 1. Copies the properties of the existing scheduled plan into a new scheduled plan
    # 2. Copies any properties passed in the JSON body of this request into the new scheduled plan (replacing the original values)
    # 3. Creates the new scheduled plan
    # 4. Runs the new scheduled plan
    #
    # The original scheduled plan is not modified by this operation.
    # Admins can create, modify, and run scheduled plans on behalf of other users by specifying a user id.
    # Non-admins can only create, modify, and run their own scheduled plans.
    #
    # #### Email Permissions:
    #
    # For details about permissions required to schedule delivery to email and the safeguards
    # Looker offers to protect against sending to unauthorized email destinations, see [Email Domain Whitelist for Scheduled Looks](https://docs.looker.com/r/api/embed-permissions).
    #
    #
    # #### Scheduled Plan Destination Formats
    #
    # Scheduled plan destinations must specify the data format to produce and send to the destination.
    #
    # Formats:
    #
    # | format | Description
    # | :-----------: | :--- |
    # | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata.
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination.
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | xlsx | MS Excel spreadsheet
    # | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document
    # | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document
    # | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image
    # ||
    #
    # Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.
    #
    #
    #
    # This API is rate limited to prevent it from being used for relay spam or DoS attacks
    #
    # POST /scheduled_plans/{scheduled_plan_id}/run_once -> models.ScheduledPlan
    def scheduled_plan_run_once_by_id(
        self,
        # Id of schedule plan to copy and run
        scheduled_plan_id: int,
        body: Optional[models.WriteScheduledPlan] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ScheduledPlan:
        """Run Scheduled Plan Once by Id"""
        if body:
            assert isinstance(body, models.WriteScheduledPlan)
        response = self.post(
            f"/scheduled_plans/{scheduled_plan_id}/run_once",
            models.ScheduledPlan,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ScheduledPlan)
        return response

    # ### Get Scheduled Plans for a Dashboard
    #
    # Returns all scheduled plans for a dashboard which belong to the caller or given user.
    #
    # If no user_id is provided, this function returns the scheduled plans owned by the caller.
    #
    #
    # To list all schedules for all users, pass `all_users=true`.
    #
    #
    # The caller must have `see_schedules` permission to see other users' scheduled plans.
    #
    # GET /scheduled_plans/dashboard/{dashboard_id} -> Sequence[models.ScheduledPlan]
    def scheduled_plans_for_dashboard(
        self,
        # Dashboard Id
        dashboard_id: int,
        # User Id (default is requesting user if not specified)
        user_id: Optional[int] = None,
        # Return scheduled plans belonging to all users for the dashboard
        all_users: Optional[bool] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ScheduledPlan]:
        """Scheduled Plans for Dashboard"""
        response = self.get(
            f"/scheduled_plans/dashboard/{dashboard_id}",
            Sequence[models.ScheduledPlan],
            query_params={"user_id": user_id, "all_users": all_users, "fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get Scheduled Plans for a Look
    #
    # Returns all scheduled plans for a look which belong to the caller or given user.
    #
    # If no user_id is provided, this function returns the scheduled plans owned by the caller.
    #
    #
    # To list all schedules for all users, pass `all_users=true`.
    #
    #
    # The caller must have `see_schedules` permission to see other users' scheduled plans.
    #
    # GET /scheduled_plans/look/{look_id} -> Sequence[models.ScheduledPlan]
    def scheduled_plans_for_look(
        self,
        # Look Id
        look_id: int,
        # User Id (default is requesting user if not specified)
        user_id: Optional[int] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Return scheduled plans belonging to all users for the look
        all_users: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ScheduledPlan]:
        """Scheduled Plans for Look"""
        response = self.get(
            f"/scheduled_plans/look/{look_id}",
            Sequence[models.ScheduledPlan],
            query_params={"user_id": user_id, "fields": fields, "all_users": all_users},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get Scheduled Plans for a LookML Dashboard
    #
    # Returns all scheduled plans for a LookML Dashboard which belong to the caller or given user.
    #
    # If no user_id is provided, this function returns the scheduled plans owned by the caller.
    #
    #
    # To list all schedules for all users, pass `all_users=true`.
    #
    #
    # The caller must have `see_schedules` permission to see other users' scheduled plans.
    #
    # GET /scheduled_plans/lookml_dashboard/{lookml_dashboard_id} -> Sequence[models.ScheduledPlan]
    def scheduled_plans_for_lookml_dashboard(
        self,
        # LookML Dashboard Id
        lookml_dashboard_id: int,
        # User Id (default is requesting user if not specified)
        user_id: Optional[int] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Return scheduled plans belonging to all users for the dashboard
        all_users: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ScheduledPlan]:
        """Scheduled Plans for LookML Dashboard"""
        response = self.get(
            f"/scheduled_plans/lookml_dashboard/{lookml_dashboard_id}",
            Sequence[models.ScheduledPlan],
            query_params={"user_id": user_id, "fields": fields, "all_users": all_users},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get Scheduled Plans for a Space
    #
    # Returns scheduled plans owned by the caller for a given space id.
    #
    # GET /scheduled_plans/space/{space_id} -> Sequence[models.ScheduledPlan]
    def scheduled_plans_for_space(
        self,
        # Space Id
        space_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ScheduledPlan]:
        """Scheduled Plans for Space"""
        response = self.get(
            f"/scheduled_plans/space/{space_id}",
            Sequence[models.ScheduledPlan],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search Favorite Content
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /content_favorite/search -> Sequence[models.ContentFavorite]
    def search_content_favorites(
        self,
        # Match content favorite id(s)
        id: Optional[int] = None,
        # Match user id(s).To create a list of multiple ids, use commas as separators
        user_id: Optional[str] = None,
        # Match content metadata id(s).To create a list of multiple ids, use commas as separators
        content_metadata_id: Optional[str] = None,
        # Match dashboard id(s).To create a list of multiple ids, use commas as separators
        dashboard_id: Optional[str] = None,
        # Match look id(s).To create a list of multiple ids, use commas as separators
        look_id: Optional[str] = None,
        # Match board id(s).To create a list of multiple ids, use commas as separators
        board_id: Optional[str] = None,
        # Number of results to return. (used with offset)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit)
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ContentFavorite]:
        """Search Favorite Contents"""
        response = self.get(
            f"/content_favorite/search",
            Sequence[models.ContentFavorite],
            query_params={
                "id": id,
                "user_id": user_id,
                "content_metadata_id": content_metadata_id,
                "dashboard_id": dashboard_id,
                "look_id": look_id,
                "board_id": board_id,
                "limit": limit,
                "offset": offset,
                "sorts": sorts,
                "fields": fields,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search Content Views
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /content_view/search -> Sequence[models.ContentView]
    def search_content_views(
        self,
        # Match view count
        view_count: Optional[str] = None,
        # Match Group Id
        group_id: Optional[str] = None,
        # Match look_id
        look_id: Optional[str] = None,
        # Match dashboard_id
        dashboard_id: Optional[str] = None,
        # Match content metadata id
        content_metadata_id: Optional[str] = None,
        # Match start of week date
        start_of_week_date: Optional[str] = None,
        # True if only all time view records should be returned
        all_time: Optional[bool] = None,
        # Match user id
        user_id: Optional[str] = None,
        # Requested fields
        fields: Optional[str] = None,
        # Number of results to return. Use with `offset` to manage pagination of results
        limit: Optional[int] = None,
        # Number of results to skip before returning data
        offset: Optional[int] = None,
        # Fields to sort by
        sorts: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ContentView]:
        """Search Content Views"""
        response = self.get(
            f"/content_view/search",
            Sequence[models.ContentView],
            query_params={
                "view_count": view_count,
                "group_id": group_id,
                "look_id": look_id,
                "dashboard_id": dashboard_id,
                "content_metadata_id": content_metadata_id,
                "start_of_week_date": start_of_week_date,
                "all_time": all_time,
                "user_id": user_id,
                "fields": fields,
                "limit": limit,
                "offset": offset,
                "sorts": sorts,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search Dashboard Elements
    #
    # Returns an **array of DashboardElement objects** that match the specified search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /dashboard_elements/search -> Sequence[models.DashboardElement]
    def search_dashboard_elements(
        self,
        # Select elements that refer to a given dashboard id
        dashboard_id: Optional[int] = None,
        # Select elements that refer to a given look id
        look_id: Optional[int] = None,
        # Match the title of element
        title: Optional[str] = None,
        # Select soft-deleted dashboard elements
        deleted: Optional[bool] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        # Fields to sort by. Sortable fields: [:look_id, :dashboard_id, :deleted, :title]
        sorts: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.DashboardElement]:
        """Search Dashboard Elements"""
        response = self.get(
            f"/dashboard_elements/search",
            Sequence[models.DashboardElement],
            query_params={
                "dashboard_id": dashboard_id,
                "look_id": look_id,
                "title": title,
                "deleted": deleted,
                "fields": fields,
                "filter_or": filter_or,
                "sorts": sorts,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search Dashboards
    #
    # Returns an **array of dashboard objects** that match the specified search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    #
    # The parameters `limit`, and `offset` are recommended for fetching results in page-size chunks.
    #
    # Get a **single dashboard** by id with [dashboard()](#!/Dashboard/dashboard)
    #
    # GET /dashboards/search -> Sequence[models.Dashboard]
    def search_dashboards(
        self,
        # Match dashboard id.
        id: Optional[str] = None,
        # Match dashboard slug.
        slug: Optional[str] = None,
        # Match Dashboard title.
        title: Optional[str] = None,
        # Match Dashboard description.
        description: Optional[str] = None,
        # Filter on a content favorite id.
        content_favorite_id: Optional[str] = None,
        # Filter on a particular space.
        space_id: Optional[str] = None,
        # Filter on dashboards deleted status.
        deleted: Optional[str] = None,
        # Filter on dashboards created by a particular user.
        user_id: Optional[str] = None,
        # Filter on a particular value of view_count
        view_count: Optional[str] = None,
        # Filter on a content favorite id.
        content_metadata_id: Optional[str] = None,
        # Exclude items that exist only in personal spaces other than the users
        curate: Optional[bool] = None,
        # Select dashboards based on when they were last viewed
        last_viewed_at: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Requested page.
        page: Optional[int] = None,
        # Results per page.
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # One or more fields to sort by. Sortable fields: [:title, :user_id, :id, :created_at, :space_id, :description, :view_count, :favorite_count, :slug, :content_favorite_id, :content_metadata_id, :deleted, :deleted_at, :last_viewed_at, :last_accessed_at]
        sorts: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Dashboard]:
        """Search Dashboards"""
        response = self.get(
            f"/dashboards/search",
            Sequence[models.Dashboard],
            query_params={
                "id": id,
                "slug": slug,
                "title": title,
                "description": description,
                "content_favorite_id": content_favorite_id,
                "space_id": space_id,
                "deleted": deleted,
                "user_id": user_id,
                "view_count": view_count,
                "content_metadata_id": content_metadata_id,
                "curate": curate,
                "last_viewed_at": last_viewed_at,
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "limit": limit,
                "offset": offset,
                "sorts": sorts,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # Search for folders by creator id, parent id, name, etc
    #
    # GET /folders/search -> Sequence[models.Folder]
    def search_folders(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Requested page.
        page: Optional[int] = None,
        # Results per page.
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match Space title.
        name: Optional[str] = None,
        # Match Space id
        id: Optional[int] = None,
        # Filter on a children of a particular folder.
        parent_id: Optional[str] = None,
        # Filter on folder created by a particular user.
        creator_id: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Folder]:
        """Search Folders"""
        response = self.get(
            f"/folders/search",
            Sequence[models.Folder],
            query_params={
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "limit": limit,
                "offset": offset,
                "sorts": sorts,
                "name": name,
                "id": id,
                "parent_id": parent_id,
                "creator_id": creator_id,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search groups
    #
    # Returns all group records that match the given search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /groups/search -> Sequence[models.Group]
    def search_groups(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        # Match group id.
        id: Optional[int] = None,
        # Match group name.
        name: Optional[str] = None,
        # Match group external_group_id.
        external_group_id: Optional[bool] = None,
        # Match group externally_managed.
        externally_managed: Optional[bool] = None,
        # Match group externally_orphaned.
        externally_orphaned: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Group]:
        """Search Groups"""
        response = self.get(
            f"/groups/search",
            Sequence[models.Group],
            query_params={
                "fields": fields,
                "limit": limit,
                "offset": offset,
                "sorts": sorts,
                "filter_or": filter_or,
                "id": id,
                "name": name,
                "external_group_id": external_group_id,
                "externally_managed": externally_managed,
                "externally_orphaned": externally_orphaned,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search Homepages
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /homepages/search -> Sequence[models.Homepage]
    def search_homepages(
        self,
        # Matches homepage title.
        title: Optional[str] = None,
        # Matches the timestamp for when the homepage was created.
        created_at: Optional[str] = None,
        # The first name of the user who created this homepage.
        first_name: Optional[str] = None,
        # The last name of the user who created this homepage.
        last_name: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Return favorited homepages when true.
        favorited: Optional[bool] = None,
        # Filter on homepages created by a particular user.
        creator_id: Optional[str] = None,
        # The fields to sort the results by
        sorts: Optional[str] = None,
        # The page to return.
        page: Optional[int] = None,
        # The number of items in the returned page.
        per_page: Optional[int] = None,
        # The number of items to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # The maximum number of items to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Homepage]:
        """Search Homepages"""
        response = self.get(
            f"/homepages/search",
            Sequence[models.Homepage],
            query_params={
                "title": title,
                "created_at": created_at,
                "first_name": first_name,
                "last_name": last_name,
                "fields": fields,
                "favorited": favorited,
                "creator_id": creator_id,
                "sorts": sorts,
                "page": page,
                "per_page": per_page,
                "offset": offset,
                "limit": limit,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search Looks
    #
    # Returns an **array of Look objects** that match the specified search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    #
    # Get a **single look** by id with [look(id)](#!/Look/look)
    #
    # GET /looks/search -> Sequence[models.Look]
    def search_looks(
        self,
        # Match look id.
        id: Optional[str] = None,
        # Match Look title.
        title: Optional[str] = None,
        # Match Look description.
        description: Optional[str] = None,
        # Select looks with a particular content favorite id
        content_favorite_id: Optional[str] = None,
        # Select looks in a particular space.
        space_id: Optional[str] = None,
        # Select looks created by a particular user.
        user_id: Optional[str] = None,
        # Select looks with particular view_count value
        view_count: Optional[str] = None,
        # Select soft-deleted looks
        deleted: Optional[bool] = None,
        # Select looks that reference a particular query by query_id
        query_id: Optional[int] = None,
        # Exclude items that exist only in personal spaces other than the users
        curate: Optional[bool] = None,
        # Select looks based on when they were last viewed
        last_viewed_at: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Requested page.
        page: Optional[int] = None,
        # Results per page.
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # One or more fields to sort results by. Sortable fields: [:title, :user_id, :id, :created_at, :space_id, :description, :updated_at, :last_updater_id, :view_count, :favorite_count, :content_favorite_id, :deleted, :deleted_at, :last_viewed_at, :last_accessed_at, :query_id]
        sorts: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Look]:
        """Search Looks"""
        response = self.get(
            f"/looks/search",
            Sequence[models.Look],
            query_params={
                "id": id,
                "title": title,
                "description": description,
                "content_favorite_id": content_favorite_id,
                "space_id": space_id,
                "user_id": user_id,
                "view_count": view_count,
                "deleted": deleted,
                "query_id": query_id,
                "curate": curate,
                "last_viewed_at": last_viewed_at,
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "limit": limit,
                "offset": offset,
                "sorts": sorts,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search model sets
    # Returns all model set records that match the given search criteria.
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /model_sets/search -> Sequence[models.ModelSet]
    def search_model_sets(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match model set id.
        id: Optional[int] = None,
        # Match model set name.
        name: Optional[str] = None,
        # Match model sets by all_access status.
        all_access: Optional[bool] = None,
        # Match model sets by built_in status.
        built_in: Optional[bool] = None,
        # Combine given search criteria in a boolean OR expression.
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.ModelSet]:
        """Search Model Sets"""
        response = self.get(
            f"/model_sets/search",
            Sequence[models.ModelSet],
            query_params={
                "fields": fields,
                "limit": limit,
                "offset": offset,
                "sorts": sorts,
                "id": id,
                "name": name,
                "all_access": all_access,
                "built_in": built_in,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search permission sets
    # Returns all permission set records that match the given search criteria.
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /permission_sets/search -> Sequence[models.PermissionSet]
    def search_permission_sets(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match permission set id.
        id: Optional[int] = None,
        # Match permission set name.
        name: Optional[str] = None,
        # Match permission sets by all_access status.
        all_access: Optional[bool] = None,
        # Match permission sets by built_in status.
        built_in: Optional[bool] = None,
        # Combine given search criteria in a boolean OR expression.
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.PermissionSet]:
        """Search Permission Sets"""
        response = self.get(
            f"/permission_sets/search",
            Sequence[models.PermissionSet],
            query_params={
                "fields": fields,
                "limit": limit,
                "offset": offset,
                "sorts": sorts,
                "id": id,
                "name": name,
                "all_access": all_access,
                "built_in": built_in,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search roles
    #
    # Returns all role records that match the given search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /roles/search -> Sequence[models.Role]
    def search_roles(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match role id.
        id: Optional[int] = None,
        # Match role name.
        name: Optional[str] = None,
        # Match roles by built_in status.
        built_in: Optional[bool] = None,
        # Combine given search criteria in a boolean OR expression.
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Role]:
        """Search Roles"""
        response = self.get(
            f"/roles/search",
            Sequence[models.Role],
            query_params={
                "fields": fields,
                "limit": limit,
                "offset": offset,
                "sorts": sorts,
                "id": id,
                "name": name,
                "built_in": built_in,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search Spaces
    #
    #   Returns an **array of space objects** that match the given search criteria.
    #
    #   If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    #
    #   The parameters `limit`, and `offset` are recommended for fetching results in page-size chunks.
    #
    #   Get a **single space** by id with [Space](#!/Space/space)
    #
    # GET /spaces/search -> Sequence[models.Space]
    def search_spaces(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Requested page.
        page: Optional[int] = None,
        # Results per page.
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match Space title.
        name: Optional[str] = None,
        # Match Space id
        id: Optional[int] = None,
        # Filter on a children of a particular space.
        parent_id: Optional[str] = None,
        # Filter on spaces created by a particular user.
        creator_id: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Space]:
        """Search Spaces"""
        response = self.get(
            f"/spaces/search",
            Sequence[models.Space],
            query_params={
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "limit": limit,
                "offset": offset,
                "sorts": sorts,
                "name": name,
                "id": id,
                "parent_id": parent_id,
                "creator_id": creator_id,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search all themes for matching criteria.
    #
    # Returns an **array of theme objects** that match the specified search criteria.
    #
    # | Search Parameters | Description
    # | :-------------------: | :------ |
    # | `begin_at` only | Find themes active at or after `begin_at`
    # | `end_at` only | Find themes active at or before `end_at`
    # | both set | Find themes with an active inclusive period between `begin_at` and `end_at`
    #
    # Note: Range matching requires boolean AND logic.
    # When using `begin_at` and `end_at` together, do not use `filter_or`=TRUE
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    #
    # Get a **single theme** by id with [Theme](#!/Theme/theme)
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or support@looker.com to update your license for this feature.
    #
    # GET /themes/search -> Sequence[models.Theme]
    def search_themes(
        self,
        # Match theme id.
        id: Optional[int] = None,
        # Match theme name.
        name: Optional[str] = None,
        # Timestamp for activation.
        begin_at: Optional[datetime.datetime] = None,
        # Timestamp for expiration.
        end_at: Optional[datetime.datetime] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Theme]:
        """Search Themes"""
        response = self.get(
            f"/themes/search",
            Sequence[models.Theme],
            query_params={
                "id": id,
                "name": name,
                "begin_at": begin_at,
                "end_at": end_at,
                "limit": limit,
                "offset": offset,
                "sorts": sorts,
                "fields": fields,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search currently locked-out users.
    #
    # GET /user_login_lockouts/search -> Sequence[models.UserLoginLockout]
    def search_user_login_lockouts(
        self,
        # Include only these fields in the response
        fields: Optional[str] = None,
        # Return only page N of paginated results
        page: Optional[int] = None,
        # Return N rows of data per page
        per_page: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Auth type user is locked out for (email, ldap, totp, api)
        auth_type: Optional[str] = None,
        # Match name
        full_name: Optional[str] = None,
        # Match email
        email: Optional[str] = None,
        # Match remote LDAP ID
        remote_id: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.UserLoginLockout]:
        """Search User Login Lockouts"""
        response = self.get(
            f"/user_login_lockouts/search",
            Sequence[models.UserLoginLockout],
            query_params={
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "sorts": sorts,
                "auth_type": auth_type,
                "full_name": full_name,
                "email": email,
                "remote_id": remote_id,
                "filter_or": filter_or,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search users
    #
    # Returns all<sup>*</sup> user records that match the given search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    #
    # (<sup>*</sup>) Results are always filtered to the level of information the caller is permitted to view.
    # Looker admins can see all user details; normal users in an open system can see
    # names of other users but no details; normal users in a closed system can only see
    # names of other users who are members of the same group as the user.
    #
    # GET /users/search -> Sequence[models.User]
    def search_users(
        self,
        # Include only these fields in the response
        fields: Optional[str] = None,
        # Return only page N of paginated results
        page: Optional[int] = None,
        # Return N rows of data per page
        per_page: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match User Id.
        id: Optional[str] = None,
        # Match First name.
        first_name: Optional[str] = None,
        # Match Last name.
        last_name: Optional[str] = None,
        # Search for user accounts associated with Looker employees
        verified_looker_employee: Optional[bool] = None,
        # Search for the user with this email address
        email: Optional[str] = None,
        # Search for disabled user accounts
        is_disabled: Optional[bool] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        # Search for users who have access to this content_metadata item
        content_metadata_id: Optional[str] = None,
        # Search for users who are direct members of this group
        group_id: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.User]:
        """Search Users"""
        response = self.get(
            f"/users/search",
            Sequence[models.User],
            query_params={
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "sorts": sorts,
                "id": id,
                "first_name": first_name,
                "last_name": last_name,
                "verified_looker_employee": verified_looker_employee,
                "email": email,
                "is_disabled": is_disabled,
                "filter_or": filter_or,
                "content_metadata_id": content_metadata_id,
                "group_id": group_id,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search for user accounts by name
    #
    # Returns all user accounts where `first_name` OR `last_name` OR `email` field values match a pattern.
    # The pattern can contain `%` and `_` wildcards as in SQL LIKE expressions.
    #
    # Any additional search params will be combined into a logical AND expression.
    #
    # GET /users/search/names/{pattern} -> Sequence[models.User]
    def search_users_names(
        self,
        # Pattern to match
        pattern: str,
        # Include only these fields in the response
        fields: Optional[str] = None,
        # Return only page N of paginated results
        page: Optional[int] = None,
        # Return N rows of data per page
        per_page: Optional[int] = None,
        # Fields to sort by
        sorts: Optional[str] = None,
        # Match User Id
        id: Optional[int] = None,
        # Match First name
        first_name: Optional[str] = None,
        # Match Last name
        last_name: Optional[str] = None,
        # Match Verified Looker employee
        verified_looker_employee: Optional[bool] = None,
        # Match Email Address
        email: Optional[str] = None,
        # Include or exclude disabled accounts in the results
        is_disabled: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.User]:
        """Search User Names"""
        pattern = self.encode_path_param(pattern)
        response = self.get(
            f"/users/search/names/{pattern}",
            Sequence[models.User],
            query_params={
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "sorts": sorts,
                "id": id,
                "first_name": first_name,
                "last_name": last_name,
                "verified_looker_employee": verified_looker_employee,
                "email": email,
                "is_disabled": is_disabled,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get API Session
    #
    # Returns information about the current API session, such as which workspace is selected for the session.
    #
    # GET /session -> models.ApiSession
    def session(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ApiSession:
        """Get Session"""
        response = self.get(
            f"/session", models.ApiSession, transport_options=transport_options
        )
        assert isinstance(response, models.ApiSession)
        return response

    # ### Get session config.
    #
    # GET /session_config -> models.SessionConfig
    def session_config(
        self, transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.SessionConfig:
        """Get Session Config"""
        response = self.get(
            f"/session_config",
            models.SessionConfig,
            transport_options=transport_options,
        )
        assert isinstance(response, models.SessionConfig)
        return response

    # ### Set the global default Color Collection by ID
    #
    # Returns the new specified default Color Collection object.
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # PUT /color_collections/default -> models.ColorCollection
    def set_default_color_collection(
        self,
        # ID of color collection to set as default
        collection_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ColorCollection:
        """Set Default Color Collection"""
        response = self.put(
            f"/color_collections/default",
            models.ColorCollection,
            query_params={"collection_id": collection_id},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ColorCollection)
        return response

    # ### Set the global default theme by theme name
    #
    # Only Admin users can call this function.
    #
    # Only an active theme with no expiration (`end_at` not set) can be assigned as the default theme. As long as a theme has an active record with no expiration, it can be set as the default.
    #
    # [Create Theme](#!/Theme/create) has detailed information on rules for default and active themes
    #
    # Returns the new specified default theme object.
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or support@looker.com to update your license for this feature.
    #
    # PUT /themes/default -> models.Theme
    def set_default_theme(
        self,
        # Name of theme to set as default
        name: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Theme:
        """Set Default Theme"""
        response = self.put(
            f"/themes/default",
            models.Theme,
            query_params={"name": name},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Theme)
        return response

    # ### Set all groups for a role, removing all existing group associations from that role.
    #
    # PUT /roles/{role_id}/groups -> Sequence[models.Group]
    def set_role_groups(
        self,
        # Id of Role
        role_id: int,
        body: Sequence[int],
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Group]:
        """Update Role Groups"""
        assert isinstance(body, Sequence)
        response = self.put(
            f"/roles/{role_id}/groups",
            Sequence[models.Group],
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Set all the users of the role with a specific id.
    #
    # PUT /roles/{role_id}/users -> Sequence[models.User]
    def set_role_users(
        self,
        # id of role
        role_id: int,
        body: Sequence[int],
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.User]:
        """Update Role Users"""
        assert isinstance(body, Sequence)
        response = self.put(
            f"/roles/{role_id}/users",
            Sequence[models.User],
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Define values for a user attribute across a set of groups, in priority order.
    #
    # This function defines all values for a user attribute defined by user groups. This is a global setting, potentially affecting
    # all users in the system. This function replaces any existing group value definitions for the indicated user attribute.
    #
    # The value of a user attribute for a given user is determined by searching the following locations, in this order:
    #
    # 1. the user's account settings
    # 2. the groups that the user is a member of
    # 3. the default value of the user attribute, if any
    #
    # The user may be a member of multiple groups which define different values for that user attribute. The order of items in the group_values parameter
    # determines which group takes priority for that user. Lowest array index wins.
    #
    # An alternate method to indicate the selection precedence of group-values is to assign numbers to the 'rank' property of each
    # group-value object in the array. Lowest 'rank' value wins. If you use this technique, you must assign a
    # rank value to every group-value object in the array.
    #
    #   To set a user attribute value for a single user, see [Set User Attribute User Value](#!/User/set_user_attribute_user_value).
    # To set a user attribute value for all members of a group, see [Set User Attribute Group Value](#!/Group/update_user_attribute_group_value).
    #
    # POST /user_attributes/{user_attribute_id}/group_values -> Sequence[models.UserAttributeGroupValue]
    def set_user_attribute_group_values(
        self,
        # Id of user attribute
        user_attribute_id: int,
        body: Sequence[models.UserAttributeGroupValue],
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.UserAttributeGroupValue]:
        """Set User Attribute Group Values"""
        assert isinstance(body, Sequence)
        response = self.post(
            f"/user_attributes/{user_attribute_id}/group_values",
            Sequence[models.UserAttributeGroupValue],
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Store a custom value for a user attribute in a user's account settings.
    #
    # Per-user user attribute values take precedence over group or default values.
    #
    # PATCH /users/{user_id}/attribute_values/{user_attribute_id} -> models.UserAttributeWithValue
    def set_user_attribute_user_value(
        self,
        # Id of user
        user_id: int,
        # Id of user attribute
        user_attribute_id: int,
        body: models.WriteUserAttributeWithValue,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.UserAttributeWithValue:
        """Set User Attribute User Value"""
        assert isinstance(body, models.WriteUserAttributeWithValue)
        response = self.patch(
            f"/users/{user_id}/attribute_values/{user_attribute_id}",
            models.UserAttributeWithValue,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.UserAttributeWithValue)
        return response

    # ### Set roles of the user with a specific id.
    #
    # PUT /users/{user_id}/roles -> Sequence[models.Role]
    def set_user_roles(
        self,
        # id of user
        user_id: int,
        body: Sequence[int],
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Role]:
        """Set User Roles"""
        assert isinstance(body, Sequence)
        response = self.put(
            f"/users/{user_id}/roles",
            Sequence[models.Role],
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get information about the space with a specific id.
    #
    # GET /spaces/{space_id} -> models.Space
    def space(
        self,
        # Id of space
        space_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Space:
        """Get Space"""
        space_id = self.encode_path_param(space_id)
        response = self.get(
            f"/spaces/{space_id}",
            models.Space,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Space)
        return response

    # ### Get the ancestors of a space
    #
    # GET /spaces/{space_id}/ancestors -> Sequence[models.Space]
    def space_ancestors(
        self,
        # Id of space
        space_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Space]:
        """Get Space Ancestors"""
        space_id = self.encode_path_param(space_id)
        response = self.get(
            f"/spaces/{space_id}/ancestors",
            Sequence[models.Space],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get the children of a space.
    #
    # GET /spaces/{space_id}/children -> Sequence[models.Space]
    def space_children(
        self,
        # Id of space
        space_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        # Requested page.
        page: Optional[int] = None,
        # Results per page.
        per_page: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Space]:
        """Get Space Children"""
        space_id = self.encode_path_param(space_id)
        response = self.get(
            f"/spaces/{space_id}/children",
            Sequence[models.Space],
            query_params={
                "fields": fields,
                "page": page,
                "per_page": per_page,
                "sorts": sorts,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Search the children of a space
    #
    # GET /spaces/{space_id}/children/search -> Sequence[models.Space]
    def space_children_search(
        self,
        # Id of space
        space_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match Space name.
        name: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Space]:
        """Search Space Children"""
        space_id = self.encode_path_param(space_id)
        response = self.get(
            f"/spaces/{space_id}/children/search",
            Sequence[models.Space],
            query_params={"fields": fields, "sorts": sorts, "name": name},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get the dashboards in a space
    #
    # GET /spaces/{space_id}/dashboards -> Sequence[models.Dashboard]
    def space_dashboards(
        self,
        # Id of space
        space_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Dashboard]:
        """Get Space Dashboards"""
        space_id = self.encode_path_param(space_id)
        response = self.get(
            f"/spaces/{space_id}/dashboards",
            Sequence[models.Dashboard],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get the looks in a space
    #
    # GET /spaces/{space_id}/looks -> Sequence[models.LookWithQuery]
    def space_looks(
        self,
        # Id of space
        space_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.LookWithQuery]:
        """Get Space Looks"""
        space_id = self.encode_path_param(space_id)
        response = self.get(
            f"/spaces/{space_id}/looks",
            Sequence[models.LookWithQuery],
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Get the parent of a space
    #
    # GET /spaces/{space_id}/parent -> models.Space
    def space_parent(
        self,
        # Id of space
        space_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Space:
        """Get Space Parent"""
        space_id = self.encode_path_param(space_id)
        response = self.get(
            f"/spaces/{space_id}/parent",
            models.Space,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Space)
        return response

    # Get a SQL Runner query.
    #
    # GET /sql_queries/{slug} -> models.SqlQuery
    def sql_query(
        self,
        # slug of query
        slug: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.SqlQuery:
        """Get SQL Runner Query"""
        slug = self.encode_path_param(slug)
        response = self.get(
            f"/sql_queries/{slug}", models.SqlQuery, transport_options=transport_options
        )
        assert isinstance(response, models.SqlQuery)
        return response

    # ### Update all linked dashboards to match the specified LookML dashboard.
    #
    # Any UDD (a dashboard which exists in the Looker database rather than as a LookML file) which has a `lookml_link_id`
    # property value referring to a LookML dashboard's id (model::dashboardname) will be updated so that it matches the current state of the LookML dashboard.
    #
    # For this operation to succeed the user must have permission to view the LookML dashboard, and only linked dashboards
    # that the user has permission to update will be synced.
    #
    # To **link** or **unlink** a UDD set the `lookml_link_id` property with [update_dashboard()](#!/Dashboard/update_dashboard)
    #
    # PATCH /dashboards/{lookml_dashboard_id}/sync -> Sequence[int]
    def sync_lookml_dashboard(
        self,
        # Id of LookML dashboard, in the form 'model::dashboardname'
        lookml_dashboard_id: str,
        body: models.WriteDashboard,
        # If true, and this dashboard is localized, export it with the raw keys, not localized.
        raw_locale: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[int]:
        """Sync LookML Dashboard"""
        lookml_dashboard_id = self.encode_path_param(lookml_dashboard_id)
        assert isinstance(body, models.WriteDashboard)
        response = self.patch(
            f"/dashboards/{lookml_dashboard_id}/sync",
            Sequence[int],
            query_params={"raw_locale": raw_locale},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Test an existing connection.
    #
    # Note that a connection's 'dialect' property has a 'connection_tests' property that lists the
    # specific types of tests that the connection supports.
    #
    # This API is rate limited.
    #
    # Unsupported tests in the request will be ignored.
    #
    # PUT /connections/{connection_name}/test -> Sequence[models.DBConnectionTestResult]
    def test_connection(
        self,
        # Name of connection
        connection_name: str,
        # Array of names of tests to run
        tests: Optional[models.DelimSequence[str]] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.DBConnectionTestResult]:
        """Test Connection"""
        connection_name = self.encode_path_param(connection_name)
        response = self.put(
            f"/connections/{connection_name}/test",
            Sequence[models.DBConnectionTestResult],
            query_params={"tests": tests},
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Test a connection configuration.
    #
    # Note that a connection's 'dialect' property has a 'connection_tests' property that lists the
    # specific types of tests that the connection supports.
    #
    # This API is rate limited.
    #
    # Unsupported tests in the request will be ignored.
    #
    # PUT /connections/test -> Sequence[models.DBConnectionTestResult]
    def test_connection_config(
        self,
        body: models.WriteDBConnection,
        # Array of names of tests to run
        tests: Optional[models.DelimSequence[str]] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.DBConnectionTestResult]:
        """Test Connection Configuration"""
        assert isinstance(body, models.WriteDBConnection)
        response = self.put(
            f"/connections/test",
            Sequence[models.DBConnectionTestResult],
            query_params={"tests": tests},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # Tests the integration to make sure all the settings are working.
    #
    # POST /integrations/{integration_id}/test -> models.IntegrationTestResult
    def test_integration(
        self,
        # Id of integration
        integration_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.IntegrationTestResult:
        """Test integration"""
        integration_id = self.encode_path_param(integration_id)
        response = self.post(
            f"/integrations/{integration_id}/test",
            models.IntegrationTestResult,
            transport_options=transport_options,
        )
        assert isinstance(response, models.IntegrationTestResult)
        return response

    # ### Test the connection authentication settings for an LDAP configuration.
    #
    # This tests that the connection is possible and that a 'server' account to be used by Looker can       authenticate to the LDAP server given connection and authentication information.
    #
    # **connection_host**, **connection_port**, and **auth_username**, are required.       **connection_tls** and **auth_password** are optional.
    #
    # Example:
    # ```json
    # {
    #   "connection_host": "ldap.example.com",
    #   "connection_port": "636",
    #   "connection_tls": true,
    #   "auth_username": "cn=looker,dc=example,dc=com",
    #   "auth_password": "secret"
    # }
    # ```
    #
    # Looker will never return an **auth_password**. If this request omits the **auth_password** field, then       the **auth_password** value from the active config (if present) will be used for the test.
    #
    # The active LDAP settings are not modified.
    #
    # PUT /ldap_config/test_auth -> models.LDAPConfigTestResult
    def test_ldap_config_auth(
        self,
        body: models.WriteLDAPConfig,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LDAPConfigTestResult:
        """Test LDAP Auth"""
        assert isinstance(body, models.WriteLDAPConfig)
        response = self.put(
            f"/ldap_config/test_auth",
            models.LDAPConfigTestResult,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.LDAPConfigTestResult)
        return response

    # ### Test the connection settings for an LDAP configuration.
    #
    # This tests that the connection is possible given a connection_host and connection_port.
    #
    # **connection_host** and **connection_port** are required. **connection_tls** is optional.
    #
    # Example:
    # ```json
    # {
    #   "connection_host": "ldap.example.com",
    #   "connection_port": "636",
    #   "connection_tls": true
    # }
    # ```
    #
    # No authentication to the LDAP server is attempted.
    #
    # The active LDAP settings are not modified.
    #
    # PUT /ldap_config/test_connection -> models.LDAPConfigTestResult
    def test_ldap_config_connection(
        self,
        body: models.WriteLDAPConfig,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LDAPConfigTestResult:
        """Test LDAP Connection"""
        assert isinstance(body, models.WriteLDAPConfig)
        response = self.put(
            f"/ldap_config/test_connection",
            models.LDAPConfigTestResult,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.LDAPConfigTestResult)
        return response

    # ### Test the user authentication settings for an LDAP configuration.
    #
    # This test accepts a full LDAP configuration along with a username/password pair and attempts to       authenticate the user with the LDAP server. The configuration is validated before attempting the       authentication.
    #
    # Looker will never return an **auth_password**. If this request omits the **auth_password** field, then       the **auth_password** value from the active config (if present) will be used for the test.
    #
    # **test_ldap_user** and **test_ldap_password** are required.
    #
    # The active LDAP settings are not modified.
    #
    # PUT /ldap_config/test_user_auth -> models.LDAPConfigTestResult
    def test_ldap_config_user_auth(
        self,
        body: models.WriteLDAPConfig,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LDAPConfigTestResult:
        """Test LDAP User Auth"""
        assert isinstance(body, models.WriteLDAPConfig)
        response = self.put(
            f"/ldap_config/test_user_auth",
            models.LDAPConfigTestResult,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.LDAPConfigTestResult)
        return response

    # ### Test the user authentication settings for an LDAP configuration without authenticating the user.
    #
    # This test will let you easily test the mapping for user properties and roles for any user without      needing to authenticate as that user.
    #
    # This test accepts a full LDAP configuration along with a username and attempts to find the full info      for the user from the LDAP server without actually authenticating the user. So, user password is not      required.The configuration is validated before attempting to contact the server.
    #
    # **test_ldap_user** is required.
    #
    # The active LDAP settings are not modified.
    #
    # PUT /ldap_config/test_user_info -> models.LDAPConfigTestResult
    def test_ldap_config_user_info(
        self,
        body: models.WriteLDAPConfig,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LDAPConfigTestResult:
        """Test LDAP User Info"""
        assert isinstance(body, models.WriteLDAPConfig)
        response = self.put(
            f"/ldap_config/test_user_info",
            models.LDAPConfigTestResult,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.LDAPConfigTestResult)
        return response

    # ### Get a theme by ID
    #
    # Use this to retrieve a specific theme, whether or not it's currently active.
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or support@looker.com to update your license for this feature.
    #
    # GET /themes/{theme_id} -> models.Theme
    def theme(
        self,
        # Id of theme
        theme_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Theme:
        """Get Theme"""
        response = self.get(
            f"/themes/{theme_id}",
            models.Theme,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Theme)
        return response

    # ### Get the named theme if it's active. Otherwise, return the default theme
    #
    # The optional `ts` parameter can specify a different timestamp than "now."
    # Note: API users with `show` ability can call this function
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or support@looker.com to update your license for this feature.
    #
    # GET /themes/theme_or_default -> models.Theme
    def theme_or_default(
        self,
        # Name of theme
        name: str,
        # Timestamp representing the target datetime for the active period. Defaults to 'now'
        ts: Optional[datetime.datetime] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Theme:
        """Get Theme or Default"""
        response = self.get(
            f"/themes/theme_or_default",
            models.Theme,
            query_params={"name": name, "ts": ts},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Theme)
        return response

    # ### Update the Looker internal database backup configuration.
    #
    # PATCH /backup_configuration -> models.BackupConfiguration
    def update_backup_configuration(
        self,
        body: models.WriteBackupConfiguration,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.BackupConfiguration:
        """Update Backup Configuration"""
        assert isinstance(body, models.WriteBackupConfiguration)
        response = self.patch(
            f"/backup_configuration",
            models.BackupConfiguration,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.BackupConfiguration)
        return response

    # ### Update a custom color collection by id.
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # PATCH /color_collections/{collection_id} -> models.ColorCollection
    def update_color_collection(
        self,
        # Id of Custom Color Collection
        collection_id: str,
        body: models.WriteColorCollection,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ColorCollection:
        """Update Custom Color collection"""
        collection_id = self.encode_path_param(collection_id)
        assert isinstance(body, models.WriteColorCollection)
        response = self.patch(
            f"/color_collections/{collection_id}",
            models.ColorCollection,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ColorCollection)
        return response

    # ### Update a connection using the specified configuration.
    #
    # PATCH /connections/{connection_name} -> models.DBConnection
    def update_connection(
        self,
        # Name of connection
        connection_name: str,
        body: models.WriteDBConnection,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DBConnection:
        """Update Connection"""
        connection_name = self.encode_path_param(connection_name)
        assert isinstance(body, models.WriteDBConnection)
        response = self.patch(
            f"/connections/{connection_name}",
            models.DBConnection,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DBConnection)
        return response

    # ### Move a piece of content.
    #
    # PATCH /content_metadata/{content_metadata_id} -> models.ContentMeta
    def update_content_metadata(
        self,
        # Id of content metadata
        content_metadata_id: int,
        body: models.WriteContentMeta,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ContentMeta:
        """Update Content Metadata"""
        assert isinstance(body, models.WriteContentMeta)
        response = self.patch(
            f"/content_metadata/{content_metadata_id}",
            models.ContentMeta,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ContentMeta)
        return response

    # ### Update type of access for content metadata.
    #
    # PUT /content_metadata_access/{content_metadata_access_id} -> models.ContentMetaGroupUser
    def update_content_metadata_access(
        self,
        # Id of content metadata access
        content_metadata_access_id: str,
        body: models.ContentMetaGroupUser,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ContentMetaGroupUser:
        """Update Content Metadata Access"""
        content_metadata_access_id = self.encode_path_param(content_metadata_access_id)
        assert isinstance(body, models.ContentMetaGroupUser)
        response = self.put(
            f"/content_metadata_access/{content_metadata_access_id}",
            models.ContentMetaGroupUser,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ContentMetaGroupUser)
        return response

    # Update custom welcome email setting and values. Optionally send a test email with the new content to the currently logged in user.
    #
    # PATCH /custom_welcome_email -> models.CustomWelcomeEmail
    def update_custom_welcome_email(
        self,
        body: models.WriteCustomWelcomeEmail,
        # If true a test email with the content from the request will be sent to the current user after saving
        send_test_welcome_email: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CustomWelcomeEmail:
        """Update Custom Welcome Email Content"""
        assert isinstance(body, models.WriteCustomWelcomeEmail)
        response = self.patch(
            f"/custom_welcome_email",
            models.CustomWelcomeEmail,
            query_params={"send_test_welcome_email": send_test_welcome_email},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.CustomWelcomeEmail)
        return response

    # Requests to this endpoint will send a welcome email with the custom content provided in the body to the currently logged in user.
    #
    # PUT /custom_welcome_email_test -> models.WelcomeEmailTest
    def update_custom_welcome_email_test(
        self,
        body: models.WriteWelcomeEmailTest,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.WelcomeEmailTest:
        """Send a test welcome email to the currently logged in user with the supplied content """
        assert isinstance(body, models.WriteWelcomeEmailTest)
        response = self.put(
            f"/custom_welcome_email_test",
            models.WelcomeEmailTest,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.WelcomeEmailTest)
        return response

    # ### Update a dashboard
    #
    # You can use this function to change the string and integer properties of
    # a dashboard. Nested objects such as filters, dashboard elements, or dashboard layout components
    # cannot be modified by this function - use the update functions for the respective
    # nested object types (like [update_dashboard_filter()](#!/3.1/Dashboard/update_dashboard_filter) to change a filter)
    # to modify nested objects referenced by a dashboard.
    #
    # If you receive a 422 error response when updating a dashboard, be sure to look at the
    # response body for information about exactly which fields are missing or contain invalid data.
    #
    # PATCH /dashboards/{dashboard_id} -> models.Dashboard
    def update_dashboard(
        self,
        # Id of dashboard
        dashboard_id: str,
        body: models.WriteDashboard,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Dashboard:
        """Update Dashboard"""
        dashboard_id = self.encode_path_param(dashboard_id)
        assert isinstance(body, models.WriteDashboard)
        response = self.patch(
            f"/dashboards/{dashboard_id}",
            models.Dashboard,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Dashboard)
        return response

    # ### Update the dashboard element with a specific id.
    #
    # PATCH /dashboard_elements/{dashboard_element_id} -> models.DashboardElement
    def update_dashboard_element(
        self,
        # Id of dashboard element
        dashboard_element_id: str,
        body: models.WriteDashboardElement,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardElement:
        """Update DashboardElement"""
        dashboard_element_id = self.encode_path_param(dashboard_element_id)
        assert isinstance(body, models.WriteDashboardElement)
        response = self.patch(
            f"/dashboard_elements/{dashboard_element_id}",
            models.DashboardElement,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardElement)
        return response

    # ### Update the dashboard filter with a specific id.
    #
    # PATCH /dashboard_filters/{dashboard_filter_id} -> models.DashboardFilter
    def update_dashboard_filter(
        self,
        # Id of dashboard filter
        dashboard_filter_id: str,
        body: models.WriteDashboardFilter,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardFilter:
        """Update Dashboard Filter"""
        dashboard_filter_id = self.encode_path_param(dashboard_filter_id)
        assert isinstance(body, models.WriteDashboardFilter)
        response = self.patch(
            f"/dashboard_filters/{dashboard_filter_id}",
            models.DashboardFilter,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardFilter)
        return response

    # ### Update the dashboard layout with a specific id.
    #
    # PATCH /dashboard_layouts/{dashboard_layout_id} -> models.DashboardLayout
    def update_dashboard_layout(
        self,
        # Id of dashboard layout
        dashboard_layout_id: str,
        body: models.WriteDashboardLayout,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardLayout:
        """Update DashboardLayout"""
        dashboard_layout_id = self.encode_path_param(dashboard_layout_id)
        assert isinstance(body, models.WriteDashboardLayout)
        response = self.patch(
            f"/dashboard_layouts/{dashboard_layout_id}",
            models.DashboardLayout,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardLayout)
        return response

    # ### Update the dashboard element with a specific id.
    #
    # PATCH /dashboard_layout_components/{dashboard_layout_component_id} -> models.DashboardLayoutComponent
    def update_dashboard_layout_component(
        self,
        # Id of dashboard layout component
        dashboard_layout_component_id: str,
        body: models.WriteDashboardLayoutComponent,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DashboardLayoutComponent:
        """Update DashboardLayoutComponent"""
        dashboard_layout_component_id = self.encode_path_param(
            dashboard_layout_component_id
        )
        assert isinstance(body, models.WriteDashboardLayoutComponent)
        response = self.patch(
            f"/dashboard_layout_components/{dashboard_layout_component_id}",
            models.DashboardLayoutComponent,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DashboardLayoutComponent)
        return response

    # ### Update a datagroup using the specified params.
    #
    # PATCH /datagroups/{datagroup_id} -> models.Datagroup
    def update_datagroup(
        self,
        # ID of datagroup.
        datagroup_id: int,
        body: models.WriteDatagroup,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Datagroup:
        """Update Datagroup"""
        assert isinstance(body, models.WriteDatagroup)
        response = self.patch(
            f"/datagroups/{datagroup_id}",
            models.Datagroup,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Datagroup)
        return response

    # ### Update the setting for enabling/disabling digest emails
    #
    # PATCH /digest_emails_enabled -> models.DigestEmails
    def update_digest_emails_enabled(
        self,
        body: models.DigestEmails,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.DigestEmails:
        """Update Digest_emails"""
        assert isinstance(body, models.DigestEmails)
        response = self.patch(
            f"/digest_emails_enabled",
            models.DigestEmails,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.DigestEmails)
        return response

    # ### Update the folder with a specific id.
    #
    # PATCH /folders/{folder_id} -> models.Folder
    def update_folder(
        self,
        # Id of folder
        folder_id: str,
        body: models.UpdateFolder,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Folder:
        """Update Folder"""
        folder_id = self.encode_path_param(folder_id)
        assert isinstance(body, models.UpdateFolder)
        response = self.patch(
            f"/folders/{folder_id}",
            models.Folder,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Folder)
        return response

    # ### Checkout and/or reset --hard an existing Git Branch
    #
    # Only allowed in development mode
    #   - Call `update_session` to select the 'dev' workspace.
    #
    # Checkout an existing branch if name field is different from the name of the currently checked out branch.
    #
    # Optionally specify a branch name, tag name or commit SHA to which the branch should be reset.
    #   **DANGER** hard reset will be force pushed to the remote. Unsaved changes and commits may be permanently lost.
    #
    # PUT /projects/{project_id}/git_branch -> models.GitBranch
    def update_git_branch(
        self,
        # Project Id
        project_id: str,
        body: models.WriteGitBranch,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.GitBranch:
        """Update Project Git Branch"""
        project_id = self.encode_path_param(project_id)
        assert isinstance(body, models.WriteGitBranch)
        response = self.put(
            f"/projects/{project_id}/git_branch",
            models.GitBranch,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.GitBranch)
        return response

    # ### Updates the a group (admin only).
    #
    # PATCH /groups/{group_id} -> models.Group
    def update_group(
        self,
        # Id of group
        group_id: int,
        body: models.WriteGroup,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Group:
        """Update Group"""
        assert isinstance(body, models.WriteGroup)
        response = self.patch(
            f"/groups/{group_id}",
            models.Group,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Group)
        return response

    # ### Update a homepage definition.
    #
    # PATCH /homepages/{homepage_id} -> models.Homepage
    def update_homepage(
        self,
        # Id of homepage
        homepage_id: int,
        body: models.WriteHomepage,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Homepage:
        """Update Homepage"""
        assert isinstance(body, models.WriteHomepage)
        response = self.patch(
            f"/homepages/{homepage_id}",
            models.Homepage,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Homepage)
        return response

    # ### Update a homepage item definition.
    #
    # PATCH /homepage_items/{homepage_item_id} -> models.HomepageItem
    def update_homepage_item(
        self,
        # Id of homepage item
        homepage_item_id: int,
        body: models.WriteHomepageItem,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.HomepageItem:
        """Update Homepage Item"""
        assert isinstance(body, models.WriteHomepageItem)
        response = self.patch(
            f"/homepage_items/{homepage_item_id}",
            models.HomepageItem,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.HomepageItem)
        return response

    # ### Update a homepage section definition.
    #
    # PATCH /homepage_sections/{homepage_section_id} -> models.HomepageSection
    def update_homepage_section(
        self,
        # Id of homepage section
        homepage_section_id: int,
        body: models.WriteHomepageSection,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.HomepageSection:
        """Update Homepage section"""
        assert isinstance(body, models.WriteHomepageSection)
        response = self.patch(
            f"/homepage_sections/{homepage_section_id}",
            models.HomepageSection,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.HomepageSection)
        return response

    # ### Update parameters on a Integration.
    #
    # PATCH /integrations/{integration_id} -> models.Integration
    def update_integration(
        self,
        # Id of integration
        integration_id: str,
        body: models.WriteIntegration,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Integration:
        """Update Integration"""
        integration_id = self.encode_path_param(integration_id)
        assert isinstance(body, models.WriteIntegration)
        response = self.patch(
            f"/integrations/{integration_id}",
            models.Integration,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Integration)
        return response

    # ### Update a Integration Hub definition.
    #
    # This API is rate limited to prevent it from being used for SSRF attacks
    #
    # PATCH /integration_hubs/{integration_hub_id} -> models.IntegrationHub
    def update_integration_hub(
        self,
        # Id of Integration Hub
        integration_hub_id: int,
        body: models.WriteIntegrationHub,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.IntegrationHub:
        """Update Integration Hub"""
        assert isinstance(body, models.WriteIntegrationHub)
        response = self.patch(
            f"/integration_hubs/{integration_hub_id}",
            models.IntegrationHub,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.IntegrationHub)
        return response

    # Update internal help resources settings
    #
    # PATCH /internal_help_resources -> models.InternalHelpResources
    def update_internal_help_resources(
        self,
        body: models.WriteInternalHelpResources,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.InternalHelpResources:
        """Update internal help resources configuration"""
        assert isinstance(body, models.WriteInternalHelpResources)
        response = self.patch(
            f"/internal_help_resources",
            models.InternalHelpResources,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.InternalHelpResources)
        return response

    # Update internal help resources content
    #
    # PATCH /internal_help_resources_content -> models.InternalHelpResourcesContent
    def update_internal_help_resources_content(
        self,
        body: models.WriteInternalHelpResourcesContent,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.InternalHelpResourcesContent:
        """Update internal help resources content"""
        assert isinstance(body, models.WriteInternalHelpResourcesContent)
        response = self.patch(
            f"/internal_help_resources_content",
            models.InternalHelpResourcesContent,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.InternalHelpResourcesContent)
        return response

    # ### Update the LDAP configuration.
    #
    # Configuring LDAP impacts authentication for all users. This configuration should be done carefully.
    #
    # Only Looker administrators can read and update the LDAP configuration.
    #
    # LDAP is enabled or disabled for Looker using the **enabled** field.
    #
    # It is **highly** recommended that any LDAP setting changes be tested using the APIs below before being set globally.
    #
    # See the [Looker LDAP docs](https://www.looker.com/docs/r/api/ldap_setup) for additional information.
    #
    # PATCH /ldap_config -> models.LDAPConfig
    def update_ldap_config(
        self,
        body: models.WriteLDAPConfig,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LDAPConfig:
        """Update LDAP Configuration"""
        assert isinstance(body, models.WriteLDAPConfig)
        response = self.patch(
            f"/ldap_config",
            models.LDAPConfig,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.LDAPConfig)
        return response

    # ### Update information about the legacy feature with a specific id.
    #
    # PATCH /legacy_features/{legacy_feature_id} -> models.LegacyFeature
    def update_legacy_feature(
        self,
        # id of legacy feature
        legacy_feature_id: str,
        body: models.WriteLegacyFeature,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LegacyFeature:
        """Update Legacy Feature"""
        legacy_feature_id = self.encode_path_param(legacy_feature_id)
        assert isinstance(body, models.WriteLegacyFeature)
        response = self.patch(
            f"/legacy_features/{legacy_feature_id}",
            models.LegacyFeature,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.LegacyFeature)
        return response

    # ### Modify a Look
    #
    # Use this function to modify parts of a look. Property values given in a call to `update_look` are
    # applied to the existing look, so there's no need to include properties whose values are not changing.
    # It's best to specify only the properties you want to change and leave everything else out
    # of your `update_look` call. **Look properties marked 'read-only' will be ignored.**
    #
    # When a user deletes a look in the Looker UI, the look data remains in the database but is
    # marked with a deleted flag ("soft-deleted"). Soft-deleted looks can be undeleted (by an admin)
    # if the delete was in error.
    #
    # To soft-delete a look via the API, use [update_look()](#!/Look/update_look) to change the look's `deleted` property to `true`.
    # You can undelete a look by calling `update_look` to change the look's `deleted` property to `false`.
    #
    # Soft-deleted looks are excluded from the results of [all_looks()](#!/Look/all_looks) and [search_looks()](#!/Look/search_looks), so they
    # essentially disappear from view even though they still reside in the db.
    # In API 3.1 and later, you can pass `deleted: true` as a parameter to [search_looks()](#!/3.1/Look/search_looks) to list soft-deleted looks.
    #
    # NOTE: [delete_look()](#!/Look/delete_look) performs a "hard delete" - the look data is removed from the Looker
    # database and destroyed. There is no "undo" for `delete_look()`.
    #
    # PATCH /looks/{look_id} -> models.LookWithQuery
    def update_look(
        self,
        # Id of look
        look_id: int,
        body: models.WriteLookWithQuery,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LookWithQuery:
        """Update Look"""
        assert isinstance(body, models.WriteLookWithQuery)
        response = self.patch(
            f"/looks/{look_id}",
            models.LookWithQuery,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.LookWithQuery)
        return response

    # ### Update a lookml model using the specified configuration.
    #
    # PATCH /lookml_models/{lookml_model_name} -> models.LookmlModel
    def update_lookml_model(
        self,
        # Name of lookml model.
        lookml_model_name: str,
        body: models.WriteLookmlModel,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.LookmlModel:
        """Update LookML Model"""
        lookml_model_name = self.encode_path_param(lookml_model_name)
        assert isinstance(body, models.WriteLookmlModel)
        response = self.patch(
            f"/lookml_models/{lookml_model_name}",
            models.LookmlModel,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.LookmlModel)
        return response

    # ### Update information about the model set with a specific id.
    #
    # PATCH /model_sets/{model_set_id} -> models.ModelSet
    def update_model_set(
        self,
        # id of model set
        model_set_id: int,
        body: models.WriteModelSet,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ModelSet:
        """Update Model Set"""
        assert isinstance(body, models.WriteModelSet)
        response = self.patch(
            f"/model_sets/{model_set_id}",
            models.ModelSet,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ModelSet)
        return response

    # ### Update the OIDC configuration.
    #
    # Configuring OIDC impacts authentication for all users. This configuration should be done carefully.
    #
    # Only Looker administrators can read and update the OIDC configuration.
    #
    # OIDC is enabled or disabled for Looker using the **enabled** field.
    #
    # It is **highly** recommended that any OIDC setting changes be tested using the APIs below before being set globally.
    #
    # PATCH /oidc_config -> models.OIDCConfig
    def update_oidc_config(
        self,
        body: models.WriteOIDCConfig,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.OIDCConfig:
        """Update OIDC Configuration"""
        assert isinstance(body, models.WriteOIDCConfig)
        response = self.patch(
            f"/oidc_config",
            models.OIDCConfig,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.OIDCConfig)
        return response

    # ### Update password config.
    #
    # PATCH /password_config -> models.PasswordConfig
    def update_password_config(
        self,
        body: models.WritePasswordConfig,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.PasswordConfig:
        """Update Password Config"""
        assert isinstance(body, models.WritePasswordConfig)
        response = self.patch(
            f"/password_config",
            models.PasswordConfig,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.PasswordConfig)
        return response

    # ### Update information about the permission set with a specific id.
    #
    # PATCH /permission_sets/{permission_set_id} -> models.PermissionSet
    def update_permission_set(
        self,
        # id of permission set
        permission_set_id: int,
        body: models.WritePermissionSet,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.PermissionSet:
        """Update Permission Set"""
        assert isinstance(body, models.WritePermissionSet)
        response = self.patch(
            f"/permission_sets/{permission_set_id}",
            models.PermissionSet,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.PermissionSet)
        return response

    # ### Update Project Configuration
    #
    # Apply changes to a project's configuration.
    #
    #
    # #### Configuring Git for a Project
    #
    # To set up a Looker project with a remote git repository, follow these steps:
    #
    # 1. Call `update_session` to select the 'dev' workspace.
    # 1. Call `create_git_deploy_key` to create a new deploy key for the project
    # 1. Copy the deploy key text into the remote git repository's ssh key configuration
    # 1. Call `update_project` to set project's `git_remote_url` ()and `git_service_name`, if necessary).
    #
    # When you modify a project's `git_remote_url`, Looker connects to the remote repository to fetch
    # metadata. The remote git repository MUST be configured with the Looker-generated deploy
    # key for this project prior to setting the project's `git_remote_url`.
    #
    # To set up a Looker project with a git repository residing on the Looker server (a 'bare' git repo):
    # 1. Call `update_session` to select the 'dev' workspace.
    # 1. Call `update_project` setting `git_remote_url` to nil and `git_service_name` to "bare".
    #
    # PATCH /projects/{project_id} -> models.Project
    def update_project(
        self,
        # Project Id
        project_id: str,
        body: models.WriteProject,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Project:
        """Update Project"""
        project_id = self.encode_path_param(project_id)
        assert isinstance(body, models.WriteProject)
        response = self.patch(
            f"/projects/{project_id}",
            models.Project,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Project)
        return response

    # ### Configure Repository Credential for a remote dependency
    #
    # Admin required.
    #
    # `root_project_id` is required.
    # `credential_id` is required.
    #
    # PUT /projects/{root_project_id}/credential/{credential_id} -> models.RepositoryCredential
    def update_repository_credential(
        self,
        # Root Project Id
        root_project_id: str,
        # Credential Id
        credential_id: str,
        body: models.WriteRepositoryCredential,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.RepositoryCredential:
        """Create Repository Credential"""
        root_project_id = self.encode_path_param(root_project_id)
        credential_id = self.encode_path_param(credential_id)
        assert isinstance(body, models.WriteRepositoryCredential)
        response = self.put(
            f"/projects/{root_project_id}/credential/{credential_id}",
            models.RepositoryCredential,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.RepositoryCredential)
        return response

    # ### Update information about the role with a specific id.
    #
    # PATCH /roles/{role_id} -> models.Role
    def update_role(
        self,
        # id of role
        role_id: int,
        body: models.WriteRole,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Role:
        """Update Role"""
        assert isinstance(body, models.WriteRole)
        response = self.patch(
            f"/roles/{role_id}",
            models.Role,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Role)
        return response

    # ### Update the SAML configuration.
    #
    # Configuring SAML impacts authentication for all users. This configuration should be done carefully.
    #
    # Only Looker administrators can read and update the SAML configuration.
    #
    # SAML is enabled or disabled for Looker using the **enabled** field.
    #
    # It is **highly** recommended that any SAML setting changes be tested using the APIs below before being set globally.
    #
    # PATCH /saml_config -> models.SamlConfig
    def update_saml_config(
        self,
        body: models.WriteSamlConfig,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.SamlConfig:
        """Update SAML Configuration"""
        assert isinstance(body, models.WriteSamlConfig)
        response = self.patch(
            f"/saml_config",
            models.SamlConfig,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.SamlConfig)
        return response

    # ### Update a Scheduled Plan
    #
    # Admins can update other users' Scheduled Plans.
    #
    # Note: Any scheduled plan destinations specified in an update will **replace** all scheduled plan destinations
    # currently defined for the scheduled plan.
    #
    # For Example: If a scheduled plan has destinations A, B, and C, and you call update on this scheduled plan
    # specifying only B in the destinations, then destinations A and C will be deleted by the update.
    #
    # Updating a scheduled plan to assign null or an empty array to the scheduled_plan_destinations property is an error, as a scheduled plan must always have at least one destination.
    #
    # If you omit the scheduled_plan_destinations property from the object passed to update, then the destinations
    # defined on the original scheduled plan will remain unchanged.
    #
    # #### Email Permissions:
    #
    # For details about permissions required to schedule delivery to email and the safeguards
    # Looker offers to protect against sending to unauthorized email destinations, see [Email Domain Whitelist for Scheduled Looks](https://docs.looker.com/r/api/embed-permissions).
    #
    #
    # #### Scheduled Plan Destination Formats
    #
    # Scheduled plan destinations must specify the data format to produce and send to the destination.
    #
    # Formats:
    #
    # | format | Description
    # | :-----------: | :--- |
    # | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata.
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination.
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | xlsx | MS Excel spreadsheet
    # | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document
    # | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document
    # | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image
    # ||
    #
    # Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.
    #
    # PATCH /scheduled_plans/{scheduled_plan_id} -> models.ScheduledPlan
    def update_scheduled_plan(
        self,
        # Scheduled Plan Id
        scheduled_plan_id: int,
        body: models.WriteScheduledPlan,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ScheduledPlan:
        """Update Scheduled Plan"""
        assert isinstance(body, models.WriteScheduledPlan)
        response = self.patch(
            f"/scheduled_plans/{scheduled_plan_id}",
            models.ScheduledPlan,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ScheduledPlan)
        return response

    # ### Update API Session
    #
    # #### API Session Workspace
    #
    # You can use this endpoint to change the active workspace for the current API session.
    #
    # Only one workspace can be active in a session. The active workspace can be changed
    # any number of times in a session.
    #
    # The default workspace for API sessions is the "production" workspace.
    #
    # All Looker APIs that use projects or lookml models (such as running queries) will
    # use the version of project and model files defined by this workspace for the lifetime of the
    # current API session or until the session workspace is changed again.
    #
    # An API session has the same lifetime as the access_token used to authenticate API requests. Each successful
    # API login generates a new access_token and a new API session.
    #
    # If your Looker API client application needs to work in a dev workspace across multiple
    # API sessions, be sure to select the dev workspace after each login.
    #
    # PATCH /session -> models.ApiSession
    def update_session(
        self,
        body: models.WriteApiSession,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ApiSession:
        """Update Session"""
        assert isinstance(body, models.WriteApiSession)
        response = self.patch(
            f"/session",
            models.ApiSession,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ApiSession)
        return response

    # ### Update session config.
    #
    # PATCH /session_config -> models.SessionConfig
    def update_session_config(
        self,
        body: models.WriteSessionConfig,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.SessionConfig:
        """Update Session Config"""
        assert isinstance(body, models.WriteSessionConfig)
        response = self.patch(
            f"/session_config",
            models.SessionConfig,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.SessionConfig)
        return response

    # ### Update the space with a specific id.
    #
    # PATCH /spaces/{space_id} -> models.Space
    def update_space(
        self,
        # Id of space
        space_id: str,
        body: models.UpdateSpace,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Space:
        """Update Space"""
        space_id = self.encode_path_param(space_id)
        assert isinstance(body, models.UpdateSpace)
        response = self.patch(
            f"/spaces/{space_id}",
            models.Space,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Space)
        return response

    # ### Update the theme by id.
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or support@looker.com to update your license for this feature.
    #
    # PATCH /themes/{theme_id} -> models.Theme
    def update_theme(
        self,
        # Id of theme
        theme_id: int,
        body: models.WriteTheme,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Theme:
        """Update Theme"""
        assert isinstance(body, models.WriteTheme)
        response = self.patch(
            f"/themes/{theme_id}",
            models.Theme,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Theme)
        return response

    # ### Update information about the user with a specific id.
    #
    # PATCH /users/{user_id} -> models.User
    def update_user(
        self,
        # Id of user
        user_id: int,
        body: models.WriteUser,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.User:
        """Update User"""
        assert isinstance(body, models.WriteUser)
        response = self.patch(
            f"/users/{user_id}",
            models.User,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.User)
        return response

    # ### Update a user attribute definition.
    #
    # PATCH /user_attributes/{user_attribute_id} -> models.UserAttribute
    def update_user_attribute(
        self,
        # Id of user attribute
        user_attribute_id: int,
        body: models.WriteUserAttribute,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.UserAttribute:
        """Update User Attribute"""
        assert isinstance(body, models.WriteUserAttribute)
        response = self.patch(
            f"/user_attributes/{user_attribute_id}",
            models.UserAttribute,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.UserAttribute)
        return response

    # ### Set the value of a user attribute for a group.
    #
    # For information about how user attribute values are calculated, see [Set User Attribute Group Values](#!/UserAttribute/set_user_attribute_group_values).
    #
    # PATCH /groups/{group_id}/attribute_values/{user_attribute_id} -> models.UserAttributeGroupValue
    def update_user_attribute_group_value(
        self,
        # Id of group
        group_id: int,
        # Id of user attribute
        user_attribute_id: int,
        body: models.UserAttributeGroupValue,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.UserAttributeGroupValue:
        """Set User Attribute Group Value"""
        assert isinstance(body, models.UserAttributeGroupValue)
        response = self.patch(
            f"/groups/{group_id}/attribute_values/{user_attribute_id}",
            models.UserAttributeGroupValue,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.UserAttributeGroupValue)
        return response

    # ### Email/password login information for the specified user.
    #
    # PATCH /users/{user_id}/credentials_email -> models.CredentialsEmail
    def update_user_credentials_email(
        self,
        # id of user
        user_id: int,
        body: models.WriteCredentialsEmail,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsEmail:
        """Update Email/Password Credential"""
        assert isinstance(body, models.WriteCredentialsEmail)
        response = self.patch(
            f"/users/{user_id}/credentials_email",
            models.CredentialsEmail,
            query_params={"fields": fields},
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsEmail)
        return response

    # ### Update the whitelabel configuration
    #
    # PUT /whitelabel_configuration -> models.WhitelabelConfiguration
    def update_whitelabel_configuration(
        self,
        body: models.WriteWhitelabelConfiguration,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.WhitelabelConfiguration:
        """Update Whitelabel configuration"""
        assert isinstance(body, models.WriteWhitelabelConfiguration)
        response = self.put(
            f"/whitelabel_configuration",
            models.WhitelabelConfiguration,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.WhitelabelConfiguration)
        return response

    # ### Get information about the user with a specific id.
    #
    # If the caller is an admin or the caller is the user being specified, then full user information will
    # be returned. Otherwise, a minimal 'public' variant of the user information will be returned. This contains
    # The user name and avatar url, but no sensitive information.
    #
    # GET /users/{user_id} -> models.User
    def user(
        self,
        # Id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.User:
        """Get User by Id"""
        response = self.get(
            f"/users/{user_id}",
            models.User,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.User)
        return response

    # ### Get information about a user attribute.
    #
    # GET /user_attributes/{user_attribute_id} -> models.UserAttribute
    def user_attribute(
        self,
        # Id of user attribute
        user_attribute_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.UserAttribute:
        """Get User Attribute"""
        response = self.get(
            f"/user_attributes/{user_attribute_id}",
            models.UserAttribute,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.UserAttribute)
        return response

    # ### Get user attribute values for a given user.
    #
    # Returns the values of specified user attributes (or all user attributes) for a certain user.
    #
    # A value for each user attribute is searched for in the following locations, in this order:
    # 1. in the user's account information
    # 1. in groups that the user is a member of
    # 1. the default value of the user attribute
    #
    # If more than one group has a value defined for a user attribute, the group with the lowest rank wins.
    #
    # The response will only include user attributes for which values were found. Use `include_unset=true` to include
    # empty records for user attributes with no value.
    #
    # The value of all hidden user attributes will be blank.
    #
    # GET /users/{user_id}/attribute_values -> Sequence[models.UserAttributeWithValue]
    def user_attribute_user_values(
        self,
        # Id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        # Specific user attributes to request. Omit or leave blank to request all user attributes.
        user_attribute_ids: Optional[models.DelimSequence[int]] = None,
        # If true, returns all values in the search path instead of just the first value found. Useful for debugging group precedence.
        all_values: Optional[bool] = None,
        # If true, returns an empty record for each requested attribute that has no user, group, or default value.
        include_unset: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.UserAttributeWithValue]:
        """Get User Attribute Values"""
        response = self.get(
            f"/users/{user_id}/attribute_values",
            Sequence[models.UserAttributeWithValue],
            query_params={
                "fields": fields,
                "user_attribute_ids": user_attribute_ids,
                "all_values": all_values,
                "include_unset": include_unset,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### API 3 login information for the specified user. This is for the newer API keys that can be added for any user.
    #
    # GET /users/{user_id}/credentials_api3/{credentials_api3_id} -> models.CredentialsApi3
    def user_credentials_api3(
        self,
        # Id of user
        user_id: int,
        # Id of API 3 Credential
        credentials_api3_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsApi3:
        """Get API 3 Credential"""
        response = self.get(
            f"/users/{user_id}/credentials_api3/{credentials_api3_id}",
            models.CredentialsApi3,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsApi3)
        return response

    # ### Email/password login information for the specified user.
    #
    # GET /users/{user_id}/credentials_email -> models.CredentialsEmail
    def user_credentials_email(
        self,
        # id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsEmail:
        """Get Email/Password Credential"""
        response = self.get(
            f"/users/{user_id}/credentials_email",
            models.CredentialsEmail,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsEmail)
        return response

    # ### Embed login information for the specified user.
    #
    # GET /users/{user_id}/credentials_embed/{credentials_embed_id} -> models.CredentialsEmbed
    def user_credentials_embed(
        self,
        # Id of user
        user_id: int,
        # Id of Embedding Credential
        credentials_embed_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsEmbed:
        """Get Embedding Credential"""
        response = self.get(
            f"/users/{user_id}/credentials_embed/{credentials_embed_id}",
            models.CredentialsEmbed,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsEmbed)
        return response

    # ### Google authentication login information for the specified user.
    #
    # GET /users/{user_id}/credentials_google -> models.CredentialsGoogle
    def user_credentials_google(
        self,
        # id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsGoogle:
        """Get Google Auth Credential"""
        response = self.get(
            f"/users/{user_id}/credentials_google",
            models.CredentialsGoogle,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsGoogle)
        return response

    # ### LDAP login information for the specified user.
    #
    # GET /users/{user_id}/credentials_ldap -> models.CredentialsLDAP
    def user_credentials_ldap(
        self,
        # id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsLDAP:
        """Get LDAP Credential"""
        response = self.get(
            f"/users/{user_id}/credentials_ldap",
            models.CredentialsLDAP,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsLDAP)
        return response

    # ### Looker Openid login information for the specified user. Used by Looker Analysts.
    #
    # GET /users/{user_id}/credentials_looker_openid -> models.CredentialsLookerOpenid
    def user_credentials_looker_openid(
        self,
        # id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsLookerOpenid:
        """Get Looker OpenId Credential"""
        response = self.get(
            f"/users/{user_id}/credentials_looker_openid",
            models.CredentialsLookerOpenid,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsLookerOpenid)
        return response

    # ### OpenID Connect (OIDC) authentication login information for the specified user.
    #
    # GET /users/{user_id}/credentials_oidc -> models.CredentialsOIDC
    def user_credentials_oidc(
        self,
        # id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsOIDC:
        """Get OIDC Auth Credential"""
        response = self.get(
            f"/users/{user_id}/credentials_oidc",
            models.CredentialsOIDC,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsOIDC)
        return response

    # ### Saml authentication login information for the specified user.
    #
    # GET /users/{user_id}/credentials_saml -> models.CredentialsSaml
    def user_credentials_saml(
        self,
        # id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsSaml:
        """Get Saml Auth Credential"""
        response = self.get(
            f"/users/{user_id}/credentials_saml",
            models.CredentialsSaml,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsSaml)
        return response

    # ### Two-factor login information for the specified user.
    #
    # GET /users/{user_id}/credentials_totp -> models.CredentialsTotp
    def user_credentials_totp(
        self,
        # id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.CredentialsTotp:
        """Get Two-Factor Credential"""
        response = self.get(
            f"/users/{user_id}/credentials_totp",
            models.CredentialsTotp,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.CredentialsTotp)
        return response

    # ### Get information about the user with a credential of given type with specific id.
    #
    # This is used to do things like find users by their embed external_user_id. Or, find the user with
    # a given api3 client_id, etc. The 'credential_type' matchs the 'type' name of the various credential
    # types. It must be one of the values listed in the table below. The 'credential_id' is your unique Id
    # for the user and is specific to each type of credential.
    #
    # An example using the Ruby sdk might look like:
    #
    # `sdk.user_for_credential('embed', 'customer-4959425')`
    #
    # This table shows the supported 'Credential Type' strings. The right column is for reference; it shows
    # which field in the given credential type is actually searched when finding a user with the supplied
    # 'credential_id'.
    #
    # | Credential Types | Id Field Matched |
    # | ---------------- | ---------------- |
    # | email            | email            |
    # | google           | google_user_id   |
    # | saml             | saml_user_id     |
    # | oidc             | oidc_user_id     |
    # | ldap             | ldap_id          |
    # | api              | token            |
    # | api3             | client_id        |
    # | embed            | external_user_id |
    # | looker_openid    | email            |
    #
    # NOTE: The 'api' credential type was only used with the legacy Looker query API and is no longer supported. The credential type for API you are currently looking at is 'api3'.
    #
    # GET /users/credential/{credential_type}/{credential_id} -> models.User
    def user_for_credential(
        self,
        # Type name of credential
        credential_type: str,
        # Id of credential
        credential_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.User:
        """Get User by Credential Id"""
        credential_type = self.encode_path_param(credential_type)
        credential_id = self.encode_path_param(credential_id)
        response = self.get(
            f"/users/credential/{credential_type}/{credential_id}",
            models.User,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.User)
        return response

    # ### Get information about roles of a given user
    #
    # GET /users/{user_id}/roles -> Sequence[models.Role]
    def user_roles(
        self,
        # id of user
        user_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        # Get only roles associated directly with the user: exclude those only associated through groups.
        direct_association_only: Optional[bool] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> Sequence[models.Role]:
        """Get User Roles"""
        response = self.get(
            f"/users/{user_id}/roles",
            Sequence[models.Role],
            query_params={
                "fields": fields,
                "direct_association_only": direct_association_only,
            },
            transport_options=transport_options,
        )
        assert isinstance(response, list)
        return response

    # ### Web login session for the specified user.
    #
    # GET /users/{user_id}/sessions/{session_id} -> models.Session
    def user_session(
        self,
        # Id of user
        user_id: int,
        # Id of Web Login Session
        session_id: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Session:
        """Get Web Login Session"""
        response = self.get(
            f"/users/{user_id}/sessions/{session_id}",
            models.Session,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.Session)
        return response

    # ### Validate Project
    #
    # Performs lint validation of all lookml files in the project.
    # Returns a list of errors found, if any.
    #
    # Validating the content of all the files in a project can be computationally intensive
    # for large projects. For best performance, call `validate_project(project_id)` only
    # when you really want to recompute project validation. To quickly display the results of
    # the most recent project validation (without recomputing), use `project_validation_results(project_id)`
    #
    # POST /projects/{project_id}/validate -> models.ProjectValidation
    def validate_project(
        self,
        # Project Id
        project_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ProjectValidation:
        """Validate Project"""
        project_id = self.encode_path_param(project_id)
        response = self.post(
            f"/projects/{project_id}/validate",
            models.ProjectValidation,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ProjectValidation)
        return response

    # ### Validate a theme with the specified information
    #
    # Validates all values set for the theme, returning any errors encountered, or 200 OK if valid
    #
    # See [Create Theme](#!/Theme/create_theme) for constraints
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or support@looker.com to update your license for this feature.
    #
    # POST /themes/validate -> models.ValidationError
    def validate_theme(
        self,
        body: models.WriteTheme,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ValidationError:
        """Validate Theme"""
        assert isinstance(body, models.WriteTheme)
        response = self.post(
            f"/themes/validate",
            models.ValidationError,
            body=body,
            transport_options=transport_options,
        )
        assert isinstance(response, models.ValidationError)
        return response

    # ### Get a vector image representing the contents of a dashboard or look.
    #
    # The returned thumbnail is an abstract representation of the contents of a dashbord or look and does not
    # reflect the actual data displayed in the respective visualizations.
    #
    # GET /vector_thumbnail/{type}/{resource_id} -> str
    def vector_thumbnail(
        self,
        # Either dashboard or look
        type: str,
        # ID of the dashboard or look to render
        resource_id: str,
        # Whether or not to refresh the rendered image with the latest content
        reload: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> str:
        """Get Vector Thumbnail"""
        type = self.encode_path_param(type)
        resource_id = self.encode_path_param(resource_id)
        response = self.get(
            f"/vector_thumbnail/{type}/{resource_id}",
            str,
            query_params={"reload": reload},
            transport_options=transport_options,
        )
        assert isinstance(response, str)
        return response

    # ### Get information about all API versions supported by this Looker instance.
    #
    # GET /versions -> models.ApiVersion
    def versions(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.ApiVersion:
        """Get ApiVersion"""
        response = self.get(
            f"/versions",
            models.ApiVersion,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.ApiVersion)
        return response

    # ### This feature is enabled only by special license.
    # ### Gets the whitelabel configuration, which includes hiding documentation links, custom favicon uploading, etc.
    #
    # GET /whitelabel_configuration -> models.WhitelabelConfiguration
    def whitelabel_configuration(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.WhitelabelConfiguration:
        """Get Whitelabel configuration"""
        response = self.get(
            f"/whitelabel_configuration",
            models.WhitelabelConfiguration,
            query_params={"fields": fields},
            transport_options=transport_options,
        )
        assert isinstance(response, models.WhitelabelConfiguration)
        return response

    # ### Get A Workspace
    #
    # Returns information about a workspace such as the git status and selected branches
    # of all projects available to the caller's user account.
    #
    # A workspace defines which versions of project files will be used to evaluate expressions
    # and operations that use model definitions - operations such as running queries or rendering dashboards.
    # Each project has its own git repository, and each project in a workspace may be configured to reference
    # particular branch or revision within their respective repositories.
    #
    # There are two predefined workspaces available: "production" and "dev".
    #
    # The production workspace is shared across all Looker users. Models in the production workspace are read-only.
    # Changing files in production is accomplished by modifying files in a git branch and using Pull Requests
    # to merge the changes from the dev branch into the production branch, and then telling
    # Looker to sync with production.
    #
    # The dev workspace is local to each Looker user. Changes made to project/model files in the dev workspace only affect
    # that user, and only when the dev workspace is selected as the active workspace for the API session.
    # (See set_session_workspace()).
    #
    # The dev workspace is NOT unique to an API session. Two applications accessing the Looker API using
    # the same user account will see the same files in the dev workspace. To avoid collisions between
    # API clients it's best to have each client login with API3 credentials for a different user account.
    #
    # Changes made to files in a dev workspace are persistent across API sessions. It's a good
    # idea to commit any changes you've made to the git repository, but not strictly required. Your modified files
    # reside in a special user-specific directory on the Looker server and will still be there when you login in again
    # later and use update_session(workspace_id: "dev") to select the dev workspace for the new API session.
    #
    # GET /workspaces/{workspace_id} -> models.Workspace
    def workspace(
        self,
        # Id of the workspace
        workspace_id: str,
        transport_options: Optional[transport.PTransportSettings] = None,
    ) -> models.Workspace:
        """Get Workspace"""
        workspace_id = self.encode_path_param(workspace_id)
        response = self.get(
            f"/workspaces/{workspace_id}",
            models.Workspace,
            transport_options=transport_options,
        )
        assert isinstance(response, models.Workspace)
        return response
