# Generated by Django 3.0.5 on 2020-05-04 14:16

import aleksis.apps.chronos.managers
import calendarweek.calendarweek
import colorfield.fields
import django.contrib.postgres.fields.jsonb
import django.contrib.sites.managers
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0001_initial'),
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='ChronosGlobalPermissions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
            ],
            options={
                'permissions': (('view_all_timetables', 'Can view all timetables'), ('view_timetable_overview', 'Can view timetable overview'), ('view_lessons_day', 'Can view all lessons per day')),
                'managed': False,
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='Break',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('short_name', models.CharField(max_length=255, verbose_name='Short name')),
                ('name', models.CharField(max_length=255, verbose_name='Long name')),
            ],
            options={
                'verbose_name': 'Break',
                'verbose_name_plural': 'Breaks',
                'ordering': ['after_period'],
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='Lesson',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('date_start', models.DateField(null=True, verbose_name='Start date')),
                ('date_end', models.DateField(null=True, verbose_name='End date')),
                ('groups', models.ManyToManyField(related_name='lessons', to='core.Group', verbose_name='Groups')),
            ],
            options={
                'verbose_name': 'Lesson',
                'verbose_name_plural': 'Lessons',
                'ordering': ['date_start', 'subject'],
            },
            bases=(models.Model, aleksis.apps.chronos.managers.GroupPropertiesMixin, aleksis.apps.chronos.managers.TeacherPropertiesMixin),
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='LessonPeriod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('lesson', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lesson_periods', to='chronos.Lesson', verbose_name='Lesson')),
            ],
            options={
                'verbose_name': 'Lesson period',
                'verbose_name_plural': 'Lesson periods',
                'ordering': ['lesson__date_start', 'period__weekday', 'period__period', 'lesson__subject'],
            },
        ),
        migrations.CreateModel(
            name='Supervision',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
            ],
            options={
                'verbose_name': 'Supervision',
                'verbose_name_plural': 'Supervisions',
                'ordering': ['area', 'break_item'],
            },
        ),
        migrations.CreateModel(
            name='TimetableWidget',
            fields=[
            ],
            options={
                'verbose_name': 'Timetable widget',
                'verbose_name_plural': 'Timetable widgets',
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('core.dashboardwidget',),
        ),
        migrations.CreateModel(
            name='TimePeriod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('weekday', models.PositiveSmallIntegerField(choices=[(0, 'Monday'), (1, 'Tuesday'), (2, 'Wednesday'), (3, 'Thursday'), (4, 'Friday'), (5, 'Saturday'), (6, 'Sunday')], verbose_name='Week day')),
                ('period', models.PositiveSmallIntegerField(verbose_name='Number of period')),
                ('time_start', models.TimeField(verbose_name='Start time')),
                ('time_end', models.TimeField(verbose_name='End time')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
            ],
            options={
                'verbose_name': 'Time period',
                'verbose_name_plural': 'Time periods',
                'ordering': ['weekday', 'period'],
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='SupervisionSubstitution',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('date', models.DateField(verbose_name='Date')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
                ('supervision', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='substitutions', to='chronos.Supervision', verbose_name='Supervision')),
                ('teacher', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='substituted_supervisions', to='core.Person', verbose_name='Teacher')),
            ],
            options={
                'verbose_name': 'Supervision substitution',
                'verbose_name_plural': 'Supervision substitutions',
                'ordering': ['date', 'supervision'],
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='SupervisionArea',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('short_name', models.CharField(max_length=255, verbose_name='Short name')),
                ('name', models.CharField(max_length=255, verbose_name='Long name')),
                ('colour_fg', colorfield.fields.ColorField(default='#000000', max_length=18)),
                ('colour_bg', colorfield.fields.ColorField(default='#FFFFFF', max_length=18)),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
            ],
            options={
                'verbose_name': 'Supervision area',
                'verbose_name_plural': 'Supervision areas',
                'ordering': ['name'],
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AddField(
            model_name='supervision',
            name='area',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='supervisions', to='chronos.SupervisionArea', verbose_name='Supervision area'),
        ),
        migrations.AddField(
            model_name='supervision',
            name='break_item',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='supervisions', to='chronos.Break', verbose_name='Break'),
        ),
        migrations.AddField(
            model_name='supervision',
            name='site',
            field=models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site'),
        ),
        migrations.AddField(
            model_name='supervision',
            name='teacher',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='supervisions', to='core.Person', verbose_name='Teacher'),
        ),
        migrations.CreateModel(
            name='Subject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('short_name', models.CharField(max_length=255, unique=True, verbose_name='Short name')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='Long name')),
                ('colour_fg', colorfield.fields.ColorField(blank=True, default='', max_length=18, verbose_name='Foreground colour')),
                ('colour_bg', colorfield.fields.ColorField(blank=True, default='', max_length=18, verbose_name='Background colour')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
            ],
            options={
                'verbose_name': 'Subject',
                'verbose_name_plural': 'Subjects',
                'ordering': ['name', 'short_name'],
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='Room',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('short_name', models.CharField(max_length=255, unique=True, verbose_name='Short name')),
                ('name', models.CharField(max_length=255, verbose_name='Long name')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
            ],
            options={
                'verbose_name': 'Room',
                'verbose_name_plural': 'Rooms',
                'ordering': ['name', 'short_name'],
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='LessonSubstitution',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('week', models.IntegerField(default=calendarweek.calendarweek.CalendarWeek.current_week, verbose_name='Week')),
                ('cancelled', models.BooleanField(default=False, verbose_name='Cancelled?')),
                ('cancelled_for_teachers', models.BooleanField(default=False, verbose_name='Cancelled for teachers?')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Comment')),
                ('lesson_period', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='substitutions', to='chronos.LessonPeriod', verbose_name='Lesson period')),
                ('room', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='chronos.Room', verbose_name='Room')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
                ('subject', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='lesson_substitutions', to='chronos.Subject', verbose_name='Subject')),
                ('teachers', models.ManyToManyField(blank=True, related_name='lesson_substitutions', to='core.Person', verbose_name='Teachers')),
            ],
            options={
                'verbose_name': 'Lesson substitution',
                'verbose_name_plural': 'Lesson substitutions',
                'ordering': ['lesson_period__lesson__date_start', 'week', 'lesson_period__period__weekday', 'lesson_period__period__period'],
            },
        ),
        migrations.AddField(
            model_name='lessonperiod',
            name='period',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lesson_periods', to='chronos.TimePeriod', verbose_name='Time period'),
        ),
        migrations.AddField(
            model_name='lessonperiod',
            name='room',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='lesson_periods', to='chronos.Room', verbose_name='Room'),
        ),
        migrations.AddField(
            model_name='lessonperiod',
            name='site',
            field=models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site'),
        ),
        migrations.AddField(
            model_name='lesson',
            name='periods',
            field=models.ManyToManyField(related_name='lessons', through='chronos.LessonPeriod', to='chronos.TimePeriod', verbose_name='Periods'),
        ),
        migrations.AddField(
            model_name='lesson',
            name='site',
            field=models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site'),
        ),
        migrations.AddField(
            model_name='lesson',
            name='subject',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lessons', to='chronos.Subject', verbose_name='Subject'),
        ),
        migrations.AddField(
            model_name='lesson',
            name='teachers',
            field=models.ManyToManyField(related_name='lessons_as_teacher', to='core.Person', verbose_name='Teachers'),
        ),
        migrations.CreateModel(
            name='Holiday',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('title', models.CharField(max_length=255, verbose_name='Title')),
                ('date_start', models.DateField(null=True, verbose_name='Start date')),
                ('date_end', models.DateField(null=True, verbose_name='End date')),
                ('comments', models.TextField(blank=True, null=True, verbose_name='Comments')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
            ],
            options={
                'verbose_name': 'Holiday',
                'verbose_name_plural': 'Holidays',
                'ordering': ['date_start'],
            },
        ),
        migrations.CreateModel(
            name='ExtraLesson',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('week', models.IntegerField(default=calendarweek.calendarweek.CalendarWeek.current_week, verbose_name='Week')),
                ('comment', models.CharField(blank=True, max_length=255, null=True, verbose_name='Comment')),
                ('groups', models.ManyToManyField(related_name='extra_lessons', to='core.Group', verbose_name='Groups')),
                ('period', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='extra_lessons', to='chronos.TimePeriod', verbose_name='Time period')),
                ('room', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='extra_lessons', to='chronos.Room', verbose_name='Room')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
                ('subject', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='extra_lessons', to='chronos.Subject', verbose_name='Subject')),
                ('teachers', models.ManyToManyField(related_name='extra_lessons_as_teacher', to='core.Person', verbose_name='Teachers')),
            ],
            options={
                'verbose_name': 'Extra lesson',
                'verbose_name_plural': 'Extra lessons',
            },
            bases=(models.Model, aleksis.apps.chronos.managers.GroupPropertiesMixin),
        ),
        migrations.CreateModel(
            name='Exam',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('date', models.DateField(null=True, verbose_name='Date of exam')),
                ('title', models.CharField(max_length=255, verbose_name='Title')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Comment')),
                ('lesson', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='exams', to='chronos.Lesson', verbose_name='Lesson')),
                ('period_from', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='chronos.TimePeriod', verbose_name='Start period')),
                ('period_to', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='chronos.TimePeriod', verbose_name='End period')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
            ],
            options={
                'verbose_name': 'Exam',
                'verbose_name_plural': 'Exams',
                'ordering': ['date'],
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('title', models.CharField(blank=True, max_length=255, null=True, verbose_name='Title')),
                ('date_start', models.DateField(null=True, verbose_name='Start date')),
                ('date_end', models.DateField(null=True, verbose_name='End date')),
                ('groups', models.ManyToManyField(related_name='events', to='core.Group', verbose_name='Groups')),
                ('period_from', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='chronos.TimePeriod', verbose_name='Start time period')),
                ('period_to', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='chronos.TimePeriod', verbose_name='End time period')),
                ('rooms', models.ManyToManyField(related_name='events', to='chronos.Room', verbose_name='Rooms')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
                ('teachers', models.ManyToManyField(related_name='events', to='core.Person', verbose_name='Teachers')),
            ],
            options={
                'verbose_name': 'Event',
                'verbose_name_plural': 'Events',
                'ordering': ['date_start'],
            },
            bases=(models.Model, aleksis.apps.chronos.managers.GroupPropertiesMixin, aleksis.apps.chronos.managers.TeacherPropertiesMixin),
        ),
        migrations.AddField(
            model_name='break',
            name='after_period',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='break_after', to='chronos.TimePeriod', verbose_name='Time period after break starts'),
        ),
        migrations.AddField(
            model_name='break',
            name='before_period',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='break_before', to='chronos.TimePeriod', verbose_name='Time period before break ends'),
        ),
        migrations.AddField(
            model_name='break',
            name='site',
            field=models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site'),
        ),
        migrations.CreateModel(
            name='AbsenceReason',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('short_name', models.CharField(max_length=255, verbose_name='Short name')),
                ('name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Name')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
            ],
            options={
                'verbose_name': 'Absence reason',
                'verbose_name_plural': 'Absence reasons',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='Absence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', django.contrib.postgres.fields.jsonb.JSONField(default=dict, editable=False)),
                ('date_start', models.DateField(null=True, verbose_name='Start date')),
                ('date_end', models.DateField(null=True, verbose_name='End date')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Comment')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='absences', to='core.Group', verbose_name='Group')),
                ('period_from', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='chronos.TimePeriod', verbose_name='Start period')),
                ('period_to', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='chronos.TimePeriod', verbose_name='End period')),
                ('reason', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='absences', to='chronos.AbsenceReason', verbose_name='Absence reason')),
                ('room', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='absences', to='chronos.Room', verbose_name='Room')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
                ('teacher', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='absences', to='core.Person', verbose_name='Teacher')),
            ],
            options={
                'verbose_name': 'Absence',
                'verbose_name_plural': 'Absences',
                'ordering': ['date_start'],
            },
        ),
        migrations.AddIndex(
            model_name='timeperiod',
            index=models.Index(fields=['time_start', 'time_end'], name='chronos_tim_time_st_491e4c_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='timeperiod',
            unique_together={('weekday', 'period')},
        ),
        migrations.AddConstraint(
            model_name='lessonsubstitution',
            constraint=models.CheckConstraint(check=models.Q(('cancelled', True), ('subject__isnull', False), _negated=True), name='either_substituted_or_cancelled'),
        ),
        migrations.AlterUniqueTogether(
            name='lessonsubstitution',
            unique_together={('lesson_period', 'week')},
        ),
        migrations.AddIndex(
            model_name='lessonperiod',
            index=models.Index(fields=['lesson', 'period'], name='chronos_les_lesson__05250e_idx'),
        ),
        migrations.AddIndex(
            model_name='lesson',
            index=models.Index(fields=['date_start', 'date_end'], name='chronos_les_date_st_5ecc62_idx'),
        ),
        migrations.AddIndex(
            model_name='holiday',
            index=models.Index(fields=['date_start', 'date_end'], name='chronos_hol_date_st_a47004_idx'),
        ),
        migrations.AddIndex(
            model_name='exam',
            index=models.Index(fields=['date'], name='chronos_exa_date_5ba442_idx'),
        ),
        migrations.AddIndex(
            model_name='event',
            index=models.Index(fields=['period_from', 'period_to', 'date_start', 'date_end'], name='chronos_eve_period__c7ec33_idx'),
        ),
        migrations.AddIndex(
            model_name='break',
            index=models.Index(fields=['after_period', 'before_period'], name='chronos_bre_after_p_0f28d3_idx'),
        ),
        migrations.AddIndex(
            model_name='absence',
            index=models.Index(fields=['date_start', 'date_end'], name='chronos_abs_date_st_337ff5_idx'),
        ),
    ]
