#  Copyright 2022-present, the Waterdip Labs Pvt. Ltd.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import dataclasses
import uuid
from dataclasses import dataclass
from enum import Enum
from typing import Any


class WidgetType(Enum):
    COUNTER = "counter"


class WidgetSize(Enum):
    HALF = 1
    FULL = 2


@dataclass
class BaseWidgetInfo:
    type: str
    title: str
    size: int
    id: str = dataclasses.field(default_factory=lambda: str(uuid.uuid4()))
    details: str = ""
    params: Any = None


@dataclass
class CounterData:
    label: str
    value: str
