# mag2exp
[Samuel Holt](https://github.com/samjrholt)<sup>1</sup>, James Loudon<sup>2</sup>, Thomas Hicken<sup>3</sup>, [David Cortés Ortuño](https://github.com/davidcortesortuno)<sup>4</sup>, [Martin Lang](https://github.com/lang-m)<sup>4</sup>, [Marijan Beg](https://github.com/marijanbeg)<sup>5,4</sup>, [Hans Fangohr](https://github.com/fangohr)<sup>4,6,7</sup>

<sup>1</sup> *Department of Physics, University of Warwick, Coventry CV4 7AL, UK*  
<sup>2</sup> *Department of Materials Science and Metallurgy, University of Cambridge, Cambridge, CB3 0FS, United Kingdom*  
<sup>3</sup> *Department of Physics, Durham University, Durham, DH1 3LE, United Kingdom*  
<sup>4</sup> *Faculty of Engineering and Physical Sciences, University of Southampton, Southampton SO17 1BJ, UK*  
<sup>5</sup> *Department of Earth Science and Engineering, Imperial College London, London SW7 2AZ, UK*  
<sup>6</sup> *Max Planck Institute for the Structure and Dynamics of Matter, Luruper Chaussee 149, 22761 Hamburg, Germany*  
<sup>7</sup> *Center for Free-Electron Laser Science, Luruper Chaussee 149, 22761 Hamburg, Germany*

| Description | Badge |
| --- | --- |
| Tests | [![Build status](https://github.com/ubermag/mag2exp/workflows/workflow/badge.svg)](https://github.com/ubermag/mag2exp/actions?query=workflow%3Aworkflow) |
|       | [![conda](https://github.com/ubermag/mag2exp/workflows/conda/badge.svg)](https://github.com/ubermag/mag2exp/actions?query=workflow%3Aconda) |
| Releases | [![PyPI version](https://badge.fury.io/py/mag2exp.svg)](https://badge.fury.io/py/mag2exp) |
|          | [![Anaconda-Server Badge](https://anaconda.org/conda-forge/mag2exp/badges/version.svg)](https://anaconda.org/conda-forge/mag2exp) |
| Coverage | [![codecov](https://codecov.io/gh/ubermag/mag2exp/branch/master/graph/badge.svg?token=hcK4fofmrL)](https://codecov.io/gh/ubermag/mag2exp) |
| Documentation | [![Documentation](https://img.shields.io/badge/Docs-ubermag.github.io-blue)](https://ubermag.github.io/documentation/mag2exp.html) |
| YouTube | [![YouTube](https://img.shields.io/badge/YouTube-ubermag-blue)](https://www.youtube.com/channel/UC7MSqVQSMFV42R1jAYmKGLg) |
| Binder | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/ubermag/mag2exp/stable?urlpath=lab/tree/docs/index.ipynb) |
| Platforms | [![Platforms](https://anaconda.org/conda-forge/mag2exp/badges/platforms.svg)](https://anaconda.org/conda-forge/mag2exp) |
| Downloads | [![Downloads](https://anaconda.org/conda-forge/mag2exp/badges/downloads.svg)](https://anaconda.org/conda-forge/mag2exp) |
| License | [![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) |
| DOI | [![DOI](https://zenodo.org/badge/67028400.svg)](https://zenodo.org/badge/latestdoi/67028400) |

## About

`mag2exp` is a Python package, integrated with Jupyter, providing:

- simulations of experimental techniques perfomed on magnetisation textures,
- the ability to perform "virtual" experiments,
- the functionality to compare of real experimental results agaist simulated experiments.


It is available on Windows, MacOS, and Linux. It requires Python 3.8+.

## Documentation

APIs and tutorials are available in the documentation. To access the documentation, use the badge in the table above.

## Installation, testing, and upgrade

We recommend installation using `conda` package manager. Instructions can be found in the documentation.

## Binder

This package can be used in the cloud via Binder. To access Binder, use the badge in the table above.

## YouTube

YouTube video tutorials are available on the [Ubermag channel](https://www.youtube.com/channel/UC7MSqVQSMFV42R1jAYmKGLg).

## Support

If you require support, have questions, want to report a bug, or want to suggest an improvement, please raise an issue in [ubermag/help](https://github.com/ubermag/help) repository.

## Contributions

All contributions are welcome, however small they are. If you would like to contribute, please fork the repository and create a pull request. If you are not sure how to contribute, please contact us by raising an issue in [ubermag/help](https://github.com/ubermag/help) repository, and we are going to help you get started and assist you on the way.

**Contributors**:



## License

Licensed under the BSD 3-Clause "New" or "Revised" License. For details, please refer to the [LICENSE](LICENSE) file.

## How to cite

1. M. Beg, M. Lang, and H. Fangohr. Ubermag: Towards more effective micromagnetic workflows. [*IEEE Transactions on Magnetics*](https://doi.org/10.1109/TMAG.2021.3078896) (2021).

2. M. Beg, R. A. Pepper, and H. Fangohr. User interfaces for computational science: A domain specific language for OOMMF embedded in Python. [*AIP Advances* **7**, 56025](http://aip.scitation.org/doi/10.1063/1.4977225) (2017).

3. Samuel Holt, James Loudon, Thomas Hicken, David Cortés Ortuño, Martin Lang, Marijan Beg, Hans Fangohr. mag2exp: Simulate experimental measurements for magnetic materials DOI: [10.5281/zenodo.3539461](http://doi.org/10.5281/zenodo.3539461) (2021).

## Acknowledgements

- [OpenDreamKit](http://opendreamkit.org/) – Horizon 2020 European Research Infrastructure project (676541)

- EPSRC Programme Grant on [Skyrmionics](http://www.skyrmions.ac.uk) (EP/N032128/1)

