from ..models import State, Chamber, District

MA = State(
    name="Massachusetts",
    abbr="MA",
    capital="Boston",
    capital_tz="America/New_York",
    fips="25",
    unicameral=False,
    legislature_name="Massachusetts General Court",
    legislature_organization_id="ocd-organization/9c4e7b53-9912-4394-a40a-14b5ecdb8aba",
    executive_name="Office of the Governor",
    executive_organization_id="ocd-organization/61a1385f-f512-4d4b-826f-3118c9a775bf",
    division_id="ocd-division/country:us/state:ma",
    jurisdiction_id="ocd-jurisdiction/country:us/state:ma/government",
    url="http://mass.gov",
    lower=Chamber(
        chamber_type="lower",
        name="House",
        organization_id="ocd-organization/ca38ad9c-c3d5-4c4f-bc2f-d885218ed802",
        num_seats=160,
        title="Representative",
        districts=[
            District(
                "Tenth Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:10th_bristol",
                1,
            ),
            District(
                "Tenth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:10th_essex",
                1,
            ),
            District(
                "Tenth Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:10th_hampden",
                1,
            ),
            District(
                "Tenth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:10th_middlesex",
                1,
            ),
            District(
                "Tenth Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:10th_norfolk",
                1,
            ),
            District(
                "Tenth Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:10th_plymouth",
                1,
            ),
            District(
                "Tenth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:10th_suffolk",
                1,
            ),
            District(
                "Tenth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:10th_worcester",
                1,
            ),
            District(
                "Eleventh Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:11th_bristol",
                1,
            ),
            District(
                "Eleventh Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:11th_essex",
                1,
            ),
            District(
                "Eleventh Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:11th_hampden",
                1,
            ),
            District(
                "Eleventh Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:11th_middlesex",
                1,
            ),
            District(
                "Eleventh Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:11th_norfolk",
                1,
            ),
            District(
                "Eleventh Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:11th_plymouth",
                1,
            ),
            District(
                "Eleventh Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:11th_suffolk",
                1,
            ),
            District(
                "Eleventh Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:11th_worcester",
                1,
            ),
            District(
                "Twelfth Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:12th_bristol",
                1,
            ),
            District(
                "Twelfth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:12th_essex",
                1,
            ),
            District(
                "Twelfth Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:12th_hampden",
                1,
            ),
            District(
                "Twelfth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:12th_middlesex",
                1,
            ),
            District(
                "Twelfth Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:12th_norfolk",
                1,
            ),
            District(
                "Twelfth Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:12th_plymouth",
                1,
            ),
            District(
                "Twelfth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:12th_suffolk",
                1,
            ),
            District(
                "Twelfth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:12th_worcester",
                1,
            ),
            District(
                "Thirteenth Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:13th_bristol",
                1,
            ),
            District(
                "Thirteenth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:13th_essex",
                1,
            ),
            District(
                "Thirteenth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:13th_middlesex",
                1,
            ),
            District(
                "Thirteenth Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:13th_norfolk",
                1,
            ),
            District(
                "Thirteenth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:13th_suffolk",
                1,
            ),
            District(
                "Thirteenth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:13th_worcester",
                1,
            ),
            District(
                "Fourteenth Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:14th_bristol",
                1,
            ),
            District(
                "Fourteenth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:14th_essex",
                1,
            ),
            District(
                "Fourteenth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:14th_middlesex",
                1,
            ),
            District(
                "Fourteenth Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:14th_norfolk",
                1,
            ),
            District(
                "Fourteenth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:14th_suffolk",
                1,
            ),
            District(
                "Fourteenth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:14th_worcester",
                1,
            ),
            District(
                "Fifteenth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:15th_essex",
                1,
            ),
            District(
                "Fifteenth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:15th_middlesex",
                1,
            ),
            District(
                "Fifteenth Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:15th_norfolk",
                1,
            ),
            District(
                "Fifteenth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:15th_suffolk",
                1,
            ),
            District(
                "Fifteenth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:15th_worcester",
                1,
            ),
            District(
                "Sixteenth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:16th_essex",
                1,
            ),
            District(
                "Sixteenth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:16th_middlesex",
                1,
            ),
            District(
                "Sixteenth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:16th_suffolk",
                1,
            ),
            District(
                "Sixteenth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:16th_worcester",
                1,
            ),
            District(
                "Seventeenth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:17th_essex",
                1,
            ),
            District(
                "Seventeenth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:17th_middlesex",
                1,
            ),
            District(
                "Seventeenth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:17th_suffolk",
                1,
            ),
            District(
                "Seventeenth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:17th_worcester",
                1,
            ),
            District(
                "Eighteenth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:18th_essex",
                1,
            ),
            District(
                "Eighteenth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:18th_middlesex",
                1,
            ),
            District(
                "Eighteenth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:18th_suffolk",
                1,
            ),
            District(
                "Eighteenth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:18th_worcester",
                1,
            ),
            District(
                "Nineteenth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:19th_middlesex",
                1,
            ),
            District(
                "Nineteenth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:19th_suffolk",
                1,
            ),
            District(
                "First Barnstable",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_barnstable",
                1,
            ),
            District(
                "First Berkshire",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_berkshire",
                1,
            ),
            District(
                "First Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_bristol",
                1,
            ),
            District(
                "First Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_essex",
                1,
            ),
            District(
                "First Franklin",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_franklin",
                1,
            ),
            District(
                "First Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_hampden",
                1,
            ),
            District(
                "First Hampshire",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_hampshire",
                1,
            ),
            District(
                "First Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_middlesex",
                1,
            ),
            District(
                "First Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_norfolk",
                1,
            ),
            District(
                "First Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_plymouth",
                1,
            ),
            District(
                "First Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_suffolk",
                1,
            ),
            District(
                "First Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:1st_worcester",
                1,
            ),
            District(
                "Twentieth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:20th_middlesex",
                1,
            ),
            District(
                "Twenty-First Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:21st_middlesex",
                1,
            ),
            District(
                "Twenty-Second Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:22nd_middlesex",
                1,
            ),
            District(
                "Twenty-Third Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:23rd_middlesex",
                1,
            ),
            District(
                "Twenty-Fourth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:24th_middlesex",
                1,
            ),
            District(
                "Twenty-Fifth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:25th_middlesex",
                1,
            ),
            District(
                "Twenty-Sixth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:26th_middlesex",
                1,
            ),
            District(
                "Twenty-Seventh Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:27th_middlesex",
                1,
            ),
            District(
                "Twenty-Eighth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:28th_middlesex",
                1,
            ),
            District(
                "Twenty-Ninth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:29th_middlesex",
                1,
            ),
            District(
                "Second Barnstable",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_barnstable",
                1,
            ),
            District(
                "Second Berkshire",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_berkshire",
                1,
            ),
            District(
                "Second Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_bristol",
                1,
            ),
            District(
                "Second Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_essex",
                1,
            ),
            District(
                "Second Franklin",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_franklin",
                1,
            ),
            District(
                "Second Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_hampden",
                1,
            ),
            District(
                "Second Hampshire",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_hampshire",
                1,
            ),
            District(
                "Second Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_middlesex",
                1,
            ),
            District(
                "Second Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_norfolk",
                1,
            ),
            District(
                "Second Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_plymouth",
                1,
            ),
            District(
                "Second Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_suffolk",
                1,
            ),
            District(
                "Second Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:2nd_worcester",
                1,
            ),
            District(
                "Thirtieth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:30th_middlesex",
                1,
            ),
            District(
                "Thirty-First Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:31st_middlesex",
                1,
            ),
            District(
                "Thirty-Second Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:32nd_middlesex",
                1,
            ),
            District(
                "Thirty-Third Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:33rd_middlesex",
                1,
            ),
            District(
                "Thirty-Fourth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:34th_middlesex",
                1,
            ),
            District(
                "Thirty-Fifth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:35th_middlesex",
                1,
            ),
            District(
                "Thirty-Sixth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:36th_middlesex",
                1,
            ),
            District(
                "Thirty-Seventh Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:37th_middlesex",
                1,
            ),
            District(
                "Third Barnstable",
                "lower",
                "ocd-division/country:us/state:ma/sldl:3rd_barnstable",
                1,
            ),
            District(
                "Third Berkshire",
                "lower",
                "ocd-division/country:us/state:ma/sldl:3rd_berkshire",
                1,
            ),
            District(
                "Third Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:3rd_bristol",
                1,
            ),
            District(
                "Third Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:3rd_essex",
                1,
            ),
            District(
                "Third Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:3rd_hampden",
                1,
            ),
            District(
                "Third Hampshire",
                "lower",
                "ocd-division/country:us/state:ma/sldl:3rd_hampshire",
                1,
            ),
            District(
                "Third Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:3rd_middlesex",
                1,
            ),
            District(
                "Third Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:3rd_norfolk",
                1,
            ),
            District(
                "Third Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:3rd_plymouth",
                1,
            ),
            District(
                "Third Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:3rd_suffolk",
                1,
            ),
            District(
                "Third Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:3rd_worcester",
                1,
            ),
            District(
                "Fourth Barnstable",
                "lower",
                "ocd-division/country:us/state:ma/sldl:4th_barnstable",
                1,
            ),
            District(
                "Fourth Berkshire",
                "lower",
                "ocd-division/country:us/state:ma/sldl:4th_berkshire",
                1,
            ),
            District(
                "Fourth Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:4th_bristol",
                1,
            ),
            District(
                "Fourth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:4th_essex",
                1,
            ),
            District(
                "Fourth Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:4th_hampden",
                1,
            ),
            District(
                "Fourth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:4th_middlesex",
                1,
            ),
            District(
                "Fourth Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:4th_norfolk",
                1,
            ),
            District(
                "Fourth Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:4th_plymouth",
                1,
            ),
            District(
                "Fourth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:4th_suffolk",
                1,
            ),
            District(
                "Fourth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:4th_worcester",
                1,
            ),
            District(
                "Fifth Barnstable",
                "lower",
                "ocd-division/country:us/state:ma/sldl:5th_barnstable",
                1,
            ),
            District(
                "Fifth Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:5th_bristol",
                1,
            ),
            District(
                "Fifth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:5th_essex",
                1,
            ),
            District(
                "Fifth Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:5th_hampden",
                1,
            ),
            District(
                "Fifth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:5th_middlesex",
                1,
            ),
            District(
                "Fifth Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:5th_norfolk",
                1,
            ),
            District(
                "Fifth Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:5th_plymouth",
                1,
            ),
            District(
                "Fifth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:5th_suffolk",
                1,
            ),
            District(
                "Fifth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:5th_worcester",
                1,
            ),
            District(
                "Sixth Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:6th_bristol",
                1,
            ),
            District(
                "Sixth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:6th_essex",
                1,
            ),
            District(
                "Sixth Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:6th_hampden",
                1,
            ),
            District(
                "Sixth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:6th_middlesex",
                1,
            ),
            District(
                "Sixth Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:6th_norfolk",
                1,
            ),
            District(
                "Sixth Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:6th_plymouth",
                1,
            ),
            District(
                "Sixth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:6th_suffolk",
                1,
            ),
            District(
                "Sixth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:6th_worcester",
                1,
            ),
            District(
                "Seventh Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:7th_bristol",
                1,
            ),
            District(
                "Seventh Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:7th_essex",
                1,
            ),
            District(
                "Seventh Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:7th_hampden",
                1,
            ),
            District(
                "Seventh Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:7th_middlesex",
                1,
            ),
            District(
                "Seventh Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:7th_norfolk",
                1,
            ),
            District(
                "Seventh Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:7th_plymouth",
                1,
            ),
            District(
                "Seventh Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:7th_suffolk",
                1,
            ),
            District(
                "Seventh Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:7th_worcester",
                1,
            ),
            District(
                "Eighth Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:8th_bristol",
                1,
            ),
            District(
                "Eighth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:8th_essex",
                1,
            ),
            District(
                "Eighth Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:8th_hampden",
                1,
            ),
            District(
                "Eighth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:8th_middlesex",
                1,
            ),
            District(
                "Eighth Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:8th_norfolk",
                1,
            ),
            District(
                "Eighth Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:8th_plymouth",
                1,
            ),
            District(
                "Eighth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:8th_suffolk",
                1,
            ),
            District(
                "Eighth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:8th_worcester",
                1,
            ),
            District(
                "Ninth Bristol",
                "lower",
                "ocd-division/country:us/state:ma/sldl:9th_bristol",
                1,
            ),
            District(
                "Ninth Essex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:9th_essex",
                1,
            ),
            District(
                "Ninth Hampden",
                "lower",
                "ocd-division/country:us/state:ma/sldl:9th_hampden",
                1,
            ),
            District(
                "Ninth Middlesex",
                "lower",
                "ocd-division/country:us/state:ma/sldl:9th_middlesex",
                1,
            ),
            District(
                "Ninth Norfolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:9th_norfolk",
                1,
            ),
            District(
                "Ninth Plymouth",
                "lower",
                "ocd-division/country:us/state:ma/sldl:9th_plymouth",
                1,
            ),
            District(
                "Ninth Suffolk",
                "lower",
                "ocd-division/country:us/state:ma/sldl:9th_suffolk",
                1,
            ),
            District(
                "Ninth Worcester",
                "lower",
                "ocd-division/country:us/state:ma/sldl:9th_worcester",
                1,
            ),
            District(
                "Barnstable, Dukes and Nantucket",
                "lower",
                "ocd-division/country:us/state:ma/sldl:barnstable_dukes_and_nantucket",
                1,
            ),
        ],
    ),
    upper=Chamber(
        chamber_type="upper",
        name="Senate",
        organization_id="ocd-organization/1a75ab3a-669b-43fe-ac8d-31a2d6923d9a",
        num_seats=40,
        title="Senator",
        districts=[
            District(
                "Bristol and Norfolk",
                "upper",
                "ocd-division/country:us/state:ma/sldu:bristol_and_norfolk",
                1,
            ),
            District(
                "Cape and Islands",
                "upper",
                "ocd-division/country:us/state:ma/sldu:cape_and_islands",
                1,
            ),
            District(
                "Fifth Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:5th_middlesex",
                1,
            ),
            District(
                "First Bristol and Plymouth",
                "upper",
                "ocd-division/country:us/state:ma/sldu:1st_bristol_and_plymouth",
                1,
            ),
            District(
                "First Essex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:1st_essex",
                1,
            ),
            District(
                "First Essex and Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:1st_essex_and_middlesex",
                1,
            ),
            District(
                "First Hampden and Hampshire",
                "upper",
                "ocd-division/country:us/state:ma/sldu:1st_hampden_and_hampshire",
                1,
            ),
            District(
                "First Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:1st_middlesex",
                1,
            ),
            District(
                "First Middlesex and Norfolk",
                "upper",
                "ocd-division/country:us/state:ma/sldu:1st_middlesex_and_norfolk",
                1,
            ),
            District(
                "First Plymouth and Bristol",
                "upper",
                "ocd-division/country:us/state:ma/sldu:1st_plymouth_and_bristol",
                1,
            ),
            District(
                "First Suffolk",
                "upper",
                "ocd-division/country:us/state:ma/sldu:1st_suffolk",
                1,
            ),
            District(
                "First Suffolk and Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:1st_suffolk_and_middlesex",
                1,
            ),
            District(
                "First Worcester",
                "upper",
                "ocd-division/country:us/state:ma/sldu:1st_worcester",
                1,
            ),
            District(
                "Fourth Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:4th_middlesex",
                1,
            ),
            District(
                "Hampden", "upper", "ocd-division/country:us/state:ma/sldu:hampden", 1
            ),
            District(
                "Berkshire, Hampshire, Franklin and Hampden",
                "upper",
                "ocd-division/country:us/state:ma/sldu:berkshire_hampshire_franklin_and_hampden",
                1,
            ),
            District(
                "Middlesex and Suffolk",
                "upper",
                "ocd-division/country:us/state:ma/sldu:middlesex_and_suffolk",
                1,
            ),
            District(
                "Middlesex and Worcester",
                "upper",
                "ocd-division/country:us/state:ma/sldu:middlesex_and_worcester",
                1,
            ),
            District(
                "Norfolk, Bristol and Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:norfolk_bristol_and_middlesex",
                1,
            ),
            District(
                "Norfolk, Bristol and Plymouth",
                "upper",
                "ocd-division/country:us/state:ma/sldu:norfolk_bristol_and_plymouth",
                1,
            ),
            District(
                "Norfolk and Plymouth",
                "upper",
                "ocd-division/country:us/state:ma/sldu:norfolk_and_plymouth",
                1,
            ),
            District(
                "Norfolk and Suffolk",
                "upper",
                "ocd-division/country:us/state:ma/sldu:norfolk_and_suffolk",
                1,
            ),
            District(
                "Plymouth and Barnstable",
                "upper",
                "ocd-division/country:us/state:ma/sldu:plymouth_and_barnstable",
                1,
            ),
            District(
                "Plymouth and Norfolk",
                "upper",
                "ocd-division/country:us/state:ma/sldu:plymouth_and_norfolk",
                1,
            ),
            District(
                "Second Bristol and Plymouth",
                "upper",
                "ocd-division/country:us/state:ma/sldu:2nd_bristol_and_plymouth",
                1,
            ),
            District(
                "Second Essex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:2nd_essex",
                1,
            ),
            District(
                "Second Essex and Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:2nd_essex_and_middlesex",
                1,
            ),
            District(
                "Second Hampden and Hampshire",
                "upper",
                "ocd-division/country:us/state:ma/sldu:2nd_hampden_and_hampshire",
                1,
            ),
            District(
                "Second Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:2nd_middlesex",
                1,
            ),
            District(
                "Second Middlesex and Norfolk",
                "upper",
                "ocd-division/country:us/state:ma/sldu:2nd_middlesex_and_norfolk",
                1,
            ),
            District(
                "Second Plymouth and Bristol",
                "upper",
                "ocd-division/country:us/state:ma/sldu:2nd_plymouth_and_bristol",
                1,
            ),
            District(
                "Second Suffolk",
                "upper",
                "ocd-division/country:us/state:ma/sldu:2nd_suffolk",
                1,
            ),
            District(
                "Second Suffolk and Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:2nd_suffolk_and_middlesex",
                1,
            ),
            District(
                "Second Worcester",
                "upper",
                "ocd-division/country:us/state:ma/sldu:2nd_worcester",
                1,
            ),
            District(
                "Third Essex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:3rd_essex",
                1,
            ),
            District(
                "Third Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:3rd_middlesex",
                1,
            ),
            District(
                "Worcester and Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:worcester_and_middlesex",
                1,
            ),
            District(
                "Worcester and Norfolk",
                "upper",
                "ocd-division/country:us/state:ma/sldu:worcester_and_norfolk",
                1,
            ),
            District(
                "Worcester, Hampden, Hampshire and Middlesex",
                "upper",
                "ocd-division/country:us/state:ma/sldu:worcester_hampden_hampshire_and_middlesex",
                1,
            ),
            District(
                "Hampshire, Franklin and Worcester",
                "upper",
                "ocd-division/country:us/state:ma/sldu:hampshire_franklin_and_worcester",
                1,
            ),
        ],
    ),
)
