"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.awsCredentialStep = void 0;
function awsCredentialStep(stepName, props) {
    const params = {};
    params['aws-region'] = props.region;
    params['role-duration-seconds'] = 30 * 60;
    // Session tagging requires the role to have `sts:TagSession` permissions,
    // which CDK bootstrapped roles do not currently have.
    params['role-skip-session-tagging'] = props.roleSkipSessionTagging ?? true;
    params['aws-access-key-id'] = props.accessKeyId;
    params['aws-secret-access-key'] = props.secretAccessKey;
    if (props.sessionToken) {
        params['aws-session-token'] = props.sessionToken;
    }
    if (props.roleToAssume) {
        params['role-to-assume'] = props.roleToAssume;
    }
    if (props.roleExternalId) {
        params['role-external-id'] = props.roleExternalId;
    }
    if (props.roleSessionName) {
        params['role-session-name'] = props.roleSessionName;
    }
    return {
        name: stepName,
        uses: 'aws-actions/configure-aws-credentials@v1-node16',
        with: params,
    };
}
exports.awsCredentialStep = awsCredentialStep;
//# sourceMappingURL=data:application/json;base64,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