

import sys


class ATTR:
    def __setattr__(self, name, value):
        if name in self.__dict__:
            raise Exception('변수에 값을 할당할 수 없습니다.')
        self.__dict__[name] = value

    def __delattr__(self, name):
        if name in self.__dict__:
            raise Exception('변수를 삭제할 수 없습니다.')


sys.modules[__name__] = ATTR()

ATTR.ATTR_NONE                      = 0
ATTR.SW_NAME                        = 576
ATTR.SW_VERSION                     = 577
ATTR.SW_REVISION                    = 578
ATTR.DEVICE_ID                      = 579
ATTR.ATTR_TEST                      = 580
ATTR.LDM_BEGIN                      = 10000
ATTR.LDM_SW_NAME                    = 10001
ATTR.LDM_SW_VERSION                 = 10002
ATTR.LDM_SW_REVISION                = 10003
ATTR.LDM_DEVICE_ID                  = 10004
ATTR.LDM_CONTROL                    = 10100
ATTR.LDM_OL_POWER_DOWN              = 10200
ATTR.LDM_OL_DYNAMIC_FOCUS           = 10201
ATTR.LDM_OL_COARSE                  = 10202
ATTR.LDM_OL_FINE                    = 10203
ATTR.LDM_OL_DEGAUSS                 = 10204
ATTR.LDM_CL_POWER_DOWN              = 10300
ATTR.LDM_CL1                        = 10301
ATTR.LDM_CL2                        = 10302
ATTR.LDM_CL1_DEGAUSS                = 10303
ATTR.LDM_CL2_DEGAUSS                = 10304
ATTR.LDM_CL2                        = 10302
ATTR.LDM_GA_RASTER1                 = 10400
ATTR.LDM_GA_RASTER2                 = 10401
ATTR.LDM_GA1_X                      = 10402
ATTR.LDM_GA1_Y                      = 10403
ATTR.LDM_GA2_X                      = 10406
ATTR.LDM_GA2_Y                      = 10407
ATTR.LDM_STIGMA_X                   = 10500
ATTR.LDM_STIGMA_Y                   = 10501
ATTR.LDM_IMAGE_SHIFT_X              = 10600
ATTR.LDM_IMAGE_SHIFT_Y              = 10601
ATTR.LDM_RASTER_X                   = 10700
ATTR.LDM_RASTER_Y                   = 10701
ATTR.LDM_RASTER_XY                  = 10702
ATTR.LDM_SCANXY_RS                  = 10800
ATTR.LDM_SCANXY_PARALLEL            = 10801
ATTR.LDM_SCANXY_ROTX_A              = 10802
ATTR.LDM_SCANXY_ROTX_B              = 10803
ATTR.LDM_SCANXY_ROTY_A              = 10804
ATTR.LDM_SCANXY_ROTY_B              = 10805
ATTR.LDM_SCANXY_MAG_X               = 10806
ATTR.LDM_SCANXY_MAG_Y               = 10807
ATTR.LDM_SCANXY_SHIFT_X             = 10808
ATTR.LDM_SCANXY_SHIFT_Y             = 10809
ATTR.LDM_SCANXY_B_POWER_DOWN        = 10900
ATTR.LDM_SCANXY_B_DAC_RANGE         = 10901
ATTR.LDM_SCANXY_B_RS                = 10902
ATTR.LDM_SCANXY_B_PARALLEL          = 10903
ATTR.LDM_SCANXY_B_CHA               = 10904
ATTR.LDM_SCANXY_B_CHB               = 10905
ATTR.LDM_SCAN_ROTX_A                = 10950
ATTR.LDM_SCAN_ROTX_B                = 10951
ATTR.LDM_SCAN_ROTY_A                = 10952
ATTR.LDM_SCAN_ROTY_B                = 10953
ATTR.LDM_SCAN_MAG_X                 = 10954
ATTR.LDM_SCAN_MAG_Y                 = 10955
ATTR.LDM_SCAN_SHIFT_X               = 10956
ATTR.LDM_SCAN_SHIFT_Y               = 10957
ATTR.LDM_SCAN_MAG_RANGE1            = 10958
ATTR.LDM_SCAN_MAG_RANGE2            = 10959
ATTR.LDM_SCAN_DRIVER                = 10960
ATTR.LDM_SCAN_X_MON                 = 10961
ATTR.LDM_SCAN_Y_MON                 = 10962
ATTR.LDM_MISC_OPA548_PD             = 11000
ATTR.LDM_MISC_LED_RED               = 11001
ATTR.LDM_MISC_LED_GREEN             = 11002
ATTR.LDM_SCAN_MAG_XY                = 13000
ATTR.LDM_SCAN_ROTATION              = 13001
ATTR.LDM_BEAM_TILT_X                = 13002
ATTR.LDM_BEAM_TILT_Y                = 13003
ATTR.LDM_BEAM_TILT_XY               = 13004
ATTR.LDM_BEAM_SHIFT_X               = 13005
ATTR.LDM_BEAM_SHIFT_Y               = 13006
ATTR.LDM_BEAM_SHIFT_XY              = 13007
ATTR.LDM_DIAG                       = 14000
ATTR.LDM_MON                        = 15000
ATTR.LDM_MON_ID0                    = 15001
ATTR.LDM_MON_ID1                    = 15002
ATTR.LDM_MON_ID2                    = 15003
ATTR.LDM_END                        = 15004
ATTR.VCU_BEGIN                      = 20000
ATTR.VCU_SW_NAME                    = 20001
ATTR.VCU_SW_VERSION                 = 20002
ATTR.VCU_SW_REVISION                = 20003
ATTR.VCU_DEVICE_ID                  = 20004
ATTR.VCU_TORR                       = 20010
ATTR.VCU_PASCAL                     = 20011
ATTR.VCU_STATUS                     = 20012
ATTR.VCU_CHAMBER_TORR               = 20013
ATTR.VCU_CHAMBER_PASCAL             = 20014
ATTR.VCU_VP_TARGET                  = 20015
ATTR.VCU_VALVE_CH0                  = 20100
ATTR.VCU_VALVE_CH1                  = 20101
ATTR.VCU_VALVE_CH2                  = 20102
ATTR.VCU_VALVE_CH3                  = 20103
ATTR.VCU_VALVE_CH4                  = 20104
ATTR.VCU_VALVE_CH5                  = 20105
ATTR.VCU_VALVE_CH6                  = 20106
ATTR.VCU_VALVE_CH7                  = 20107
ATTR.VCU_PCV_PWM                    = 20200
ATTR.VCU_PCV_DAC                    = 20201
ATTR.VCU_GAUGE_CH0                  = 20300
ATTR.VCU_GAUGE_CH0_TORR             = 20301
ATTR.VCU_GAUGE_CH1                  = 20302
ATTR.VCU_GAUGE_CH1_TORR             = 20303
ATTR.VCU_GAUGE_CH2                  = 20304
ATTR.VCU_GAUGE_CH2_TORR             = 20305
ATTR.VCU_GAUGE_CH0_PASCAL           = 20306
ATTR.VCU_GAUGE_CH1_PASCAL           = 20307
ATTR.VCU_GAUGE_CH2_PASCAL           = 20308
ATTR.VCU_TMP_RPM                    = 20400
ATTR.VCU_TMP_STATUS                 = 20401
ATTR.VCU_TMP_CONTROLLER             = 20402
ATTR.VCU_TMP_POWER                  = 20403
ATTR.VCU_TMP_FREQUENCY              = 20404
ATTR.VCU_TMP_CONT_TEMP              = 20405
ATTR.VCU_TMP_LIFE_TIME              = 20406
ATTR.VCU_TMP_ERROR                  = 20407
ATTR.VCU_TMP_BEARING_TEMP           = 20408
ATTR.VCU_TMP_MOTOR_TEMP             = 20409
ATTR.VCU_TMP_DRIVE_CURRENT          = 20410
ATTR.VCU_DIAG                       = 20450
ATTR.VCU_MON                        = 20490
ATTR.VCU_MON_ID0                    = 20491
ATTR.VCU_MON_ID1                    = 20492
ATTR.VCU_MON_ID2                    = 20493
ATTR.VCU_END                        = 20494
ATTR.HPIM_BEGIN                     = 20500
ATTR.HPIM_BEGIN                     = 20500
ATTR.HPIM_EGUN_POWER                = 20501
ATTR.HPIM_EGUN_FILAMENT             = 20502
ATTR.HPIM_EGUN_FILAMENT_VOLTAGE     = 20503
ATTR.HPIM_EGUN_BIAS                 = 20504
ATTR.HPIM_EGUN_BIAS_VOLTAGE         = 20505
ATTR.HPIM_EGUN_ACCELERATOR          = 20506
ATTR.HPIM_EGUN_ACCELERATOR_VOLTAGE  = 20507
ATTR.HPIM_EGUN_EMISSION             = 20508
ATTR.HPIM_EGUN_EMISSION_CURRENT     = 20509
ATTR.HPIM_EGUN_FILAMENT_STATUS      = 20510
ATTR.HPIM_PMT_POWER                 = 20511
ATTR.HPIM_PMT                       = 20512
ATTR.HPIM_PMT_VOLTAGE               = 20513
ATTR.HPIM_SCINTILLATOR_POWER        = 20514
ATTR.HPIM_SCINTILLATOR              = 20515
ATTR.HPIM_SCINTILLATOR_VOLTAGE      = 20516
ATTR.HPIM_COLLECTOR_POWER           = 20517
ATTR.HPIM_COLLECTOR                 = 20518
ATTR.HPIM_COLLECTOR_VOLTAGE         = 20519
ATTR.EGUN                           = 20600
ATTR.EGUN_POWER                     = 20601
ATTR.EGUN_FILAMENT_VOLTAGE          = 20602
ATTR.EGUN_BIAS_VOLTAGE              = 20603
ATTR.EGUN_ACCELERATOR_VOLTAGE       = 20604
ATTR.HPIM_DIAG                      = 20700
ATTR.HPIM_MON                       = 20800
ATTR.HPIM_MON_ID0                   = 20801
ATTR.HPIM_MON_ID1                   = 20802
ATTR.HPIM_MON_ID2                   = 20803
ATTR.HPIM_END                       = 20804
ATTR.STAGE_BEGIN                    = 30000
ATTR.STAGE_SW_NAME                  = 30200
ATTR.STAGE_SW_VERSION               = 30201
ATTR.STAGE_SW_REVISION              = 30202
ATTR.STAGE_DEVICE_ID                = 30203
ATTR.STAGE_CONTROL                  = 30001
ATTR.STAGE_STATUS_CLEAR             = 30002
ATTR.STAGE_X_POS                    = 30003
ATTR.STAGE_X_SPEED                  = 30004
ATTR.STAGE_X_TARGET                 = 30005
ATTR.STAGE_X_CURRENT                = 30006
ATTR.STAGE_X_DIV                    = 30007
ATTR.STAGE_X_STATUS_FAULT           = 30008
ATTR.STAGE_X_STATUS_UVLO            = 30009
ATTR.STAGE_X_STATUS_CPOV            = 30010
ATTR.STAGE_X_STATUS_OCP             = 30011
ATTR.STAGE_X_STATUS_STL             = 30012
ATTR.STAGE_X_STATUS_TF              = 30013
ATTR.STAGE_X_STATUS_OL              = 30014
ATTR.STAGE_Y_POS                    = 30015
ATTR.STAGE_Y_SPEED                  = 30016
ATTR.STAGE_Y_TARGET                 = 30017
ATTR.STAGE_Y_CURRENT                = 30018
ATTR.STAGE_Y_DIV                    = 30019
ATTR.STAGE_Y_STATUS_FAULT           = 30020
ATTR.STAGE_Y_STATUS_UVLO            = 30021
ATTR.STAGE_Y_STATUS_CPOV            = 30022
ATTR.STAGE_Y_STATUS_OCP             = 30023
ATTR.STAGE_Y_STATUS_STL             = 30024
ATTR.STAGE_Y_STATUS_TF              = 30025
ATTR.STAGE_Y_STATUS_OL              = 30026
ATTR.STAGE_Z_POS                    = 30027
ATTR.STAGE_Z_SPEED                  = 30028
ATTR.STAGE_Z_TARGET                 = 30029
ATTR.STAGE_Z_CURRENT                = 30030
ATTR.STAGE_Z_DIV                    = 30031
ATTR.STAGE_Z_STATUS_FAULT           = 30032
ATTR.STAGE_Z_STATUS_UVLO            = 30033
ATTR.STAGE_Z_STATUS_CPOV            = 30034
ATTR.STAGE_Z_STATUS_OCP             = 30035
ATTR.STAGE_Z_STATUS_STL             = 30036
ATTR.STAGE_Z_STATUS_TF              = 30037
ATTR.STAGE_Z_STATUS_OL              = 30038
ATTR.STAGE_R_POS                    = 30039
ATTR.STAGE_R_SPEED                  = 30040
ATTR.STAGE_R_TARGET                 = 30041
ATTR.STAGE_R_CURRENT                = 30042
ATTR.STAGE_R_DIV                    = 30043
ATTR.STAGE_R_STATUS_FAULT           = 30044
ATTR.STAGE_R_STATUS_UVLO            = 30045
ATTR.STAGE_R_STATUS_CPOV            = 30046
ATTR.STAGE_R_STATUS_OCP             = 30047
ATTR.STAGE_R_STATUS_STL             = 30048
ATTR.STAGE_R_STATUS_TF              = 30049
ATTR.STAGE_R_STATUS_OL              = 30050
ATTR.STAGE_T_POS                    = 30051
ATTR.STAGE_T_SPEED                  = 30052
ATTR.STAGE_T_TARGET                 = 30053
ATTR.STAGE_T_CURRENT                = 30054
ATTR.STAGE_T_DIV                    = 30055
ATTR.STAGE_T_STATUS_FAULT           = 30056
ATTR.STAGE_T_STATUS_UVLO            = 30057
ATTR.STAGE_T_STATUS_CPOV            = 30058
ATTR.STAGE_T_STATUS_OCP             = 30059
ATTR.STAGE_T_STATUS_STL             = 30060
ATTR.STAGE_T_STATUS_TF              = 30061
ATTR.STAGE_T_STATUS_OL              = 30062
ATTR.STAGE_X_HOMMING                = 30063
ATTR.STAGE_Y_HOMMING                = 30064
ATTR.STAGE_Z_HOMMING                = 30065
ATTR.STAGE_R_HOMMING                = 30066
ATTR.STAGE_T_HOMMING                = 30067
ATTR.STAGE_ACTION                   = 30068
ATTR.STAGE_SAMPLE_HEIGHT            = 30080
ATTR.STAGE_STATUS                   = 30100
ATTR.STAGE_X_STATUS                 = 30101
ATTR.STAGE_Y_STATUS                 = 30102
ATTR.STAGE_Z_STATUS                 = 30103
ATTR.STAGE_R_STATUS                 = 30104
ATTR.STAGE_T_STATUS                 = 30105
ATTR.STAGE_TEST                     = 30300
ATTR.STAGE_XY_TARGET                = 30400
ATTR.STAGE_DIAG                     = 30500
ATTR.STAGE_MON                      = 30600
ATTR.STAGE_MON_ID0                  = 30601
ATTR.STAGE_MON_ID1                  = 30602
ATTR.STAGE_MON_ID2                  = 30603
ATTR.STAGE_END                      = 30604
ATTR.SGU_BEGIN                      = 40000
ATTR.SGU_OFFSET_X                   = 40100
ATTR.SGU_OFFSET_Y                   = 40101
ATTR.SGU_GAIN_X                     = 40102
ATTR.SGU_GAIN_Y                     = 40103
ATTR.SGU_CHANNEL_MUX                = 40104
ATTR.SGU_CHANNEL_MUX_00             = 40105
ATTR.SGU_CHANNEL_MUX_01             = 40106
ATTR.SGU_CHANNEL_MUX_02             = 40107
ATTR.SGU_CHANNEL_MUX_03             = 40108
ATTR.SGU_CHANNEL_MUX_04             = 40109
ATTR.SGU_CHANNEL_MUX_05             = 40110
ATTR.SGU_CHANNEL_MUX_06             = 40111
ATTR.SGU_CHANNEL_MUX_07             = 40112
ATTR.SGU_CHANNEL_GAIN               = 40113
ATTR.SGU_CHANNEL_GAIN_00            = 40114
ATTR.SGU_CHANNEL_GAIN_01            = 40115
ATTR.SGU_CHANNEL_GAIN_02            = 40116
ATTR.SGU_CHANNEL_GAIN_03            = 40117
ATTR.SGU_CHANNEL_GAIN_04            = 40118
ATTR.SGU_CHANNEL_GAIN_05            = 40119
ATTR.SGU_CHANNEL_GAIN_06            = 40120
ATTR.SGU_CHANNEL_GAIN_07            = 40121
ATTR.SGU_DMA_SLOT_00                = 40122
ATTR.SGU_DMA_SLOT_01                = 40123
ATTR.SGU_DMA_SLOT_02                = 40124
ATTR.SGU_DMA_SLOT_03                = 40125
ATTR.SGU_DMA_SLOT_04                = 40126
ATTR.SGU_DMA_SLOT_05                = 40127
ATTR.SGU_DMA_SLOT_06                = 40128
ATTR.SGU_DMA_SLOT_07                = 40129
ATTR.SGU_MAX_RANGE_RATIO            = 40130
ATTR.SGU_RISING_TIME                = 40131
ATTR.SGU_SETTLING_TIME              = 40132
ATTR.SGU_LOOPBACK                   = 40133
ATTR.SGU_BSE_INVERSE                = 40134
ATTR.SGU_CAL_OFFSET_X               = 40200
ATTR.SGU_CAL_OFFSET_Y               = 40201
ATTR.SGU_CAL_GAIN_X                 = 40202
ATTR.SGU_CAL_GAIN_Y                 = 40203
ATTR.SGU_CAL_WD_A                   = 40204
ATTR.SGU_CAL_WD_B                   = 40205
ATTR.SGU_CAL_WD_C                   = 40206
ATTR.SGU_CAL_WD_MAX_I               = 40207
ATTR.SGU_CAL_WD_MAX_DAC             = 40208
ATTR.SGU_CAL_WD_a                   = 40209
ATTR.SGU_CAL_WD_b                   = 40210
ATTR.SGU_CAL_SHEAR_ANGLE            = 40211
ATTR.SGU_CAL_MAG_ALPHAX             = 40212
ATTR.SGU_CAL_MAG_ALPHAY             = 40213
ATTR.SGU_CAL_MAG_C                  = 40214
ATTR.SGU_CAL_MAG_MAX_DAC            = 40215
ATTR.SGU_CAL_SPOTSIZE_TABLE_COUNT   = 40216
ATTR.SGU_CAL_SPOTSIZE_00            = 40217
ATTR.SGU_CAL_SPOTSIZE_01            = 40218
ATTR.SGU_CAL_SPOTSIZE_02            = 40219
ATTR.SGU_CAL_SPOTSIZE_03            = 40220
ATTR.SGU_CAL_SPOTSIZE_04            = 40221
ATTR.SGU_CAL_SPOTSIZE_05            = 40222
ATTR.SGU_CAL_SPOTSIZE_06            = 40223
ATTR.SGU_CAL_SPOTSIZE_07            = 40224
ATTR.SGU_CAL_SPOTSIZE_08            = 40225
ATTR.SGU_CAL_SPOTSIZE_09            = 40226
ATTR.SGU_CAL_SPOTSIZE_10            = 40227
ATTR.SGU_CAL_SPOTSIZE_11            = 40228
ATTR.SGU_CAL_SPOTSIZE_12            = 40229
ATTR.SGU_CAL_SPOTSIZE_13            = 40230
ATTR.SGU_CAL_SPOTSIZE_14            = 40231
ATTR.SGU_CAL_SPOTSIZE_15            = 40232
ATTR.SGU_CAL_SPOTSIZE_16            = 40233
ATTR.SGU_CAL_SPOTSIZE_17            = 40234
ATTR.SGU_CAL_SPOTSIZE_18            = 40235
ATTR.SGU_CAL_SPOTSIZE_19            = 40236
ATTR.SGU_CAL_SHEAR_SCALE            = 40237
ATTR.SGU_CAL_MAG_CX                 = 40238
ATTR.SGU_CAL_MAG_CY                 = 40239
ATTR.SGU_CAL_BSE_OFFSET_CH0         = 40240
ATTR.SGU_CAL_BSE_OFFSET_CH1         = 40241
ATTR.SGU_CAL_BSE_OFFSET_CH2         = 40242
ATTR.SGU_CAL_BSE_OFFSET_CH3         = 40243
ATTR.SGU_PARAM_FREQUENCY            = 40300
ATTR.SGU_PARAM_MAX_RANGE_RATIO      = 40301
ATTR.SGU_PARAM_RISING_TIME          = 40302
ATTR.SGU_PARAM_SETTLING_TIME        = 40303
ATTR.SGU_PARAM_BEAM_MAX_RANGE_RATIO = 40304
ATTR.SGU_PARAM_BEAM_RISING_TIME     = 40305
ATTR.SGU_PARAM_BEAM_SETTLING_TIME   = 40306
ATTR.SGU_PARAM_BEAM_RASTER_SCALE    = 40307
ATTR.SGU_PARAM_PMT_SENSITIVITY      = 40308
ATTR.SGU_PARAM_PMT_MIN              = 40309
ATTR.SGU_PARAM_PMT_MAX              = 40310
ATTR.SGU_PARAM_MAG_ALPHA0           = 40311
ATTR.SGU_PARAM_SCAN_DELAY           = 40312
ATTR.SGU_PARAM_SCAN_DELAY_OFFSET_SCALE = 40313
ATTR.SGU_PARAM_SENSOR_INFO          = 40400
ATTR.SGU_PARAM_SENSOR_SE_MUX        = 40401
ATTR.SGU_PARAM_SENSOR_SE_CHANNEL    = 40402
ATTR.SGU_PARAM_SENSOR_BSEC_CHANNEL  = 40403
ATTR.SGU_PARAM_SENSOR_BSE           = 40404
ATTR.SGU_PARAM_SENSOR_STEM          = 40405
ATTR.SGU_DIAG                       = 40500
ATTR.SGU_MON                        = 40600
ATTR.SGU_MON_ID0                    = 40601
ATTR.SGU_MON_ID1                    = 40602
ATTR.SGU_MON_ID2                    = 40603
ATTR.SGU_END                        = 40604
ATTR.ATTR_SEM_BEGIN                 = 100000
ATTR.ATTR_SEM_STATUS                = 100001
ATTR.ATTR_SEM_SCAN_STATUS           = 100002
ATTR.ATTR_SEM_EGUN_STATUS           = 100003
ATTR.ATTR_SEM_SYSTEM_STATUS         = 100004
ATTR.ATTR_SEM_SE_STATUS             = 100005
ATTR.ATTR_SEM_NOTIFY_STATUS         = 100006
ATTR.ATTR_SEM_SCAN                  = 100100
ATTR.ATTR_SEM_WD                    = 100101
ATTR.ATTR_SEM_WD_COARSE             = 100102
ATTR.ATTR_SEM_WD_FINE               = 100103
ATTR.ATTR_SEM_WD_THETA              = 100104
ATTR.ATTR_SEM_WD_CURRENT            = 100105
ATTR.ATTR_SEM_BEAM_ALIGN            = 100106
ATTR.ATTR_SEM_SPOT_SIZE             = 100107
ATTR.ATTR_SEM_ROTATE                = 100108
ATTR.ATTR_SEM_SE_GAIN               = 100109
ATTR.ATTR_SEM_AUTOGAIN              = 100110
ATTR.ATTR_SEM_SHIFT_X               = 100111
ATTR.ATTR_SEM_SHIFT_Y               = 100112
ATTR.ATTR_SEM_ACCELERATOR           = 100113
ATTR.ATTR_SEM_MAGNIFICATION         = 100114
ATTR.ATTR_SEM_MAGNIFICATION_FACTOR  = 100115
ATTR.ATTR_SEM_DWELL                 = 100116
ATTR.ATTR_SEM_BSE_GAIN              = 100117
ATTR.ATTR_SEM_MAGNIFICATION_MIN     = 100118
ATTR.ATTR_SEM_BEAM_TILT_X           = 100119
ATTR.ATTR_SEM_BEAM_TILT_Y           = 100120
ATTR.ATTR_SEM_BEAM_SHIFT_X          = 100121
ATTR.ATTR_SEM_BEAM_SHIFT_Y          = 100122
ATTR.ATTR_SEM_BIAS                  = 100123
ATTR.ATTR_SEM_FILAMENT              = 100124
ATTR.ATTR_SEM_STIGMA_X              = 100125
ATTR.ATTR_SEM_STIGMA_Y              = 100126
ATTR.ATTR_SEM_STAGE                 = 100200
ATTR.ATTR_SEM_STAGE_X               = 100201
ATTR.ATTR_SEM_STAGE_Y               = 100202
ATTR.ATTR_SEM_STAGE_Z               = 100203
ATTR.ATTR_SEM_STAGE_R               = 100204
ATTR.ATTR_SEM_STAGE_T               = 100205
ATTR.ATTR_SEM_IMAGE                 = 100300
ATTR.ATTR_SEM_IMAGE_HEADER          = 100301
ATTR.ATTR_SEM_IMAGE_WIDTH           = 100302
ATTR.ATTR_SEM_IMAGE_HEIGHT          = 100303
ATTR.ATTR_SEM_IMAGE_BPP             = 100304
ATTR.ATTR_SEM_IMAGE_SIZE            = 100305
ATTR.ATTR_SEM_IMAGE_RISING_TIME     = 100306
ATTR.ATTR_SEM_IMAGE_SETTLING_TIME   = 100307
ATTR.ATTR_SEM_IMAGE_TIME            = 100308
ATTR.ATTR_SEM_IMAGE_DECIMATIONRATE  = 100309
ATTR.ATTR_SEM_IMAGE_SEGMENT         = 100310
ATTR.ATTR_SEM_IMAGE_REG_WRITE       = 100311
ATTR.ATTR_SEM_IMAGE_REG_READ        = 100312
ATTR.ATTR_SEM_IMAGE_COUNT           = 100313
ATTR.ATTR_SEM_VACUUM                = 100500
ATTR.ATTR_SEM_VACUUM_STATUS         = 100501
ATTR.ATTR_SEM_VACUUM_EGUN           = 100502
ATTR.ATTR_SEM_VACUUM_CHAMBER        = 100503
ATTR.ATTR_SEM_VACUUM_MISC           = 100504
ATTR.ATTR_SEM_NAVICAM               = 100600
ATTR.ATTR_SEM_NAVICAM_STATUS        = 100601
ATTR.ATTR_SEM_WOBBLE                = 100700
ATTR.ATTR_SEM_DYNAMIC               = 100800
ATTR.ATTR_SEM_DYNAMIC_ENABLE        = 100801
ATTR.ATTR_SEM_DYNAMIC_FOCUS         = 100802
ATTR.ATTR_SEM_TILT_ENALBE           = 100803
ATTR.ATTR_SEM_TILT_CORRECTION       = 100804
ATTR.ATTR_SEM_END                   = 100805
ATTR.ATTR_GUI                       = 200000


