# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-06-28 09:08
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('wagtailcore', '0033_remove_golive_expiry_help_text'),
        ('wagtaillinkchecker', '0002_auto_20160209_1533'),
    ]

    operations = [
        migrations.CreateModel(
            name='Scan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('scan_finished', models.DateTimeField(blank=True, null=True)),
                ('scan_started', models.DateTimeField(auto_now_add=True)),
                ('site', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
            ],
        ),
        migrations.CreateModel(
            name='ScanLink',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField()),
                ('crawled', models.BooleanField(default=False)),
                ('invalid', models.BooleanField(default=False)),
                ('broken', models.BooleanField(default=False)),
                ('status_code', models.IntegerField(blank=True, null=True)),
                ('error_text', models.TextField(blank=True, null=True)),
                ('page_deleted', models.BooleanField(default=False)),
                ('page_slug', models.CharField(blank=True, max_length=128, null=True)),
                ('page', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='wagtailcore.Page')),
                ('scan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='links', to='wagtaillinkchecker.Scan')),
            ],
        ),
        migrations.AlterField(
            model_name='sitepreferences',
            name='automated_scanning',
            field=models.BooleanField(default=False, help_text='Conduct automated sitewide scans for broken links, and send emails if a problem is found.', verbose_name='Automated Scanning'),
        ),
        migrations.AlterUniqueTogether(
            name='scanlink',
            unique_together=set([('url', 'scan')]),
        ),
    ]
