# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'BuiltinRoleAssignmentRoleArgs',
    'ContactPointAlertmanagerArgs',
    'ContactPointDingdingArgs',
    'ContactPointDiscordArgs',
    'ContactPointEmailArgs',
    'ContactPointGooglechatArgs',
    'ContactPointKafkaArgs',
    'ContactPointOpsgenyArgs',
    'ContactPointPagerdutyArgs',
    'ContactPointPushoverArgs',
    'ContactPointSensugoArgs',
    'ContactPointSlackArgs',
    'ContactPointTeamArgs',
    'ContactPointTelegramArgs',
    'ContactPointThreemaArgs',
    'ContactPointVictoropArgs',
    'ContactPointWebhookArgs',
    'ContactPointWecomArgs',
    'DashboardPermissionPermissionArgs',
    'DataSourceJsonDataArgs',
    'DataSourceJsonDataDerivedFieldArgs',
    'DataSourcePermissionPermissionArgs',
    'DataSourceSecureJsonDataArgs',
    'FolderPermissionPermissionArgs',
    'MuteTimingIntervalArgs',
    'MuteTimingIntervalTimeArgs',
    'NotificationPolicyPolicyArgs',
    'NotificationPolicyPolicyMatcherArgs',
    'NotificationPolicyPolicyPolicyArgs',
    'NotificationPolicyPolicyPolicyMatcherArgs',
    'NotificationPolicyPolicyPolicyPolicyArgs',
    'NotificationPolicyPolicyPolicyPolicyMatcherArgs',
    'NotificationPolicyPolicyPolicyPolicyPolicyArgs',
    'NotificationPolicyPolicyPolicyPolicyPolicyMatcherArgs',
    'OncallIntegrationDefaultRouteArgs',
    'OncallIntegrationDefaultRouteMsteamsArgs',
    'OncallIntegrationDefaultRouteSlackArgs',
    'OncallIntegrationDefaultRouteTelegramArgs',
    'OncallIntegrationTemplatesArgs',
    'OncallIntegrationTemplatesSlackArgs',
    'OncallRouteMsteamsArgs',
    'OncallRouteSlackArgs',
    'OncallRouteTelegramArgs',
    'OncallScheduleSlackArgs',
    'PlaylistItemArgs',
    'ReportScheduleArgs',
    'ReportTimeRangeArgs',
    'RolePermissionArgs',
    'RuleGroupRuleArgs',
    'RuleGroupRuleDataArgs',
    'RuleGroupRuleDataRelativeTimeRangeArgs',
    'SyntheticMonitoringCheckSettingsArgs',
    'SyntheticMonitoringCheckSettingsDnsArgs',
    'SyntheticMonitoringCheckSettingsDnsValidateAdditionalRrArgs',
    'SyntheticMonitoringCheckSettingsDnsValidateAnswerRrsArgs',
    'SyntheticMonitoringCheckSettingsDnsValidateAuthorityRrsArgs',
    'SyntheticMonitoringCheckSettingsHttpArgs',
    'SyntheticMonitoringCheckSettingsHttpBasicAuthArgs',
    'SyntheticMonitoringCheckSettingsHttpFailIfHeaderMatchesRegexpArgs',
    'SyntheticMonitoringCheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs',
    'SyntheticMonitoringCheckSettingsHttpTlsConfigArgs',
    'SyntheticMonitoringCheckSettingsPingArgs',
    'SyntheticMonitoringCheckSettingsTcpArgs',
    'SyntheticMonitoringCheckSettingsTcpQueryResponseArgs',
    'SyntheticMonitoringCheckSettingsTcpTlsConfigArgs',
    'SyntheticMonitoringCheckSettingsTracerouteArgs',
]

@pulumi.input_type
class BuiltinRoleAssignmentRoleArgs:
    def __init__(__self__, *,
                 uid: pulumi.Input[str],
                 global_: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] uid: Unique identifier of the role to assign to `builtin_role`.
        :param pulumi.Input[bool] global_: States whether the assignment is available across all organizations or not. Defaults to `false`.
        """
        pulumi.set(__self__, "uid", uid)
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Input[str]:
        """
        Unique identifier of the role to assign to `builtin_role`.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: pulumi.Input[str]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="global")
    def global_(self) -> Optional[pulumi.Input[bool]]:
        """
        States whether the assignment is available across all organizations or not. Defaults to `false`.
        """
        return pulumi.get(self, "global_")

    @global_.setter
    def global_(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "global_", value)


@pulumi.input_type
class ContactPointAlertmanagerArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 basic_auth_password: Optional[pulumi.Input[str]] = None,
                 basic_auth_user: Optional[pulumi.Input[str]] = None,
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: The URL of the Alertmanager instance.
        :param pulumi.Input[str] basic_auth_password: The password component of the basic auth credentials to use.
        :param pulumi.Input[str] basic_auth_user: The username component of the basic auth credentials to use.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if basic_auth_password is not None:
            pulumi.set(__self__, "basic_auth_password", basic_auth_password)
        if basic_auth_user is not None:
            pulumi.set(__self__, "basic_auth_user", basic_auth_user)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL of the Alertmanager instance.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="basicAuthPassword")
    def basic_auth_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password component of the basic auth credentials to use.
        """
        return pulumi.get(self, "basic_auth_password")

    @basic_auth_password.setter
    def basic_auth_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basic_auth_password", value)

    @property
    @pulumi.getter(name="basicAuthUser")
    def basic_auth_user(self) -> Optional[pulumi.Input[str]]:
        """
        The username component of the basic auth credentials to use.
        """
        return pulumi.get(self, "basic_auth_user")

    @basic_auth_user.setter
    def basic_auth_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basic_auth_user", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointDingdingArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: The DingDing webhook URL.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] message: The templated content of the message.
        :param pulumi.Input[str] message_type: The format of message to send - either 'link' or 'actionCard'
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The DingDing webhook URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The templated content of the message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        The format of message to send - either 'link' or 'actionCard'
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointDiscordArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 avatar_url: Optional[pulumi.Input[str]] = None,
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 use_discord_username: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] url: The discord webhook URL.
        :param pulumi.Input[str] avatar_url: The URL of a custom avatar image to use. Defaults to ``.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] message: The templated content of the message. Defaults to ``.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] uid: The UID of the contact point.
        :param pulumi.Input[bool] use_discord_username: Whether to use the bot account's plain username instead of "Grafana." Defaults to `false`.
        """
        pulumi.set(__self__, "url", url)
        if avatar_url is not None:
            pulumi.set(__self__, "avatar_url", avatar_url)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if use_discord_username is not None:
            pulumi.set(__self__, "use_discord_username", use_discord_username)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The discord webhook URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of a custom avatar image to use. Defaults to ``.
        """
        return pulumi.get(self, "avatar_url")

    @avatar_url.setter
    def avatar_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar_url", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The templated content of the message. Defaults to ``.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="useDiscordUsername")
    def use_discord_username(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use the bot account's plain username instead of "Grafana." Defaults to `false`.
        """
        return pulumi.get(self, "use_discord_username")

    @use_discord_username.setter
    def use_discord_username(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_discord_username", value)


@pulumi.input_type
class ContactPointEmailArgs:
    def __init__(__self__, *,
                 addresses: pulumi.Input[Sequence[pulumi.Input[str]]],
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 single_email: Optional[pulumi.Input[bool]] = None,
                 subject: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: The addresses to send emails to.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] message: The templated content of the email. Defaults to ``.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[bool] single_email: Whether to send a single email CC'ing all addresses, rather than a separate email to each address. Defaults to `false`.
        :param pulumi.Input[str] subject: The templated subject line of the email. Defaults to ``.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "addresses", addresses)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if single_email is not None:
            pulumi.set(__self__, "single_email", single_email)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The addresses to send emails to.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The templated content of the email. Defaults to ``.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="singleEmail")
    def single_email(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to send a single email CC'ing all addresses, rather than a separate email to each address. Defaults to `false`.
        """
        return pulumi.get(self, "single_email")

    @single_email.setter
    def single_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_email", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[str]]:
        """
        The templated subject line of the email. Defaults to ``.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointGooglechatArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: The Google Chat webhook URL.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] message: The templated content of the message.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The Google Chat webhook URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The templated content of the message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointKafkaArgs:
    def __init__(__self__, *,
                 rest_proxy_url: pulumi.Input[str],
                 topic: pulumi.Input[str],
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] rest_proxy_url: The URL of the Kafka REST proxy to send requests to.
        :param pulumi.Input[str] topic: The name of the Kafka topic to publish to.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "rest_proxy_url", rest_proxy_url)
        pulumi.set(__self__, "topic", topic)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="restProxyUrl")
    def rest_proxy_url(self) -> pulumi.Input[str]:
        """
        The URL of the Kafka REST proxy to send requests to.
        """
        return pulumi.get(self, "rest_proxy_url")

    @rest_proxy_url.setter
    def rest_proxy_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "rest_proxy_url", value)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        The name of the Kafka topic to publish to.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointOpsgenyArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[str],
                 auto_close: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 override_priority: Optional[pulumi.Input[bool]] = None,
                 send_tags_as: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] api_key: The OpsGenie API key to use.
        :param pulumi.Input[bool] auto_close: Whether to auto-close alerts in OpsGenie when they resolve in the Alertmanager.
        :param pulumi.Input[str] description: A templated high-level description to use for the alert.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] message: The templated content of the message.
        :param pulumi.Input[bool] override_priority: Whether to allow the alert priority to be configured via the value of the `og_priority` annotation on the alert.
        :param pulumi.Input[str] send_tags_as: Whether to send annotations to OpsGenie as Tags, Details, or both. Supported values are `tags`, `details`, `both`, or empty to use the default behavior of Tags.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] uid: The UID of the contact point.
        :param pulumi.Input[str] url: Allows customization of the OpsGenie API URL.
        """
        pulumi.set(__self__, "api_key", api_key)
        if auto_close is not None:
            pulumi.set(__self__, "auto_close", auto_close)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if override_priority is not None:
            pulumi.set(__self__, "override_priority", override_priority)
        if send_tags_as is not None:
            pulumi.set(__self__, "send_tags_as", send_tags_as)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[str]:
        """
        The OpsGenie API key to use.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="autoClose")
    def auto_close(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to auto-close alerts in OpsGenie when they resolve in the Alertmanager.
        """
        return pulumi.get(self, "auto_close")

    @auto_close.setter
    def auto_close(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_close", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A templated high-level description to use for the alert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The templated content of the message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="overridePriority")
    def override_priority(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow the alert priority to be configured via the value of the `og_priority` annotation on the alert.
        """
        return pulumi.get(self, "override_priority")

    @override_priority.setter
    def override_priority(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "override_priority", value)

    @property
    @pulumi.getter(name="sendTagsAs")
    def send_tags_as(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to send annotations to OpsGenie as Tags, Details, or both. Supported values are `tags`, `details`, `both`, or empty to use the default behavior of Tags.
        """
        return pulumi.get(self, "send_tags_as")

    @send_tags_as.setter
    def send_tags_as(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "send_tags_as", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Allows customization of the OpsGenie API URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ContactPointPagerdutyArgs:
    def __init__(__self__, *,
                 integration_key: pulumi.Input[str],
                 class_: Optional[pulumi.Input[str]] = None,
                 component: Optional[pulumi.Input[str]] = None,
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 summary: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] integration_key: The PagerDuty API key.
        :param pulumi.Input[str] class_: The class or type of event, for example `ping failure`.
        :param pulumi.Input[str] component: The component being affected by the event.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] group: The group to which the provided component belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] severity: The PagerDuty event severity level. Default is `critical`.
        :param pulumi.Input[str] summary: The templated summary message of the event.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "integration_key", integration_key)
        if class_ is not None:
            pulumi.set(__self__, "class_", class_)
        if component is not None:
            pulumi.set(__self__, "component", component)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="integrationKey")
    def integration_key(self) -> pulumi.Input[str]:
        """
        The PagerDuty API key.
        """
        return pulumi.get(self, "integration_key")

    @integration_key.setter
    def integration_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "integration_key", value)

    @property
    @pulumi.getter(name="class")
    def class_(self) -> Optional[pulumi.Input[str]]:
        """
        The class or type of event, for example `ping failure`.
        """
        return pulumi.get(self, "class_")

    @class_.setter
    def class_(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "class_", value)

    @property
    @pulumi.getter
    def component(self) -> Optional[pulumi.Input[str]]:
        """
        The component being affected by the event.
        """
        return pulumi.get(self, "component")

    @component.setter
    def component(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        The group to which the provided component belongs to.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        The PagerDuty event severity level. Default is `critical`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[str]]:
        """
        The templated summary message of the event.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointPushoverArgs:
    def __init__(__self__, *,
                 api_token: pulumi.Input[str],
                 user_key: pulumi.Input[str],
                 device: Optional[pulumi.Input[str]] = None,
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 expire: Optional[pulumi.Input[int]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 ok_priority: Optional[pulumi.Input[int]] = None,
                 ok_sound: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 retry: Optional[pulumi.Input[int]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sound: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] api_token: The Pushover API token.
        :param pulumi.Input[str] user_key: The Pushover user key.
        :param pulumi.Input[str] device: Comma-separated list of devices to which the event is associated.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[int] expire: How many seconds for which the notification will continue to be retried by Pushover.
        :param pulumi.Input[str] message: The templated notification message content.
        :param pulumi.Input[int] ok_priority: The priority level of the resolved event.
        :param pulumi.Input[str] ok_sound: The sound associated with the resolved notification.
        :param pulumi.Input[int] priority: The priority level of the event.
        :param pulumi.Input[int] retry: How often, in seconds, the Pushover servers will send the same notification to the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] sound: The sound associated with the notification.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "api_token", api_token)
        pulumi.set(__self__, "user_key", user_key)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if expire is not None:
            pulumi.set(__self__, "expire", expire)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if ok_priority is not None:
            pulumi.set(__self__, "ok_priority", ok_priority)
        if ok_sound is not None:
            pulumi.set(__self__, "ok_sound", ok_sound)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if sound is not None:
            pulumi.set(__self__, "sound", sound)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> pulumi.Input[str]:
        """
        The Pushover API token.
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_token", value)

    @property
    @pulumi.getter(name="userKey")
    def user_key(self) -> pulumi.Input[str]:
        """
        The Pushover user key.
        """
        return pulumi.get(self, "user_key")

    @user_key.setter
    def user_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_key", value)

    @property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[str]]:
        """
        Comma-separated list of devices to which the event is associated.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def expire(self) -> Optional[pulumi.Input[int]]:
        """
        How many seconds for which the notification will continue to be retried by Pushover.
        """
        return pulumi.get(self, "expire")

    @expire.setter
    def expire(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expire", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The templated notification message content.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="okPriority")
    def ok_priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority level of the resolved event.
        """
        return pulumi.get(self, "ok_priority")

    @ok_priority.setter
    def ok_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ok_priority", value)

    @property
    @pulumi.getter(name="okSound")
    def ok_sound(self) -> Optional[pulumi.Input[str]]:
        """
        The sound associated with the resolved notification.
        """
        return pulumi.get(self, "ok_sound")

    @ok_sound.setter
    def ok_sound(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ok_sound", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority level of the event.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def retry(self) -> Optional[pulumi.Input[int]]:
        """
        How often, in seconds, the Pushover servers will send the same notification to the user.
        """
        return pulumi.get(self, "retry")

    @retry.setter
    def retry(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def sound(self) -> Optional[pulumi.Input[str]]:
        """
        The sound associated with the notification.
        """
        return pulumi.get(self, "sound")

    @sound.setter
    def sound(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sound", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointSensugoArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[str],
                 url: pulumi.Input[str],
                 check: Optional[pulumi.Input[str]] = None,
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 entity: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] api_key: The SensuGo API key.
        :param pulumi.Input[str] url: The SensuGo URL to send requests to.
        :param pulumi.Input[str] check: The SensuGo check to which the event should be routed.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] entity: The entity being monitored.
        :param pulumi.Input[str] handler: A custom handler to execute in addition to the check.
        :param pulumi.Input[str] message: Templated message content describing the alert.
        :param pulumi.Input[str] namespace: The namespace in which the check resides.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "url", url)
        if check is not None:
            pulumi.set(__self__, "check", check)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[str]:
        """
        The SensuGo API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The SensuGo URL to send requests to.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def check(self) -> Optional[pulumi.Input[str]]:
        """
        The SensuGo check to which the event should be routed.
        """
        return pulumi.get(self, "check")

    @check.setter
    def check(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "check", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input[str]]:
        """
        The entity being monitored.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[str]]:
        """
        A custom handler to execute in addition to the check.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Templated message content describing the alert.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace in which the check resides.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointSlackArgs:
    def __init__(__self__, *,
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 icon_emoji: Optional[pulumi.Input[str]] = None,
                 icon_url: Optional[pulumi.Input[str]] = None,
                 mention_channel: Optional[pulumi.Input[str]] = None,
                 mention_groups: Optional[pulumi.Input[str]] = None,
                 mention_users: Optional[pulumi.Input[str]] = None,
                 recipient: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 text: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] endpoint_url: Use this to override the Slack API endpoint URL to send requests to.
        :param pulumi.Input[str] icon_emoji: The name of a Slack workspace emoji to use as the bot icon.
        :param pulumi.Input[str] icon_url: A URL of an image to use as the bot icon.
        :param pulumi.Input[str] mention_channel: Describes how to ping the slack channel that messages are being sent to. Options are `here` for an @here ping, `channel` for @channel, or empty for no ping.
        :param pulumi.Input[str] mention_groups: Comma-separated list of groups to mention in the message.
        :param pulumi.Input[str] mention_users: Comma-separated list of users to mention in the message.
        :param pulumi.Input[str] recipient: Channel, private group, or IM channel (can be an encoded ID or a name) to send messages to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] text: Templated content of the message.
        :param pulumi.Input[str] title: Templated title of the message.
        :param pulumi.Input[str] token: A Slack API token,for sending messages directly without the webhook method.
        :param pulumi.Input[str] uid: The UID of the contact point.
        :param pulumi.Input[str] url: A Slack webhook URL,for sending messages via the webhook method.
        :param pulumi.Input[str] username: Username for the bot to use.
        """
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if icon_emoji is not None:
            pulumi.set(__self__, "icon_emoji", icon_emoji)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if mention_channel is not None:
            pulumi.set(__self__, "mention_channel", mention_channel)
        if mention_groups is not None:
            pulumi.set(__self__, "mention_groups", mention_groups)
        if mention_users is not None:
            pulumi.set(__self__, "mention_users", mention_users)
        if recipient is not None:
            pulumi.set(__self__, "recipient", recipient)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        Use this to override the Slack API endpoint URL to send requests to.
        """
        return pulumi.get(self, "endpoint_url")

    @endpoint_url.setter
    def endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_url", value)

    @property
    @pulumi.getter(name="iconEmoji")
    def icon_emoji(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a Slack workspace emoji to use as the bot icon.
        """
        return pulumi.get(self, "icon_emoji")

    @icon_emoji.setter
    def icon_emoji(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_emoji", value)

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[str]]:
        """
        A URL of an image to use as the bot icon.
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_url", value)

    @property
    @pulumi.getter(name="mentionChannel")
    def mention_channel(self) -> Optional[pulumi.Input[str]]:
        """
        Describes how to ping the slack channel that messages are being sent to. Options are `here` for an @here ping, `channel` for @channel, or empty for no ping.
        """
        return pulumi.get(self, "mention_channel")

    @mention_channel.setter
    def mention_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mention_channel", value)

    @property
    @pulumi.getter(name="mentionGroups")
    def mention_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Comma-separated list of groups to mention in the message.
        """
        return pulumi.get(self, "mention_groups")

    @mention_groups.setter
    def mention_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mention_groups", value)

    @property
    @pulumi.getter(name="mentionUsers")
    def mention_users(self) -> Optional[pulumi.Input[str]]:
        """
        Comma-separated list of users to mention in the message.
        """
        return pulumi.get(self, "mention_users")

    @mention_users.setter
    def mention_users(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mention_users", value)

    @property
    @pulumi.getter
    def recipient(self) -> Optional[pulumi.Input[str]]:
        """
        Channel, private group, or IM channel (can be an encoded ID or a name) to send messages to.
        """
        return pulumi.get(self, "recipient")

    @recipient.setter
    def recipient(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recipient", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        Templated content of the message.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Templated title of the message.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        A Slack API token,for sending messages directly without the webhook method.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        A Slack webhook URL,for sending messages via the webhook method.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username for the bot to use.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ContactPointTeamArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 section_title: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: A Teams webhook URL.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] message: The templated message content to send.
        :param pulumi.Input[str] section_title: The templated subtitle for each message section.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] title: The templated title of the message.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if section_title is not None:
            pulumi.set(__self__, "section_title", section_title)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        A Teams webhook URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The templated message content to send.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="sectionTitle")
    def section_title(self) -> Optional[pulumi.Input[str]]:
        """
        The templated subtitle for each message section.
        """
        return pulumi.get(self, "section_title")

    @section_title.setter
    def section_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "section_title", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The templated title of the message.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointTelegramArgs:
    def __init__(__self__, *,
                 chat_id: pulumi.Input[str],
                 token: pulumi.Input[str],
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] chat_id: The chat ID to send messages to.
        :param pulumi.Input[str] token: The Telegram bot token.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] message: The templated content of the message.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "chat_id", chat_id)
        pulumi.set(__self__, "token", token)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="chatId")
    def chat_id(self) -> pulumi.Input[str]:
        """
        The chat ID to send messages to.
        """
        return pulumi.get(self, "chat_id")

    @chat_id.setter
    def chat_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "chat_id", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The Telegram bot token.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The templated content of the message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointThreemaArgs:
    def __init__(__self__, *,
                 api_secret: pulumi.Input[str],
                 gateway_id: pulumi.Input[str],
                 recipient_id: pulumi.Input[str],
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] api_secret: The Threema API key.
        :param pulumi.Input[str] gateway_id: The Threema gateway ID.
        :param pulumi.Input[str] recipient_id: The ID of the recipient of the message.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "api_secret", api_secret)
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "recipient_id", recipient_id)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiSecret")
    def api_secret(self) -> pulumi.Input[str]:
        """
        The Threema API key.
        """
        return pulumi.get(self, "api_secret")

    @api_secret.setter
    def api_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_secret", value)

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Input[str]:
        """
        The Threema gateway ID.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway_id", value)

    @property
    @pulumi.getter(name="recipientId")
    def recipient_id(self) -> pulumi.Input[str]:
        """
        The ID of the recipient of the message.
        """
        return pulumi.get(self, "recipient_id")

    @recipient_id.setter
    def recipient_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "recipient_id", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointVictoropArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: The VictorOps webhook URL.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] message_type: The VictorOps alert state - typically either `CRITICAL` or `RECOVERY`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The VictorOps webhook URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        The VictorOps alert state - typically either `CRITICAL` or `RECOVERY`.
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointWebhookArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 authorization_credentials: Optional[pulumi.Input[str]] = None,
                 authorization_scheme: Optional[pulumi.Input[str]] = None,
                 basic_auth_password: Optional[pulumi.Input[str]] = None,
                 basic_auth_user: Optional[pulumi.Input[str]] = None,
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 http_method: Optional[pulumi.Input[str]] = None,
                 max_alerts: Optional[pulumi.Input[int]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: The URL to send webhook requests to.
        :param pulumi.Input[str] authorization_credentials: Allows a custom authorization scheme - attaches an auth header with this value. Do not use in conjunction with basic auth parameters.
        :param pulumi.Input[str] authorization_scheme: Allows a custom authorization scheme - attaches an auth header with this name. Do not use in conjunction with basic auth parameters.
        :param pulumi.Input[str] basic_auth_password: The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        :param pulumi.Input[str] basic_auth_user: The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] http_method: The HTTP method to use in the request. Defaults to `POST`.
        :param pulumi.Input[int] max_alerts: The maximum number of alerts to send in a single request. This can be helpful in limiting the size of the request body. The default is 0, which indicates no limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if authorization_credentials is not None:
            pulumi.set(__self__, "authorization_credentials", authorization_credentials)
        if authorization_scheme is not None:
            pulumi.set(__self__, "authorization_scheme", authorization_scheme)
        if basic_auth_password is not None:
            pulumi.set(__self__, "basic_auth_password", basic_auth_password)
        if basic_auth_user is not None:
            pulumi.set(__self__, "basic_auth_user", basic_auth_user)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if max_alerts is not None:
            pulumi.set(__self__, "max_alerts", max_alerts)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL to send webhook requests to.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="authorizationCredentials")
    def authorization_credentials(self) -> Optional[pulumi.Input[str]]:
        """
        Allows a custom authorization scheme - attaches an auth header with this value. Do not use in conjunction with basic auth parameters.
        """
        return pulumi.get(self, "authorization_credentials")

    @authorization_credentials.setter
    def authorization_credentials(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_credentials", value)

    @property
    @pulumi.getter(name="authorizationScheme")
    def authorization_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Allows a custom authorization scheme - attaches an auth header with this name. Do not use in conjunction with basic auth parameters.
        """
        return pulumi.get(self, "authorization_scheme")

    @authorization_scheme.setter
    def authorization_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_scheme", value)

    @property
    @pulumi.getter(name="basicAuthPassword")
    def basic_auth_password(self) -> Optional[pulumi.Input[str]]:
        """
        The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        """
        return pulumi.get(self, "basic_auth_password")

    @basic_auth_password.setter
    def basic_auth_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basic_auth_password", value)

    @property
    @pulumi.getter(name="basicAuthUser")
    def basic_auth_user(self) -> Optional[pulumi.Input[str]]:
        """
        The username to use in basic auth headers attached to the request. If omitted, basic auth will not be used.
        """
        return pulumi.get(self, "basic_auth_user")

    @basic_auth_user.setter
    def basic_auth_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basic_auth_user", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP method to use in the request. Defaults to `POST`.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter(name="maxAlerts")
    def max_alerts(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of alerts to send in a single request. This can be helpful in limiting the size of the request body. The default is 0, which indicates no limit.
        """
        return pulumi.get(self, "max_alerts")

    @max_alerts.setter
    def max_alerts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_alerts", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ContactPointWecomArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 disable_resolve_message: Optional[pulumi.Input[bool]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: The WeCom webhook URL.
        :param pulumi.Input[bool] disable_resolve_message: Whether to disable sending resolve messages. Defaults to `false`.
        :param pulumi.Input[str] message: The templated content of the message to send.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Additional custom properties to attach to the notifier. Defaults to `map[]`.
        :param pulumi.Input[str] title: The templated title of the message to send.
        :param pulumi.Input[str] uid: The UID of the contact point.
        """
        pulumi.set(__self__, "url", url)
        if disable_resolve_message is not None:
            pulumi.set(__self__, "disable_resolve_message", disable_resolve_message)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The WeCom webhook URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="disableResolveMessage")
    def disable_resolve_message(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable sending resolve messages. Defaults to `false`.
        """
        return pulumi.get(self, "disable_resolve_message")

    @disable_resolve_message.setter
    def disable_resolve_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_resolve_message", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The templated content of the message to send.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional custom properties to attach to the notifier. Defaults to `map[]`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The templated title of the message to send.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The UID of the contact point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class DashboardPermissionPermissionArgs:
    def __init__(__self__, *,
                 permission: pulumi.Input[str],
                 role: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] permission: Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        :param pulumi.Input[str] role: Manage permissions for `Viewer` or `Editor` roles.
        :param pulumi.Input[int] team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param pulumi.Input[int] user_id: ID of the user to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input[str]:
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[str]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Manage permissions for `Viewer` or `Editor` roles.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the user to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class DataSourceJsonDataArgs:
    def __init__(__self__, *,
                 assume_role_arn: Optional[pulumi.Input[str]] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 catalog: Optional[pulumi.Input[str]] = None,
                 client_email: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 conn_max_lifetime: Optional[pulumi.Input[int]] = None,
                 custom_metrics_namespaces: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 default_bucket: Optional[pulumi.Input[str]] = None,
                 default_project: Optional[pulumi.Input[str]] = None,
                 default_region: Optional[pulumi.Input[str]] = None,
                 derived_fields: Optional[pulumi.Input[Sequence[pulumi.Input['DataSourceJsonDataDerivedFieldArgs']]]] = None,
                 encrypt: Optional[pulumi.Input[str]] = None,
                 es_version: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 github_url: Optional[pulumi.Input[str]] = None,
                 graphite_version: Optional[pulumi.Input[str]] = None,
                 http_method: Optional[pulumi.Input[str]] = None,
                 implementation: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 log_level_field: Optional[pulumi.Input[str]] = None,
                 log_message_field: Optional[pulumi.Input[str]] = None,
                 manage_alerts: Optional[pulumi.Input[bool]] = None,
                 max_concurrent_shard_requests: Optional[pulumi.Input[int]] = None,
                 max_idle_conns: Optional[pulumi.Input[int]] = None,
                 max_lines: Optional[pulumi.Input[int]] = None,
                 max_open_conns: Optional[pulumi.Input[int]] = None,
                 org_slug: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 output_location: Optional[pulumi.Input[str]] = None,
                 postgres_version: Optional[pulumi.Input[int]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 query_timeout: Optional[pulumi.Input[str]] = None,
                 sigv4_assume_role_arn: Optional[pulumi.Input[str]] = None,
                 sigv4_auth: Optional[pulumi.Input[bool]] = None,
                 sigv4_auth_type: Optional[pulumi.Input[str]] = None,
                 sigv4_external_id: Optional[pulumi.Input[str]] = None,
                 sigv4_profile: Optional[pulumi.Input[str]] = None,
                 sigv4_region: Optional[pulumi.Input[str]] = None,
                 ssl_mode: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 time_field: Optional[pulumi.Input[str]] = None,
                 time_interval: Optional[pulumi.Input[str]] = None,
                 timescaledb: Optional[pulumi.Input[bool]] = None,
                 tls_auth: Optional[pulumi.Input[bool]] = None,
                 tls_auth_with_ca_cert: Optional[pulumi.Input[bool]] = None,
                 tls_configuration_method: Optional[pulumi.Input[str]] = None,
                 tls_skip_verify: Optional[pulumi.Input[bool]] = None,
                 token_uri: Optional[pulumi.Input[str]] = None,
                 tracing_datasource_uid: Optional[pulumi.Input[str]] = None,
                 tsdb_resolution: Optional[pulumi.Input[int]] = None,
                 tsdb_version: Optional[pulumi.Input[int]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 workgroup: Optional[pulumi.Input[str]] = None,
                 xpack_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] assume_role_arn: (CloudWatch, Athena) The ARN of the role to be assumed by Grafana when using the CloudWatch or Athena data source.
        :param pulumi.Input[str] auth_type: (CloudWatch, Athena) The authentication type used to access the data source.
        :param pulumi.Input[str] authentication_type: (Stackdriver) The authentication type: `jwt` or `gce`.
        :param pulumi.Input[str] catalog: (Athena) Athena catalog.
        :param pulumi.Input[str] client_email: (Stackdriver) Service account email address.
        :param pulumi.Input[str] client_id: (Azure Monitor) The service account client id.
        :param pulumi.Input[str] cloud_name: (Azure Monitor) The cloud name.
        :param pulumi.Input[int] conn_max_lifetime: (MySQL, PostgreSQL, and MSSQL) Maximum amount of time in seconds a connection may be reused (Grafana v5.4+).
        :param pulumi.Input[str] custom_metrics_namespaces: (CloudWatch) A comma-separated list of custom namespaces to be queried by the CloudWatch data source.
        :param pulumi.Input[str] database: (Athena) Name of the database within the catalog.
        :param pulumi.Input[str] default_bucket: (InfluxDB) The default bucket for the data source.
        :param pulumi.Input[str] default_project: (Stackdriver) The default project for the data source.
        :param pulumi.Input[str] default_region: (CloudWatch, Athena) The default region for the data source.
        :param pulumi.Input[Sequence[pulumi.Input['DataSourceJsonDataDerivedFieldArgs']]] derived_fields: (Loki) See https://grafana.com/docs/grafana/latest/datasources/loki/#derived-fields
        :param pulumi.Input[str] encrypt: (MSSQL) Connection SSL encryption handling: 'disable', 'false' or 'true'.
        :param pulumi.Input[str] es_version: (Elasticsearch) Elasticsearch semantic version (Grafana v8.0+).
        :param pulumi.Input[str] external_id: (CloudWatch, Athena) If you are assuming a role in another account, that has been created with an external ID, specify the external ID here.
        :param pulumi.Input[str] github_url: (Github) Github URL
        :param pulumi.Input[str] graphite_version: (Graphite) Graphite version.
        :param pulumi.Input[str] http_method: (Prometheus) HTTP method to use for making requests.
        :param pulumi.Input[str] implementation: (Alertmanager) Implementation of Alertmanager. Either 'cortex' or 'prometheus'
        :param pulumi.Input[str] interval: (Elasticsearch) Index date time format. nil(No Pattern), 'Hourly', 'Daily', 'Weekly', 'Monthly' or 'Yearly'.
        :param pulumi.Input[str] log_level_field: (Elasticsearch) Which field should be used to indicate the priority of the log message.
        :param pulumi.Input[str] log_message_field: (Elasticsearch) Which field should be used as the log message.
        :param pulumi.Input[bool] manage_alerts: (Prometheus) Manage alerts.
        :param pulumi.Input[int] max_concurrent_shard_requests: (Elasticsearch) Maximum number of concurrent shard requests.
        :param pulumi.Input[int] max_idle_conns: (MySQL, PostgreSQL and MSSQL) Maximum number of connections in the idle connection pool (Grafana v5.4+).
        :param pulumi.Input[int] max_lines: (Loki) Upper limit for the number of log lines returned by Loki
        :param pulumi.Input[int] max_open_conns: (MySQL, PostgreSQL and MSSQL) Maximum number of open connections to the database (Grafana v5.4+).
        :param pulumi.Input[str] org_slug: (Sentry) Organization slug.
        :param pulumi.Input[str] organization: (InfluxDB) An organization is a workspace for a group of users. All dashboards, tasks, buckets, members, etc., belong to an organization.
        :param pulumi.Input[str] output_location: (Athena) AWS S3 bucket to store execution outputs. If not specified, the default query result location from the Workgroup configuration will be used.
        :param pulumi.Input[int] postgres_version: (PostgreSQL) Postgres version as a number (903/904/905/906/1000) meaning v9.3, v9.4, etc.
        :param pulumi.Input[str] profile: (CloudWatch, Athena) The credentials profile name to use when authentication type is set as 'Credentials file'.
        :param pulumi.Input[str] query_timeout: (Prometheus) Timeout for queries made to the Prometheus data source in seconds.
        :param pulumi.Input[str] sigv4_assume_role_arn: (Elasticsearch and Prometheus) Specifies the ARN of an IAM role to assume.
        :param pulumi.Input[bool] sigv4_auth: (Elasticsearch and Prometheus) Enable usage of SigV4.
        :param pulumi.Input[str] sigv4_auth_type: (Elasticsearch and Prometheus) The Sigv4 authentication provider to use: 'default', 'credentials' or 'keys' (AMG: 'workspace-iam-role').
        :param pulumi.Input[str] sigv4_external_id: (Elasticsearch and Prometheus) When assuming a role in another account use this external ID.
        :param pulumi.Input[str] sigv4_profile: (Elasticsearch and Prometheus) Credentials profile name, leave blank for default.
        :param pulumi.Input[str] sigv4_region: (Elasticsearch and Prometheus) AWS region to use for Sigv4.
        :param pulumi.Input[str] ssl_mode: (PostgreSQL) SSLmode. 'disable', 'require', 'verify-ca' or 'verify-full'.
        :param pulumi.Input[str] subscription_id: (Azure Monitor) The subscription id
        :param pulumi.Input[str] tenant_id: (Azure Monitor) Service account tenant ID.
        :param pulumi.Input[str] time_field: (Elasticsearch) Which field that should be used as timestamp.
        :param pulumi.Input[str] time_interval: (Prometheus, Elasticsearch, InfluxDB, MySQL, PostgreSQL, and MSSQL) Lowest interval/step value that should be used for this data source. Sometimes called "Scrape Interval" in the Grafana UI.
        :param pulumi.Input[bool] timescaledb: (PostgreSQL) Enable usage of TimescaleDB extension.
        :param pulumi.Input[bool] tls_auth: (All) Enable TLS authentication using client cert configured in secure json data.
        :param pulumi.Input[bool] tls_auth_with_ca_cert: (All) Enable TLS authentication using CA cert.
        :param pulumi.Input[str] tls_configuration_method: (All) SSL Certificate configuration, either by ‘file-path’ or ‘file-content’.
        :param pulumi.Input[bool] tls_skip_verify: (All) Controls whether a client verifies the server’s certificate chain and host name.
        :param pulumi.Input[str] token_uri: (Stackdriver) The token URI used, provided in the service account key.
        :param pulumi.Input[str] tracing_datasource_uid: (Cloudwatch) The X-Ray datasource uid to associate to this Cloudwatch datasource.
        :param pulumi.Input[int] tsdb_resolution: (OpenTSDB) Resolution.
        :param pulumi.Input[int] tsdb_version: (OpenTSDB) Version.
        :param pulumi.Input[str] version: (InfluxDB) InfluxQL or Flux.
        :param pulumi.Input[str] workgroup: (Athena) Workgroup to use.
        :param pulumi.Input[bool] xpack_enabled: (Elasticsearch) Enable X-Pack support.
        """
        if assume_role_arn is not None:
            pulumi.set(__self__, "assume_role_arn", assume_role_arn)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if conn_max_lifetime is not None:
            pulumi.set(__self__, "conn_max_lifetime", conn_max_lifetime)
        if custom_metrics_namespaces is not None:
            pulumi.set(__self__, "custom_metrics_namespaces", custom_metrics_namespaces)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if default_bucket is not None:
            pulumi.set(__self__, "default_bucket", default_bucket)
        if default_project is not None:
            pulumi.set(__self__, "default_project", default_project)
        if default_region is not None:
            pulumi.set(__self__, "default_region", default_region)
        if derived_fields is not None:
            pulumi.set(__self__, "derived_fields", derived_fields)
        if encrypt is not None:
            pulumi.set(__self__, "encrypt", encrypt)
        if es_version is not None:
            pulumi.set(__self__, "es_version", es_version)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if github_url is not None:
            pulumi.set(__self__, "github_url", github_url)
        if graphite_version is not None:
            pulumi.set(__self__, "graphite_version", graphite_version)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if implementation is not None:
            pulumi.set(__self__, "implementation", implementation)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if log_level_field is not None:
            pulumi.set(__self__, "log_level_field", log_level_field)
        if log_message_field is not None:
            pulumi.set(__self__, "log_message_field", log_message_field)
        if manage_alerts is not None:
            pulumi.set(__self__, "manage_alerts", manage_alerts)
        if max_concurrent_shard_requests is not None:
            pulumi.set(__self__, "max_concurrent_shard_requests", max_concurrent_shard_requests)
        if max_idle_conns is not None:
            pulumi.set(__self__, "max_idle_conns", max_idle_conns)
        if max_lines is not None:
            pulumi.set(__self__, "max_lines", max_lines)
        if max_open_conns is not None:
            pulumi.set(__self__, "max_open_conns", max_open_conns)
        if org_slug is not None:
            pulumi.set(__self__, "org_slug", org_slug)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if postgres_version is not None:
            pulumi.set(__self__, "postgres_version", postgres_version)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if query_timeout is not None:
            pulumi.set(__self__, "query_timeout", query_timeout)
        if sigv4_assume_role_arn is not None:
            pulumi.set(__self__, "sigv4_assume_role_arn", sigv4_assume_role_arn)
        if sigv4_auth is not None:
            pulumi.set(__self__, "sigv4_auth", sigv4_auth)
        if sigv4_auth_type is not None:
            pulumi.set(__self__, "sigv4_auth_type", sigv4_auth_type)
        if sigv4_external_id is not None:
            pulumi.set(__self__, "sigv4_external_id", sigv4_external_id)
        if sigv4_profile is not None:
            pulumi.set(__self__, "sigv4_profile", sigv4_profile)
        if sigv4_region is not None:
            pulumi.set(__self__, "sigv4_region", sigv4_region)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_field is not None:
            pulumi.set(__self__, "time_field", time_field)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)
        if timescaledb is not None:
            pulumi.set(__self__, "timescaledb", timescaledb)
        if tls_auth is not None:
            pulumi.set(__self__, "tls_auth", tls_auth)
        if tls_auth_with_ca_cert is not None:
            pulumi.set(__self__, "tls_auth_with_ca_cert", tls_auth_with_ca_cert)
        if tls_configuration_method is not None:
            pulumi.set(__self__, "tls_configuration_method", tls_configuration_method)
        if tls_skip_verify is not None:
            pulumi.set(__self__, "tls_skip_verify", tls_skip_verify)
        if token_uri is not None:
            pulumi.set(__self__, "token_uri", token_uri)
        if tracing_datasource_uid is not None:
            pulumi.set(__self__, "tracing_datasource_uid", tracing_datasource_uid)
        if tsdb_resolution is not None:
            pulumi.set(__self__, "tsdb_resolution", tsdb_resolution)
        if tsdb_version is not None:
            pulumi.set(__self__, "tsdb_version", tsdb_version)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if workgroup is not None:
            pulumi.set(__self__, "workgroup", workgroup)
        if xpack_enabled is not None:
            pulumi.set(__self__, "xpack_enabled", xpack_enabled)

    @property
    @pulumi.getter(name="assumeRoleArn")
    def assume_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        (CloudWatch, Athena) The ARN of the role to be assumed by Grafana when using the CloudWatch or Athena data source.
        """
        return pulumi.get(self, "assume_role_arn")

    @assume_role_arn.setter
    def assume_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assume_role_arn", value)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        (CloudWatch, Athena) The authentication type used to access the data source.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Stackdriver) The authentication type: `jwt` or `gce`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[str]]:
        """
        (Athena) Athena catalog.
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[str]]:
        """
        (Stackdriver) Service account email address.
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_email", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Azure Monitor) The service account client id.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Azure Monitor) The cloud name.
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter(name="connMaxLifetime")
    def conn_max_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        (MySQL, PostgreSQL, and MSSQL) Maximum amount of time in seconds a connection may be reused (Grafana v5.4+).
        """
        return pulumi.get(self, "conn_max_lifetime")

    @conn_max_lifetime.setter
    def conn_max_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "conn_max_lifetime", value)

    @property
    @pulumi.getter(name="customMetricsNamespaces")
    def custom_metrics_namespaces(self) -> Optional[pulumi.Input[str]]:
        """
        (CloudWatch) A comma-separated list of custom namespaces to be queried by the CloudWatch data source.
        """
        return pulumi.get(self, "custom_metrics_namespaces")

    @custom_metrics_namespaces.setter
    def custom_metrics_namespaces(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_metrics_namespaces", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        (Athena) Name of the database within the catalog.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="defaultBucket")
    def default_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        (InfluxDB) The default bucket for the data source.
        """
        return pulumi.get(self, "default_bucket")

    @default_bucket.setter
    def default_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_bucket", value)

    @property
    @pulumi.getter(name="defaultProject")
    def default_project(self) -> Optional[pulumi.Input[str]]:
        """
        (Stackdriver) The default project for the data source.
        """
        return pulumi.get(self, "default_project")

    @default_project.setter
    def default_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_project", value)

    @property
    @pulumi.getter(name="defaultRegion")
    def default_region(self) -> Optional[pulumi.Input[str]]:
        """
        (CloudWatch, Athena) The default region for the data source.
        """
        return pulumi.get(self, "default_region")

    @default_region.setter
    def default_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_region", value)

    @property
    @pulumi.getter(name="derivedFields")
    def derived_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSourceJsonDataDerivedFieldArgs']]]]:
        """
        (Loki) See https://grafana.com/docs/grafana/latest/datasources/loki/#derived-fields
        """
        return pulumi.get(self, "derived_fields")

    @derived_fields.setter
    def derived_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSourceJsonDataDerivedFieldArgs']]]]):
        pulumi.set(self, "derived_fields", value)

    @property
    @pulumi.getter
    def encrypt(self) -> Optional[pulumi.Input[str]]:
        """
        (MSSQL) Connection SSL encryption handling: 'disable', 'false' or 'true'.
        """
        return pulumi.get(self, "encrypt")

    @encrypt.setter
    def encrypt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypt", value)

    @property
    @pulumi.getter(name="esVersion")
    def es_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch) Elasticsearch semantic version (Grafana v8.0+).
        """
        return pulumi.get(self, "es_version")

    @es_version.setter
    def es_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "es_version", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (CloudWatch, Athena) If you are assuming a role in another account, that has been created with an external ID, specify the external ID here.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="githubUrl")
    def github_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Github) Github URL
        """
        return pulumi.get(self, "github_url")

    @github_url.setter
    def github_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "github_url", value)

    @property
    @pulumi.getter(name="graphiteVersion")
    def graphite_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Graphite) Graphite version.
        """
        return pulumi.get(self, "graphite_version")

    @graphite_version.setter
    def graphite_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graphite_version", value)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[str]]:
        """
        (Prometheus) HTTP method to use for making requests.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter
    def implementation(self) -> Optional[pulumi.Input[str]]:
        """
        (Alertmanager) Implementation of Alertmanager. Either 'cortex' or 'prometheus'
        """
        return pulumi.get(self, "implementation")

    @implementation.setter
    def implementation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "implementation", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch) Index date time format. nil(No Pattern), 'Hourly', 'Daily', 'Weekly', 'Monthly' or 'Yearly'.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="logLevelField")
    def log_level_field(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch) Which field should be used to indicate the priority of the log message.
        """
        return pulumi.get(self, "log_level_field")

    @log_level_field.setter
    def log_level_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_level_field", value)

    @property
    @pulumi.getter(name="logMessageField")
    def log_message_field(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch) Which field should be used as the log message.
        """
        return pulumi.get(self, "log_message_field")

    @log_message_field.setter
    def log_message_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_message_field", value)

    @property
    @pulumi.getter(name="manageAlerts")
    def manage_alerts(self) -> Optional[pulumi.Input[bool]]:
        """
        (Prometheus) Manage alerts.
        """
        return pulumi.get(self, "manage_alerts")

    @manage_alerts.setter
    def manage_alerts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_alerts", value)

    @property
    @pulumi.getter(name="maxConcurrentShardRequests")
    def max_concurrent_shard_requests(self) -> Optional[pulumi.Input[int]]:
        """
        (Elasticsearch) Maximum number of concurrent shard requests.
        """
        return pulumi.get(self, "max_concurrent_shard_requests")

    @max_concurrent_shard_requests.setter
    def max_concurrent_shard_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_shard_requests", value)

    @property
    @pulumi.getter(name="maxIdleConns")
    def max_idle_conns(self) -> Optional[pulumi.Input[int]]:
        """
        (MySQL, PostgreSQL and MSSQL) Maximum number of connections in the idle connection pool (Grafana v5.4+).
        """
        return pulumi.get(self, "max_idle_conns")

    @max_idle_conns.setter
    def max_idle_conns(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_idle_conns", value)

    @property
    @pulumi.getter(name="maxLines")
    def max_lines(self) -> Optional[pulumi.Input[int]]:
        """
        (Loki) Upper limit for the number of log lines returned by Loki
        """
        return pulumi.get(self, "max_lines")

    @max_lines.setter
    def max_lines(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_lines", value)

    @property
    @pulumi.getter(name="maxOpenConns")
    def max_open_conns(self) -> Optional[pulumi.Input[int]]:
        """
        (MySQL, PostgreSQL and MSSQL) Maximum number of open connections to the database (Grafana v5.4+).
        """
        return pulumi.get(self, "max_open_conns")

    @max_open_conns.setter
    def max_open_conns(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_open_conns", value)

    @property
    @pulumi.getter(name="orgSlug")
    def org_slug(self) -> Optional[pulumi.Input[str]]:
        """
        (Sentry) Organization slug.
        """
        return pulumi.get(self, "org_slug")

    @org_slug.setter
    def org_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_slug", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        (InfluxDB) An organization is a workspace for a group of users. All dashboards, tasks, buckets, members, etc., belong to an organization.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input[str]]:
        """
        (Athena) AWS S3 bucket to store execution outputs. If not specified, the default query result location from the Workgroup configuration will be used.
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_location", value)

    @property
    @pulumi.getter(name="postgresVersion")
    def postgres_version(self) -> Optional[pulumi.Input[int]]:
        """
        (PostgreSQL) Postgres version as a number (903/904/905/906/1000) meaning v9.3, v9.4, etc.
        """
        return pulumi.get(self, "postgres_version")

    @postgres_version.setter
    def postgres_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "postgres_version", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        (CloudWatch, Athena) The credentials profile name to use when authentication type is set as 'Credentials file'.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="queryTimeout")
    def query_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        (Prometheus) Timeout for queries made to the Prometheus data source in seconds.
        """
        return pulumi.get(self, "query_timeout")

    @query_timeout.setter
    def query_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_timeout", value)

    @property
    @pulumi.getter(name="sigv4AssumeRoleArn")
    def sigv4_assume_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch and Prometheus) Specifies the ARN of an IAM role to assume.
        """
        return pulumi.get(self, "sigv4_assume_role_arn")

    @sigv4_assume_role_arn.setter
    def sigv4_assume_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sigv4_assume_role_arn", value)

    @property
    @pulumi.getter(name="sigv4Auth")
    def sigv4_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        (Elasticsearch and Prometheus) Enable usage of SigV4.
        """
        return pulumi.get(self, "sigv4_auth")

    @sigv4_auth.setter
    def sigv4_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sigv4_auth", value)

    @property
    @pulumi.getter(name="sigv4AuthType")
    def sigv4_auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch and Prometheus) The Sigv4 authentication provider to use: 'default', 'credentials' or 'keys' (AMG: 'workspace-iam-role').
        """
        return pulumi.get(self, "sigv4_auth_type")

    @sigv4_auth_type.setter
    def sigv4_auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sigv4_auth_type", value)

    @property
    @pulumi.getter(name="sigv4ExternalId")
    def sigv4_external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch and Prometheus) When assuming a role in another account use this external ID.
        """
        return pulumi.get(self, "sigv4_external_id")

    @sigv4_external_id.setter
    def sigv4_external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sigv4_external_id", value)

    @property
    @pulumi.getter(name="sigv4Profile")
    def sigv4_profile(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch and Prometheus) Credentials profile name, leave blank for default.
        """
        return pulumi.get(self, "sigv4_profile")

    @sigv4_profile.setter
    def sigv4_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sigv4_profile", value)

    @property
    @pulumi.getter(name="sigv4Region")
    def sigv4_region(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch and Prometheus) AWS region to use for Sigv4.
        """
        return pulumi.get(self, "sigv4_region")

    @sigv4_region.setter
    def sigv4_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sigv4_region", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (PostgreSQL) SSLmode. 'disable', 'require', 'verify-ca' or 'verify-full'.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Azure Monitor) The subscription id
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Azure Monitor) Service account tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="timeField")
    def time_field(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch) Which field that should be used as timestamp.
        """
        return pulumi.get(self, "time_field")

    @time_field.setter
    def time_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_field", value)

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[pulumi.Input[str]]:
        """
        (Prometheus, Elasticsearch, InfluxDB, MySQL, PostgreSQL, and MSSQL) Lowest interval/step value that should be used for this data source. Sometimes called "Scrape Interval" in the Grafana UI.
        """
        return pulumi.get(self, "time_interval")

    @time_interval.setter
    def time_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_interval", value)

    @property
    @pulumi.getter
    def timescaledb(self) -> Optional[pulumi.Input[bool]]:
        """
        (PostgreSQL) Enable usage of TimescaleDB extension.
        """
        return pulumi.get(self, "timescaledb")

    @timescaledb.setter
    def timescaledb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "timescaledb", value)

    @property
    @pulumi.getter(name="tlsAuth")
    def tls_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        (All) Enable TLS authentication using client cert configured in secure json data.
        """
        return pulumi.get(self, "tls_auth")

    @tls_auth.setter
    def tls_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls_auth", value)

    @property
    @pulumi.getter(name="tlsAuthWithCaCert")
    def tls_auth_with_ca_cert(self) -> Optional[pulumi.Input[bool]]:
        """
        (All) Enable TLS authentication using CA cert.
        """
        return pulumi.get(self, "tls_auth_with_ca_cert")

    @tls_auth_with_ca_cert.setter
    def tls_auth_with_ca_cert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls_auth_with_ca_cert", value)

    @property
    @pulumi.getter(name="tlsConfigurationMethod")
    def tls_configuration_method(self) -> Optional[pulumi.Input[str]]:
        """
        (All) SSL Certificate configuration, either by ‘file-path’ or ‘file-content’.
        """
        return pulumi.get(self, "tls_configuration_method")

    @tls_configuration_method.setter
    def tls_configuration_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_configuration_method", value)

    @property
    @pulumi.getter(name="tlsSkipVerify")
    def tls_skip_verify(self) -> Optional[pulumi.Input[bool]]:
        """
        (All) Controls whether a client verifies the server’s certificate chain and host name.
        """
        return pulumi.get(self, "tls_skip_verify")

    @tls_skip_verify.setter
    def tls_skip_verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls_skip_verify", value)

    @property
    @pulumi.getter(name="tokenUri")
    def token_uri(self) -> Optional[pulumi.Input[str]]:
        """
        (Stackdriver) The token URI used, provided in the service account key.
        """
        return pulumi.get(self, "token_uri")

    @token_uri.setter
    def token_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_uri", value)

    @property
    @pulumi.getter(name="tracingDatasourceUid")
    def tracing_datasource_uid(self) -> Optional[pulumi.Input[str]]:
        """
        (Cloudwatch) The X-Ray datasource uid to associate to this Cloudwatch datasource.
        """
        return pulumi.get(self, "tracing_datasource_uid")

    @tracing_datasource_uid.setter
    def tracing_datasource_uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracing_datasource_uid", value)

    @property
    @pulumi.getter(name="tsdbResolution")
    def tsdb_resolution(self) -> Optional[pulumi.Input[int]]:
        """
        (OpenTSDB) Resolution.
        """
        return pulumi.get(self, "tsdb_resolution")

    @tsdb_resolution.setter
    def tsdb_resolution(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tsdb_resolution", value)

    @property
    @pulumi.getter(name="tsdbVersion")
    def tsdb_version(self) -> Optional[pulumi.Input[int]]:
        """
        (OpenTSDB) Version.
        """
        return pulumi.get(self, "tsdb_version")

    @tsdb_version.setter
    def tsdb_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tsdb_version", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        (InfluxDB) InfluxQL or Flux.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def workgroup(self) -> Optional[pulumi.Input[str]]:
        """
        (Athena) Workgroup to use.
        """
        return pulumi.get(self, "workgroup")

    @workgroup.setter
    def workgroup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workgroup", value)

    @property
    @pulumi.getter(name="xpackEnabled")
    def xpack_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Elasticsearch) Enable X-Pack support.
        """
        return pulumi.get(self, "xpack_enabled")

    @xpack_enabled.setter
    def xpack_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "xpack_enabled", value)


@pulumi.input_type
class DataSourceJsonDataDerivedFieldArgs:
    def __init__(__self__, *,
                 datasource_uid: Optional[pulumi.Input[str]] = None,
                 matcher_regex: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: A unique name for the data source.
        :param pulumi.Input[str] url: The URL for the data source. The type of URL required varies depending on the chosen data source type.
        """
        if datasource_uid is not None:
            pulumi.set(__self__, "datasource_uid", datasource_uid)
        if matcher_regex is not None:
            pulumi.set(__self__, "matcher_regex", matcher_regex)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="datasourceUid")
    def datasource_uid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "datasource_uid")

    @datasource_uid.setter
    def datasource_uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datasource_uid", value)

    @property
    @pulumi.getter(name="matcherRegex")
    def matcher_regex(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "matcher_regex")

    @matcher_regex.setter
    def matcher_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "matcher_regex", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for the data source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL for the data source. The type of URL required varies depending on the chosen data source type.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class DataSourcePermissionPermissionArgs:
    def __init__(__self__, *,
                 permission: pulumi.Input[str],
                 team_id: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] permission: Permission to associate with item. Must be `Query`.
        :param pulumi.Input[int] team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param pulumi.Input[int] user_id: ID of the user to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input[str]:
        """
        Permission to associate with item. Must be `Query`.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[str]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the user to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class DataSourceSecureJsonDataArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[str]] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 basic_auth_password: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 sigv4_access_key: Optional[pulumi.Input[str]] = None,
                 sigv4_secret_key: Optional[pulumi.Input[str]] = None,
                 tls_ca_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] access_key: (CloudWatch, Athena) The access key used to access the data source.
        :param pulumi.Input[str] access_token: (Github) The access token used to access the data source.
        :param pulumi.Input[str] auth_token: (Sentry) Authorization token.
        :param pulumi.Input[str] basic_auth_password: (All) Password to use for basic authentication.
        :param pulumi.Input[str] client_secret: (Azure Monitor) Client secret for authentication.
        :param pulumi.Input[str] password: (All) Password to use for authentication.
        :param pulumi.Input[str] private_key: (Stackdriver) The service account key `private_key` to use to access the data source.
        :param pulumi.Input[str] secret_key: (CloudWatch, Athena) The secret key to use to access the data source.
        :param pulumi.Input[str] sigv4_access_key: (Elasticsearch and Prometheus) SigV4 access key. Required when using 'keys' auth provider.
        :param pulumi.Input[str] sigv4_secret_key: (Elasticsearch and Prometheus) SigV4 secret key. Required when using 'keys' auth provider.
        :param pulumi.Input[str] tls_ca_cert: (All) CA cert for out going requests.
        :param pulumi.Input[str] tls_client_cert: (All) TLS Client cert for outgoing requests.
        :param pulumi.Input[str] tls_client_key: (All) TLS Client key for outgoing requests.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if basic_auth_password is not None:
            pulumi.set(__self__, "basic_auth_password", basic_auth_password)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if sigv4_access_key is not None:
            pulumi.set(__self__, "sigv4_access_key", sigv4_access_key)
        if sigv4_secret_key is not None:
            pulumi.set(__self__, "sigv4_secret_key", sigv4_secret_key)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        (CloudWatch, Athena) The access key used to access the data source.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        (Github) The access token used to access the data source.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        """
        (Sentry) Authorization token.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="basicAuthPassword")
    def basic_auth_password(self) -> Optional[pulumi.Input[str]]:
        """
        (All) Password to use for basic authentication.
        """
        return pulumi.get(self, "basic_auth_password")

    @basic_auth_password.setter
    def basic_auth_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basic_auth_password", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        (Azure Monitor) Client secret for authentication.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        (All) Password to use for authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Stackdriver) The service account key `private_key` to use to access the data source.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        (CloudWatch, Athena) The secret key to use to access the data source.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="sigv4AccessKey")
    def sigv4_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch and Prometheus) SigV4 access key. Required when using 'keys' auth provider.
        """
        return pulumi.get(self, "sigv4_access_key")

    @sigv4_access_key.setter
    def sigv4_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sigv4_access_key", value)

    @property
    @pulumi.getter(name="sigv4SecretKey")
    def sigv4_secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Elasticsearch and Prometheus) SigV4 secret key. Required when using 'keys' auth provider.
        """
        return pulumi.get(self, "sigv4_secret_key")

    @sigv4_secret_key.setter
    def sigv4_secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sigv4_secret_key", value)

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        (All) CA cert for out going requests.
        """
        return pulumi.get(self, "tls_ca_cert")

    @tls_ca_cert.setter
    def tls_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ca_cert", value)

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        (All) TLS Client cert for outgoing requests.
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_cert", value)

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        (All) TLS Client key for outgoing requests.
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key", value)


@pulumi.input_type
class FolderPermissionPermissionArgs:
    def __init__(__self__, *,
                 permission: pulumi.Input[str],
                 role: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] permission: Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        :param pulumi.Input[str] role: Manage permissions for `Viewer` or `Editor` roles.
        :param pulumi.Input[int] team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param pulumi.Input[int] user_id: ID of the user to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input[str]:
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[str]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Manage permissions for `Viewer` or `Editor` roles.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the user to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class MuteTimingIntervalArgs:
    def __init__(__self__, *,
                 days_of_months: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 months: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 times: Optional[pulumi.Input[Sequence[pulumi.Input['MuteTimingIntervalTimeArgs']]]] = None,
                 weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 years: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] days_of_months: An inclusive range of days, 1-31, within a month, e.g. "1" or "14:16". Negative values can be used to represent days counting from the end of a month, e.g. "-1".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] months: An inclusive range of months, either numerical or full calendar month, e.g. "1:3", "december", or "may:august".
        :param pulumi.Input[Sequence[pulumi.Input['MuteTimingIntervalTimeArgs']]] times: The time ranges, represented in minutes, during which to mute in a given day.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] weekdays: An inclusive range of weekdays, e.g. "monday" or "tuesday:thursday".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] years: A positive inclusive range of years, e.g. "2030" or "2025:2026".
        """
        if days_of_months is not None:
            pulumi.set(__self__, "days_of_months", days_of_months)
        if months is not None:
            pulumi.set(__self__, "months", months)
        if times is not None:
            pulumi.set(__self__, "times", times)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter(name="daysOfMonths")
    def days_of_months(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An inclusive range of days, 1-31, within a month, e.g. "1" or "14:16". Negative values can be used to represent days counting from the end of a month, e.g. "-1".
        """
        return pulumi.get(self, "days_of_months")

    @days_of_months.setter
    def days_of_months(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "days_of_months", value)

    @property
    @pulumi.getter
    def months(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An inclusive range of months, either numerical or full calendar month, e.g. "1:3", "december", or "may:august".
        """
        return pulumi.get(self, "months")

    @months.setter
    def months(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "months", value)

    @property
    @pulumi.getter
    def times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MuteTimingIntervalTimeArgs']]]]:
        """
        The time ranges, represented in minutes, during which to mute in a given day.
        """
        return pulumi.get(self, "times")

    @times.setter
    def times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MuteTimingIntervalTimeArgs']]]]):
        pulumi.set(self, "times", value)

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An inclusive range of weekdays, e.g. "monday" or "tuesday:thursday".
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "weekdays", value)

    @property
    @pulumi.getter
    def years(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A positive inclusive range of years, e.g. "2030" or "2025:2026".
        """
        return pulumi.get(self, "years")

    @years.setter
    def years(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "years", value)


@pulumi.input_type
class MuteTimingIntervalTimeArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[str],
                 start: pulumi.Input[str]):
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[str]:
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[str]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class NotificationPolicyPolicyArgs:
    def __init__(__self__, *,
                 contact_point: pulumi.Input[str],
                 group_bies: pulumi.Input[Sequence[pulumi.Input[str]]],
                 continue_: Optional[pulumi.Input[bool]] = None,
                 group_interval: Optional[pulumi.Input[str]] = None,
                 group_wait: Optional[pulumi.Input[str]] = None,
                 matchers: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyMatcherArgs']]]] = None,
                 mute_timings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyArgs']]]] = None,
                 repeat_interval: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] contact_point: The contact point to route notifications that match this rule to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        :param pulumi.Input[bool] continue_: Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        :param pulumi.Input[str] group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param pulumi.Input[str] group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyMatcherArgs']]] matchers: Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mute_timings: A list of mute timing names to apply to alerts that match this policy.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyArgs']]] policies: Routing rules for specific label sets.
        :param pulumi.Input[str] repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        pulumi.set(__self__, "contact_point", contact_point)
        pulumi.set(__self__, "group_bies", group_bies)
        if continue_ is not None:
            pulumi.set(__self__, "continue_", continue_)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if matchers is not None:
            pulumi.set(__self__, "matchers", matchers)
        if mute_timings is not None:
            pulumi.set(__self__, "mute_timings", mute_timings)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> pulumi.Input[str]:
        """
        The contact point to route notifications that match this rule to.
        """
        return pulumi.get(self, "contact_point")

    @contact_point.setter
    def contact_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "contact_point", value)

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "group_bies", value)

    @property
    @pulumi.getter(name="continue")
    def continue_(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        """
        return pulumi.get(self, "continue_")

    @continue_.setter
    def continue_(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_", value)

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @group_interval.setter
    def group_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_interval", value)

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[pulumi.Input[str]]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @group_wait.setter
    def group_wait(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_wait", value)

    @property
    @pulumi.getter
    def matchers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyMatcherArgs']]]]:
        """
        Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        """
        return pulumi.get(self, "matchers")

    @matchers.setter
    def matchers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyMatcherArgs']]]]):
        pulumi.set(self, "matchers", value)

    @property
    @pulumi.getter(name="muteTimings")
    def mute_timings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of mute timing names to apply to alerts that match this policy.
        """
        return pulumi.get(self, "mute_timings")

    @mute_timings.setter
    def mute_timings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mute_timings", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyArgs']]]]:
        """
        Routing rules for specific label sets.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repeat_interval", value)


@pulumi.input_type
class NotificationPolicyPolicyMatcherArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 match: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input[str]:
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input[str]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NotificationPolicyPolicyPolicyArgs:
    def __init__(__self__, *,
                 contact_point: pulumi.Input[str],
                 group_bies: pulumi.Input[Sequence[pulumi.Input[str]]],
                 continue_: Optional[pulumi.Input[bool]] = None,
                 group_interval: Optional[pulumi.Input[str]] = None,
                 group_wait: Optional[pulumi.Input[str]] = None,
                 matchers: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyMatcherArgs']]]] = None,
                 mute_timings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyArgs']]]] = None,
                 repeat_interval: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] contact_point: The contact point to route notifications that match this rule to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        :param pulumi.Input[bool] continue_: Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        :param pulumi.Input[str] group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param pulumi.Input[str] group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyMatcherArgs']]] matchers: Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mute_timings: A list of mute timing names to apply to alerts that match this policy.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyArgs']]] policies: Routing rules for specific label sets.
        :param pulumi.Input[str] repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        pulumi.set(__self__, "contact_point", contact_point)
        pulumi.set(__self__, "group_bies", group_bies)
        if continue_ is not None:
            pulumi.set(__self__, "continue_", continue_)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if matchers is not None:
            pulumi.set(__self__, "matchers", matchers)
        if mute_timings is not None:
            pulumi.set(__self__, "mute_timings", mute_timings)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> pulumi.Input[str]:
        """
        The contact point to route notifications that match this rule to.
        """
        return pulumi.get(self, "contact_point")

    @contact_point.setter
    def contact_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "contact_point", value)

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "group_bies", value)

    @property
    @pulumi.getter(name="continue")
    def continue_(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        """
        return pulumi.get(self, "continue_")

    @continue_.setter
    def continue_(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_", value)

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @group_interval.setter
    def group_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_interval", value)

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[pulumi.Input[str]]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @group_wait.setter
    def group_wait(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_wait", value)

    @property
    @pulumi.getter
    def matchers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyMatcherArgs']]]]:
        """
        Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        """
        return pulumi.get(self, "matchers")

    @matchers.setter
    def matchers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyMatcherArgs']]]]):
        pulumi.set(self, "matchers", value)

    @property
    @pulumi.getter(name="muteTimings")
    def mute_timings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of mute timing names to apply to alerts that match this policy.
        """
        return pulumi.get(self, "mute_timings")

    @mute_timings.setter
    def mute_timings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mute_timings", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyArgs']]]]:
        """
        Routing rules for specific label sets.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repeat_interval", value)


@pulumi.input_type
class NotificationPolicyPolicyPolicyMatcherArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 match: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input[str]:
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input[str]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NotificationPolicyPolicyPolicyPolicyArgs:
    def __init__(__self__, *,
                 contact_point: pulumi.Input[str],
                 group_bies: pulumi.Input[Sequence[pulumi.Input[str]]],
                 continue_: Optional[pulumi.Input[bool]] = None,
                 group_interval: Optional[pulumi.Input[str]] = None,
                 group_wait: Optional[pulumi.Input[str]] = None,
                 matchers: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyMatcherArgs']]]] = None,
                 mute_timings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyPolicyArgs']]]] = None,
                 repeat_interval: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] contact_point: The contact point to route notifications that match this rule to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        :param pulumi.Input[bool] continue_: Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        :param pulumi.Input[str] group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param pulumi.Input[str] group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyMatcherArgs']]] matchers: Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mute_timings: A list of mute timing names to apply to alerts that match this policy.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyPolicyArgs']]] policies: Routing rules for specific label sets.
        :param pulumi.Input[str] repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        pulumi.set(__self__, "contact_point", contact_point)
        pulumi.set(__self__, "group_bies", group_bies)
        if continue_ is not None:
            pulumi.set(__self__, "continue_", continue_)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if matchers is not None:
            pulumi.set(__self__, "matchers", matchers)
        if mute_timings is not None:
            pulumi.set(__self__, "mute_timings", mute_timings)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> pulumi.Input[str]:
        """
        The contact point to route notifications that match this rule to.
        """
        return pulumi.get(self, "contact_point")

    @contact_point.setter
    def contact_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "contact_point", value)

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "group_bies", value)

    @property
    @pulumi.getter(name="continue")
    def continue_(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        """
        return pulumi.get(self, "continue_")

    @continue_.setter
    def continue_(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_", value)

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @group_interval.setter
    def group_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_interval", value)

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[pulumi.Input[str]]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @group_wait.setter
    def group_wait(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_wait", value)

    @property
    @pulumi.getter
    def matchers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyMatcherArgs']]]]:
        """
        Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        """
        return pulumi.get(self, "matchers")

    @matchers.setter
    def matchers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyMatcherArgs']]]]):
        pulumi.set(self, "matchers", value)

    @property
    @pulumi.getter(name="muteTimings")
    def mute_timings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of mute timing names to apply to alerts that match this policy.
        """
        return pulumi.get(self, "mute_timings")

    @mute_timings.setter
    def mute_timings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mute_timings", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyPolicyArgs']]]]:
        """
        Routing rules for specific label sets.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repeat_interval", value)


@pulumi.input_type
class NotificationPolicyPolicyPolicyPolicyMatcherArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 match: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input[str]:
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input[str]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NotificationPolicyPolicyPolicyPolicyPolicyArgs:
    def __init__(__self__, *,
                 contact_point: pulumi.Input[str],
                 group_bies: pulumi.Input[Sequence[pulumi.Input[str]]],
                 continue_: Optional[pulumi.Input[bool]] = None,
                 group_interval: Optional[pulumi.Input[str]] = None,
                 group_wait: Optional[pulumi.Input[str]] = None,
                 matchers: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyPolicyMatcherArgs']]]] = None,
                 mute_timings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 repeat_interval: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] contact_point: The contact point to route notifications that match this rule to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_bies: A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        :param pulumi.Input[bool] continue_: Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        :param pulumi.Input[str] group_interval: Minimum time interval between two notifications for the same group. Default is 5 minutes.
        :param pulumi.Input[str] group_wait: Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyPolicyMatcherArgs']]] matchers: Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mute_timings: A list of mute timing names to apply to alerts that match this policy.
        :param pulumi.Input[str] repeat_interval: Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        pulumi.set(__self__, "contact_point", contact_point)
        pulumi.set(__self__, "group_bies", group_bies)
        if continue_ is not None:
            pulumi.set(__self__, "continue_", continue_)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if matchers is not None:
            pulumi.set(__self__, "matchers", matchers)
        if mute_timings is not None:
            pulumi.set(__self__, "mute_timings", mute_timings)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @property
    @pulumi.getter(name="contactPoint")
    def contact_point(self) -> pulumi.Input[str]:
        """
        The contact point to route notifications that match this rule to.
        """
        return pulumi.get(self, "contact_point")

    @contact_point.setter
    def contact_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "contact_point", value)

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of alert labels to group alerts into notifications by. Use the special label `...` to group alerts by all labels, effectively disabling grouping.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "group_bies", value)

    @property
    @pulumi.getter(name="continue")
    def continue_(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to continue matching subsequent rules if an alert matches the current rule. Otherwise, the rule will be 'consumed' by the first policy to match it.
        """
        return pulumi.get(self, "continue_")

    @continue_.setter
    def continue_(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_", value)

    @property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum time interval between two notifications for the same group. Default is 5 minutes.
        """
        return pulumi.get(self, "group_interval")

    @group_interval.setter
    def group_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_interval", value)

    @property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[pulumi.Input[str]]:
        """
        Time to wait to buffer alerts of the same group before sending a notification. Default is 30 seconds.
        """
        return pulumi.get(self, "group_wait")

    @group_wait.setter
    def group_wait(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_wait", value)

    @property
    @pulumi.getter
    def matchers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyPolicyMatcherArgs']]]]:
        """
        Describes which labels this rule should match. When multiple matchers are supplied, an alert must match ALL matchers to be accepted by this policy. When no matchers are supplied, the rule will match all alert instances.
        """
        return pulumi.get(self, "matchers")

    @matchers.setter
    def matchers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationPolicyPolicyPolicyPolicyPolicyMatcherArgs']]]]):
        pulumi.set(self, "matchers", value)

    @property
    @pulumi.getter(name="muteTimings")
    def mute_timings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of mute timing names to apply to alerts that match this policy.
        """
        return pulumi.get(self, "mute_timings")

    @mute_timings.setter
    def mute_timings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mute_timings", value)

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum time interval for re-sending a notification if an alert is still firing. Default is 4 hours.
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repeat_interval", value)


@pulumi.input_type
class NotificationPolicyPolicyPolicyPolicyPolicyMatcherArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 match: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input[str]:
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input[str]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class OncallIntegrationDefaultRouteArgs:
    def __init__(__self__, *,
                 escalation_chain_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 msteams: Optional[pulumi.Input['OncallIntegrationDefaultRouteMsteamsArgs']] = None,
                 slack: Optional[pulumi.Input['OncallIntegrationDefaultRouteSlackArgs']] = None,
                 telegram: Optional[pulumi.Input['OncallIntegrationDefaultRouteTelegramArgs']] = None):
        """
        :param pulumi.Input[str] escalation_chain_id: The ID of the escalation chain.
        :param pulumi.Input[str] id: The ID of this resource.
        :param pulumi.Input['OncallIntegrationDefaultRouteMsteamsArgs'] msteams: MS teams-specific settings for a route.
        :param pulumi.Input['OncallIntegrationDefaultRouteSlackArgs'] slack: Slack-specific settings for a route.
        :param pulumi.Input['OncallIntegrationDefaultRouteTelegramArgs'] telegram: Telegram-specific settings for a route.
        """
        if escalation_chain_id is not None:
            pulumi.set(__self__, "escalation_chain_id", escalation_chain_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if msteams is not None:
            pulumi.set(__self__, "msteams", msteams)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if telegram is not None:
            pulumi.set(__self__, "telegram", telegram)

    @property
    @pulumi.getter(name="escalationChainId")
    def escalation_chain_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the escalation chain.
        """
        return pulumi.get(self, "escalation_chain_id")

    @escalation_chain_id.setter
    def escalation_chain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "escalation_chain_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def msteams(self) -> Optional[pulumi.Input['OncallIntegrationDefaultRouteMsteamsArgs']]:
        """
        MS teams-specific settings for a route.
        """
        return pulumi.get(self, "msteams")

    @msteams.setter
    def msteams(self, value: Optional[pulumi.Input['OncallIntegrationDefaultRouteMsteamsArgs']]):
        pulumi.set(self, "msteams", value)

    @property
    @pulumi.getter
    def slack(self) -> Optional[pulumi.Input['OncallIntegrationDefaultRouteSlackArgs']]:
        """
        Slack-specific settings for a route.
        """
        return pulumi.get(self, "slack")

    @slack.setter
    def slack(self, value: Optional[pulumi.Input['OncallIntegrationDefaultRouteSlackArgs']]):
        pulumi.set(self, "slack", value)

    @property
    @pulumi.getter
    def telegram(self) -> Optional[pulumi.Input['OncallIntegrationDefaultRouteTelegramArgs']]:
        """
        Telegram-specific settings for a route.
        """
        return pulumi.get(self, "telegram")

    @telegram.setter
    def telegram(self, value: Optional[pulumi.Input['OncallIntegrationDefaultRouteTelegramArgs']]):
        pulumi.set(self, "telegram", value)


@pulumi.input_type
class OncallIntegrationDefaultRouteMsteamsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The ID of this resource.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class OncallIntegrationDefaultRouteSlackArgs:
    def __init__(__self__, *,
                 channel_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class OncallIntegrationDefaultRouteTelegramArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The ID of this resource.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class OncallIntegrationTemplatesArgs:
    def __init__(__self__, *,
                 grouping_key: Optional[pulumi.Input[str]] = None,
                 resolve_signal: Optional[pulumi.Input[str]] = None,
                 slack: Optional[pulumi.Input['OncallIntegrationTemplatesSlackArgs']] = None):
        """
        :param pulumi.Input[str] grouping_key: Template for the key by which alerts are grouped.
        :param pulumi.Input[str] resolve_signal: Template for sending a signal to resolve the Incident.
        :param pulumi.Input['OncallIntegrationTemplatesSlackArgs'] slack: Templates for Slack.
        """
        if grouping_key is not None:
            pulumi.set(__self__, "grouping_key", grouping_key)
        if resolve_signal is not None:
            pulumi.set(__self__, "resolve_signal", resolve_signal)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)

    @property
    @pulumi.getter(name="groupingKey")
    def grouping_key(self) -> Optional[pulumi.Input[str]]:
        """
        Template for the key by which alerts are grouped.
        """
        return pulumi.get(self, "grouping_key")

    @grouping_key.setter
    def grouping_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grouping_key", value)

    @property
    @pulumi.getter(name="resolveSignal")
    def resolve_signal(self) -> Optional[pulumi.Input[str]]:
        """
        Template for sending a signal to resolve the Incident.
        """
        return pulumi.get(self, "resolve_signal")

    @resolve_signal.setter
    def resolve_signal(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolve_signal", value)

    @property
    @pulumi.getter
    def slack(self) -> Optional[pulumi.Input['OncallIntegrationTemplatesSlackArgs']]:
        """
        Templates for Slack.
        """
        return pulumi.get(self, "slack")

    @slack.setter
    def slack(self, value: Optional[pulumi.Input['OncallIntegrationTemplatesSlackArgs']]):
        pulumi.set(self, "slack", value)


@pulumi.input_type
class OncallIntegrationTemplatesSlackArgs:
    def __init__(__self__, *,
                 image_url: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class OncallRouteMsteamsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Enable notification in MS teams. Defaults to `true`.
        :param pulumi.Input[str] id: MS teams channel id. Alerts will be directed to this channel in Microsoft teams.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notification in MS teams. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        MS teams channel id. Alerts will be directed to this channel in Microsoft teams.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class OncallRouteSlackArgs:
    def __init__(__self__, *,
                 channel_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] channel_id: Slack channel id. Alerts will be directed to this channel in Slack.
        :param pulumi.Input[bool] enabled: Enable notification in Slack. Defaults to `true`.
        """
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[pulumi.Input[str]]:
        """
        Slack channel id. Alerts will be directed to this channel in Slack.
        """
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notification in Slack. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class OncallRouteTelegramArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Enable notification in Telegram. Defaults to `true`.
        :param pulumi.Input[str] id: Telegram channel id. Alerts will be directed to this channel in Telegram.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notification in Telegram. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Telegram channel id. Alerts will be directed to this channel in Telegram.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class OncallScheduleSlackArgs:
    def __init__(__self__, *,
                 channel_id: Optional[pulumi.Input[str]] = None,
                 user_group_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] channel_id: Slack channel id. Reminder about schedule shifts will be directed to this channel in Slack.
        :param pulumi.Input[str] user_group_id: Slack user group id. Members of user group will be updated when on-call users change.
        """
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if user_group_id is not None:
            pulumi.set(__self__, "user_group_id", user_group_id)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[pulumi.Input[str]]:
        """
        Slack channel id. Reminder about schedule shifts will be directed to this channel in Slack.
        """
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_id", value)

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Slack user group id. Members of user group will be updated when on-call users change.
        """
        return pulumi.get(self, "user_group_id")

    @user_group_id.setter
    def user_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_group_id", value)


@pulumi.input_type
class PlaylistItemArgs:
    def __init__(__self__, *,
                 order: pulumi.Input[int],
                 title: pulumi.Input[str],
                 id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The ID of this resource.
        """
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "title", title)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[int]:
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[int]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ReportScheduleArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input[str],
                 custom_interval: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 workdays_only: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] frequency: Frequency of the report. One of `never`, `once`, `hourly`, `daily`, `weekly`, `monthly` or `custom`.
        :param pulumi.Input[str] custom_interval: Custom interval of the report.
               **Note:** This field is only available when frequency is set to `custom`.
        :param pulumi.Input[str] end_time: End time of the report. If empty, the report will be sent indefinitely (according to frequency). Note that times will be saved as UTC in Grafana.
        :param pulumi.Input[str] start_time: Start time of the report. If empty, the start date will be set to the creation time. Note that times will be saved as UTC in Grafana.
        :param pulumi.Input[bool] workdays_only: Whether to send the report only on work days. Defaults to `false`.
        """
        pulumi.set(__self__, "frequency", frequency)
        if custom_interval is not None:
            pulumi.set(__self__, "custom_interval", custom_interval)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if workdays_only is not None:
            pulumi.set(__self__, "workdays_only", workdays_only)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[str]:
        """
        Frequency of the report. One of `never`, `once`, `hourly`, `daily`, `weekly`, `monthly` or `custom`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[str]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="customInterval")
    def custom_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Custom interval of the report.
        **Note:** This field is only available when frequency is set to `custom`.
        """
        return pulumi.get(self, "custom_interval")

    @custom_interval.setter
    def custom_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_interval", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        End time of the report. If empty, the report will be sent indefinitely (according to frequency). Note that times will be saved as UTC in Grafana.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Start time of the report. If empty, the start date will be set to the creation time. Note that times will be saved as UTC in Grafana.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="workdaysOnly")
    def workdays_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to send the report only on work days. Defaults to `false`.
        """
        return pulumi.get(self, "workdays_only")

    @workdays_only.setter
    def workdays_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "workdays_only", value)


@pulumi.input_type
class ReportTimeRangeArgs:
    def __init__(__self__, *,
                 from_: Optional[pulumi.Input[str]] = None,
                 to: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] from_: Start of the time range.
        :param pulumi.Input[str] to: End of the time range.
        """
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[pulumi.Input[str]]:
        """
        Start of the time range.
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter
    def to(self) -> Optional[pulumi.Input[str]]:
        """
        End of the time range.
        """
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "to", value)


@pulumi.input_type
class RolePermissionArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 scope: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: Specific action users granted with the role will be allowed to perform (for example: `users:read`)
        :param pulumi.Input[str] scope: Scope to restrict the action to a set of resources (for example: `users:*` or `roles:customrole1`)
        """
        pulumi.set(__self__, "action", action)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Specific action users granted with the role will be allowed to perform (for example: `users:read`)
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        Scope to restrict the action to a set of resources (for example: `users:*` or `roles:customrole1`)
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class RuleGroupRuleArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input[str],
                 datas: pulumi.Input[Sequence[pulumi.Input['RuleGroupRuleDataArgs']]],
                 name: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 exec_err_state: Optional[pulumi.Input[str]] = None,
                 for_: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 no_data_state: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] condition: The `ref_id` of the query node in the `data` field to use as the alert condition.
        :param pulumi.Input[Sequence[pulumi.Input['RuleGroupRuleDataArgs']]] datas: A sequence of stages that describe the contents of the rule.
        :param pulumi.Input[str] name: The name of the alert rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Key-value pairs of metadata to attach to the alert rule that may add user-defined context, but cannot be used for matching, grouping, or routing. Defaults to `map[]`.
        :param pulumi.Input[str] exec_err_state: Describes what state to enter when the rule's query is invalid and the rule cannot be executed. Options are OK, Error, and Alerting. Defaults to `Alerting`.
        :param pulumi.Input[str] for_: The amount of time for which the rule must be breached for the rule to be considered to be Firing. Before this time has elapsed, the rule is only considered to be Pending. Defaults to `0`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Key-value pairs to attach to the alert rule that can be used in matching, grouping, and routing. Defaults to `map[]`.
        :param pulumi.Input[str] no_data_state: Describes what state to enter when the rule's query returns No Data. Options are OK, NoData, and Alerting. Defaults to `NoData`.
        :param pulumi.Input[str] uid: The unique identifier of the alert rule.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "datas", datas)
        pulumi.set(__self__, "name", name)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if exec_err_state is not None:
            pulumi.set(__self__, "exec_err_state", exec_err_state)
        if for_ is not None:
            pulumi.set(__self__, "for_", for_)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if no_data_state is not None:
            pulumi.set(__self__, "no_data_state", no_data_state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input[str]:
        """
        The `ref_id` of the query node in the `data` field to use as the alert condition.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def datas(self) -> pulumi.Input[Sequence[pulumi.Input['RuleGroupRuleDataArgs']]]:
        """
        A sequence of stages that describe the contents of the rule.
        """
        return pulumi.get(self, "datas")

    @datas.setter
    def datas(self, value: pulumi.Input[Sequence[pulumi.Input['RuleGroupRuleDataArgs']]]):
        pulumi.set(self, "datas", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the alert rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value pairs of metadata to attach to the alert rule that may add user-defined context, but cannot be used for matching, grouping, or routing. Defaults to `map[]`.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="execErrState")
    def exec_err_state(self) -> Optional[pulumi.Input[str]]:
        """
        Describes what state to enter when the rule's query is invalid and the rule cannot be executed. Options are OK, Error, and Alerting. Defaults to `Alerting`.
        """
        return pulumi.get(self, "exec_err_state")

    @exec_err_state.setter
    def exec_err_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exec_err_state", value)

    @property
    @pulumi.getter(name="for")
    def for_(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time for which the rule must be breached for the rule to be considered to be Firing. Before this time has elapsed, the rule is only considered to be Pending. Defaults to `0`.
        """
        return pulumi.get(self, "for_")

    @for_.setter
    def for_(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "for_", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value pairs to attach to the alert rule that can be used in matching, grouping, and routing. Defaults to `map[]`.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="noDataState")
    def no_data_state(self) -> Optional[pulumi.Input[str]]:
        """
        Describes what state to enter when the rule's query returns No Data. Options are OK, NoData, and Alerting. Defaults to `NoData`.
        """
        return pulumi.get(self, "no_data_state")

    @no_data_state.setter
    def no_data_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "no_data_state", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the alert rule.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class RuleGroupRuleDataArgs:
    def __init__(__self__, *,
                 datasource_uid: pulumi.Input[str],
                 model: pulumi.Input[str],
                 ref_id: pulumi.Input[str],
                 relative_time_range: pulumi.Input['RuleGroupRuleDataRelativeTimeRangeArgs'],
                 query_type: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "datasource_uid", datasource_uid)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "ref_id", ref_id)
        pulumi.set(__self__, "relative_time_range", relative_time_range)
        if query_type is not None:
            pulumi.set(__self__, "query_type", query_type)

    @property
    @pulumi.getter(name="datasourceUid")
    def datasource_uid(self) -> pulumi.Input[str]:
        return pulumi.get(self, "datasource_uid")

    @datasource_uid.setter
    def datasource_uid(self, value: pulumi.Input[str]):
        pulumi.set(self, "datasource_uid", value)

    @property
    @pulumi.getter
    def model(self) -> pulumi.Input[str]:
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: pulumi.Input[str]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "ref_id")

    @ref_id.setter
    def ref_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ref_id", value)

    @property
    @pulumi.getter(name="relativeTimeRange")
    def relative_time_range(self) -> pulumi.Input['RuleGroupRuleDataRelativeTimeRangeArgs']:
        return pulumi.get(self, "relative_time_range")

    @relative_time_range.setter
    def relative_time_range(self, value: pulumi.Input['RuleGroupRuleDataRelativeTimeRangeArgs']):
        pulumi.set(self, "relative_time_range", value)

    @property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "query_type")

    @query_type.setter
    def query_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_type", value)


@pulumi.input_type
class RuleGroupRuleDataRelativeTimeRangeArgs:
    def __init__(__self__, *,
                 from_: pulumi.Input[int],
                 to: pulumi.Input[int]):
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> pulumi.Input[int]:
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: pulumi.Input[int]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter
    def to(self) -> pulumi.Input[int]:
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: pulumi.Input[int]):
        pulumi.set(self, "to", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsArgs:
    def __init__(__self__, *,
                 dns: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsDnsArgs']] = None,
                 http: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsHttpArgs']] = None,
                 ping: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsPingArgs']] = None,
                 tcp: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsTcpArgs']] = None,
                 traceroute: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsTracerouteArgs']] = None):
        """
        :param pulumi.Input['SyntheticMonitoringCheckSettingsDnsArgs'] dns: Settings for DNS check. The target must be a valid hostname (or IP address for `PTR` records).
        :param pulumi.Input['SyntheticMonitoringCheckSettingsHttpArgs'] http: Settings for HTTP check. The target must be a URL (http or https).
        :param pulumi.Input['SyntheticMonitoringCheckSettingsPingArgs'] ping: Settings for ping (ICMP) check. The target must be a valid hostname or IP address.
        :param pulumi.Input['SyntheticMonitoringCheckSettingsTcpArgs'] tcp: Settings for TCP check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        :param pulumi.Input['SyntheticMonitoringCheckSettingsTracerouteArgs'] traceroute: Settings for traceroute check. The target must be a valid hostname or IP address
        """
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if ping is not None:
            pulumi.set(__self__, "ping", ping)
        if tcp is not None:
            pulumi.set(__self__, "tcp", tcp)
        if traceroute is not None:
            pulumi.set(__self__, "traceroute", traceroute)

    @property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['SyntheticMonitoringCheckSettingsDnsArgs']]:
        """
        Settings for DNS check. The target must be a valid hostname (or IP address for `PTR` records).
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsDnsArgs']]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter
    def http(self) -> Optional[pulumi.Input['SyntheticMonitoringCheckSettingsHttpArgs']]:
        """
        Settings for HTTP check. The target must be a URL (http or https).
        """
        return pulumi.get(self, "http")

    @http.setter
    def http(self, value: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsHttpArgs']]):
        pulumi.set(self, "http", value)

    @property
    @pulumi.getter
    def ping(self) -> Optional[pulumi.Input['SyntheticMonitoringCheckSettingsPingArgs']]:
        """
        Settings for ping (ICMP) check. The target must be a valid hostname or IP address.
        """
        return pulumi.get(self, "ping")

    @ping.setter
    def ping(self, value: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsPingArgs']]):
        pulumi.set(self, "ping", value)

    @property
    @pulumi.getter
    def tcp(self) -> Optional[pulumi.Input['SyntheticMonitoringCheckSettingsTcpArgs']]:
        """
        Settings for TCP check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        """
        return pulumi.get(self, "tcp")

    @tcp.setter
    def tcp(self, value: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsTcpArgs']]):
        pulumi.set(self, "tcp", value)

    @property
    @pulumi.getter
    def traceroute(self) -> Optional[pulumi.Input['SyntheticMonitoringCheckSettingsTracerouteArgs']]:
        """
        Settings for traceroute check. The target must be a valid hostname or IP address
        """
        return pulumi.get(self, "traceroute")

    @traceroute.setter
    def traceroute(self, value: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsTracerouteArgs']]):
        pulumi.set(self, "traceroute", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsDnsArgs:
    def __init__(__self__, *,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 record_type: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 source_ip_address: Optional[pulumi.Input[str]] = None,
                 valid_r_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 validate_additional_rrs: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsDnsValidateAdditionalRrArgs']]]] = None,
                 validate_answer_rrs: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsDnsValidateAnswerRrsArgs']] = None,
                 validate_authority_rrs: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsDnsValidateAuthorityRrsArgs']] = None):
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if valid_r_codes is not None:
            pulumi.set(__self__, "valid_r_codes", valid_r_codes)
        if validate_additional_rrs is not None:
            pulumi.set(__self__, "validate_additional_rrs", validate_additional_rrs)
        if validate_answer_rrs is not None:
            pulumi.set(__self__, "validate_answer_rrs", validate_answer_rrs)
        if validate_authority_rrs is not None:
            pulumi.set(__self__, "validate_authority_rrs", validate_authority_rrs)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "record_type")

    @record_type.setter
    def record_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_type", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ip_address", value)

    @property
    @pulumi.getter(name="validRCodes")
    def valid_r_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "valid_r_codes")

    @valid_r_codes.setter
    def valid_r_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "valid_r_codes", value)

    @property
    @pulumi.getter(name="validateAdditionalRrs")
    def validate_additional_rrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsDnsValidateAdditionalRrArgs']]]]:
        return pulumi.get(self, "validate_additional_rrs")

    @validate_additional_rrs.setter
    def validate_additional_rrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsDnsValidateAdditionalRrArgs']]]]):
        pulumi.set(self, "validate_additional_rrs", value)

    @property
    @pulumi.getter(name="validateAnswerRrs")
    def validate_answer_rrs(self) -> Optional[pulumi.Input['SyntheticMonitoringCheckSettingsDnsValidateAnswerRrsArgs']]:
        return pulumi.get(self, "validate_answer_rrs")

    @validate_answer_rrs.setter
    def validate_answer_rrs(self, value: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsDnsValidateAnswerRrsArgs']]):
        pulumi.set(self, "validate_answer_rrs", value)

    @property
    @pulumi.getter(name="validateAuthorityRrs")
    def validate_authority_rrs(self) -> Optional[pulumi.Input['SyntheticMonitoringCheckSettingsDnsValidateAuthorityRrsArgs']]:
        return pulumi.get(self, "validate_authority_rrs")

    @validate_authority_rrs.setter
    def validate_authority_rrs(self, value: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsDnsValidateAuthorityRrsArgs']]):
        pulumi.set(self, "validate_authority_rrs", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsDnsValidateAdditionalRrArgs:
    def __init__(__self__, *,
                 fail_if_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 fail_if_not_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if fail_if_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_matches_regexps", fail_if_matches_regexps)
        if fail_if_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_not_matches_regexps", fail_if_not_matches_regexps)

    @property
    @pulumi.getter(name="failIfMatchesRegexps")
    def fail_if_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "fail_if_matches_regexps")

    @fail_if_matches_regexps.setter
    def fail_if_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fail_if_matches_regexps", value)

    @property
    @pulumi.getter(name="failIfNotMatchesRegexps")
    def fail_if_not_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "fail_if_not_matches_regexps")

    @fail_if_not_matches_regexps.setter
    def fail_if_not_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fail_if_not_matches_regexps", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsDnsValidateAnswerRrsArgs:
    def __init__(__self__, *,
                 fail_if_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 fail_if_not_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if fail_if_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_matches_regexps", fail_if_matches_regexps)
        if fail_if_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_not_matches_regexps", fail_if_not_matches_regexps)

    @property
    @pulumi.getter(name="failIfMatchesRegexps")
    def fail_if_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "fail_if_matches_regexps")

    @fail_if_matches_regexps.setter
    def fail_if_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fail_if_matches_regexps", value)

    @property
    @pulumi.getter(name="failIfNotMatchesRegexps")
    def fail_if_not_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "fail_if_not_matches_regexps")

    @fail_if_not_matches_regexps.setter
    def fail_if_not_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fail_if_not_matches_regexps", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsDnsValidateAuthorityRrsArgs:
    def __init__(__self__, *,
                 fail_if_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 fail_if_not_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if fail_if_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_matches_regexps", fail_if_matches_regexps)
        if fail_if_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_not_matches_regexps", fail_if_not_matches_regexps)

    @property
    @pulumi.getter(name="failIfMatchesRegexps")
    def fail_if_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "fail_if_matches_regexps")

    @fail_if_matches_regexps.setter
    def fail_if_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fail_if_matches_regexps", value)

    @property
    @pulumi.getter(name="failIfNotMatchesRegexps")
    def fail_if_not_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "fail_if_not_matches_regexps")

    @fail_if_not_matches_regexps.setter
    def fail_if_not_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fail_if_not_matches_regexps", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsHttpArgs:
    def __init__(__self__, *,
                 basic_auth: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsHttpBasicAuthArgs']] = None,
                 bearer_token: Optional[pulumi.Input[str]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 cache_busting_query_param_name: Optional[pulumi.Input[str]] = None,
                 fail_if_body_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 fail_if_body_not_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 fail_if_header_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsHttpFailIfHeaderMatchesRegexpArgs']]]] = None,
                 fail_if_header_not_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs']]]] = None,
                 fail_if_not_ssl: Optional[pulumi.Input[bool]] = None,
                 fail_if_ssl: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 no_follow_redirects: Optional[pulumi.Input[bool]] = None,
                 proxy_url: Optional[pulumi.Input[str]] = None,
                 tls_config: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsHttpTlsConfigArgs']] = None,
                 valid_http_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 valid_status_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if bearer_token is not None:
            pulumi.set(__self__, "bearer_token", bearer_token)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if cache_busting_query_param_name is not None:
            pulumi.set(__self__, "cache_busting_query_param_name", cache_busting_query_param_name)
        if fail_if_body_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_body_matches_regexps", fail_if_body_matches_regexps)
        if fail_if_body_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_body_not_matches_regexps", fail_if_body_not_matches_regexps)
        if fail_if_header_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_header_matches_regexps", fail_if_header_matches_regexps)
        if fail_if_header_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_header_not_matches_regexps", fail_if_header_not_matches_regexps)
        if fail_if_not_ssl is not None:
            pulumi.set(__self__, "fail_if_not_ssl", fail_if_not_ssl)
        if fail_if_ssl is not None:
            pulumi.set(__self__, "fail_if_ssl", fail_if_ssl)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if no_follow_redirects is not None:
            pulumi.set(__self__, "no_follow_redirects", no_follow_redirects)
        if proxy_url is not None:
            pulumi.set(__self__, "proxy_url", proxy_url)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)
        if valid_http_versions is not None:
            pulumi.set(__self__, "valid_http_versions", valid_http_versions)
        if valid_status_codes is not None:
            pulumi.set(__self__, "valid_status_codes", valid_status_codes)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional[pulumi.Input['SyntheticMonitoringCheckSettingsHttpBasicAuthArgs']]:
        return pulumi.get(self, "basic_auth")

    @basic_auth.setter
    def basic_auth(self, value: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsHttpBasicAuthArgs']]):
        pulumi.set(self, "basic_auth", value)

    @property
    @pulumi.getter(name="bearerToken")
    def bearer_token(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bearer_token")

    @bearer_token.setter
    def bearer_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bearer_token", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="cacheBustingQueryParamName")
    def cache_busting_query_param_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cache_busting_query_param_name")

    @cache_busting_query_param_name.setter
    def cache_busting_query_param_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_busting_query_param_name", value)

    @property
    @pulumi.getter(name="failIfBodyMatchesRegexps")
    def fail_if_body_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "fail_if_body_matches_regexps")

    @fail_if_body_matches_regexps.setter
    def fail_if_body_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fail_if_body_matches_regexps", value)

    @property
    @pulumi.getter(name="failIfBodyNotMatchesRegexps")
    def fail_if_body_not_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "fail_if_body_not_matches_regexps")

    @fail_if_body_not_matches_regexps.setter
    def fail_if_body_not_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fail_if_body_not_matches_regexps", value)

    @property
    @pulumi.getter(name="failIfHeaderMatchesRegexps")
    def fail_if_header_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsHttpFailIfHeaderMatchesRegexpArgs']]]]:
        return pulumi.get(self, "fail_if_header_matches_regexps")

    @fail_if_header_matches_regexps.setter
    def fail_if_header_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsHttpFailIfHeaderMatchesRegexpArgs']]]]):
        pulumi.set(self, "fail_if_header_matches_regexps", value)

    @property
    @pulumi.getter(name="failIfHeaderNotMatchesRegexps")
    def fail_if_header_not_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs']]]]:
        return pulumi.get(self, "fail_if_header_not_matches_regexps")

    @fail_if_header_not_matches_regexps.setter
    def fail_if_header_not_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs']]]]):
        pulumi.set(self, "fail_if_header_not_matches_regexps", value)

    @property
    @pulumi.getter(name="failIfNotSsl")
    def fail_if_not_ssl(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "fail_if_not_ssl")

    @fail_if_not_ssl.setter
    def fail_if_not_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fail_if_not_ssl", value)

    @property
    @pulumi.getter(name="failIfSsl")
    def fail_if_ssl(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "fail_if_ssl")

    @fail_if_ssl.setter
    def fail_if_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fail_if_ssl", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="noFollowRedirects")
    def no_follow_redirects(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "no_follow_redirects")

    @no_follow_redirects.setter
    def no_follow_redirects(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_follow_redirects", value)

    @property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "proxy_url")

    @proxy_url.setter
    def proxy_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_url", value)

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['SyntheticMonitoringCheckSettingsHttpTlsConfigArgs']]:
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsHttpTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)

    @property
    @pulumi.getter(name="validHttpVersions")
    def valid_http_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "valid_http_versions")

    @valid_http_versions.setter
    def valid_http_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "valid_http_versions", value)

    @property
    @pulumi.getter(name="validStatusCodes")
    def valid_status_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        return pulumi.get(self, "valid_status_codes")

    @valid_status_codes.setter
    def valid_status_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "valid_status_codes", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsHttpBasicAuthArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsHttpFailIfHeaderMatchesRegexpArgs:
    def __init__(__self__, *,
                 header: pulumi.Input[str],
                 regexp: pulumi.Input[str],
                 allow_missing: Optional[pulumi.Input[bool]] = None):
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "regexp", regexp)
        if allow_missing is not None:
            pulumi.set(__self__, "allow_missing", allow_missing)

    @property
    @pulumi.getter
    def header(self) -> pulumi.Input[str]:
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input[str]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter
    def regexp(self) -> pulumi.Input[str]:
        return pulumi.get(self, "regexp")

    @regexp.setter
    def regexp(self, value: pulumi.Input[str]):
        pulumi.set(self, "regexp", value)

    @property
    @pulumi.getter(name="allowMissing")
    def allow_missing(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_missing")

    @allow_missing.setter
    def allow_missing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_missing", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs:
    def __init__(__self__, *,
                 header: pulumi.Input[str],
                 regexp: pulumi.Input[str],
                 allow_missing: Optional[pulumi.Input[bool]] = None):
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "regexp", regexp)
        if allow_missing is not None:
            pulumi.set(__self__, "allow_missing", allow_missing)

    @property
    @pulumi.getter
    def header(self) -> pulumi.Input[str]:
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input[str]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter
    def regexp(self) -> pulumi.Input[str]:
        return pulumi.get(self, "regexp")

    @regexp.setter
    def regexp(self, value: pulumi.Input[str]):
        pulumi.set(self, "regexp", value)

    @property
    @pulumi.getter(name="allowMissing")
    def allow_missing(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_missing")

    @allow_missing.setter
    def allow_missing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_missing", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsHttpTlsConfigArgs:
    def __init__(__self__, *,
                 ca_cert: Optional[pulumi.Input[str]] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 insecure_skip_verify: Optional[pulumi.Input[bool]] = None,
                 server_name: Optional[pulumi.Input[str]] = None):
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert", value)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "insecure_skip_verify")

    @insecure_skip_verify.setter
    def insecure_skip_verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure_skip_verify", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsPingArgs:
    def __init__(__self__, *,
                 dont_fragment: Optional[pulumi.Input[bool]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 payload_size: Optional[pulumi.Input[int]] = None,
                 source_ip_address: Optional[pulumi.Input[str]] = None):
        if dont_fragment is not None:
            pulumi.set(__self__, "dont_fragment", dont_fragment)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if payload_size is not None:
            pulumi.set(__self__, "payload_size", payload_size)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)

    @property
    @pulumi.getter(name="dontFragment")
    def dont_fragment(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "dont_fragment")

    @dont_fragment.setter
    def dont_fragment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dont_fragment", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="payloadSize")
    def payload_size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "payload_size")

    @payload_size.setter
    def payload_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "payload_size", value)

    @property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ip_address", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsTcpArgs:
    def __init__(__self__, *,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 query_responses: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsTcpQueryResponseArgs']]]] = None,
                 source_ip_address: Optional[pulumi.Input[str]] = None,
                 tls: Optional[pulumi.Input[bool]] = None,
                 tls_config: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsTcpTlsConfigArgs']] = None):
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if query_responses is not None:
            pulumi.set(__self__, "query_responses", query_responses)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="queryResponses")
    def query_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsTcpQueryResponseArgs']]]]:
        return pulumi.get(self, "query_responses")

    @query_responses.setter
    def query_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticMonitoringCheckSettingsTcpQueryResponseArgs']]]]):
        pulumi.set(self, "query_responses", value)

    @property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ip_address", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls", value)

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['SyntheticMonitoringCheckSettingsTcpTlsConfigArgs']]:
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['SyntheticMonitoringCheckSettingsTcpTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsTcpQueryResponseArgs:
    def __init__(__self__, *,
                 expect: pulumi.Input[str],
                 send: pulumi.Input[str],
                 start_tls: Optional[pulumi.Input[bool]] = None):
        pulumi.set(__self__, "expect", expect)
        pulumi.set(__self__, "send", send)
        if start_tls is not None:
            pulumi.set(__self__, "start_tls", start_tls)

    @property
    @pulumi.getter
    def expect(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expect")

    @expect.setter
    def expect(self, value: pulumi.Input[str]):
        pulumi.set(self, "expect", value)

    @property
    @pulumi.getter
    def send(self) -> pulumi.Input[str]:
        return pulumi.get(self, "send")

    @send.setter
    def send(self, value: pulumi.Input[str]):
        pulumi.set(self, "send", value)

    @property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "start_tls")

    @start_tls.setter
    def start_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_tls", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsTcpTlsConfigArgs:
    def __init__(__self__, *,
                 ca_cert: Optional[pulumi.Input[str]] = None,
                 client_cert: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 insecure_skip_verify: Optional[pulumi.Input[bool]] = None,
                 server_name: Optional[pulumi.Input[str]] = None):
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert", value)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "insecure_skip_verify")

    @insecure_skip_verify.setter
    def insecure_skip_verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure_skip_verify", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)


@pulumi.input_type
class SyntheticMonitoringCheckSettingsTracerouteArgs:
    def __init__(__self__, *,
                 max_hops: Optional[pulumi.Input[int]] = None,
                 max_unknown_hops: Optional[pulumi.Input[int]] = None,
                 ptr_lookup: Optional[pulumi.Input[bool]] = None):
        if max_hops is not None:
            pulumi.set(__self__, "max_hops", max_hops)
        if max_unknown_hops is not None:
            pulumi.set(__self__, "max_unknown_hops", max_unknown_hops)
        if ptr_lookup is not None:
            pulumi.set(__self__, "ptr_lookup", ptr_lookup)

    @property
    @pulumi.getter(name="maxHops")
    def max_hops(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_hops")

    @max_hops.setter
    def max_hops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_hops", value)

    @property
    @pulumi.getter(name="maxUnknownHops")
    def max_unknown_hops(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_unknown_hops")

    @max_unknown_hops.setter
    def max_unknown_hops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_unknown_hops", value)

    @property
    @pulumi.getter(name="ptrLookup")
    def ptr_lookup(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "ptr_lookup")

    @ptr_lookup.setter
    def ptr_lookup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ptr_lookup", value)


