/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.wkaclass;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import uk.ac.wlv.wkaclass.Arff;
import uk.ac.wlv.wkaclass.PredictClass;
import uk.ac.wlv.wkaclass.Utilities;
import uk.ac.wlv.wkaclass.WekaCrossValidateInfoGain;
import uk.ac.wlv.wkaclass.WekaCrossValidateNoSelection;
import uk.ac.wlv.wkaclass.WekaDirectTrainClassifyEvaluate;

public class WekaMachineLearning {
    public static void main(String[] args) throws Exception {
        boolean[] bArgumentRecognised = new boolean[args.length];
        String arffTrainFile = "-";
        String arffEvalFile = "-";
        String classifierName = ",,all,";
        String classifierExclude = "none";
        String resultsFileName = "-";
        String addToClasspath = "";
        String summaryResultsFileName = "-";
        String instructionFilename = "-";
        WekaMachineLearning.overallHelp();
        int i = 0;
        while (i < args.length) {
            bArgumentRecognised[i] = false;
            ++i;
        }
        i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("arff")) {
                Arff arff = new Arff();
                arff.main(args);
                return;
            }
            if (args[i].equalsIgnoreCase("predict")) {
                PredictClass predictClass = new PredictClass();
                PredictClass.main(args);
                return;
            }
            if (args[i].equalsIgnoreCase("noselection")) {
                WekaCrossValidateNoSelection wekaCrossValidateNoSelection = new WekaCrossValidateNoSelection();
                WekaCrossValidateNoSelection.main(args);
                return;
            }
            if (args[i].equalsIgnoreCase("infogain")) {
                WekaCrossValidateInfoGain wekaCrossValidateInfoGain = new WekaCrossValidateInfoGain();
                WekaCrossValidateInfoGain.main(args);
                return;
            }
            if (args[i].equalsIgnoreCase("pre")) {
                bArgumentRecognised[i] = true;
            }
            if (i < args.length - 1) {
                if (args[i].equalsIgnoreCase("classifier")) {
                    classifierName = ",," + args[i + 1].toLowerCase() + ",";
                    bArgumentRecognised[i] = true;
                    bArgumentRecognised[i + 1] = true;
                }
                if (args[i].equalsIgnoreCase("exclude")) {
                    classifierExclude = args[i + 1];
                    bArgumentRecognised[i] = true;
                    bArgumentRecognised[i + 1] = true;
                }
                if (args[i].equalsIgnoreCase("instructions")) {
                    instructionFilename = args[i + 1];
                    bArgumentRecognised[i] = true;
                    bArgumentRecognised[i + 1] = true;
                }
                if (args[i].equalsIgnoreCase("arffTrain")) {
                    arffTrainFile = args[i + 1];
                    bArgumentRecognised[i] = true;
                    bArgumentRecognised[i + 1] = true;
                }
                if (args[i].equalsIgnoreCase("arffEval")) {
                    arffEvalFile = args[i + 1];
                    bArgumentRecognised[i] = true;
                    bArgumentRecognised[i + 1] = true;
                }
                if (args[i].equalsIgnoreCase("results")) {
                    resultsFileName = args[i + 1];
                    bArgumentRecognised[i] = true;
                    bArgumentRecognised[i + 1] = true;
                }
                if (args[i].equalsIgnoreCase("summary")) {
                    summaryResultsFileName = args[i + 1];
                    bArgumentRecognised[i] = true;
                    bArgumentRecognised[i + 1] = true;
                }
                if (args[i].equalsIgnoreCase("addToClasspath")) {
                    addToClasspath = args[i + 1];
                    Utilities.addToClassPath(addToClasspath);
                    bArgumentRecognised[i] = true;
                    bArgumentRecognised[i + 1] = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < args.length) {
            if (!bArgumentRecognised[i]) {
                System.out.println("Unrecognised command - wrong spelling or case?: " + args[i]);
                return;
            }
            ++i;
        }
        WekaMachineLearning.reportParameters(args, classifierName, classifierExclude, addToClasspath, instructionFilename, arffTrainFile, arffEvalFile, resultsFileName, summaryResultsFileName);
        if (instructionFilename.equals("-")) {
            if (arffTrainFile.equals("-") || arffEvalFile.equals("-") || resultsFileName.equals("-") || summaryResultsFileName.equals("-")) {
                System.out.println("Must specify instructions or arffTrain, arffEval, results, and summary. Giving up.");
                return;
            }
            System.out.println("started training with " + arffTrainFile);
            WekaDirectTrainClassifyEvaluate.directClassifyAllArff(arffTrainFile, arffEvalFile, classifierName, classifierExclude, resultsFileName, summaryResultsFileName);
        } else {
            File f = new File(instructionFilename);
            if (f.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(instructionFilename));
                while (reader.ready()) {
                    arffTrainFile = reader.readLine();
                    if (reader.ready()) {
                        arffEvalFile = reader.readLine();
                    }
                    if (reader.ready()) {
                        resultsFileName = reader.readLine();
                    }
                    if (!reader.ready() || (summaryResultsFileName = reader.readLine()).length() <= 4) continue;
                    System.out.println("started training with " + arffTrainFile);
                    WekaDirectTrainClassifyEvaluate.directClassifyAllArff(arffTrainFile, arffEvalFile, classifierName, classifierExclude, resultsFileName, summaryResultsFileName);
                }
                reader.close();
            } else {
                System.out.println(String.valueOf(instructionFilename) + " not found. Must contain train file/eval file/results file/summary file instead");
            }
        }
        System.out.println("WekaAutoMachineLearning Done");
    }

    public static void reportParameters(String[] args, String classifierName, String classifierExclude, String addToClasspath, String instructionFilename, String arffTrainFile, String arffEvalFile, String resultsFileName, String summaryResultsFileName) {
        System.out.println("Pre method defaults or set by command line:");
        System.out.println(" " + classifierName + " [classifier] ALL/SMO/SLOG/BAYES/ADA/SMOreg/JRIP/DEC/J48 /MLP/LibSVM/LibLin -last 3 not in ALL");
        System.out.println(" " + classifierExclude + " [exclude] SMO/SLOG/BAYES/ADA/SMOreg/JRIP/DEC/J48 classifier to exclude");
        System.out.println(" " + instructionFilename + " [instructions] file name (train., eval., results file triples list)");
        System.out.println(" " + arffTrainFile + " [arffTrain] file");
        System.out.println(" " + arffEvalFile + " [arffEval] file");
        System.out.println(" " + resultsFileName + " [results] file");
        System.out.println(" " + summaryResultsFileName + " [summary] results file (just accuracy)");
        System.out.println(" " + addToClasspath + " [addToClasspath] file to add to classpath");
    }

    public static void overallHelp() {
        System.out.println("Approaches available (via command name)");
        System.out.println("  [pre] (default) - input pre-calcuated folds and pre-selected features");
        System.out.println("                  e.g., 10-fold evaluation from SentiStrength");
        System.out.println("  [infogain] process raw single ARFF with feature selection, auto folds");
        System.out.println("   [min,max,step] number of features to check: from 100 to 1000 by 100");
        System.out.println("   [iterations] number of iterations of 10-fold cross-validation");
        System.out.println("   [input,results,summary] arff,text,text files");
        System.out.println("   [classifier,exclude] comma separated list of classifiers, one to exclude");
        System.out.println("    choose ALL or list from SMO/SLOG/BAYES/ADA/SMOreg/JRIP/DEC/J48");
        System.out.println("  [noselection] process raw single ARFF without feature selection, auto folds");
        System.out.println("  [arff] convert plain text to ARFF, with/wo ML prediction");
        System.out.println("");
    }
}

