/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.utilities;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import uk.ac.wlv.utilities.FileOps;
import uk.ac.wlv.utilities.Trie;

public class StringIndex {
    private int igTextMax = 10000000;
    public String[] sgText;
    public String[] sgTextComment;
    private int[] igTextLessPtr;
    private int[] igTextMorePtr;
    private int[] igTextCount;
    private int igTextLast = -1;
    private boolean bgIncludeCounts = false;

    public void initialise(int iVocabMaxIfOverrideDefault, boolean bIncludeCounts, boolean bIncludeComments) {
        int i;
        this.bgIncludeCounts = bIncludeCounts;
        if (iVocabMaxIfOverrideDefault > 0) {
            this.igTextMax = iVocabMaxIfOverrideDefault;
        }
        this.sgText = new String[this.igTextMax];
        this.igTextLessPtr = new int[this.igTextMax];
        this.igTextMorePtr = new int[this.igTextMax];
        this.igTextLast = -1;
        if (this.bgIncludeCounts) {
            this.igTextCount = new int[this.igTextMax];
            i = 0;
            while (i < this.igTextMax) {
                this.igTextCount[i] = 0;
                ++i;
            }
        }
        if (bIncludeComments) {
            this.sgTextComment = new String[this.igTextMax];
            i = 0;
            while (i < this.igTextMax) {
                this.igTextCount[i] = 0;
                ++i;
            }
        }
    }

    public boolean load(String sVocabTermPtrsCountFileName) {
        File f = new File(sVocabTermPtrsCountFileName);
        if (!f.exists()) {
            System.out.println("Could not find the vocab file: " + sVocabTermPtrsCountFileName);
            return false;
        }
        try {
            BufferedReader rReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sVocabTermPtrsCountFileName), "UTF8"));
            String sLine = rReader.readLine();
            String[] sData = sLine.split("\t");
            this.igTextLast = -1;
            while (rReader.ready()) {
                sLine = rReader.readLine();
                if (sLine.length() <= 0 || (sData = sLine.split("\t")).length <= 2) continue;
                if (this.igTextLast == this.igTextMax - 1) {
                    this.increaseArraySizes(this.igTextMax * 2);
                }
                this.sgText[++this.igTextLast] = sData[0];
                this.igTextLessPtr[this.igTextLast] = Integer.parseInt(sData[1]);
                this.igTextMorePtr[this.igTextLast] = Integer.parseInt(sData[2]);
                this.igTextCount[this.igTextLast] = Integer.parseInt(sData[3]);
            }
            rReader.close();
        }
        catch (IOException e) {
            System.out.println("Could not open file for reading or read from file: " + sVocabTermPtrsCountFileName);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int getLastWordID() {
        return this.igTextLast;
    }

    public boolean save(String sVocabTermPtrsCountFileName) {
        if (!FileOps.backupFileAndDeleteOriginal(sVocabTermPtrsCountFileName, 10)) {
            System.out.println("Could not backup vocab! Perhaps no index exists yet.");
        }
        try {
            BufferedWriter wWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sVocabTermPtrsCountFileName), "UTF8"));
            wWriter.write("Word\tLessPtr\tMorePtr\tAllTopics");
            int i = 0;
            while (i <= this.igTextLast) {
                wWriter.write(String.valueOf(this.sgText[i]) + "\t" + this.igTextLessPtr[i] + "\t" + this.igTextMorePtr[i] + "\t" + this.igTextCount[i] + "\n");
                ++i;
            }
            wWriter.close();
        }
        catch (IOException e) {
            System.out.println("Could not open file for writing or write to file: " + sVocabTermPtrsCountFileName);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int addString(String sText, boolean bRecordCount) {
        int iPos = -1;
        if (this.igTextLast == this.igTextMax - 1) {
            this.increaseArraySizes(this.igTextMax * 2);
        }
        if ((iPos = bRecordCount ? Trie.i_GetTriePositionForStringAndAddCount(sText, this.sgText, this.igTextCount, this.igTextLessPtr, this.igTextMorePtr, 0, this.igTextLast, false, 1) : Trie.i_GetTriePositionForString(sText, this.sgText, this.igTextLessPtr, this.igTextMorePtr, 0, this.igTextLast, false)) > this.igTextLast) {
            this.igTextLast = iPos;
        }
        return iPos;
    }

    public int findString(String sText) {
        return Trie.i_GetTriePositionForString(sText, this.sgText, this.igTextLessPtr, this.igTextMorePtr, 0, this.igTextLast, true);
    }

    public void add1ToCount(int iStringPos) {
        int n = iStringPos;
        this.igTextCount[n] = this.igTextCount[n] + 1;
    }

    private void increaseArraySizes(int iNewArraySize) {
        if (iNewArraySize <= this.igTextMax) {
            return;
        }
        String[] sgTextTemp = new String[iNewArraySize];
        int[] iTextLessPtrTemp = new int[iNewArraySize];
        int[] iTextMorePtrTemp = new int[iNewArraySize];
        System.arraycopy(this.sgText, 0, sgTextTemp, 0, this.igTextMax);
        System.arraycopy(this.igTextLessPtr, 0, iTextLessPtrTemp, 0, this.igTextMax);
        System.arraycopy(this.igTextMorePtr, 0, iTextMorePtrTemp, 0, this.igTextMax);
        if (this.bgIncludeCounts) {
            int[] iVocabCountTemp = new int[iNewArraySize];
            System.arraycopy(this.igTextCount, 0, iVocabCountTemp, 0, this.igTextMax);
            int i = this.igTextMax;
            while (i < iNewArraySize) {
                this.igTextCount[i] = 0;
                ++i;
            }
            this.igTextCount = iVocabCountTemp;
        }
        this.igTextMax = iNewArraySize;
        this.igTextLessPtr = iTextLessPtrTemp;
        this.igTextMorePtr = iTextMorePtrTemp;
    }

    private static String[] increaseArraySize(String[] sArray, int iCurrentArraySize, int iNewArraySize) {
        if (iNewArraySize <= iCurrentArraySize) {
            return sArray;
        }
        String[] sArrayTemp = new String[iNewArraySize];
        System.arraycopy(sArray, 0, sArrayTemp, 0, iCurrentArraySize);
        return sArrayTemp;
    }

    private static int[] increaseArraySize(int[] iArray, int iCurrentArraySize, int iNewArraySize) {
        if (iNewArraySize <= iCurrentArraySize) {
            return iArray;
        }
        int[] iArrayTemp = new int[iNewArraySize];
        System.arraycopy(iArray, 0, iArrayTemp, 0, iCurrentArraySize);
        return iArrayTemp;
    }

    public String getString(int iStringPos) {
        return this.sgText[iStringPos];
    }

    public String getComment(int iStringPos) {
        if (this.sgTextComment[iStringPos] == null) {
            return "";
        }
        return this.sgTextComment[iStringPos];
    }

    public void addComment(int iStringPos, String sComment) {
        this.sgTextComment[iStringPos] = sComment;
    }

    public int getCount(int iStringPos) {
        return this.igTextCount[iStringPos];
    }

    public void setCountToZero(int iStringPos) {
        this.igTextCount[iStringPos] = 0;
    }

    public void setAllCountsToZero() {
        int i = 0;
        while (i <= this.igTextLast) {
            this.igTextCount[i] = 0;
            ++i;
        }
    }
}

