/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class FileOps {
    public static boolean backupFileAndDeleteOriginal(String sFileName, int iMaxBackups) {
        File f;
        int iLastBackup = iMaxBackups;
        while (iLastBackup >= 0) {
            f = new File(String.valueOf(sFileName) + iLastBackup + ".bak");
            if (f.exists()) break;
            --iLastBackup;
        }
        if (iLastBackup < 1) {
            f = new File(sFileName);
            if (f.exists()) {
                f.renameTo(new File(String.valueOf(sFileName) + "1.bak"));
                return true;
            }
            return false;
        }
        if (iLastBackup == iMaxBackups) {
            f = new File(String.valueOf(sFileName) + iLastBackup + ".bak");
            f.delete();
            --iLastBackup;
        }
        int i = iLastBackup;
        while (i > 0) {
            f = new File(String.valueOf(sFileName) + i + ".bak");
            f.renameTo(new File(String.valueOf(sFileName) + (i + 1) + ".bak"));
            --i;
        }
        f = new File(sFileName);
        f.renameTo(new File(String.valueOf(sFileName) + "1.bak"));
        return true;
    }

    public static int i_CountLinesInTextFile(String sFileLocation) {
        int iLines = 0;
        try {
            BufferedReader rReader = new BufferedReader(new FileReader(sFileLocation));
            while (rReader.ready()) {
                String sLine = rReader.readLine();
                ++iLines;
            }
            rReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        return iLines;
    }

    public static String getNextAvailableFilename(String sFileNameStart, String sFileNameEnd) {
        int i = 0;
        while (i <= 1000) {
            String sFileName = String.valueOf(sFileNameStart) + i + sFileNameEnd;
            File f = new File(sFileName);
            if (!f.isFile()) {
                return sFileName;
            }
            ++i;
        }
        return "";
    }

    public static String s_ChopFileNameExtension(String sFilename) {
        int iLastDotPos;
        if (sFilename != null && sFilename != "" && (iLastDotPos = sFilename.lastIndexOf(".")) > 0) {
            sFilename = sFilename.substring(0, iLastDotPos);
        }
        return sFilename;
    }
}

