/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import uk.ac.wlv.utilities.Trie;

public class UnusedTermsClassificationIndex {
    private String[] sgTermList = null;
    private int igTermListCount = 0;
    private int igTermListMax = 10000000;
    private int[] igTermListLessPtr;
    private int[] igTermListMorePtr;
    private int[] igTermListFreq;
    private int[] igTermListFreqTemp;
    private int[] igTermListPosClassDiff;
    private int[] iTermsAddedIDTemp;
    private int[] igTermListNegClassDiff;
    private int[] igTermListScaleClassDiff;
    private int[] igTermListBinaryClassDiff;
    private int[] igTermListTrinaryClassDiff;
    private int iTermsAddedIDTempCount;
    private int[][] igTermListPosCorrectClass;
    private int[][] igTermListNegCorrectClass;
    private int[][] igTermListScaleCorrectClass;
    private int[][] igTermListBinaryCorrectClass;
    private int[][] igTermListTrinaryCorrectClass;

    public static void main(String[] args) {
    }

    public void addTermToNewTermIndex(String sTerm) {
        int iTermID;
        if (this.sgTermList == null) {
            this.initialise(true, true, true, true);
        }
        if (sTerm == "") {
            return;
        }
        boolean bDontAddMoreElements = false;
        if (this.igTermListCount == this.igTermListMax) {
            bDontAddMoreElements = true;
        }
        if ((iTermID = Trie.i_GetTriePositionForString(sTerm, this.sgTermList, this.igTermListLessPtr, this.igTermListMorePtr, 1, this.igTermListCount, bDontAddMoreElements)) > 0) {
            this.iTermsAddedIDTemp[++this.iTermsAddedIDTempCount] = iTermID;
            int n = iTermID;
            this.igTermListFreqTemp[n] = this.igTermListFreqTemp[n] + 1;
            if (iTermID > this.igTermListCount) {
                this.igTermListCount = iTermID;
            }
        }
    }

    public void addNewIndexToMainIndexWithPosNegValues(int iCorrectPosClass, int iEstPosClass, int iCorrectNegClass, int iEstNegClass) {
        if (iCorrectNegClass > 0 && iCorrectPosClass > 0) {
            int iTerm = 1;
            while (iTerm <= this.iTermsAddedIDTempCount) {
                int iTermID = this.iTermsAddedIDTemp[iTerm];
                if (this.igTermListFreqTemp[iTermID] != 0) {
                    try {
                        int[] nArray = this.igTermListNegCorrectClass[iTermID];
                        int n = iCorrectNegClass - 1;
                        nArray[n] = nArray[n] + 1;
                        int[] nArray2 = this.igTermListPosCorrectClass[iTermID];
                        int n2 = iCorrectPosClass - 1;
                        nArray2[n2] = nArray2[n2] + 1;
                        int n3 = iTermID;
                        this.igTermListPosClassDiff[n3] = this.igTermListPosClassDiff[n3] + (iCorrectPosClass - iEstPosClass);
                        int n4 = iTermID;
                        this.igTermListNegClassDiff[n4] = this.igTermListNegClassDiff[n4] + (iCorrectNegClass + iEstNegClass);
                        int n5 = iTermID;
                        this.igTermListFreq[n5] = this.igTermListFreq[n5] + 1;
                        this.iTermsAddedIDTemp[iTerm] = 0;
                    }
                    catch (Exception e) {
                        System.out.println("[UnusedTermsClassificationIndex] Error trying to add Pos + Neg to index. " + e.getMessage());
                    }
                }
                ++iTerm;
            }
        }
        this.iTermsAddedIDTempCount = 0;
    }

    public void addNewIndexToMainIndexWithScaleValues(int iCorrectScaleClass, int iEstScaleClass) {
        int iTerm = 1;
        while (iTerm <= this.iTermsAddedIDTempCount) {
            int iTermID = this.iTermsAddedIDTemp[iTerm];
            if (this.igTermListFreqTemp[iTermID] != 0) {
                try {
                    int[] nArray = this.igTermListScaleCorrectClass[iTermID];
                    int n = iCorrectScaleClass + 4;
                    nArray[n] = nArray[n] + 1;
                    int n2 = iTermID;
                    this.igTermListScaleClassDiff[n2] = this.igTermListScaleClassDiff[n2] + (iCorrectScaleClass - iEstScaleClass);
                    int n3 = iTermID;
                    this.igTermListFreq[n3] = this.igTermListFreq[n3] + 1;
                    this.iTermsAddedIDTemp[iTerm] = 0;
                }
                catch (Exception e) {
                    System.out.println("Error trying to add scale values to index. " + e.getMessage());
                }
            }
            ++iTerm;
        }
        this.iTermsAddedIDTempCount = 0;
    }

    public void addNewIndexToMainIndexWithTrinaryValues(int iCorrectTrinaryClass, int iEstTrinaryClass) {
        int iTerm = 1;
        while (iTerm <= this.iTermsAddedIDTempCount) {
            int iTermID = this.iTermsAddedIDTemp[iTerm];
            if (this.igTermListFreqTemp[iTermID] != 0) {
                try {
                    int[] nArray = this.igTermListTrinaryCorrectClass[iTermID];
                    int n = iCorrectTrinaryClass + 1;
                    nArray[n] = nArray[n] + 1;
                    int n2 = iTermID;
                    this.igTermListTrinaryClassDiff[n2] = this.igTermListTrinaryClassDiff[n2] + (iCorrectTrinaryClass - iEstTrinaryClass);
                    int n3 = iTermID;
                    this.igTermListFreq[n3] = this.igTermListFreq[n3] + 1;
                    this.iTermsAddedIDTemp[iTerm] = 0;
                }
                catch (Exception e) {
                    System.out.println("Error trying to add trinary values to index. " + e.getMessage());
                }
            }
            ++iTerm;
        }
        this.iTermsAddedIDTempCount = 0;
    }

    public void addNewIndexToMainIndexWithBinaryValues(int iCorrectBinaryClass, int iEstBinaryClass) {
        int iTerm = 1;
        while (iTerm <= this.iTermsAddedIDTempCount) {
            int iTermID = this.iTermsAddedIDTemp[iTerm];
            if (this.igTermListFreqTemp[iTermID] != 0) {
                try {
                    int n = iTermID;
                    this.igTermListBinaryClassDiff[n] = this.igTermListBinaryClassDiff[n] + (iCorrectBinaryClass - iEstBinaryClass);
                    if (iCorrectBinaryClass == -1) {
                        iCorrectBinaryClass = 0;
                    }
                    int[] nArray = this.igTermListBinaryCorrectClass[iTermID];
                    int n2 = iCorrectBinaryClass;
                    nArray[n2] = nArray[n2] + 1;
                    int n3 = iTermID;
                    this.igTermListFreq[n3] = this.igTermListFreq[n3] + 1;
                    this.iTermsAddedIDTemp[iTerm] = 0;
                }
                catch (Exception e) {
                    System.out.println("Error trying to add scale values to index. " + e.getMessage());
                }
            }
            ++iTerm;
        }
        this.iTermsAddedIDTempCount = 0;
    }

    public void initialise(boolean bInitialiseScale, boolean bInitialisePosNeg, boolean bInitialiseBinary, boolean bInitialiseTrinary) {
        this.igTermListCount = 0;
        this.iTermsAddedIDTempCount = 0;
        this.sgTermList = new String[this.igTermListMax];
        this.igTermListLessPtr = new int[this.igTermListMax + 1];
        this.igTermListMorePtr = new int[this.igTermListMax + 1];
        this.igTermListFreq = new int[this.igTermListMax + 1];
        this.igTermListFreqTemp = new int[this.igTermListMax + 1];
        this.iTermsAddedIDTemp = new int[this.igTermListMax + 1];
        if (bInitialisePosNeg) {
            this.igTermListNegCorrectClass = new int[this.igTermListMax + 1][5];
            this.igTermListPosCorrectClass = new int[this.igTermListMax + 1][5];
            this.igTermListNegClassDiff = new int[this.igTermListMax + 1];
            this.igTermListPosClassDiff = new int[this.igTermListMax + 1];
        }
        if (bInitialiseScale) {
            this.igTermListScaleCorrectClass = new int[this.igTermListMax + 1][9];
            this.igTermListScaleClassDiff = new int[this.igTermListMax + 1];
        }
        if (bInitialiseBinary) {
            this.igTermListBinaryCorrectClass = new int[this.igTermListMax + 1][2];
            this.igTermListBinaryClassDiff = new int[this.igTermListMax + 1];
        }
        if (bInitialiseTrinary) {
            this.igTermListTrinaryCorrectClass = new int[this.igTermListMax + 1][3];
            this.igTermListTrinaryClassDiff = new int[this.igTermListMax + 1];
        }
    }

    public void printIndexWithPosNegValues(String sOutputFile, int iMinFreq) {
        try {
            BufferedWriter wWriter = new BufferedWriter(new FileWriter(sOutputFile));
            wWriter.write("Term\tTermFreq >= " + iMinFreq + "\t" + "PosClassDiff (correct-estimate)\t" + "NegClassDiff\t" + "PosClassAvDiff\t" + "NegClassAvDiff\t");
            int i = 1;
            while (i <= 5) {
                wWriter.write("CorrectClass" + i + "pos\t");
                ++i;
            }
            i = 1;
            while (i <= 5) {
                wWriter.write("CorrectClass" + i + "neg\t");
                ++i;
            }
            wWriter.write("\n");
            if (this.igTermListCount > 0) {
                int iTerm = 1;
                while (iTerm <= this.igTermListCount) {
                    if (this.igTermListFreq[iTerm] >= iMinFreq) {
                        wWriter.write(String.valueOf(this.sgTermList[iTerm]) + "\t" + this.igTermListFreq[iTerm] + "\t" + this.igTermListPosClassDiff[iTerm] + "\t" + this.igTermListNegClassDiff[iTerm] + "\t" + (float)this.igTermListPosClassDiff[iTerm] / (float)this.igTermListFreq[iTerm] + "\t" + (float)this.igTermListNegClassDiff[iTerm] / (float)this.igTermListFreq[iTerm] + "\t");
                        int i2 = 0;
                        while (i2 < 5) {
                            wWriter.write(String.valueOf(this.igTermListPosCorrectClass[iTerm][i2]) + "\t");
                            ++i2;
                        }
                        i2 = 0;
                        while (i2 < 5) {
                            wWriter.write(String.valueOf(this.igTermListNegCorrectClass[iTerm][i2]) + "\t");
                            ++i2;
                        }
                        wWriter.write("\n");
                    }
                    ++iTerm;
                }
            } else {
                wWriter.write("No terms found in corpus!\n");
            }
            wWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error printing index to " + sOutputFile);
            e.printStackTrace();
        }
    }

    public void printIndexWithScaleValues(String sOutputFile, int iMinFreq) {
        try {
            BufferedWriter wWriter = new BufferedWriter(new FileWriter(sOutputFile));
            wWriter.write("Term\tTermFreq\tScaleClassDiff (correct-estimate)\tScaleClassAvDiff\t");
            int i = -4;
            while (i <= 4) {
                wWriter.write("CorrectClass" + i + "\t");
                ++i;
            }
            wWriter.write("\n");
            int iTerm = 1;
            while (iTerm <= this.igTermListCount) {
                if (this.igTermListFreq[iTerm] > iMinFreq) {
                    wWriter.write(String.valueOf(this.sgTermList[iTerm]) + "\t" + this.igTermListFreq[iTerm] + "\t" + this.igTermListScaleClassDiff[iTerm] + "\t" + (float)this.igTermListScaleClassDiff[iTerm] / (float)this.igTermListFreq[iTerm] + "\t");
                    int i2 = 0;
                    while (i2 < 9) {
                        wWriter.write(String.valueOf(this.igTermListScaleCorrectClass[iTerm][i2]) + "\t");
                        ++i2;
                    }
                    wWriter.write("\n");
                }
                ++iTerm;
            }
            wWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error printing Scale index to " + sOutputFile);
            e.printStackTrace();
        }
    }

    public void printIndexWithTrinaryValues(String sOutputFile, int iMinFreq) {
        try {
            BufferedWriter wWriter = new BufferedWriter(new FileWriter(sOutputFile));
            wWriter.write("Term\tTermFreq\tTrinaryClassDiff (correct-estimate)\tTrinaryClassAvDiff\t");
            int i = -1;
            while (i <= 1) {
                wWriter.write("CorrectClass" + i + "\t");
                ++i;
            }
            wWriter.write("\n");
            int iTerm = 1;
            while (iTerm <= this.igTermListCount) {
                if (this.igTermListFreq[iTerm] > iMinFreq) {
                    wWriter.write(String.valueOf(this.sgTermList[iTerm]) + "\t" + this.igTermListFreq[iTerm] + "\t" + this.igTermListTrinaryClassDiff[iTerm] + "\t" + (float)this.igTermListTrinaryClassDiff[iTerm] / (float)this.igTermListFreq[iTerm] + "\t");
                    int i2 = 0;
                    while (i2 < 3) {
                        wWriter.write(String.valueOf(this.igTermListTrinaryCorrectClass[iTerm][i2]) + "\t");
                        ++i2;
                    }
                    wWriter.write("\n");
                }
                ++iTerm;
            }
            wWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error printing Trinary index to " + sOutputFile);
            e.printStackTrace();
        }
    }

    public void printIndexWithBinaryValues(String sOutputFile, int iMinFreq) {
        try {
            BufferedWriter wWriter = new BufferedWriter(new FileWriter(sOutputFile));
            wWriter.write("Term\tTermFreq\tBinaryClassDiff (correct-estimate)\tBinaryClassAvDiff\t");
            wWriter.write("CorrectClass-1\tCorrectClass1\t");
            wWriter.write("\n");
            int iTerm = 1;
            while (iTerm <= this.igTermListCount) {
                if (this.igTermListFreq[iTerm] > iMinFreq) {
                    wWriter.write(String.valueOf(this.sgTermList[iTerm]) + "\t" + this.igTermListFreq[iTerm] + "\t" + this.igTermListBinaryClassDiff[iTerm] + "\t" + (float)this.igTermListBinaryClassDiff[iTerm] / (float)this.igTermListFreq[iTerm] + "\t");
                    int i = 0;
                    while (i < 2) {
                        wWriter.write(String.valueOf(this.igTermListBinaryCorrectClass[iTerm][i]) + "\t");
                        ++i;
                    }
                    wWriter.write("\n");
                }
                ++iTerm;
            }
            wWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error printing Binary index to " + sOutputFile);
            e.printStackTrace();
        }
    }
}

