/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.sentistrength.Corpus;
import uk.ac.wlv.utilities.FileOps;
import uk.ac.wlv.utilities.Sort;

public class SentimentWords {
    private String[] sgSentimentWords;
    private int[] igSentimentWordsStrengthTake1;
    private int igSentimentWordsCount = 0;
    private String[] sgSentimentWordsWithStarAtStart;
    private int[] igSentimentWordsWithStarAtStartStrengthTake1;
    private int igSentimentWordsWithStarAtStartCount = 0;
    private boolean[] bgSentimentWordsWithStarAtStartHasStarAtEnd;

    public String getSentimentWord(int iWordID) {
        if (iWordID > 0) {
            if (iWordID <= this.igSentimentWordsCount) {
                return this.sgSentimentWords[iWordID];
            }
            if (iWordID <= this.igSentimentWordsCount + this.igSentimentWordsWithStarAtStartCount) {
                return this.sgSentimentWordsWithStarAtStart[iWordID - this.igSentimentWordsCount];
            }
        }
        return "";
    }

    public int getSentiment(String sWord) {
        int iWordID = Sort.i_FindStringPositionInSortedArrayWithWildcardsInArray(sWord.toLowerCase(), this.sgSentimentWords, 1, this.igSentimentWordsCount);
        if (iWordID >= 0) {
            return this.igSentimentWordsStrengthTake1[iWordID];
        }
        int iStarWordID = this.getMatchingStarAtStartRawWordID(sWord);
        if (iStarWordID >= 0) {
            return this.igSentimentWordsWithStarAtStartStrengthTake1[iStarWordID];
        }
        return 999;
    }

    public boolean setSentiment(String sWord, int iNewSentiment) {
        int iWordID = Sort.i_FindStringPositionInSortedArrayWithWildcardsInArray(sWord.toLowerCase(), this.sgSentimentWords, 1, this.igSentimentWordsCount);
        if (iWordID >= 0) {
            if (iNewSentiment > 0) {
                this.setSentiment(iWordID, iNewSentiment - 1);
            } else {
                this.setSentiment(iWordID, iNewSentiment + 1);
            }
            return true;
        }
        if (sWord.indexOf("*") == 0 && (sWord = sWord.substring(1)).indexOf("*") > 0) {
            sWord.substring(0, sWord.length() - 1);
        }
        if (this.igSentimentWordsWithStarAtStartCount > 0) {
            int i = 1;
            while (i <= this.igSentimentWordsWithStarAtStartCount) {
                if (sWord == this.sgSentimentWordsWithStarAtStart[i]) {
                    if (iNewSentiment > 0) {
                        this.setSentiment(this.igSentimentWordsCount + i, iNewSentiment - 1);
                    } else {
                        this.setSentiment(this.igSentimentWordsCount + i, iNewSentiment + 1);
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean saveSentimentList(String sFilename, Corpus c) {
        try {
            String sOutput;
            int iSentimentStrength;
            BufferedWriter wWriter = new BufferedWriter(new FileWriter(sFilename));
            int i = 1;
            while (i <= this.igSentimentWordsCount) {
                iSentimentStrength = this.igSentimentWordsStrengthTake1[i];
                iSentimentStrength = iSentimentStrength < 0 ? --iSentimentStrength : ++iSentimentStrength;
                sOutput = String.valueOf(this.sgSentimentWords[i]) + "\t" + iSentimentStrength + "\n";
                if (c.options.bgForceUTF8) {
                    try {
                        sOutput = new String(sOutput.getBytes("UTF-8"), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        System.out.println("UTF-8 not found on your system!");
                        e.printStackTrace();
                    }
                }
                wWriter.write(sOutput);
                ++i;
            }
            i = 1;
            while (i <= this.igSentimentWordsWithStarAtStartCount) {
                iSentimentStrength = this.igSentimentWordsWithStarAtStartStrengthTake1[i];
                iSentimentStrength = iSentimentStrength < 0 ? --iSentimentStrength : ++iSentimentStrength;
                sOutput = "*" + this.sgSentimentWordsWithStarAtStart[i];
                if (this.bgSentimentWordsWithStarAtStartHasStarAtEnd[i]) {
                    sOutput = String.valueOf(sOutput) + "*";
                }
                sOutput = String.valueOf(sOutput) + "\t" + iSentimentStrength + "\n";
                if (c.options.bgForceUTF8) {
                    try {
                        sOutput = new String(sOutput.getBytes("UTF-8"), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        System.out.println("UTF-8 not found on your system!");
                        e.printStackTrace();
                    }
                }
                wWriter.write(sOutput);
                ++i;
            }
            wWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean printSentimentValuesInSingleRow(BufferedWriter wWriter) {
        try {
            int iSentimentStrength;
            int i = 1;
            while (i <= this.igSentimentWordsCount) {
                iSentimentStrength = this.igSentimentWordsStrengthTake1[i];
                wWriter.write("\t" + iSentimentStrength);
                ++i;
            }
            i = 1;
            while (i <= this.igSentimentWordsWithStarAtStartCount) {
                iSentimentStrength = this.igSentimentWordsWithStarAtStartStrengthTake1[i];
                wWriter.write("\t" + iSentimentStrength);
                ++i;
            }
            wWriter.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean printSentimentTermsInSingleHeaderRow(BufferedWriter wWriter) {
        try {
            int i = 1;
            while (i <= this.igSentimentWordsCount) {
                wWriter.write("\t" + this.sgSentimentWords[i]);
                ++i;
            }
            i = 1;
            while (i <= this.igSentimentWordsWithStarAtStartCount) {
                wWriter.write("\t*" + this.sgSentimentWordsWithStarAtStart[i]);
                if (this.bgSentimentWordsWithStarAtStartHasStarAtEnd[i]) {
                    wWriter.write("*");
                }
                ++i;
            }
            wWriter.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int getSentiment(int iWordID) {
        if (iWordID > 0) {
            if (iWordID <= this.igSentimentWordsCount) {
                return this.igSentimentWordsStrengthTake1[iWordID];
            }
            return this.igSentimentWordsWithStarAtStartStrengthTake1[iWordID - this.igSentimentWordsCount];
        }
        return 999;
    }

    public void setSentiment(int iWordID, int iNewSentiment) {
        if (iWordID <= this.igSentimentWordsCount) {
            this.igSentimentWordsStrengthTake1[iWordID] = iNewSentiment;
        } else {
            this.igSentimentWordsWithStarAtStartStrengthTake1[iWordID - this.igSentimentWordsCount] = iNewSentiment;
        }
    }

    public int getSentimentID(String sWord) {
        int iWordID = Sort.i_FindStringPositionInSortedArrayWithWildcardsInArray(sWord.toLowerCase(), this.sgSentimentWords, 1, this.igSentimentWordsCount);
        if (iWordID >= 0) {
            return iWordID;
        }
        iWordID = this.getMatchingStarAtStartRawWordID(sWord);
        if (iWordID >= 0) {
            return iWordID + this.igSentimentWordsCount;
        }
        return -1;
    }

    private int getMatchingStarAtStartRawWordID(String sWord) {
        int iSubStringPos = 0;
        if (this.igSentimentWordsWithStarAtStartCount > 0) {
            int i = 1;
            while (i <= this.igSentimentWordsWithStarAtStartCount) {
                iSubStringPos = sWord.indexOf(this.sgSentimentWordsWithStarAtStart[i]);
                if (iSubStringPos >= 0 && (this.bgSentimentWordsWithStarAtStartHasStarAtEnd[i] || iSubStringPos + this.sgSentimentWordsWithStarAtStart[i].length() == sWord.length())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getSentimentWordCount() {
        return this.igSentimentWordsCount;
    }

    public boolean initialise(String sFilename, ClassificationOptions options, int iExtraBlankArrayEntriesToInclude) {
        int iWordStrength = 0;
        int iWordsWithStarAtStart = 0;
        if (sFilename == "") {
            System.out.println("No sentiment file specified");
            return false;
        }
        File f = new File(sFilename);
        if (!f.exists()) {
            System.out.println("Could not find sentiment file: " + sFilename);
            return false;
        }
        int iLinesInFile = FileOps.i_CountLinesInTextFile(sFilename);
        if (iLinesInFile < 2) {
            System.out.println("Less than 2 lines in sentiment file: " + sFilename);
            return false;
        }
        this.igSentimentWordsStrengthTake1 = new int[iLinesInFile + 1 + iExtraBlankArrayEntriesToInclude];
        this.sgSentimentWords = new String[iLinesInFile + 1 + iExtraBlankArrayEntriesToInclude];
        this.igSentimentWordsCount = 0;
        try {
            String sLine;
            BufferedReader rReader = options.bgForceUTF8 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sFilename), "UTF8")) : new BufferedReader(new FileReader(sFilename));
            while ((sLine = rReader.readLine()) != null) {
                if (sLine == "") continue;
                if (sLine.indexOf("*") == 0) {
                    ++iWordsWithStarAtStart;
                    continue;
                }
                int iFirstTabLocation = sLine.indexOf("\t");
                if (iFirstTabLocation < 0) continue;
                int iSecondTabLocation = sLine.indexOf("\t", iFirstTabLocation + 1);
                try {
                    iWordStrength = iSecondTabLocation > 0 ? Integer.parseInt(sLine.substring(iFirstTabLocation + 1, iSecondTabLocation).trim()) : Integer.parseInt(sLine.substring(iFirstTabLocation + 1).trim());
                }
                catch (NumberFormatException e) {
                    System.out.println("Failed to identify integer weight for sentiment word! Ignoring word\nLine: " + sLine);
                    iWordStrength = 0;
                }
                sLine = sLine.substring(0, iFirstTabLocation);
                if (sLine.indexOf(" ") >= 0) {
                    sLine = sLine.trim();
                }
                if (sLine == "") continue;
                this.sgSentimentWords[++this.igSentimentWordsCount] = sLine;
                if (iWordStrength <= 0 && iWordStrength < 0) {
                    ++iWordStrength;
                }
                this.igSentimentWordsStrengthTake1[this.igSentimentWordsCount] = --iWordStrength;
            }
            rReader.close();
            Sort.quickSortStringsWithInt(this.sgSentimentWords, this.igSentimentWordsStrengthTake1, 1, this.igSentimentWordsCount);
        }
        catch (FileNotFoundException e) {
            System.out.println("Couldn't find sentiment file: " + sFilename);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Found sentiment file but couldn't read from it: " + sFilename);
            e.printStackTrace();
            return false;
        }
        if (iWordsWithStarAtStart > 0) {
            return this.initialiseWordsWithStarAtStart(sFilename, options, iWordsWithStarAtStart, iExtraBlankArrayEntriesToInclude);
        }
        return true;
    }

    public boolean initialiseWordsWithStarAtStart(String sFilename, ClassificationOptions options, int iWordsWithStarAtStart, int iExtraBlankArrayEntriesToInclude) {
        int iWordStrength = 0;
        File f = new File(sFilename);
        if (!f.exists()) {
            System.out.println("Could not find sentiment file: " + sFilename);
            return false;
        }
        this.igSentimentWordsWithStarAtStartStrengthTake1 = new int[iWordsWithStarAtStart + 1 + iExtraBlankArrayEntriesToInclude];
        this.sgSentimentWordsWithStarAtStart = new String[iWordsWithStarAtStart + 1 + iExtraBlankArrayEntriesToInclude];
        this.bgSentimentWordsWithStarAtStartHasStarAtEnd = new boolean[iWordsWithStarAtStart + 1 + iExtraBlankArrayEntriesToInclude];
        this.igSentimentWordsWithStarAtStartCount = 0;
        try {
            BufferedReader rReader = options.bgForceUTF8 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sFilename), "UTF8")) : new BufferedReader(new FileReader(sFilename));
            while (rReader.ready()) {
                int iFirstTabLocation;
                String sLine = rReader.readLine();
                if (sLine == "" || sLine.indexOf("*") != 0 || (iFirstTabLocation = sLine.indexOf("\t")) < 0) continue;
                int iSecondTabLocation = sLine.indexOf("\t", iFirstTabLocation + 1);
                try {
                    iWordStrength = iSecondTabLocation > 0 ? Integer.parseInt(sLine.substring(iFirstTabLocation + 1, iSecondTabLocation)) : Integer.parseInt(sLine.substring(iFirstTabLocation + 1));
                }
                catch (NumberFormatException e) {
                    System.out.println("Failed to identify integer weight for *sentiment* word! Ignoring word\nLine: " + sLine);
                    iWordStrength = 0;
                }
                sLine = sLine.substring(1, iFirstTabLocation);
                if (sLine.indexOf("*") > 0) {
                    sLine = sLine.substring(0, sLine.indexOf("*"));
                    this.bgSentimentWordsWithStarAtStartHasStarAtEnd[++this.igSentimentWordsWithStarAtStartCount] = true;
                } else {
                    this.bgSentimentWordsWithStarAtStartHasStarAtEnd[++this.igSentimentWordsWithStarAtStartCount] = false;
                }
                if (sLine.indexOf(" ") >= 0) {
                    sLine = sLine.trim();
                }
                if (sLine != "") {
                    this.sgSentimentWordsWithStarAtStart[this.igSentimentWordsWithStarAtStartCount] = sLine;
                    if (iWordStrength <= 0 && iWordStrength < 0) {
                        ++iWordStrength;
                    }
                    this.igSentimentWordsWithStarAtStartStrengthTake1[this.igSentimentWordsWithStarAtStartCount] = --iWordStrength;
                    continue;
                }
                --this.igSentimentWordsWithStarAtStartCount;
            }
            rReader.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Couldn't find *sentiment file*: " + sFilename);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Found *sentiment file* but couldn't read from it: " + sFilename);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean addOrModifySentimentTerm(String sTerm, int iTermStrength, boolean bSortSentimentListAfterAddingTerm) {
        int iTermPosition = this.getSentimentID(sTerm);
        if (iTermPosition > 0) {
            if (iTermStrength <= 0 && iTermStrength < 0) {
                ++iTermStrength;
            }
            this.igSentimentWordsStrengthTake1[iTermPosition] = --iTermStrength;
        } else {
            try {
                this.sgSentimentWords[++this.igSentimentWordsCount] = sTerm;
                if (iTermStrength <= 0 && iTermStrength < 0) {
                    ++iTermStrength;
                }
                this.igSentimentWordsStrengthTake1[this.igSentimentWordsCount] = --iTermStrength;
                if (bSortSentimentListAfterAddingTerm) {
                    Sort.quickSortStringsWithInt(this.sgSentimentWords, this.igSentimentWordsStrengthTake1, 1, this.igSentimentWordsCount);
                }
            }
            catch (Exception e) {
                System.out.println("Could not add extra sentiment term: " + sTerm);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void sortSentimentList() {
        Sort.quickSortStringsWithInt(this.sgSentimentWords, this.igSentimentWordsStrengthTake1, 1, this.igSentimentWordsCount);
    }
}

