/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.sentistrength.ClassificationResources;
import uk.ac.wlv.sentistrength.Term;
import uk.ac.wlv.sentistrength.TextParsingOptions;
import uk.ac.wlv.sentistrength.UnusedTermsClassificationIndex;
import uk.ac.wlv.utilities.Sort;
import uk.ac.wlv.utilities.StringIndex;
import uk.ac.wlv.wkaclass.Arff;

public class Sentence {
    private Term[] term;
    private boolean[] bgSpaceAfterTerm;
    private int igTermCount = 0;
    private int igPositiveSentiment = 0;
    private int igNegativeSentiment = 0;
    private boolean bgNothingToClassify = true;
    private ClassificationResources resources;
    private ClassificationOptions options;
    private int[] igSentimentIDList;
    private int igSentimentIDListCount = 0;
    private boolean bSentimentIDListMade = false;
    private boolean[] bgIncludeTerm;
    private boolean bgIdiomsApplied = false;
    private boolean bgObjectEvaluationsApplied = false;
    private String sgClassificationRationale = "";

    public void addSentenceToIndex(UnusedTermsClassificationIndex unusedTermClassificationIndex) {
        int i = 1;
        while (i <= this.igTermCount) {
            unusedTermClassificationIndex.addTermToNewTermIndex(this.term[i].getText());
            ++i;
        }
    }

    public int addToStringIndex(StringIndex stringIndex, TextParsingOptions textParsingOptions, boolean bRecordCount, boolean bArffIndex) {
        String sEncoded = "";
        int iStringPos = -1;
        int iTermsChecked = 0;
        if (textParsingOptions.bgIncludePunctuation && textParsingOptions.igNgramSize == 1 && !textParsingOptions.bgUseTranslations && !textParsingOptions.bgAddEmphasisCode) {
            int i = 1;
            while (i <= this.igTermCount) {
                stringIndex.addString(this.term[i].getText(), bRecordCount);
                ++i;
            }
            iTermsChecked = this.igTermCount;
        } else {
            String sText = "";
            int iCurrentTerm = 0;
            int iTermCount = 0;
            while (iCurrentTerm < this.igTermCount) {
                if (textParsingOptions.bgIncludePunctuation || !this.term[++iCurrentTerm].isPunctuation()) {
                    sText = ++iTermCount > 1 ? String.valueOf(sText) + " " : "";
                    sText = textParsingOptions.bgUseTranslations ? String.valueOf(sText) + this.term[iCurrentTerm].getTranslation() : String.valueOf(sText) + this.term[iCurrentTerm].getOriginalText();
                    if (textParsingOptions.bgAddEmphasisCode && this.term[iCurrentTerm].containsEmphasis()) {
                        sText = String.valueOf(sText) + "+";
                    }
                }
                if (iTermCount != textParsingOptions.igNgramSize) continue;
                if (bArffIndex) {
                    sEncoded = Arff.arffSafeWordEncode(sText.toLowerCase(), false);
                    iStringPos = stringIndex.findString(sEncoded);
                    iTermCount = 0;
                    if (iStringPos > -1) {
                        stringIndex.add1ToCount(iStringPos);
                    }
                } else {
                    stringIndex.addString(sText.toLowerCase(), bRecordCount);
                    iTermCount = 0;
                }
                iCurrentTerm += 1 - textParsingOptions.igNgramSize;
                ++iTermsChecked;
            }
        }
        return iTermsChecked;
    }

    public void setSentence(String sSentence, ClassificationResources classResources, ClassificationOptions newClassificationOptions) {
        this.resources = classResources;
        this.options = newClassificationOptions;
        if (this.options.bgAlwaysSplitWordsAtApostrophes && sSentence.indexOf("'") >= 0) {
            sSentence = sSentence.replace("'", " ");
        }
        String[] sSegmentList = sSentence.split(" ");
        int iSegmentListLength = sSegmentList.length;
        int iMaxTermListLength = sSentence.length() + 1;
        this.term = new Term[iMaxTermListLength];
        this.bgSpaceAfterTerm = new boolean[iMaxTermListLength];
        int iPos = 0;
        this.igTermCount = 0;
        int iSegment = 0;
        while (iSegment < iSegmentListLength) {
            iPos = 0;
            while (iPos >= 0 && iPos < sSegmentList[iSegment].length()) {
                this.term[++this.igTermCount] = new Term();
                int iOffset = this.term[this.igTermCount].extractNextWordOrPunctuationOrEmoticon(sSegmentList[iSegment].substring(iPos), this.resources, this.options);
                iPos = iOffset < 0 ? iOffset : (iPos += iOffset);
                this.bgSpaceAfterTerm[this.igTermCount] = false;
            }
            this.bgSpaceAfterTerm[this.igTermCount] = true;
            ++iSegment;
        }
        this.bgSpaceAfterTerm[this.igTermCount] = false;
    }

    public int[] getSentimentIDList() {
        if (!this.bSentimentIDListMade) {
            this.makeSentimentIDList();
        }
        return this.igSentimentIDList;
    }

    public void makeSentimentIDList() {
        int iSentimentIDTemp = 0;
        this.igSentimentIDListCount = 0;
        int i = 1;
        while (i <= this.igTermCount) {
            if (this.term[i].getSentimentID() > 0) {
                ++this.igSentimentIDListCount;
            }
            ++i;
        }
        if (this.igSentimentIDListCount > 0) {
            this.igSentimentIDList = new int[this.igSentimentIDListCount + 1];
            this.igSentimentIDListCount = 0;
            i = 1;
            while (i <= this.igTermCount) {
                iSentimentIDTemp = this.term[i].getSentimentID();
                if (iSentimentIDTemp > 0) {
                    int j = 1;
                    while (j <= this.igSentimentIDListCount) {
                        if (iSentimentIDTemp == this.igSentimentIDList[j]) {
                            iSentimentIDTemp = 0;
                            break;
                        }
                        ++j;
                    }
                    if (iSentimentIDTemp > 0) {
                        this.igSentimentIDList[++this.igSentimentIDListCount] = iSentimentIDTemp;
                    }
                }
                ++i;
            }
            Sort.quickSortInt(this.igSentimentIDList, 1, this.igSentimentIDListCount);
        }
        this.bSentimentIDListMade = true;
    }

    public String getTaggedSentence() {
        String sTagged = "";
        int i = 1;
        while (i <= this.igTermCount) {
            sTagged = this.bgSpaceAfterTerm[i] ? String.valueOf(sTagged) + this.term[i].getTag() + " " : String.valueOf(sTagged) + this.term[i].getTag();
            ++i;
        }
        return String.valueOf(sTagged) + "<br>";
    }

    public String getClassificationRationale() {
        return this.sgClassificationRationale;
    }

    public String getTranslatedSentence() {
        String sTranslated = "";
        int i = 1;
        while (i <= this.igTermCount) {
            if (this.term[i].isWord()) {
                sTranslated = String.valueOf(sTranslated) + this.term[i].getTranslatedWord();
            } else if (this.term[i].isPunctuation()) {
                sTranslated = String.valueOf(sTranslated) + this.term[i].getTranslatedPunctuation();
            } else if (this.term[i].isEmoticon()) {
                sTranslated = String.valueOf(sTranslated) + this.term[i].getEmoticon();
            }
            if (this.bgSpaceAfterTerm[i]) {
                sTranslated = String.valueOf(sTranslated) + " ";
            }
            ++i;
        }
        return String.valueOf(sTranslated) + "<br>";
    }

    public void recalculateSentenceSentimentScore() {
        this.calculateSentenceSentimentScore();
    }

    public void reClassifyClassifiedSentenceForSentimentChange(int iSentimentWordID) {
        if (this.igNegativeSentiment == 0) {
            this.calculateSentenceSentimentScore();
            return;
        }
        if (!this.bSentimentIDListMade) {
            this.makeSentimentIDList();
        }
        if (this.igSentimentIDListCount == 0) {
            return;
        }
        if (Sort.i_FindIntPositionInSortedArray(iSentimentWordID, this.igSentimentIDList, 1, this.igSentimentIDListCount) >= 0) {
            this.calculateSentenceSentimentScore();
        }
    }

    public int getSentencePositiveSentiment() {
        if (this.igPositiveSentiment == 0) {
            this.calculateSentenceSentimentScore();
        }
        return this.igPositiveSentiment;
    }

    public int getSentenceNegativeSentiment() {
        if (this.igNegativeSentiment == 0) {
            this.calculateSentenceSentimentScore();
        }
        return this.igNegativeSentiment;
    }

    private void markTermsValidToClassify() {
        this.bgIncludeTerm = new boolean[this.igTermCount + 1];
        if (this.options.bgIgnoreSentencesWithoutKeywords) {
            this.bgNothingToClassify = true;
            int iTerm = 1;
            while (iTerm <= this.igTermCount) {
                this.bgIncludeTerm[iTerm] = false;
                if (this.term[iTerm].isWord()) {
                    int iKeyword = 0;
                    while (iKeyword < this.options.sgSentimentKeyWords.length) {
                        if (this.term[iTerm].matchesString(this.options.sgSentimentKeyWords[iKeyword], true)) {
                            this.bgIncludeTerm[iTerm] = true;
                            this.bgNothingToClassify = false;
                        }
                        ++iKeyword;
                    }
                }
                ++iTerm;
            }
            if (!this.bgNothingToClassify) {
                int iTermsSinceValid = 100000;
                int iTerm2 = 1;
                while (iTerm2 <= this.igTermCount) {
                    if (this.bgIncludeTerm[iTerm2]) {
                        iTermsSinceValid = 0;
                    } else if (iTermsSinceValid < this.options.igWordsToIncludeAfterKeyword) {
                        this.bgIncludeTerm[iTerm2] = true;
                        if (this.term[iTerm2].isWord()) {
                            ++iTermsSinceValid;
                        }
                    }
                    ++iTerm2;
                }
                iTermsSinceValid = 100000;
                iTerm2 = this.igTermCount;
                while (iTerm2 >= 1) {
                    if (this.bgIncludeTerm[iTerm2]) {
                        iTermsSinceValid = 0;
                    } else if (iTermsSinceValid < this.options.igWordsToIncludeBeforeKeyword) {
                        this.bgIncludeTerm[iTerm2] = true;
                        if (this.term[iTerm2].isWord()) {
                            ++iTermsSinceValid;
                        }
                    }
                    --iTerm2;
                }
            }
        } else {
            int iTerm = 1;
            while (iTerm <= this.igTermCount) {
                this.bgIncludeTerm[iTerm] = true;
                ++iTerm;
            }
            this.bgNothingToClassify = false;
        }
    }

    private void calculateSentenceSentimentScore() {
        int iTerm;
        if (this.options.bgExplainClassification && this.sgClassificationRationale.length() > 0) {
            this.sgClassificationRationale = "";
        }
        this.igNegativeSentiment = 1;
        this.igPositiveSentiment = 1;
        int iWordTotal = 0;
        int iLastBoosterWordScore = 0;
        int iTemp = 0;
        if (this.igTermCount == 0) {
            this.bgNothingToClassify = true;
            this.igNegativeSentiment = -1;
            this.igPositiveSentiment = 1;
            return;
        }
        this.markTermsValidToClassify();
        if (this.bgNothingToClassify) {
            this.igNegativeSentiment = -1;
            this.igPositiveSentiment = 1;
            return;
        }
        boolean bSentencePunctuationBoost = false;
        int iWordsSinceNegative = this.options.igMaxWordsBeforeSentimentToNegate + 2;
        int iWordsSinceBooster = 0;
        float[] fSentiment = new float[this.igTermCount + 1];
        if (this.options.bgUseIdiomLookupTable) {
            this.overrideTermStrengthsWithIdiomStrengths(false);
        }
        if (this.options.bgUseObjectEvaluationTable) {
            this.overrideTermStrengthsWithObjectEvaluationStrengths(false);
        }
        int iTerm2 = 1;
        while (iTerm2 <= this.igTermCount) {
            if (this.bgIncludeTerm[iTerm2]) {
                if (this.term[iTerm2].isWord()) {
                    String sEmphasis;
                    ++iWordTotal;
                    if (iTerm2 == 1 || !this.term[iTerm2].isProperNoun() || this.term[iTerm2 - 1].getOriginalText().equals(":") || this.term[iTerm2 - 1].getOriginalText().length() > 3 && this.term[iTerm2 - 1].getOriginalText().substring(0, 1).equals("@")) {
                        fSentiment[iWordTotal] = this.term[iTerm2].getSentimentValue();
                        if (this.options.bgExplainClassification) {
                            iTemp = this.term[iTerm2].getSentimentValue();
                            iTemp = iTemp < 0 ? --iTemp : ++iTemp;
                            this.sgClassificationRationale = iTemp == 1 ? String.valueOf(this.sgClassificationRationale) + this.term[iTerm2].getOriginalText() + " " : String.valueOf(this.sgClassificationRationale) + this.term[iTerm2].getOriginalText() + "[" + iTemp + "] ";
                        }
                    } else if (this.options.bgExplainClassification) {
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + this.term[iTerm2].getOriginalText() + " [proper noun] ";
                    }
                    if (!(!this.options.bgMultipleLettersBoostSentiment || this.term[iTerm2].getWordEmphasisLength() < this.options.igMinRepeatedLettersForBoost || iTerm2 != 1 && this.term[iTerm2 - 1].isPunctuation() && this.term[iTerm2 - 1].getOriginalText().equals("@") || (sEmphasis = this.term[iTerm2].getWordEmphasis().toLowerCase()).indexOf("xx") >= 0 || sEmphasis.indexOf("ww") >= 0 || sEmphasis.indexOf("ha") >= 0)) {
                        if (fSentiment[iWordTotal] < 0.0f) {
                            int n = iWordTotal;
                            fSentiment[n] = (float)((double)fSentiment[n] - 0.6);
                            if (this.options.bgExplainClassification) {
                                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[-0.6 spelling emphasis] ";
                            }
                        } else if (fSentiment[iWordTotal] > 0.0f) {
                            int n = iWordTotal;
                            fSentiment[n] = (float)((double)fSentiment[n] + 0.6);
                            if (this.options.bgExplainClassification) {
                                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[+0.6 spelling emphasis] ";
                            }
                        } else if (this.options.igMoodToInterpretNeutralEmphasis > 0) {
                            int n = iWordTotal;
                            fSentiment[n] = (float)((double)fSentiment[n] + 0.6);
                            if (this.options.bgExplainClassification) {
                                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[+0.6 spelling mood emphasis] ";
                            }
                        } else if (this.options.igMoodToInterpretNeutralEmphasis < 0) {
                            int n = iWordTotal;
                            fSentiment[n] = (float)((double)fSentiment[n] - 0.6);
                            if (this.options.bgExplainClassification) {
                                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[-0.6 spelling mood emphasis] ";
                            }
                        }
                    }
                    if (this.options.bgCapitalsBoostTermSentiment && fSentiment[iWordTotal] != 0.0f && this.term[iTerm2].isAllCapitals()) {
                        if (fSentiment[iWordTotal] > 0.0f) {
                            int n = iWordTotal;
                            fSentiment[n] = fSentiment[n] + 1.0f;
                            if (this.options.bgExplainClassification) {
                                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[+1 CAPITALS] ";
                            }
                        } else {
                            int n = iWordTotal;
                            fSentiment[n] = fSentiment[n] - 1.0f;
                            if (this.options.bgExplainClassification) {
                                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[-1 CAPITALS] ";
                            }
                        }
                    }
                    if (this.options.bgBoosterWordsChangeEmotion) {
                        if (iWordsSinceBooster == this.options.igMaxWordsAfterBoosters) {
                            iLastBoosterWordScore = 0;
                        }
                        if (iLastBoosterWordScore != 0) {
                            if (fSentiment[iWordTotal] > 0.0f) {
                                int n = iWordTotal;
                                fSentiment[n] = fSentiment[n] + (float)iLastBoosterWordScore;
                                if (this.options.bgExplainClassification) {
                                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[+" + iLastBoosterWordScore + " booster word] ";
                                }
                            } else if (fSentiment[iWordTotal] < 0.0f) {
                                int n = iWordTotal;
                                fSentiment[n] = fSentiment[n] - (float)iLastBoosterWordScore;
                                if (this.options.bgExplainClassification) {
                                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[-" + iLastBoosterWordScore + " booster word] ";
                                }
                            }
                            if (this.term[iTerm2].getBoosterWordScore() != 0 && (iLastBoosterWordScore = this.term[iTerm2].getBoosterWordScore()) != 0) {
                                iWordsSinceBooster = 0;
                            }
                        } else {
                            iLastBoosterWordScore = this.term[iTerm2].getBoosterWordScore();
                            if (iLastBoosterWordScore != 0) {
                                iWordsSinceBooster = 0;
                            }
                        }
                    }
                    if (this.options.bgNegatingWordsOccurBeforeSentiment) {
                        if (this.options.bgNegatingWordsFlipEmotion) {
                            if (iWordsSinceNegative <= this.options.igMaxWordsBeforeSentimentToNegate) {
                                fSentiment[iWordTotal] = -fSentiment[iWordTotal] * this.options.fgStrengthMultiplierForNegatedWords;
                                if (this.options.bgExplainClassification) {
                                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[*-" + this.options.fgStrengthMultiplierForNegatedWords + " approx. negated multiplier] ";
                                }
                            }
                        } else {
                            if (this.options.bgNegatingNegativeNeutralisesEmotion && fSentiment[iWordTotal] < 0.0f && iWordsSinceNegative <= this.options.igMaxWordsBeforeSentimentToNegate) {
                                fSentiment[iWordTotal] = 0.0f;
                                if (this.options.bgExplainClassification) {
                                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[=0 negation] ";
                                }
                            }
                            if (this.options.bgNegatingPositiveFlipsEmotion && fSentiment[iWordTotal] > 0.0f && iWordsSinceNegative <= this.options.igMaxWordsBeforeSentimentToNegate) {
                                fSentiment[iWordTotal] = -fSentiment[iWordTotal] * this.options.fgStrengthMultiplierForNegatedWords;
                                if (this.options.bgExplainClassification) {
                                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[*-" + this.options.fgStrengthMultiplierForNegatedWords + " approx. negated multiplier] ";
                                }
                            }
                        }
                    }
                    if (this.term[iTerm2].isNegatingWord()) {
                        iWordsSinceNegative = -1;
                    }
                    if (iLastBoosterWordScore == 0) {
                        ++iWordsSinceNegative;
                    }
                    if (this.term[iTerm2].isNegatingWord() && this.options.bgNegatingWordsOccurAfterSentiment) {
                        int iTermsChecked = 0;
                        int iPriorWord = iWordTotal - 1;
                        while (iPriorWord > 0) {
                            if (this.options.bgNegatingWordsFlipEmotion) {
                                fSentiment[iPriorWord] = -fSentiment[iPriorWord] * this.options.fgStrengthMultiplierForNegatedWords;
                                if (this.options.bgExplainClassification) {
                                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[*-" + this.options.fgStrengthMultiplierForNegatedWords + " approx. negated multiplier] ";
                                }
                            } else {
                                if (this.options.bgNegatingNegativeNeutralisesEmotion && fSentiment[iPriorWord] < 0.0f) {
                                    fSentiment[iPriorWord] = 0.0f;
                                    if (this.options.bgExplainClassification) {
                                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[=0 negation] ";
                                    }
                                }
                                if (this.options.bgNegatingPositiveFlipsEmotion && fSentiment[iPriorWord] > 0.0f) {
                                    fSentiment[iPriorWord] = -fSentiment[iPriorWord] * this.options.fgStrengthMultiplierForNegatedWords;
                                    if (this.options.bgExplainClassification) {
                                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[*-" + this.options.fgStrengthMultiplierForNegatedWords + " approx. negated multiplier] ";
                                    }
                                }
                            }
                            if (++iTermsChecked > this.options.igMaxWordsAfterSentimentToNegate) break;
                            --iPriorWord;
                        }
                    }
                    if (this.options.bgAllowMultipleNegativeWordsToIncreaseNegativeEmotion && fSentiment[iWordTotal] < -1.0f && iWordTotal > 1 && fSentiment[iWordTotal - 1] < -1.0f) {
                        int n = iWordTotal;
                        fSentiment[n] = fSentiment[n] - 1.0f;
                        if (this.options.bgExplainClassification) {
                            this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[-1 consecutive negative words] ";
                        }
                    }
                    if (this.options.bgAllowMultiplePositiveWordsToIncreasePositiveEmotion && fSentiment[iWordTotal] > 1.0f && iWordTotal > 1 && fSentiment[iWordTotal - 1] > 1.0f) {
                        int n = iWordTotal;
                        fSentiment[n] = fSentiment[n] + 1.0f;
                        if (this.options.bgExplainClassification) {
                            this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[+1 consecutive positive words] ";
                        }
                    }
                } else if (this.term[iTerm2].isEmoticon()) {
                    int iEmoSentiment = this.term[iTerm2].getEmoticonSentimentStrength();
                    if (iEmoSentiment != 0) {
                        if (iWordTotal > 0) {
                            int n = iWordTotal;
                            fSentiment[n] = fSentiment[n] + (float)this.term[iTerm2].getEmoticonSentimentStrength();
                            if (this.options.bgExplainClassification) {
                                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + this.term[iTerm2].getEmoticon() + " [" + this.term[iTerm2].getEmoticonSentimentStrength() + " emoticon] ";
                            }
                        } else {
                            fSentiment[++iWordTotal] = iEmoSentiment;
                            if (this.options.bgExplainClassification) {
                                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + this.term[iTerm2].getEmoticon() + " [" + this.term[iTerm2].getEmoticonSentimentStrength() + " emoticon]";
                            }
                        }
                    }
                } else if (this.term[iTerm2].isPunctuation()) {
                    if (this.term[iTerm2].getPunctuationEmphasisLength() >= this.options.igMinPunctuationWithExclamationToChangeSentenceSentiment && this.term[iTerm2].punctuationContains("!") && iWordTotal > 0) {
                        bSentencePunctuationBoost = true;
                        if (this.options.bgExplainClassification) {
                            this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + this.term[iTerm2].getOriginalText();
                        }
                    } else if (this.options.bgExplainClassification) {
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + this.term[iTerm2].getOriginalText();
                    }
                }
            }
            ++iTerm2;
        }
        float fTotalNeg = 0.0f;
        float fTotalPos = 0.0f;
        float fMaxNeg = 0.0f;
        float fMaxPos = 0.0f;
        int iPosWords = 0;
        int iNegWords = 0;
        int iWord = 1;
        while (iWord <= iWordTotal) {
            if (fSentiment[iWord] < 0.0f) {
                fTotalNeg += fSentiment[iWord];
                ++iNegWords;
                if (fMaxNeg > fSentiment[iWord]) {
                    fMaxNeg = fSentiment[iWord];
                }
            } else if (fSentiment[iWord] > 0.0f) {
                fTotalPos += fSentiment[iWord];
                ++iPosWords;
                if (fMaxPos < fSentiment[iWord]) {
                    fMaxPos = fSentiment[iWord];
                }
            }
            ++iWord;
        }
        fMaxNeg -= 1.0f;
        fMaxPos += 1.0f;
        if (this.options.igEmotionSentenceCombineMethod == this.options.igCombineAverage) {
            this.igPositiveSentiment = iPosWords == 0 ? 1 : (int)Math.round(((double)(fTotalPos + (float)iPosWords) + 0.45) / (double)iPosWords);
            this.igNegativeSentiment = iNegWords == 0 ? -1 : (int)Math.round(((double)(fTotalNeg - (float)iNegWords) + 0.55) / (double)iNegWords);
        } else if (this.options.igEmotionSentenceCombineMethod == this.options.igCombineTotal) {
            this.igPositiveSentiment = Math.round(fTotalPos) + iPosWords;
            this.igNegativeSentiment = Math.round(fTotalNeg) - iNegWords;
        } else {
            this.igPositiveSentiment = Math.round(fMaxPos);
            this.igNegativeSentiment = Math.round(fMaxNeg);
        }
        if (this.options.bgReduceNegativeEmotionInQuestionSentences && this.igNegativeSentiment < -1) {
            iTerm = 1;
            while (iTerm <= this.igTermCount) {
                if (this.term[iTerm].isWord()) {
                    if (this.resources.questionWords.questionWord(this.term[iTerm].getTranslatedWord().toLowerCase())) {
                        ++this.igNegativeSentiment;
                        if (!this.options.bgExplainClassification) break;
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[+1 negative for question word]";
                        break;
                    }
                } else if (this.term[iTerm].isPunctuation() && this.term[iTerm].punctuationContains("?")) {
                    ++this.igNegativeSentiment;
                    if (!this.options.bgExplainClassification) break;
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[+1 negative for question mark ?]";
                    break;
                }
                ++iTerm;
            }
        }
        if (this.igPositiveSentiment == 1 && this.options.bgMissCountsAsPlus2) {
            iTerm = 1;
            while (iTerm <= this.igTermCount) {
                if (this.term[iTerm].isWord() && this.term[iTerm].getTranslatedWord().toLowerCase().compareTo("miss") == 0) {
                    this.igPositiveSentiment = 2;
                    if (!this.options.bgExplainClassification) break;
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[pos = 2 for term 'miss']";
                    break;
                }
                ++iTerm;
            }
        }
        if (bSentencePunctuationBoost) {
            if (this.igPositiveSentiment < -this.igNegativeSentiment) {
                --this.igNegativeSentiment;
                if (this.options.bgExplainClassification) {
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[-1 punctuation emphasis] ";
                }
            } else if (this.igPositiveSentiment > -this.igNegativeSentiment) {
                ++this.igPositiveSentiment;
                if (this.options.bgExplainClassification) {
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[+1 punctuation emphasis] ";
                }
            } else if (this.options.igMoodToInterpretNeutralEmphasis > 0) {
                ++this.igPositiveSentiment;
                if (this.options.bgExplainClassification) {
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[+1 punctuation mood emphasis] ";
                }
            } else if (this.options.igMoodToInterpretNeutralEmphasis < 0) {
                --this.igNegativeSentiment;
                if (this.options.bgExplainClassification) {
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[-1 punctuation mood emphasis] ";
                }
            }
        }
        if (this.igPositiveSentiment == 1 && this.igNegativeSentiment == -1 && this.options.bgExclamationInNeutralSentenceCountsAsPlus2) {
            iTerm = 1;
            while (iTerm <= this.igTermCount) {
                if (this.term[iTerm].isPunctuation() && this.term[iTerm].punctuationContains("!")) {
                    this.igPositiveSentiment = 2;
                    if (!this.options.bgExplainClassification) break;
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[pos = 2 for !]";
                    break;
                }
                ++iTerm;
            }
        }
        if (this.igPositiveSentiment == 1 && this.igNegativeSentiment == -1 && this.options.bgYouOrYourIsPlus2UnlessSentenceNegative) {
            int iTerm3 = 1;
            while (iTerm3 <= this.igTermCount) {
                String sTranslatedWord;
                if (this.term[iTerm3].isWord() && ((sTranslatedWord = this.term[iTerm3].getTranslatedWord().toLowerCase()).compareTo("you") == 0 || sTranslatedWord.compareTo("your") == 0 || sTranslatedWord.compareTo("whats") == 0)) {
                    this.igPositiveSentiment = 2;
                    if (!this.options.bgExplainClassification) break;
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[pos = 2 for you/your/whats]";
                    break;
                }
                ++iTerm3;
            }
        }
        this.adjustSentimentForIrony();
        if (this.options.igEmotionSentenceCombineMethod != this.options.igCombineTotal) {
            if (this.igPositiveSentiment > 5) {
                this.igPositiveSentiment = 5;
            }
            if (this.igNegativeSentiment < -5) {
                this.igNegativeSentiment = -5;
            }
        }
        if (this.options.bgExplainClassification) {
            this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[sentence: " + this.igPositiveSentiment + "," + this.igNegativeSentiment + "]";
        }
    }

    private void adjustSentimentForIrony() {
        int iTerm;
        if (this.igPositiveSentiment >= this.options.igMinSentencePosForQuotesIrony) {
            iTerm = 1;
            while (iTerm <= this.igTermCount) {
                if (this.term[iTerm].isPunctuation() && this.term[iTerm].getText().indexOf(34) >= 0) {
                    if (this.igNegativeSentiment > -this.igPositiveSentiment) {
                        this.igNegativeSentiment = 1 - this.igPositiveSentiment;
                    }
                    this.igPositiveSentiment = 1;
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[Irony change: pos = 1, neg = " + this.igNegativeSentiment + "]";
                    return;
                }
                ++iTerm;
            }
        }
        if (this.igPositiveSentiment >= this.options.igMinSentencePosForPunctuationIrony) {
            iTerm = 1;
            while (iTerm <= this.igTermCount) {
                if (this.term[iTerm].isPunctuation() && this.term[iTerm].punctuationContains("!") && this.term[iTerm].getPunctuationEmphasisLength() > 0) {
                    if (this.igNegativeSentiment > -this.igPositiveSentiment) {
                        this.igNegativeSentiment = 1 - this.igPositiveSentiment;
                    }
                    this.igPositiveSentiment = 1;
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[Irony change: pos = 1, neg = " + this.igNegativeSentiment + "]";
                    return;
                }
                ++iTerm;
            }
        }
        if (this.igPositiveSentiment >= this.options.igMinSentencePosForTermsIrony) {
            iTerm = 1;
            while (iTerm <= this.igTermCount) {
                if (this.resources.ironyList.termIsIronic(this.term[iTerm].getText())) {
                    if (this.igNegativeSentiment > -this.igPositiveSentiment) {
                        this.igNegativeSentiment = 1 - this.igPositiveSentiment;
                    }
                    this.igPositiveSentiment = 1;
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[Irony change: pos = 1, neg = " + this.igNegativeSentiment + "]";
                    return;
                }
                ++iTerm;
            }
        }
    }

    public void overrideTermStrengthsWithObjectEvaluationStrengths(boolean recalculateIfAlreadyDone) {
        boolean bMatchingObject = false;
        boolean bMatchingEvaluation = false;
        if (!this.bgObjectEvaluationsApplied || recalculateIfAlreadyDone) {
            int iObject = 1;
            while (iObject < this.resources.evaluativeTerms.igObjectEvaluationCount) {
                bMatchingObject = false;
                bMatchingEvaluation = false;
                int iTerm = 1;
                while (iTerm <= this.igTermCount) {
                    if (this.term[iTerm].isWord() && this.term[iTerm].matchesStringWithWildcard(this.resources.evaluativeTerms.sgObject[iObject], true)) {
                        bMatchingObject = true;
                        break;
                    }
                    ++iTerm;
                }
                if (bMatchingObject) {
                    iTerm = 1;
                    while (iTerm <= this.igTermCount) {
                        if (this.term[iTerm].isWord() && this.term[iTerm].matchesStringWithWildcard(this.resources.evaluativeTerms.sgObjectEvaluation[iObject], true)) {
                            bMatchingEvaluation = true;
                            break;
                        }
                        ++iTerm;
                    }
                }
                if (bMatchingEvaluation) {
                    if (this.options.bgExplainClassification) {
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[term weight changed by object/evaluation]";
                    }
                    this.term[iTerm].setSentimentOverrideValue(this.resources.evaluativeTerms.igObjectEvaluationStrength[iObject]);
                }
                ++iObject;
            }
            this.bgObjectEvaluationsApplied = true;
        }
    }

    public void overrideTermStrengthsWithIdiomStrengths(boolean recalculateIfAlreadyDone) {
        if (!this.bgIdiomsApplied || recalculateIfAlreadyDone) {
            int iTerm = 1;
            while (iTerm <= this.igTermCount) {
                if (this.term[iTerm].isWord()) {
                    int iIdiom = 1;
                    while (iIdiom <= this.resources.idiomList.igIdiomCount) {
                        if (iTerm + this.resources.idiomList.igIdiomWordCount[iIdiom] - 1 <= this.igTermCount) {
                            boolean bMatchingIdiom = true;
                            int iIdiomTerm = 0;
                            while (iIdiomTerm < this.resources.idiomList.igIdiomWordCount[iIdiom]) {
                                if (!this.term[iTerm + iIdiomTerm].matchesStringWithWildcard(this.resources.idiomList.sgIdiomWords[iIdiom][iIdiomTerm], true)) {
                                    bMatchingIdiom = false;
                                    break;
                                }
                                ++iIdiomTerm;
                            }
                            if (bMatchingIdiom) {
                                if (this.options.bgExplainClassification) {
                                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[term weight(s) changed by idiom " + this.resources.idiomList.getIdiom(iIdiom) + "]";
                                }
                                this.term[iTerm].setSentimentOverrideValue(this.resources.idiomList.igIdiomStrength[iIdiom]);
                                iIdiomTerm = 1;
                                while (iIdiomTerm < this.resources.idiomList.igIdiomWordCount[iIdiom]) {
                                    this.term[iTerm + iIdiomTerm].setSentimentOverrideValue(0);
                                    ++iIdiomTerm;
                                }
                            }
                        }
                        ++iIdiom;
                    }
                }
                ++iTerm;
            }
            this.bgIdiomsApplied = true;
        }
    }
}

