/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.utilities.FileOps;
import uk.ac.wlv.utilities.Sort;

public class QuestionWords {
    private String[] sgQuestionWord;
    private int igQuestionWordCount = 0;
    private int igQuestionWordMax = 0;

    public boolean initialise(String sFilename, ClassificationOptions options) {
        if (this.igQuestionWordMax > 0) {
            return true;
        }
        File f = new File(sFilename);
        if (!f.exists()) {
            System.out.println("Could not find the question word file: " + sFilename);
            return false;
        }
        this.igQuestionWordMax = FileOps.i_CountLinesInTextFile(sFilename) + 2;
        this.sgQuestionWord = new String[this.igQuestionWordMax];
        this.igQuestionWordCount = 0;
        try {
            String sLine;
            BufferedReader rReader = options.bgForceUTF8 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sFilename), "UTF8")) : new BufferedReader(new FileReader(sFilename));
            while ((sLine = rReader.readLine()) != null) {
                if (sLine == "") continue;
                ++this.igQuestionWordCount;
                this.sgQuestionWord[this.igQuestionWordCount] = sLine;
            }
            rReader.close();
            Sort.quickSortStrings(this.sgQuestionWord, 1, this.igQuestionWordCount);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find the question word file: " + sFilename);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Found question word file but could not read from it: " + sFilename);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean questionWord(String sWord) {
        return Sort.i_FindStringPositionInSortedArray(sWord, this.sgQuestionWord, 1, this.igQuestionWordCount) >= 0;
    }
}

