/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.util.Random;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.sentistrength.ClassificationResources;
import uk.ac.wlv.sentistrength.Sentence;
import uk.ac.wlv.sentistrength.TextParsingOptions;
import uk.ac.wlv.sentistrength.UnusedTermsClassificationIndex;
import uk.ac.wlv.utilities.Sort;
import uk.ac.wlv.utilities.StringIndex;

public class Paragraph {
    private Sentence[] sentence;
    private int igSentenceCount = 0;
    private int[] igSentimentIDList;
    private int igSentimentIDListCount = 0;
    private boolean bSentimentIDListMade = false;
    private int igPositiveSentiment = 0;
    private int igNegativeSentiment = 0;
    private int igTrinarySentiment = 0;
    private int igScaleSentiment = 0;
    private ClassificationResources resources;
    private ClassificationOptions options;
    private Random generator = new Random();
    private String sgClassificationRationale = "";

    public void addParagraphToIndexWithPosNegValues(UnusedTermsClassificationIndex unusedTermsClassificationIndex, int iCorrectPosClass, int iEstPosClass, int iCorrectNegClass, int iEstNegClass) {
        int i = 1;
        while (i <= this.igSentenceCount) {
            this.sentence[i].addSentenceToIndex(unusedTermsClassificationIndex);
            ++i;
        }
        unusedTermsClassificationIndex.addNewIndexToMainIndexWithPosNegValues(iCorrectPosClass, iEstPosClass, iCorrectNegClass, iEstNegClass);
    }

    public void addParagraphToIndexWithScaleValues(UnusedTermsClassificationIndex unusedTermsClassificationIndex, int iCorrectScaleClass, int iEstScaleClass) {
        int i = 1;
        while (i <= this.igSentenceCount) {
            this.sentence[i].addSentenceToIndex(unusedTermsClassificationIndex);
            ++i;
        }
        unusedTermsClassificationIndex.addNewIndexToMainIndexWithScaleValues(iCorrectScaleClass, iEstScaleClass);
    }

    public void addParagraphToIndexWithBinaryValues(UnusedTermsClassificationIndex unusedTermsClassificationIndex, int iCorrectBinaryClass, int iEstBinaryClass) {
        int i = 1;
        while (i <= this.igSentenceCount) {
            this.sentence[i].addSentenceToIndex(unusedTermsClassificationIndex);
            ++i;
        }
        unusedTermsClassificationIndex.addNewIndexToMainIndexWithBinaryValues(iCorrectBinaryClass, iEstBinaryClass);
    }

    public int addToStringIndex(StringIndex stringIndex, TextParsingOptions textParsingOptions, boolean bRecordCount, boolean bArffIndex) {
        int iTermsChecked = 0;
        int i = 1;
        while (i <= this.igSentenceCount) {
            iTermsChecked += this.sentence[i].addToStringIndex(stringIndex, textParsingOptions, bRecordCount, bArffIndex);
            ++i;
        }
        return iTermsChecked;
    }

    public void addParagraphToIndexWithTrinaryValues(UnusedTermsClassificationIndex unusedTermsClassificationIndex, int iCorrectTrinaryClass, int iEstTrinaryClass) {
        int i = 1;
        while (i <= this.igSentenceCount) {
            this.sentence[i].addSentenceToIndex(unusedTermsClassificationIndex);
            ++i;
        }
        unusedTermsClassificationIndex.addNewIndexToMainIndexWithTrinaryValues(iCorrectTrinaryClass, iEstTrinaryClass);
    }

    public void setParagraph(String sParagraph, ClassificationResources classResources, ClassificationOptions newClassificationOptions) {
        this.resources = classResources;
        this.options = newClassificationOptions;
        if (sParagraph.indexOf("\"") >= 0) {
            sParagraph = sParagraph.replace("\"", "'");
        }
        int iSentenceEnds = 2;
        int iPos = 0;
        while (iPos >= 0 && iPos < sParagraph.length()) {
            if ((iPos = sParagraph.indexOf("<br>", iPos)) < 0) continue;
            iPos += 3;
            ++iSentenceEnds;
        }
        iPos = 0;
        while (iPos >= 0 && iPos < sParagraph.length()) {
            if ((iPos = sParagraph.indexOf(".", iPos)) < 0) continue;
            ++iPos;
            ++iSentenceEnds;
        }
        iPos = 0;
        while (iPos >= 0 && iPos < sParagraph.length()) {
            if ((iPos = sParagraph.indexOf("!", iPos)) < 0) continue;
            ++iPos;
            ++iSentenceEnds;
        }
        iPos = 0;
        while (iPos >= 0 && iPos < sParagraph.length()) {
            if ((iPos = sParagraph.indexOf("?", iPos)) < 0) continue;
            ++iPos;
            ++iSentenceEnds;
        }
        this.sentence = new Sentence[iSentenceEnds];
        this.igSentenceCount = 0;
        int iLastSentenceEnd = -1;
        boolean bPunctuationIndicatesSentenceEnd = false;
        int iNextBr = sParagraph.indexOf("<br>");
        String sNextSentence = "";
        iPos = 0;
        while (iPos < sParagraph.length()) {
            String sNextChar = sParagraph.substring(iPos, iPos + 1);
            if (iPos == sParagraph.length() - 1) {
                sNextSentence = sParagraph.substring(iLastSentenceEnd + 1);
            } else if (iPos == iNextBr) {
                sNextSentence = sParagraph.substring(iLastSentenceEnd + 1, iPos);
                iLastSentenceEnd = iPos + 3;
                iNextBr = sParagraph.indexOf("<br>", iNextBr + 2);
            } else if (this.b_IsSentenceEndPunctuation(sNextChar)) {
                bPunctuationIndicatesSentenceEnd = true;
            } else if (sNextChar.compareTo(" ") == 0) {
                if (bPunctuationIndicatesSentenceEnd) {
                    sNextSentence = sParagraph.substring(iLastSentenceEnd + 1, iPos);
                    iLastSentenceEnd = iPos;
                }
            } else if (this.b_IsAlphanumeric(sNextChar) && bPunctuationIndicatesSentenceEnd) {
                sNextSentence = sParagraph.substring(iLastSentenceEnd + 1, iPos);
                iLastSentenceEnd = iPos - 1;
            }
            if (sNextSentence != "") {
                ++this.igSentenceCount;
                this.sentence[this.igSentenceCount] = new Sentence();
                this.sentence[this.igSentenceCount].setSentence(sNextSentence, this.resources, this.options);
                sNextSentence = "";
                bPunctuationIndicatesSentenceEnd = false;
            }
            ++iPos;
        }
    }

    public int[] getSentimentIDList() {
        if (!this.bSentimentIDListMade) {
            this.makeSentimentIDList();
        }
        return this.igSentimentIDList;
    }

    public String getClassificationRationale() {
        return this.sgClassificationRationale;
    }

    public void makeSentimentIDList() {
        boolean bIsDuplicate = false;
        this.igSentimentIDListCount = 0;
        int i = 1;
        while (i <= this.igSentenceCount) {
            if (this.sentence[i].getSentimentIDList() != null) {
                this.igSentimentIDListCount += this.sentence[i].getSentimentIDList().length;
            }
            ++i;
        }
        if (this.igSentimentIDListCount > 0) {
            this.igSentimentIDList = new int[this.igSentimentIDListCount + 1];
            this.igSentimentIDListCount = 0;
            i = 1;
            while (i <= this.igSentenceCount) {
                int[] sentenceIDList = this.sentence[i].getSentimentIDList();
                if (sentenceIDList != null) {
                    int j = 1;
                    while (j < sentenceIDList.length) {
                        if (sentenceIDList[j] != 0) {
                            bIsDuplicate = false;
                            int k = 1;
                            while (k <= this.igSentimentIDListCount) {
                                if (sentenceIDList[j] == this.igSentimentIDList[k]) {
                                    bIsDuplicate = true;
                                    break;
                                }
                                ++k;
                            }
                            if (!bIsDuplicate) {
                                this.igSentimentIDList[++this.igSentimentIDListCount] = sentenceIDList[j];
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            Sort.quickSortInt(this.igSentimentIDList, 1, this.igSentimentIDListCount);
        }
        this.bSentimentIDListMade = true;
    }

    public String getTaggedParagraph() {
        String sTagged = "";
        int i = 1;
        while (i <= this.igSentenceCount) {
            sTagged = String.valueOf(sTagged) + this.sentence[i].getTaggedSentence();
            ++i;
        }
        return sTagged;
    }

    public String getTranslatedParagraph() {
        String sTranslated = "";
        int i = 1;
        while (i <= this.igSentenceCount) {
            sTranslated = String.valueOf(sTranslated) + this.sentence[i].getTranslatedSentence();
            ++i;
        }
        return sTranslated;
    }

    public void recalculateParagraphSentimentScores() {
        int iSentence = 1;
        while (iSentence <= this.igSentenceCount) {
            this.sentence[iSentence].recalculateSentenceSentimentScore();
            ++iSentence;
        }
        this.calculateParagraphSentimentScores();
    }

    public void reClassifyClassifiedParagraphForSentimentChange(int iSentimentWordID) {
        if (this.igNegativeSentiment == 0) {
            this.calculateParagraphSentimentScores();
            return;
        }
        if (!this.bSentimentIDListMade) {
            this.makeSentimentIDList();
        }
        if (this.igSentimentIDListCount == 0) {
            return;
        }
        if (Sort.i_FindIntPositionInSortedArray(iSentimentWordID, this.igSentimentIDList, 1, this.igSentimentIDListCount) >= 0) {
            int iSentence = 1;
            while (iSentence <= this.igSentenceCount) {
                this.sentence[iSentence].reClassifyClassifiedSentenceForSentimentChange(iSentimentWordID);
                ++iSentence;
            }
            this.calculateParagraphSentimentScores();
        }
    }

    public int getParagraphPositiveSentiment() {
        if (this.igPositiveSentiment == 0) {
            this.calculateParagraphSentimentScores();
        }
        return this.igPositiveSentiment;
    }

    public int getParagraphNegativeSentiment() {
        if (this.igNegativeSentiment == 0) {
            this.calculateParagraphSentimentScores();
        }
        return this.igNegativeSentiment;
    }

    public int getParagraphTrinarySentiment() {
        if (this.igNegativeSentiment == 0) {
            this.calculateParagraphSentimentScores();
        }
        return this.igTrinarySentiment;
    }

    public int getParagraphScaleSentiment() {
        if (this.igNegativeSentiment == 0) {
            this.calculateParagraphSentimentScores();
        }
        return this.igScaleSentiment;
    }

    private boolean b_IsSentenceEndPunctuation(String sChar) {
        return sChar.compareTo(".") == 0 || sChar.compareTo("!") == 0 || sChar.compareTo("?") == 0;
    }

    private boolean b_IsAlphanumeric(String sChar) {
        return sChar.compareToIgnoreCase("a") >= 0 && sChar.compareToIgnoreCase("z") <= 0 || sChar.compareTo("0") >= 0 && sChar.compareTo("9") <= 0 || sChar.compareTo("$") == 0 || sChar.compareTo("\u00a3") == 0 || sChar.compareTo("'") == 0;
    }

    private void calculateParagraphSentimentScores() {
        this.igPositiveSentiment = 1;
        this.igNegativeSentiment = -1;
        this.igTrinarySentiment = 0;
        if (this.options.bgExplainClassification && this.sgClassificationRationale.length() > 0) {
            this.sgClassificationRationale = "";
        }
        int iPosTotal = 0;
        int iPosMax = 0;
        int iNegTotal = 0;
        int iNegMax = 0;
        int iPosTemp = 0;
        int iNegTemp = 0;
        int iSentencesUsed = 0;
        if (this.igSentenceCount == 0) {
            return;
        }
        int iSentence = 1;
        while (iSentence <= this.igSentenceCount) {
            iNegTemp = this.sentence[iSentence].getSentenceNegativeSentiment();
            iPosTemp = this.sentence[iSentence].getSentencePositiveSentiment();
            if (iNegTemp != 0 || iPosTemp != 0) {
                iNegTotal += iNegTemp;
                ++iSentencesUsed;
                if (iNegMax > iNegTemp) {
                    iNegMax = iNegTemp;
                }
                iPosTotal += iPosTemp;
                if (iPosMax < iPosTemp) {
                    iPosMax = iPosTemp;
                }
            }
            if (this.options.bgExplainClassification) {
                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + this.sentence[iSentence].getClassificationRationale() + " ";
            }
            ++iSentence;
        }
        if (iNegTotal == 0 && this.options.igEmotionParagraphCombineMethod != this.options.igCombineTotal) {
            this.igPositiveSentiment = 0;
            this.igNegativeSentiment = 0;
            this.igTrinarySentiment = this.binarySelectionTieBreaker();
            return;
        }
        if (this.options.igEmotionParagraphCombineMethod == this.options.igCombineAverage) {
            this.igPositiveSentiment = (int)((double)((float)iPosTotal / (float)iSentencesUsed) + 0.5);
            this.igNegativeSentiment = (int)((double)((float)iNegTotal / (float)iSentencesUsed) - 0.5);
            if (this.options.bgExplainClassification) {
                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[result = average (" + iPosTotal + " and " + iNegTotal + ") of " + iSentencesUsed + " sentences]";
            }
        } else if (this.options.igEmotionParagraphCombineMethod == this.options.igCombineTotal) {
            this.igPositiveSentiment = iPosTotal;
            this.igNegativeSentiment = iNegTotal;
            if (this.options.bgExplainClassification) {
                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[result: total positive; total negative]";
            }
        } else {
            this.igPositiveSentiment = iPosMax;
            this.igNegativeSentiment = iNegMax;
            if (this.options.bgExplainClassification) {
                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[result: max + and - of any sentence]";
            }
        }
        if (this.options.igEmotionParagraphCombineMethod != this.options.igCombineTotal) {
            if (this.igPositiveSentiment == 0) {
                this.igPositiveSentiment = 1;
            }
            if (this.igNegativeSentiment == 0) {
                this.igNegativeSentiment = -1;
            }
        }
        if (this.options.bgScaleMode) {
            this.igScaleSentiment = this.igPositiveSentiment + this.igNegativeSentiment;
            if (this.options.bgExplainClassification) {
                this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[scale result = sum of pos and neg scores]";
            }
            return;
        }
        if (this.options.igEmotionParagraphCombineMethod == this.options.igCombineTotal) {
            if (this.igPositiveSentiment == 0 && this.igNegativeSentiment == 0) {
                if (this.options.bgBinaryVersionOfTrinaryMode) {
                    this.igTrinarySentiment = this.options.igDefaultBinaryClassification;
                    if (this.options.bgExplainClassification) {
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[binary result set to default value]";
                    }
                } else {
                    this.igTrinarySentiment = 0;
                    if (this.options.bgExplainClassification) {
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[trinary result 0 as pos=1, neg=-1]";
                    }
                }
            } else {
                if ((float)this.igPositiveSentiment > this.options.fgNegativeSentimentMultiplier * (float)(-this.igNegativeSentiment)) {
                    this.igTrinarySentiment = 1;
                    if (this.options.bgExplainClassification) {
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[overall result 1 as pos > -neg * " + this.options.fgNegativeSentimentMultiplier + "]";
                    }
                    return;
                }
                if ((float)this.igPositiveSentiment < this.options.fgNegativeSentimentMultiplier * (float)(-this.igNegativeSentiment)) {
                    this.igTrinarySentiment = -1;
                    if (this.options.bgExplainClassification) {
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[overall result -1 as pos < -neg * " + this.options.fgNegativeSentimentMultiplier + "]";
                    }
                    return;
                }
                if (this.options.bgBinaryVersionOfTrinaryMode) {
                    this.igTrinarySentiment = this.options.igDefaultBinaryClassification;
                    if (this.options.bgExplainClassification) {
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[binary result = default value as pos = -neg * " + this.options.fgNegativeSentimentMultiplier + "]";
                    }
                } else {
                    this.igTrinarySentiment = 0;
                    if (this.options.bgExplainClassification) {
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[trinary result = 0 as pos = -neg * " + this.options.fgNegativeSentimentMultiplier + "]";
                    }
                }
            }
        } else {
            if (this.igPositiveSentiment == 1 && this.igNegativeSentiment == -1) {
                if (this.options.bgBinaryVersionOfTrinaryMode) {
                    this.igTrinarySentiment = this.binarySelectionTieBreaker();
                    if (this.options.bgExplainClassification) {
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[binary result = default value as pos=1 neg=-1]";
                    }
                } else {
                    this.igTrinarySentiment = 0;
                    if (this.options.bgExplainClassification) {
                        this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[trinary result = 0 as pos=1 neg=-1]";
                    }
                }
                return;
            }
            if (this.igPositiveSentiment > -this.igNegativeSentiment) {
                this.igTrinarySentiment = 1;
                if (this.options.bgExplainClassification) {
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[overall result = 1 as pos>-neg]";
                }
                return;
            }
            if (this.igPositiveSentiment < -this.igNegativeSentiment) {
                this.igTrinarySentiment = -1;
                if (this.options.bgExplainClassification) {
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[overall result = -1 as pos<-neg]";
                }
                return;
            }
            int iNegTot = 0;
            int iPosTot = 0;
            int iSentence2 = 1;
            while (iSentence2 <= this.igSentenceCount) {
                iNegTot += this.sentence[iSentence2].getSentenceNegativeSentiment();
                iPosTot = this.sentence[iSentence2].getSentencePositiveSentiment();
                ++iSentence2;
            }
            if (this.options.bgBinaryVersionOfTrinaryMode && iPosTot == -iNegTot) {
                this.igTrinarySentiment = this.binarySelectionTieBreaker();
                if (this.options.bgExplainClassification) {
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[binary result = default as posSentenceTotal>-negSentenceTotal]";
                }
            } else {
                if (this.options.bgExplainClassification) {
                    this.sgClassificationRationale = String.valueOf(this.sgClassificationRationale) + "[overall result = largest of posSentenceTotal, negSentenceTotal]";
                }
                this.igTrinarySentiment = iPosTot > -iNegTot ? 1 : -1;
            }
        }
    }

    private int binarySelectionTieBreaker() {
        if (this.options.igDefaultBinaryClassification == 1 || this.options.igDefaultBinaryClassification == -1) {
            if (this.options.igDefaultBinaryClassification == 1 || this.options.igDefaultBinaryClassification == -1) {
                return this.options.igDefaultBinaryClassification;
            }
            return this.options.igDefaultBinaryClassification;
        }
        if (this.generator.nextDouble() > 0.5) {
            return 1;
        }
        return -1;
    }
}

