/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.utilities.FileOps;
import uk.ac.wlv.utilities.Sort;

public class NegatingWordList {
    private String[] sgNegatingWord;
    private int igNegatingWordCount = 0;
    private int igNegatingWordMax = 0;

    public boolean initialise(String sFilename, ClassificationOptions options) {
        if (this.igNegatingWordMax > 0) {
            return true;
        }
        File f = new File(sFilename);
        if (!f.exists()) {
            System.out.println("Could not find the negating words file: " + sFilename);
            return false;
        }
        this.igNegatingWordMax = FileOps.i_CountLinesInTextFile(sFilename) + 2;
        this.sgNegatingWord = new String[this.igNegatingWordMax];
        this.igNegatingWordCount = 0;
        try {
            String sLine;
            BufferedReader rReader = options.bgForceUTF8 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sFilename), "UTF8")) : new BufferedReader(new FileReader(sFilename));
            while ((sLine = rReader.readLine()) != null) {
                if (sLine == "") continue;
                ++this.igNegatingWordCount;
                this.sgNegatingWord[this.igNegatingWordCount] = sLine;
            }
            rReader.close();
            Sort.quickSortStrings(this.sgNegatingWord, 1, this.igNegatingWordCount);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find negating words file: " + sFilename);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Found negating words file but could not read from it: " + sFilename);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean negatingWord(String sWord) {
        return Sort.i_FindStringPositionInSortedArray(sWord, this.sgNegatingWord, 1, this.igNegatingWordCount) >= 0;
    }
}

