/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import uk.ac.wlv.utilities.FileOps;
import uk.ac.wlv.utilities.Sort;

public class Lemmatiser {
    private String[] sgWord;
    private String[] sgLemma;
    private int igWordLast = -1;

    public boolean initialise(String sFileName, boolean bForceUTF8) {
        int iLinesInFile = 0;
        if (sFileName.equals("")) {
            System.out.println("No lemma file specified!");
            return false;
        }
        File f = new File(sFileName);
        if (!f.exists()) {
            System.out.println("Could not find lemma file: " + sFileName);
            return false;
        }
        iLinesInFile = FileOps.i_CountLinesInTextFile(sFileName);
        if (iLinesInFile < 2) {
            System.out.println("Less than 2 lines in sentiment file: " + sFileName);
            return false;
        }
        this.sgWord = new String[iLinesInFile + 1];
        this.sgLemma = new String[iLinesInFile + 1];
        this.igWordLast = -1;
        try {
            String sLine;
            BufferedReader rReader = bForceUTF8 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sFileName), "UTF8")) : new BufferedReader(new FileReader(sFileName));
            while ((sLine = rReader.readLine()) != null) {
                int iFirstTabLocation;
                if (sLine == "" || (iFirstTabLocation = sLine.indexOf("\t")) < 0) continue;
                int iSecondTabLocation = sLine.indexOf("\t", iFirstTabLocation + 1);
                this.sgWord[++this.igWordLast] = sLine.substring(0, iFirstTabLocation);
                this.sgLemma[this.igWordLast] = iSecondTabLocation > 0 ? sLine.substring(iFirstTabLocation + 1, iSecondTabLocation) : sLine.substring(iFirstTabLocation + 1);
                if (this.sgWord[this.igWordLast].indexOf(" ") >= 0) {
                    this.sgWord[this.igWordLast] = this.sgWord[this.igWordLast].trim();
                }
                if (this.sgLemma[this.igWordLast].indexOf(" ") < 0) continue;
                this.sgLemma[this.igWordLast] = this.sgLemma[this.igWordLast].trim();
            }
            rReader.close();
            Sort.quickSortStringsWithStrings(this.sgWord, this.sgLemma, 0, this.igWordLast);
        }
        catch (FileNotFoundException e) {
            System.out.println("Couldn't find lemma file: " + sFileName);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Found lemma file but couldn't read from it: " + sFileName);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String lemmatise(String sWord) {
        int iLemmaID = Sort.i_FindStringPositionInSortedArray(sWord, this.sgWord, 0, this.igWordLast);
        if (iLemmaID >= 0) {
            return this.sgLemma[iLemmaID];
        }
        return sWord;
    }
}

