/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.utilities.FileOps;
import uk.ac.wlv.utilities.Sort;

public class IronyList {
    private String[] sgIronyTerm;
    private int igIronyTermCount = 0;
    private int igIronyTermMax = 0;

    public boolean termIsIronic(String term) {
        int iIronyTermCount = Sort.i_FindStringPositionInSortedArray(term, this.sgIronyTerm, 1, this.igIronyTermCount);
        return iIronyTermCount >= 0;
    }

    public boolean initialise(String sSourceFile, ClassificationOptions options) {
        if (this.igIronyTermCount > 0) {
            return true;
        }
        File f = new File(sSourceFile);
        if (!f.exists()) {
            return true;
        }
        try {
            String sLine;
            this.igIronyTermMax = FileOps.i_CountLinesInTextFile(sSourceFile) + 2;
            this.igIronyTermCount = 0;
            String[] sIronyTermTemp = new String[this.igIronyTermMax];
            this.sgIronyTerm = sIronyTermTemp;
            BufferedReader rReader = options.bgForceUTF8 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sSourceFile), "UTF8")) : new BufferedReader(new FileReader(sSourceFile));
            while ((sLine = rReader.readLine()) != null) {
                String[] sData;
                if (sLine == "" || (sData = sLine.split("\t")).length <= 0) continue;
                this.sgIronyTerm[++this.igIronyTermCount] = sData[0];
            }
            rReader.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find IronyTerm file: " + sSourceFile);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Found IronyTerm file but could not read from it: " + sSourceFile);
            e.printStackTrace();
            return false;
        }
        Sort.quickSortStrings(this.sgIronyTerm, 1, this.igIronyTermCount);
        return true;
    }
}

