/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.utilities.FileOps;

public class IdiomList {
    public String[] sgIdioms;
    public int[] igIdiomStrength;
    public int igIdiomCount = 0;
    public String[][] sgIdiomWords;
    int[] igIdiomWordCount;

    public boolean initialise(String sFilename, ClassificationOptions options, int iExtraBlankArrayEntriesToInclude) {
        int iLinesInFile = 0;
        int iIdiomStrength = 0;
        if (sFilename == "") {
            return false;
        }
        File f = new File(sFilename);
        if (!f.exists()) {
            System.out.println("Could not find idiom list file: " + sFilename);
            return false;
        }
        iLinesInFile = FileOps.i_CountLinesInTextFile(sFilename);
        this.sgIdioms = new String[iLinesInFile + 2 + iExtraBlankArrayEntriesToInclude];
        this.igIdiomStrength = new int[iLinesInFile + 2 + iExtraBlankArrayEntriesToInclude];
        this.igIdiomCount = 0;
        try {
            String sLine;
            BufferedReader rReader = options.bgForceUTF8 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sFilename), "UTF8")) : new BufferedReader(new FileReader(sFilename));
            while ((sLine = rReader.readLine()) != null) {
                int iFirstTabLocation;
                if (sLine == "" || (iFirstTabLocation = sLine.indexOf("\t")) < 0) continue;
                int iSecondTabLocation = sLine.indexOf("\t", iFirstTabLocation + 1);
                try {
                    iIdiomStrength = iSecondTabLocation > 0 ? Integer.parseInt(sLine.substring(iFirstTabLocation + 1, iSecondTabLocation).trim()) : Integer.parseInt(sLine.substring(iFirstTabLocation + 1).trim());
                    if (iIdiomStrength > 0) {
                        --iIdiomStrength;
                    } else if (iIdiomStrength < 0) {
                        ++iIdiomStrength;
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("Failed to identify integer weight for idiom! Ignoring idiom");
                    System.out.println("Line: " + sLine);
                    iIdiomStrength = 0;
                }
                sLine = sLine.substring(0, iFirstTabLocation);
                if (sLine.indexOf(" ") >= 0) {
                    sLine = sLine.trim();
                }
                if (sLine.indexOf("  ") > 0) {
                    sLine = sLine.replace("  ", " ");
                }
                if (sLine.indexOf("  ") > 0) {
                    sLine = sLine.replace("  ", " ");
                }
                if (sLine == "") continue;
                ++this.igIdiomCount;
                this.sgIdioms[this.igIdiomCount] = sLine;
                this.igIdiomStrength[this.igIdiomCount] = iIdiomStrength;
            }
            rReader.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find idiom list file: " + sFilename);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Found idiom list file but could not read from it: " + sFilename);
            e.printStackTrace();
            return false;
        }
        this.convertIdiomStringsToWordLists();
        return true;
    }

    public boolean addExtraIdiom(String sIdiom, int iIdiomStrength, boolean bConvertIdiomStringsToWordListsAfterAddingIdiom) {
        try {
            ++this.igIdiomCount;
            this.sgIdioms[this.igIdiomCount] = sIdiom;
            if (iIdiomStrength <= 0 && iIdiomStrength < 0) {
                ++iIdiomStrength;
            }
            this.igIdiomStrength[this.igIdiomCount] = --iIdiomStrength;
            if (bConvertIdiomStringsToWordListsAfterAddingIdiom) {
                this.convertIdiomStringsToWordLists();
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Could not add extra idiom: " + sIdiom);
            e.printStackTrace();
            return false;
        }
    }

    public void convertIdiomStringsToWordLists() {
        this.sgIdiomWords = new String[this.igIdiomCount + 1][10];
        this.igIdiomWordCount = new int[this.igIdiomCount + 1];
        int iIdiom = 1;
        while (iIdiom <= this.igIdiomCount) {
            String[] sWordList = this.sgIdioms[iIdiom].split(" ");
            if (sWordList.length >= 9) {
                System.out.println("Ignoring idiom! Too many words in it! (>9): " + this.sgIdioms[iIdiom]);
            } else {
                this.igIdiomWordCount[iIdiom] = sWordList.length;
                int iTerm = 0;
                while (iTerm < sWordList.length) {
                    this.sgIdiomWords[iIdiom][iTerm] = sWordList[iTerm];
                    ++iTerm;
                }
            }
            ++iIdiom;
        }
    }

    public int getIdiomStrength_oldNotUseful(String sPhrase) {
        sPhrase = sPhrase.toLowerCase();
        int i = 1;
        while (i <= this.igIdiomCount) {
            if (sPhrase.indexOf(this.sgIdioms[i]) >= 0) {
                return this.igIdiomStrength[i];
            }
            ++i;
        }
        return 999;
    }

    public String getIdiom(int iIdiomID) {
        if (iIdiomID > 0 && iIdiomID < this.igIdiomCount) {
            return this.sgIdioms[iIdiomID];
        }
        return "";
    }
}

