/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.sentistrength.IdiomList;
import uk.ac.wlv.sentistrength.SentimentWords;
import uk.ac.wlv.utilities.FileOps;

public class EvaluativeTerms {
    private int igObjectEvaluationMax = 0;
    public String[] sgObject;
    public String[] sgObjectEvaluation;
    public int[] igObjectEvaluationStrength;
    public int igObjectEvaluationCount = 0;

    public boolean initialise(String sSourceFile, ClassificationOptions options, IdiomList idiomList, SentimentWords sentimentWords) {
        if (this.igObjectEvaluationCount > 0) {
            return true;
        }
        File f = new File(sSourceFile);
        if (!f.exists()) {
            System.out.println("Could not find additional (object/evaluation) file: " + sSourceFile);
            return false;
        }
        int iStrength = 0;
        boolean bIdiomsAdded = false;
        boolean bSentimentWordsAdded = false;
        try {
            String sLine;
            this.igObjectEvaluationMax = FileOps.i_CountLinesInTextFile(sSourceFile) + 2;
            this.igObjectEvaluationCount = 0;
            this.sgObject = new String[this.igObjectEvaluationMax];
            this.sgObjectEvaluation = new String[this.igObjectEvaluationMax];
            this.igObjectEvaluationStrength = new int[this.igObjectEvaluationMax];
            BufferedReader rReader = options.bgForceUTF8 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sSourceFile), "UTF8")) : new BufferedReader(new FileReader(sSourceFile));
            while ((sLine = rReader.readLine()) != null) {
                if (sLine == "" || sLine.indexOf("##") == 0 || sLine.indexOf("\t") <= 0) continue;
                String[] sData = sLine.split("\t");
                if (sData.length > 2 && sData[2].indexOf("##") != 0) {
                    this.sgObject[++this.igObjectEvaluationCount] = sData[0];
                    this.sgObjectEvaluation[this.igObjectEvaluationCount] = sData[1];
                    try {
                        this.igObjectEvaluationStrength[this.igObjectEvaluationCount] = Integer.parseInt(sData[2].trim());
                        if (this.igObjectEvaluationStrength[this.igObjectEvaluationCount] > 0) {
                            int n = this.igObjectEvaluationCount;
                            this.igObjectEvaluationStrength[n] = this.igObjectEvaluationStrength[n] - 1;
                            continue;
                        }
                        if (this.igObjectEvaluationStrength[this.igObjectEvaluationCount] >= 0) continue;
                        int n = this.igObjectEvaluationCount;
                        this.igObjectEvaluationStrength[n] = this.igObjectEvaluationStrength[n] + 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Failed to identify integer weight for object/evaluation! Ignoring object/evaluation");
                        System.out.println("Line: " + sLine);
                        --this.igObjectEvaluationCount;
                    }
                    continue;
                }
                if (sData[0].indexOf(" ") > 0) {
                    try {
                        iStrength = Integer.parseInt(sData[1].trim());
                        idiomList.addExtraIdiom(sData[0], iStrength, false);
                        bIdiomsAdded = true;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Failed to identify integer weight for idiom in additional file! Ignoring it");
                        System.out.println("Line: " + sLine);
                    }
                    continue;
                }
                try {
                    iStrength = Integer.parseInt(sData[1].trim());
                    sentimentWords.addOrModifySentimentTerm(sData[0], iStrength, false);
                    bSentimentWordsAdded = true;
                }
                catch (NumberFormatException e) {
                    System.out.println("Failed to identify integer weight for sentiment term in additional file! Ignoring it");
                    System.out.println("Line: " + sLine);
                    --this.igObjectEvaluationCount;
                }
            }
            rReader.close();
            if (this.igObjectEvaluationCount > 0) {
                options.bgUseObjectEvaluationTable = true;
            }
            if (bSentimentWordsAdded) {
                sentimentWords.sortSentimentList();
            }
            if (bIdiomsAdded) {
                idiomList.convertIdiomStringsToWordLists();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find additional (object/evaluation) file: " + sSourceFile);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Found additional (object/evaluation) file but could not read from it: " + sSourceFile);
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

