/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.utilities.FileOps;
import uk.ac.wlv.utilities.Sort;

public class EmoticonsList {
    private String[] sgEmoticon;
    private int[] igEmoticonStrength;
    private int igEmoticonCount = 0;
    private int igEmoticonMax = 0;

    public int getEmoticon(String emoticon) {
        int iEmoticon = Sort.i_FindStringPositionInSortedArray(emoticon, this.sgEmoticon, 1, this.igEmoticonCount);
        if (iEmoticon >= 0) {
            return this.igEmoticonStrength[iEmoticon];
        }
        return 999;
    }

    public boolean initialise(String sSourceFile, ClassificationOptions options) {
        if (this.igEmoticonCount > 0) {
            return true;
        }
        File f = new File(sSourceFile);
        if (!f.exists()) {
            System.out.println("Could not find file: " + sSourceFile);
            return false;
        }
        try {
            String sLine;
            this.igEmoticonMax = FileOps.i_CountLinesInTextFile(sSourceFile) + 2;
            this.igEmoticonCount = 0;
            String[] sEmoticonTemp = new String[this.igEmoticonMax];
            this.sgEmoticon = sEmoticonTemp;
            int[] iEmoticonStrengthTemp = new int[this.igEmoticonMax];
            this.igEmoticonStrength = iEmoticonStrengthTemp;
            BufferedReader rReader = options.bgForceUTF8 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sSourceFile), "UTF8")) : new BufferedReader(new FileReader(sSourceFile));
            while ((sLine = rReader.readLine()) != null) {
                String[] sData;
                if (sLine == "" || (sData = sLine.split("\t")).length <= 1) continue;
                ++this.igEmoticonCount;
                this.sgEmoticon[this.igEmoticonCount] = sData[0];
                try {
                    this.igEmoticonStrength[this.igEmoticonCount] = Integer.parseInt(sData[1].trim());
                }
                catch (NumberFormatException e) {
                    System.out.println("Failed to identify integer weight for emoticon! Ignoring emoticon");
                    System.out.println("Line: " + sLine);
                    --this.igEmoticonCount;
                }
            }
            rReader.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find emoticon file: " + sSourceFile);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Found emoticon file but could not read from it: " + sSourceFile);
            e.printStackTrace();
            return false;
        }
        if (this.igEmoticonCount > 1) {
            Sort.quickSortStringsWithInt(this.sgEmoticon, this.igEmoticonStrength, 1, this.igEmoticonCount);
        }
        return true;
    }
}

