/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.utilities.FileOps;
import uk.ac.wlv.utilities.Sort;

public class CorrectSpellingsList {
    private String[] sgCorrectWord;
    private int igCorrectWordCount = 0;
    private int igCorrectWordMax = 0;

    public boolean initialise(String sFilename, ClassificationOptions options) {
        if (this.igCorrectWordMax > 0) {
            return true;
        }
        if (!options.bgCorrectSpellingsUsingDictionary) {
            return true;
        }
        this.igCorrectWordMax = FileOps.i_CountLinesInTextFile(sFilename) + 2;
        this.sgCorrectWord = new String[this.igCorrectWordMax];
        this.igCorrectWordCount = 0;
        File f = new File(sFilename);
        if (!f.exists()) {
            System.out.println("Could not find the spellings file: " + sFilename);
            return false;
        }
        try {
            String sLine;
            BufferedReader rReader = options.bgForceUTF8 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sFilename), "UTF8")) : new BufferedReader(new FileReader(sFilename));
            while ((sLine = rReader.readLine()) != null) {
                if (sLine == "") continue;
                ++this.igCorrectWordCount;
                this.sgCorrectWord[this.igCorrectWordCount] = sLine;
            }
            rReader.close();
            Sort.quickSortStrings(this.sgCorrectWord, 1, this.igCorrectWordCount);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find the spellings file: " + sFilename);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Found spellings file but could not read from it: " + sFilename);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean correctSpelling(String sWord) {
        return Sort.i_FindStringPositionInSortedArray(sWord, this.sgCorrectWord, 1, this.igCorrectWordCount) >= 0;
    }
}

