/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.sentistrength.ClassificationResources;
import uk.ac.wlv.sentistrength.ClassificationStatistics;
import uk.ac.wlv.sentistrength.Paragraph;
import uk.ac.wlv.sentistrength.UnusedTermsClassificationIndex;
import uk.ac.wlv.utilities.FileOps;
import uk.ac.wlv.utilities.Sort;

public class Corpus {
    public ClassificationOptions options = new ClassificationOptions();
    public ClassificationResources resources = new ClassificationResources();
    private Paragraph[] paragraph;
    private int igParagraphCount = 0;
    private int[] igPosCorrect;
    private int[] igNegCorrect;
    private int[] igTrinaryCorrect;
    private int[] igScaleCorrect;
    private int[] igPosClass;
    private int[] igNegClass;
    private int[] igTrinaryClass;
    private int[] igScaleClass;
    private boolean bgCorpusClassified = false;
    private int[] igSentimentIDList;
    private int igSentimentIDListCount = 0;
    private int[] igSentimentIDParagraphCount;
    private boolean bSentimentIDListMade = false;
    UnusedTermsClassificationIndex unusedTermsClassificationIndex = null;
    private boolean[] bgSupcorpusMember;
    int igSupcorpusMemberCount;

    public void indexClassifiedCorpus() {
        this.unusedTermsClassificationIndex = new UnusedTermsClassificationIndex();
        if (this.options.bgScaleMode) {
            this.unusedTermsClassificationIndex.initialise(true, false, false, false);
            int i = 1;
            while (i <= this.igParagraphCount) {
                this.paragraph[i].addParagraphToIndexWithScaleValues(this.unusedTermsClassificationIndex, this.igScaleCorrect[i], this.igScaleClass[i]);
                ++i;
            }
        } else if (this.options.bgTrinaryMode && this.options.bgBinaryVersionOfTrinaryMode) {
            this.unusedTermsClassificationIndex.initialise(false, false, true, false);
            int i = 1;
            while (i <= this.igParagraphCount) {
                this.paragraph[i].addParagraphToIndexWithBinaryValues(this.unusedTermsClassificationIndex, this.igTrinaryCorrect[i], this.igTrinaryClass[i]);
                ++i;
            }
        } else if (this.options.bgTrinaryMode && !this.options.bgBinaryVersionOfTrinaryMode) {
            this.unusedTermsClassificationIndex.initialise(false, false, false, true);
            int i = 1;
            while (i <= this.igParagraphCount) {
                this.paragraph[i].addParagraphToIndexWithTrinaryValues(this.unusedTermsClassificationIndex, this.igTrinaryCorrect[i], this.igTrinaryClass[i]);
                ++i;
            }
        } else {
            this.unusedTermsClassificationIndex.initialise(false, true, false, false);
            int i = 1;
            while (i <= this.igParagraphCount) {
                this.paragraph[i].addParagraphToIndexWithPosNegValues(this.unusedTermsClassificationIndex, this.igPosCorrect[i], this.igPosClass[i], this.igNegCorrect[i], this.igNegClass[i]);
                ++i;
            }
        }
    }

    public void printCorpusUnusedTermsClassificationIndex(String saveFile, int iMinFreq) {
        if (!this.bgCorpusClassified) {
            this.calculateCorpusSentimentScores();
        }
        if (this.unusedTermsClassificationIndex == null) {
            this.indexClassifiedCorpus();
        }
        if (this.options.bgScaleMode) {
            this.unusedTermsClassificationIndex.printIndexWithScaleValues(saveFile, iMinFreq);
        } else if (this.options.bgTrinaryMode && this.options.bgBinaryVersionOfTrinaryMode) {
            this.unusedTermsClassificationIndex.printIndexWithBinaryValues(saveFile, iMinFreq);
        } else if (this.options.bgTrinaryMode && !this.options.bgBinaryVersionOfTrinaryMode) {
            this.unusedTermsClassificationIndex.printIndexWithTrinaryValues(saveFile, iMinFreq);
        } else {
            this.unusedTermsClassificationIndex.printIndexWithPosNegValues(saveFile, iMinFreq);
        }
        System.out.println("Term weights saved to " + saveFile);
    }

    public void setSubcorpus(boolean[] bSubcorpusMember) {
        this.igSupcorpusMemberCount = 0;
        int i = 0;
        while (i <= this.igParagraphCount) {
            if (bSubcorpusMember[i]) {
                this.bgSupcorpusMember[i] = true;
                ++this.igSupcorpusMemberCount;
            } else {
                this.bgSupcorpusMember[i] = false;
            }
            ++i;
        }
    }

    public void useWholeCorpusNotSubcorpus() {
        int i = 0;
        while (i <= this.igParagraphCount) {
            this.bgSupcorpusMember[i] = true;
            ++i;
        }
        this.igSupcorpusMemberCount = this.igParagraphCount;
    }

    public int getCorpusSize() {
        return this.igParagraphCount;
    }

    public boolean setSingleTextAsCorpus(String sText, int iPosCorrect, int iNegCorrect) {
        if (this.resources == null && !this.resources.initialise(this.options)) {
            return false;
        }
        this.igParagraphCount = 2;
        this.paragraph = new Paragraph[this.igParagraphCount];
        this.igPosCorrect = new int[this.igParagraphCount];
        this.igNegCorrect = new int[this.igParagraphCount];
        this.igTrinaryCorrect = new int[this.igParagraphCount];
        this.igScaleCorrect = new int[this.igParagraphCount];
        this.bgSupcorpusMember = new boolean[this.igParagraphCount];
        this.igParagraphCount = 1;
        this.paragraph[this.igParagraphCount] = new Paragraph();
        this.paragraph[this.igParagraphCount].setParagraph(sText, this.resources, this.options);
        this.igPosCorrect[this.igParagraphCount] = iPosCorrect;
        if (iNegCorrect < 0) {
            iNegCorrect *= -1;
        }
        this.igNegCorrect[this.igParagraphCount] = iNegCorrect;
        this.useWholeCorpusNotSubcorpus();
        return true;
    }

    public boolean setCorpus(String sInFilenameAndPath) {
        if (this.resources == null && !this.resources.initialise(this.options)) {
            return false;
        }
        this.igParagraphCount = FileOps.i_CountLinesInTextFile(sInFilenameAndPath) + 1;
        if (this.igParagraphCount <= 2) {
            this.igParagraphCount = 0;
            return false;
        }
        this.paragraph = new Paragraph[this.igParagraphCount];
        this.igPosCorrect = new int[this.igParagraphCount];
        this.igNegCorrect = new int[this.igParagraphCount];
        this.igTrinaryCorrect = new int[this.igParagraphCount];
        this.igScaleCorrect = new int[this.igParagraphCount];
        this.bgSupcorpusMember = new boolean[this.igParagraphCount];
        this.igParagraphCount = 0;
        try {
            String sLine;
            BufferedReader rReader = new BufferedReader(new FileReader(sInFilenameAndPath));
            if (rReader.ready() && this.options.bgSkipHeaderLine) {
                String string = rReader.readLine();
            }
            while ((sLine = rReader.readLine()) != null) {
                if (sLine == "") continue;
                this.paragraph[++this.igParagraphCount] = new Paragraph();
                int iLastTabPos = sLine.lastIndexOf("\t");
                int iFirstTabPos = sLine.indexOf("\t");
                if (iFirstTabPos < iLastTabPos || iFirstTabPos > 0 && (this.options.bgTrinaryMode || this.options.bgScaleMode)) {
                    this.paragraph[this.igParagraphCount].setParagraph(sLine.substring(iLastTabPos + 1), this.resources, this.options);
                    if (this.options.bgTrinaryMode) {
                        try {
                            this.igTrinaryCorrect[this.igParagraphCount] = Integer.parseInt(sLine.substring(0, iFirstTabPos).trim());
                        }
                        catch (Exception e) {
                            System.out.println("Trinary classification could not be read and will be ignored!: " + sLine);
                            this.igTrinaryCorrect[this.igParagraphCount] = 999;
                        }
                        if (this.igTrinaryCorrect[this.igParagraphCount] > 1 || this.igTrinaryCorrect[this.igParagraphCount] < -1) {
                            System.out.println("Trinary classification out of bounds and will be ignored!: " + sLine);
                            --this.igParagraphCount;
                            continue;
                        }
                        if (!this.options.bgBinaryVersionOfTrinaryMode || this.igTrinaryCorrect[this.igParagraphCount] != 0) continue;
                        System.out.println("Warning, unexpected 0 in binary classification!: " + sLine);
                        continue;
                    }
                    if (this.options.bgScaleMode) {
                        try {
                            this.igScaleCorrect[this.igParagraphCount] = Integer.parseInt(sLine.substring(0, iFirstTabPos).trim());
                        }
                        catch (Exception e) {
                            System.out.println("Scale classification could not be read and will be ignored!: " + sLine);
                            this.igScaleCorrect[this.igParagraphCount] = 999;
                        }
                        if (this.igScaleCorrect[this.igParagraphCount] <= 4 && this.igTrinaryCorrect[this.igParagraphCount] >= -4) continue;
                        System.out.println("Scale classification out of bounds (-4 to +4) and will be ignored!: " + sLine);
                        --this.igParagraphCount;
                        continue;
                    }
                    try {
                        this.igPosCorrect[this.igParagraphCount] = Integer.parseInt(sLine.substring(0, iFirstTabPos).trim());
                        this.igNegCorrect[this.igParagraphCount] = Integer.parseInt(sLine.substring(iFirstTabPos + 1, iLastTabPos).trim());
                        if (this.igNegCorrect[this.igParagraphCount] < 0) {
                            this.igNegCorrect[this.igParagraphCount] = -this.igNegCorrect[this.igParagraphCount];
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Positive or negative classification could not be read and will be ignored!: " + sLine);
                        this.igPosCorrect[this.igParagraphCount] = 0;
                    }
                    if (this.igPosCorrect[this.igParagraphCount] > 5 || this.igPosCorrect[this.igParagraphCount] < 1) {
                        System.out.println("Warning, positive classification out of bounds and line will be ignored!: " + sLine);
                        --this.igParagraphCount;
                        continue;
                    }
                    if (this.igNegCorrect[this.igParagraphCount] <= 5 && this.igNegCorrect[this.igParagraphCount] >= 1) continue;
                    System.out.println("Warning, negative classification out of bounds (must be 1,2,3,4, or 5, with or without -) and line will be ignored!: " + sLine);
                    --this.igParagraphCount;
                    continue;
                }
                if (iFirstTabPos >= 0) {
                    if (this.options.bgTrinaryMode) {
                        this.igTrinaryCorrect[this.igParagraphCount] = Integer.parseInt(sLine.substring(0, iFirstTabPos).trim());
                    }
                    sLine = sLine.substring(iFirstTabPos + 1);
                } else if (this.options.bgTrinaryMode) {
                    this.igTrinaryCorrect[this.igParagraphCount] = 0;
                }
                this.paragraph[this.igParagraphCount].setParagraph(sLine, this.resources, this.options);
                this.igPosCorrect[this.igParagraphCount] = 0;
                this.igNegCorrect[this.igParagraphCount] = 0;
            }
            rReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.useWholeCorpusNotSubcorpus();
        System.out.println("Number of texts in corpus: " + this.igParagraphCount);
        return true;
    }

    public boolean initialise() {
        return this.resources.initialise(this.options);
    }

    public void reCalculateCorpusSentimentScores() {
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (this.bgSupcorpusMember[i]) {
                this.paragraph[i].recalculateParagraphSentimentScores();
            }
            ++i;
        }
        this.calculateCorpusSentimentScores();
    }

    public int getCorpusMemberPositiveSentimentScore(int i) {
        if (i < 1 || i > this.igParagraphCount) {
            return 0;
        }
        return this.paragraph[i].getParagraphPositiveSentiment();
    }

    public int getCorpusMemberNegativeSentimentScore(int i) {
        if (i < 1 || i > this.igParagraphCount) {
            return 0;
        }
        return this.paragraph[i].getParagraphNegativeSentiment();
    }

    public void calculateCorpusSentimentScores() {
        if (this.igParagraphCount == 0) {
            return;
        }
        if (this.igPosClass == null || this.igPosClass.length < this.igPosCorrect.length) {
            this.igPosClass = new int[this.igParagraphCount + 1];
            this.igNegClass = new int[this.igParagraphCount + 1];
            this.igTrinaryClass = new int[this.igParagraphCount + 1];
            this.igScaleClass = new int[this.igParagraphCount + 1];
        }
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (this.bgSupcorpusMember[i]) {
                this.igPosClass[i] = this.paragraph[i].getParagraphPositiveSentiment();
                this.igNegClass[i] = this.paragraph[i].getParagraphNegativeSentiment();
                if (this.options.bgTrinaryMode) {
                    this.igTrinaryClass[i] = this.paragraph[i].getParagraphTrinarySentiment();
                }
                if (this.options.bgScaleMode) {
                    this.igScaleClass[i] = this.paragraph[i].getParagraphScaleSentiment();
                }
            }
            ++i;
        }
        this.bgCorpusClassified = true;
    }

    public void reClassifyClassifiedCorpusForSentimentChange(int iSentimentWordID, int iMinParasToContainWord) {
        int iSentimentWordIDArrayPos;
        if (this.igParagraphCount == 0) {
            return;
        }
        if (!this.bSentimentIDListMade) {
            this.makeSentimentIDListForCompleteCorpusIgnoringSubcorpus();
        }
        if ((iSentimentWordIDArrayPos = Sort.i_FindIntPositionInSortedArray(iSentimentWordID, this.igSentimentIDList, 1, this.igSentimentIDListCount)) == -1 || this.igSentimentIDParagraphCount[iSentimentWordIDArrayPos] < iMinParasToContainWord) {
            return;
        }
        this.igPosClass = new int[this.igParagraphCount + 1];
        this.igNegClass = new int[this.igParagraphCount + 1];
        if (this.options.bgTrinaryMode) {
            this.igTrinaryClass = new int[this.igParagraphCount + 1];
        }
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (this.bgSupcorpusMember[i]) {
                this.paragraph[i].reClassifyClassifiedParagraphForSentimentChange(iSentimentWordID);
                this.igPosClass[i] = this.paragraph[i].getParagraphPositiveSentiment();
                this.igNegClass[i] = this.paragraph[i].getParagraphNegativeSentiment();
                if (this.options.bgTrinaryMode) {
                    this.igTrinaryClass[i] = this.paragraph[i].getParagraphTrinarySentiment();
                }
                if (this.options.bgScaleMode) {
                    this.igScaleClass[i] = this.paragraph[i].getParagraphScaleSentiment();
                }
            }
            ++i;
        }
        this.bgCorpusClassified = true;
    }

    public boolean printCorpusSentimentScores(String sOutFilenameAndPath) {
        if (!this.bgCorpusClassified) {
            this.calculateCorpusSentimentScores();
        }
        try {
            BufferedWriter wWriter = new BufferedWriter(new FileWriter(sOutFilenameAndPath));
            wWriter.write("Correct+\tCorrect-\tPredict+\tPredict-\tText\n");
            int i = 1;
            while (i <= this.igParagraphCount) {
                if (this.bgSupcorpusMember[i]) {
                    wWriter.write(String.valueOf(this.igPosCorrect[i]) + "\t" + this.igNegCorrect[i] + "\t" + this.igPosClass[i] + "\t" + this.igNegClass[i] + "\t" + this.paragraph[i].getTaggedParagraph() + "\n");
                }
                ++i;
            }
            wWriter.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public float getClassificationPositiveAccuracyProportion() {
        if (this.igSupcorpusMemberCount == 0) {
            return 0.0f;
        }
        return (float)this.getClassificationPositiveNumberCorrect() / (float)this.igSupcorpusMemberCount;
    }

    public float getClassificationNegativeAccuracyProportion() {
        if (this.igSupcorpusMemberCount == 0) {
            return 0.0f;
        }
        return (float)this.getClassificationNegativeNumberCorrect() / (float)this.igSupcorpusMemberCount;
    }

    public double getBaselineNegativeAccuracyProportion() {
        if (this.igParagraphCount == 0) {
            return 0.0;
        }
        return ClassificationStatistics.baselineAccuracyMajorityClassProportion(this.igNegCorrect, this.igParagraphCount);
    }

    public double getBaselinePositiveAccuracyProportion() {
        if (this.igParagraphCount == 0) {
            return 0.0;
        }
        return ClassificationStatistics.baselineAccuracyMajorityClassProportion(this.igPosCorrect, this.igParagraphCount);
    }

    public int getClassificationNegativeNumberCorrect() {
        if (this.igParagraphCount == 0) {
            return 0;
        }
        int iMatches = 0;
        if (!this.bgCorpusClassified) {
            this.calculateCorpusSentimentScores();
        }
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (this.bgSupcorpusMember[i] && this.igNegCorrect[i] == -this.igNegClass[i]) {
                ++iMatches;
            }
            ++i;
        }
        return iMatches;
    }

    public int getClassificationPositiveNumberCorrect() {
        if (this.igParagraphCount == 0) {
            return 0;
        }
        int iMatches = 0;
        if (!this.bgCorpusClassified) {
            this.calculateCorpusSentimentScores();
        }
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (this.bgSupcorpusMember[i] && this.igPosCorrect[i] == this.igPosClass[i]) {
                ++iMatches;
            }
            ++i;
        }
        return iMatches;
    }

    public double getClassificationPositiveMeanDifference() {
        if (this.igParagraphCount == 0) {
            return 0.0;
        }
        double fTotalDiff = 0.0;
        int iTotal = 0;
        if (!this.bgCorpusClassified) {
            this.calculateCorpusSentimentScores();
        }
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (this.bgSupcorpusMember[i]) {
                fTotalDiff += Math.abs((double)(this.igPosCorrect[i] - this.igPosClass[i]));
                ++iTotal;
            }
            ++i;
        }
        if (iTotal > 0) {
            return fTotalDiff / (double)iTotal;
        }
        return 0.0;
    }

    public int getClassificationPositiveTotalDifference() {
        if (this.igParagraphCount == 0) {
            return 0;
        }
        int iTotalDiff = 0;
        if (!this.bgCorpusClassified) {
            this.calculateCorpusSentimentScores();
        }
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (this.bgSupcorpusMember[i]) {
                iTotalDiff += Math.abs(this.igPosCorrect[i] - this.igPosClass[i]);
            }
            ++i;
        }
        return iTotalDiff;
    }

    public int getClassificationTrinaryNumberCorrect() {
        if (this.igParagraphCount == 0) {
            return 0;
        }
        int iTrinaryCorrect = 0;
        if (!this.bgCorpusClassified) {
            this.calculateCorpusSentimentScores();
        }
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (this.bgSupcorpusMember[i] && this.igTrinaryCorrect[i] == this.igTrinaryClass[i]) {
                ++iTrinaryCorrect;
            }
            ++i;
        }
        return iTrinaryCorrect;
    }

    public float getClassificationScaleCorrelationWholeCorpus() {
        if (this.igParagraphCount == 0) {
            return 0.0f;
        }
        return (float)ClassificationStatistics.correlation(this.igScaleCorrect, this.igScaleClass, this.igParagraphCount);
    }

    public float getClassificationScaleMADWholeCorpus() {
        if (this.igParagraphCount == 0) {
            return 0.0f;
        }
        return (float)ClassificationStatistics.meanAbsoluteDeviation(this.igScaleCorrect, this.igScaleClass, this.igParagraphCount, false);
    }

    public float getClassificationScaleMeanPredictedMinusHumanWholeCorpus() {
        if (this.igParagraphCount == 0) {
            return 0.0f;
        }
        return (float)ClassificationStatistics.meanDeviation(this.igScaleCorrect, this.igScaleClass, this.igParagraphCount, false);
    }

    public float getClassificationScaleAccuracyProportion() {
        if (this.igSupcorpusMemberCount == 0) {
            return 0.0f;
        }
        return (float)this.getClassificationScaleNumberCorrect() / (float)this.igSupcorpusMemberCount;
    }

    public float getClassificationPosCorrelationWholeCorpus() {
        if (this.igParagraphCount == 0) {
            return 0.0f;
        }
        return (float)ClassificationStatistics.correlationAbs(this.igPosCorrect, this.igPosClass, this.igParagraphCount);
    }

    public float getClassificationNegCorrelationWholeCorpus() {
        if (this.igParagraphCount == 0) {
            return 0.0f;
        }
        return (float)ClassificationStatistics.correlationAbs(this.igNegCorrect, this.igNegClass, this.igParagraphCount);
    }

    public int getClassificationScaleNumberCorrect() {
        if (this.igParagraphCount == 0) {
            return 0;
        }
        int iScaleCorrect = 0;
        if (!this.bgCorpusClassified) {
            this.calculateCorpusSentimentScores();
        }
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (this.bgSupcorpusMember[i] && this.igScaleCorrect[i] == this.igScaleClass[i]) {
                ++iScaleCorrect;
            }
            ++i;
        }
        return iScaleCorrect;
    }

    public int getClassificationNegativeTotalDifference() {
        if (this.igParagraphCount == 0) {
            return 0;
        }
        int iTotalDiff = 0;
        if (!this.bgCorpusClassified) {
            this.calculateCorpusSentimentScores();
        }
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (this.bgSupcorpusMember[i]) {
                iTotalDiff += Math.abs(this.igNegCorrect[i] + this.igNegClass[i]);
            }
            ++i;
        }
        return iTotalDiff;
    }

    public double getClassificationNegativeMeanDifference() {
        if (this.igParagraphCount == 0) {
            return 0.0;
        }
        double fTotalDiff = 0.0;
        int iTotal = 0;
        if (!this.bgCorpusClassified) {
            this.calculateCorpusSentimentScores();
        }
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (this.bgSupcorpusMember[i]) {
                fTotalDiff += Math.abs((double)(this.igNegCorrect[i] + this.igNegClass[i]));
                ++iTotal;
            }
            ++i;
        }
        if (iTotal > 0) {
            return fTotalDiff / (double)iTotal;
        }
        return 0.0;
    }

    public boolean printClassificationResultsSummary_NOT_DONE(String sOutFilenameAndPath) {
        if (!this.bgCorpusClassified) {
            this.calculateCorpusSentimentScores();
        }
        try {
            BufferedWriter wWriter = new BufferedWriter(new FileWriter(sOutFilenameAndPath));
            int i = 1;
            while (i <= this.igParagraphCount) {
                boolean cfr_ignored_0 = this.bgSupcorpusMember[i];
                ++i;
            }
            wWriter.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void makeSentimentIDListForCompleteCorpusIgnoringSubcorpus() {
        this.igSentimentIDListCount = 0;
        int i = 1;
        while (i <= this.igParagraphCount) {
            this.paragraph[i].makeSentimentIDList();
            if (this.paragraph[i].getSentimentIDList() != null) {
                this.igSentimentIDListCount += this.paragraph[i].getSentimentIDList().length;
            }
            ++i;
        }
        if (this.igSentimentIDListCount > 0) {
            int j;
            int[] sentenceIDList;
            this.igSentimentIDList = new int[this.igSentimentIDListCount + 1];
            this.igSentimentIDParagraphCount = new int[this.igSentimentIDListCount + 1];
            this.igSentimentIDListCount = 0;
            i = 1;
            while (i <= this.igParagraphCount) {
                sentenceIDList = this.paragraph[i].getSentimentIDList();
                if (sentenceIDList != null) {
                    j = 0;
                    while (j < sentenceIDList.length) {
                        if (sentenceIDList[j] != 0) {
                            this.igSentimentIDList[++this.igSentimentIDListCount] = sentenceIDList[j];
                        }
                        ++j;
                    }
                }
                ++i;
            }
            Sort.quickSortInt(this.igSentimentIDList, 1, this.igSentimentIDListCount);
            i = 1;
            while (i <= this.igParagraphCount) {
                sentenceIDList = this.paragraph[i].getSentimentIDList();
                if (sentenceIDList != null) {
                    j = 0;
                    while (j < sentenceIDList.length) {
                        if (sentenceIDList[j] != 0) {
                            int n = Sort.i_FindIntPositionInSortedArray(sentenceIDList[j], this.igSentimentIDList, 1, this.igSentimentIDListCount);
                            this.igSentimentIDParagraphCount[n] = this.igSentimentIDParagraphCount[n] + 1;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.bSentimentIDListMade = true;
    }

    private void run10FoldCrossValidationMultipleTimes(int iMinImprovement, boolean bUseTotalDifference, int iReplications, int iMultiOptimisations, BufferedWriter sWriter, BufferedWriter wTermStrengthWriter) {
        int i = 1;
        while (i <= iReplications) {
            this.run10FoldCrossValidationOnce(iMinImprovement, bUseTotalDifference, iMultiOptimisations, sWriter, wTermStrengthWriter);
            ++i;
        }
        System.out.println("Set of " + iReplications + " 10-fold cross validations finished");
    }

    public void run10FoldCrossValidationMultipleTimes(int iMinImprovement, boolean bUseTotalDifference, int iReplications, int iMultiOptimisations, String sOutFileName) {
        try {
            BufferedWriter wWriter = new BufferedWriter(new FileWriter(sOutFileName));
            BufferedWriter wTermStrengthWriter = new BufferedWriter(new FileWriter(String.valueOf(FileOps.s_ChopFileNameExtension(sOutFileName)) + "_termStrVars.txt"));
            this.options.printClassificationOptionsHeadings(wWriter);
            this.writeClassificationStatsHeadings(wWriter);
            this.options.printClassificationOptionsHeadings(wTermStrengthWriter);
            this.resources.sentimentWords.printSentimentTermsInSingleHeaderRow(wTermStrengthWriter);
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wWriter, wTermStrengthWriter);
            wWriter.close();
            wTermStrengthWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public void classifyAllLinesAndRecordWithID(String sInputFile, int iTextCol, int iIDCol, String sOutputFile) {
        int iPos = 0;
        int iNeg = 0;
        int iTrinary = -3;
        int iScale = -10;
        int iCount1 = 0;
        String sLine = "";
        try {
            int character;
            BufferedReader rReader = new BufferedReader(new FileReader(sInputFile));
            BufferedWriter wWriter = new BufferedWriter(new FileWriter(sOutputFile));
            while (rReader.ready()) {
                String[] sData;
                sLine = rReader.readLine();
                ++iCount1;
                if (sLine == "" || (sData = sLine.split("\t")).length <= iTextCol || sData.length <= iIDCol) continue;
                Paragraph paragraph = new Paragraph();
                paragraph.setParagraph(sData[iTextCol], this.resources, this.options);
                if (this.options.bgTrinaryMode) {
                    iTrinary = paragraph.getParagraphTrinarySentiment();
                    wWriter.write(String.valueOf(sData[iIDCol]) + "\t" + iTrinary + "\n");
                    continue;
                }
                if (this.options.bgScaleMode) {
                    iScale = paragraph.getParagraphScaleSentiment();
                    wWriter.write(String.valueOf(sData[iIDCol]) + "\t" + iScale + "\n");
                    continue;
                }
                iPos = paragraph.getParagraphPositiveSentiment();
                iNeg = paragraph.getParagraphNegativeSentiment();
                wWriter.write(String.valueOf(sData[iIDCol]) + "\t" + iPos + "\t" + iNeg + "\n");
            }
            Thread.sleep(10L);
            if (rReader.ready()) {
                System.out.println("Reader ready again after pause!");
            }
            if ((character = rReader.read()) != -1) {
                System.out.println("Reader returns char after reader.read() false! " + character);
            }
            rReader.close();
            wWriter.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find input file: " + sInputFile);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Error reading or writing from file: " + sInputFile);
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Error reading from or writing to file: " + sInputFile);
            e.printStackTrace();
        }
        System.out.println("Processed " + iCount1 + " lines from file: " + sInputFile + ". Last line was:\n" + sLine);
    }

    public void annotateAllLinesInInputFile(String sInputFile, int iTextCol) {
        int iPos = 0;
        int iNeg = 0;
        int iTrinary = -3;
        int iScale = -10;
        String sTempFile = String.valueOf(sInputFile) + "_temp";
        try {
            BufferedReader rReader = new BufferedReader(new FileReader(sInputFile));
            BufferedWriter wWriter = new BufferedWriter(new FileWriter(sTempFile));
            while (rReader.ready()) {
                String sLine = rReader.readLine();
                if (sLine == "") continue;
                String[] sData = sLine.split("\t");
                if (sData.length > iTextCol) {
                    Paragraph paragraph = new Paragraph();
                    paragraph.setParagraph(sData[iTextCol], this.resources, this.options);
                    if (this.options.bgTrinaryMode) {
                        iTrinary = paragraph.getParagraphTrinarySentiment();
                        wWriter.write(String.valueOf(sLine) + "\t" + iTrinary + "\n");
                        continue;
                    }
                    if (this.options.bgScaleMode) {
                        iScale = paragraph.getParagraphScaleSentiment();
                        wWriter.write(String.valueOf(sLine) + "\t" + iScale + "\n");
                        continue;
                    }
                    iPos = paragraph.getParagraphPositiveSentiment();
                    iNeg = paragraph.getParagraphNegativeSentiment();
                    wWriter.write(String.valueOf(sLine) + "\t" + iPos + "\t" + iNeg + "\n");
                    continue;
                }
                wWriter.write(String.valueOf(sLine) + "\n");
            }
            rReader.close();
            wWriter.close();
            File original = new File(sInputFile);
            original.delete();
            File newFile = new File(sTempFile);
            newFile.renameTo(original);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find input file: " + sInputFile);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Error reading or writing from file: " + sInputFile);
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Error reading from or writing to file: " + sInputFile);
            e.printStackTrace();
        }
    }

    public void classifyAllLinesInInputFile(String sInputFile, int iTextCol, String sOutputFile, String sStatsFile) {
        int iPos = 0;
        int iNeg = 0;
        int iTrinary = -3;
        int iScale = -10;
        int iFileTrinary = -2;
        int iFileScale = -9;
        int iClassified = 0;
        int iCorrectPosCount = 0;
        int iCorrectNegCount = 0;
        int iCorrectTrinaryCount = 0;
        int iScaleDiff = 0;
        int iScaleAbsDiff = 0;
        int iCorrectScaleCount = 0;
        int iPosAbsDiff = 0;
        int iNegAbsDiff = 0;
        int[][] confusion = new int[][]{new int[3], new int[3], new int[3]};
        int[][] confusionPos = new int[][]{new int[5], new int[5], new int[5], new int[5], new int[5]};
        int[][] confusionNeg = new int[][]{new int[5], new int[5], new int[5], new int[5], new int[5]};
        int[][] confusionScale = new int[][]{new int[9], new int[9], new int[9], new int[9], new int[9], new int[9], new int[9], new int[9], new int[9]};
        int maxClassifyForCorrelation = 20000;
        int[] iPosClassCorr = new int[maxClassifyForCorrelation];
        int[] iNegClassCorr = new int[maxClassifyForCorrelation];
        int[] iPosClassPred = new int[maxClassifyForCorrelation];
        int[] iNegClassPred = new int[maxClassifyForCorrelation];
        int[] iScaleClassCorr = new int[maxClassifyForCorrelation];
        int[] iScaleClassPred = new int[maxClassifyForCorrelation];
        String sRationale = "";
        String sOutput = "";
        try {
            BufferedReader rReader;
            BufferedWriter wWriter;
            if (this.options.bgForceUTF8) {
                wWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sOutputFile), "UTF8"));
                rReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sInputFile), "UTF8"));
            } else {
                wWriter = new BufferedWriter(new FileWriter(sOutputFile));
                rReader = new BufferedReader(new FileReader(sInputFile));
            }
            if (this.options.bgTrinaryMode || this.options.bgScaleMode) {
                wWriter.write("Overall\tText");
            } else if (this.options.bgTensiStrength) {
                wWriter.write("Relax\tStress\tText");
            } else {
                wWriter.write("Positive\tNegative\tText");
            }
            if (this.options.bgExplainClassification) {
                wWriter.write("\tExplanation\n");
            } else {
                wWriter.write("\n");
            }
            while (rReader.ready()) {
                String sLine = rReader.readLine();
                if (sLine == "") continue;
                int iTabPos = sLine.lastIndexOf("\t");
                int iFilePos = 0;
                int iFileNeg = 0;
                if (iTabPos >= 0) {
                    String[] sData = sLine.split("\t");
                    if (sData.length > 1) {
                        if (iTextCol > -1) {
                            wWriter.write(String.valueOf(sLine) + "\t");
                            if (iTextCol < sData.length) {
                                sLine = sData[iTextCol];
                            }
                        } else if (this.options.bgTrinaryMode) {
                            iFileTrinary = -2;
                            try {
                                iFileTrinary = Integer.parseInt(sData[0].trim());
                                if (iFileTrinary > 1 || iFileTrinary < -1) {
                                    System.out.println("Invalid trinary sentiment " + iFileTrinary + " (expected -1,0,1) at line: " + sLine);
                                    iFileTrinary = 0;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if (this.options.bgScaleMode) {
                            iFileScale = -9;
                            try {
                                iFileScale = Integer.parseInt(sData[0].trim());
                                if (iFileScale > 4 || iFileScale < -4) {
                                    System.out.println("Invalid overall sentiment " + iFileScale + " (expected -4 to +4) at line: " + sLine);
                                    iFileScale = 0;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            try {
                                iFilePos = Integer.parseInt(sData[0].trim());
                                iFileNeg = Integer.parseInt(sData[1].trim());
                                if (iFileNeg < 0) {
                                    iFileNeg = -iFileNeg;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    sLine = sLine.substring(iTabPos + 1);
                }
                Paragraph paragraph = new Paragraph();
                paragraph.setParagraph(sLine, this.resources, this.options);
                if (this.options.bgTrinaryMode) {
                    iTrinary = paragraph.getParagraphTrinarySentiment();
                    if (this.options.bgExplainClassification) {
                        sRationale = "\t" + paragraph.getClassificationRationale();
                    }
                    sOutput = String.valueOf(iTrinary) + "\t" + sLine + sRationale + "\n";
                } else if (this.options.bgScaleMode) {
                    iScale = paragraph.getParagraphScaleSentiment();
                    if (this.options.bgExplainClassification) {
                        sRationale = "\t" + paragraph.getClassificationRationale();
                    }
                    sOutput = String.valueOf(iScale) + "\t" + sLine + sRationale + "\n";
                } else {
                    iPos = paragraph.getParagraphPositiveSentiment();
                    iNeg = paragraph.getParagraphNegativeSentiment();
                    if (this.options.bgExplainClassification) {
                        sRationale = "\t" + paragraph.getClassificationRationale();
                    }
                    sOutput = String.valueOf(iPos) + "\t" + iNeg + "\t" + sLine + sRationale + "\n";
                }
                wWriter.write(sOutput);
                if (this.options.bgTrinaryMode) {
                    if (iFileTrinary <= -2 || iFileTrinary >= 2 || iTrinary <= -2 || iTrinary >= 2) continue;
                    ++iClassified;
                    if (iFileTrinary == iTrinary) {
                        ++iCorrectTrinaryCount;
                    }
                    int[] nArray = confusion[iTrinary + 1];
                    int n = iFileTrinary + 1;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                if (this.options.bgScaleMode) {
                    if (iFileScale <= -9) continue;
                    ++iClassified;
                    if (iFileScale == iScale) {
                        ++iCorrectScaleCount;
                    }
                    if (iClassified < maxClassifyForCorrelation) {
                        iScaleClassCorr[iClassified] = iFileScale;
                        iScaleClassPred[iClassified] = iScale;
                    }
                    iScaleDiff += iScale - iFileScale;
                    iScaleAbsDiff += Math.abs(iScale - iFileScale);
                    int[] nArray = confusionScale[iScale + 4];
                    int n = iFileScale + 4;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                if (iFileNeg == 0) continue;
                ++iClassified;
                if (iPos == iFilePos) {
                    ++iCorrectPosCount;
                }
                iPosAbsDiff += Math.abs(iPos - iFilePos);
                if (iClassified < maxClassifyForCorrelation) {
                    iPosClassCorr[iClassified] = iFilePos;
                    iPosClassPred[iClassified] = iPos;
                }
                if (iNeg == -iFileNeg) {
                    ++iCorrectNegCount;
                }
                iNegAbsDiff += Math.abs(iNeg + iFileNeg);
                if (iClassified < maxClassifyForCorrelation) {
                    iNegClassCorr[iClassified] = iFileNeg;
                    iNegClassPred[iClassified] = iNeg;
                }
                int[] nArray = confusionPos[iPos - 1];
                int n = iFilePos - 1;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = confusionNeg[Math.abs(iNeg) - 1];
                int n2 = Math.abs(iFileNeg) - 1;
                nArray2[n2] = nArray2[n2] + 1;
            }
            rReader.close();
            wWriter.close();
            if (iClassified > 0) {
                if (this.options.bgTrinaryMode) {
                    System.out.println("Trinary correct: " + iCorrectTrinaryCount + " (" + (float)iCorrectTrinaryCount / (float)iClassified * 100.0f + "%).");
                    System.out.println("Correct -> -1   0   1");
                    System.out.println("Est = -1   " + confusion[0][0] + " " + confusion[0][1] + " " + confusion[0][2]);
                    System.out.println("Est =  0   " + confusion[1][0] + " " + confusion[1][1] + " " + confusion[1][2]);
                    System.out.println("Est =  1   " + confusion[2][0] + " " + confusion[2][1] + " " + confusion[2][2]);
                } else if (this.options.bgScaleMode) {
                    System.out.println("Scale correct: " + iCorrectScaleCount + " (" + (float)iCorrectScaleCount / (float)iClassified * 100.0f + "%) out of " + iClassified);
                    System.out.println("Correlation: " + ClassificationStatistics.correlationConfusion(confusionScale, 8));
                    System.out.println("Mean abs diff: " + (float)iScaleAbsDiff / (float)iClassified);
                    System.out.println("Mean diff (predicted - file value): " + (float)iScaleDiff / (float)iClassified);
                    System.out.println("Correct -> x -4  -3  -2  -1   0   1   2   3   4");
                    System.out.println("Est = -4   " + confusionScale[0][0] + " " + confusionScale[0][1] + " " + confusionScale[0][2] + " " + confusionScale[0][3] + " " + confusionScale[0][4] + " " + confusionScale[0][5] + " " + confusionScale[0][6] + " " + confusionScale[0][7] + " " + confusionScale[0][8]);
                    System.out.println("Est = -3   " + confusionScale[1][0] + " " + confusionScale[1][1] + " " + confusionScale[1][2] + " " + confusionScale[1][3] + " " + confusionScale[1][4] + " " + confusionScale[1][5] + " " + confusionScale[1][6] + " " + confusionScale[1][7] + " " + confusionScale[1][8]);
                    System.out.println("Est = -2   " + confusionScale[2][0] + " " + confusionScale[2][1] + " " + confusionScale[2][2] + " " + confusionScale[2][3] + " " + confusionScale[2][4] + " " + confusionScale[2][5] + " " + confusionScale[2][6] + " " + confusionScale[2][7] + " " + confusionScale[2][8]);
                    System.out.println("Est = -1   " + confusionScale[3][0] + " " + confusionScale[3][1] + " " + confusionScale[3][2] + " " + confusionScale[3][3] + " " + confusionScale[3][4] + " " + confusionScale[3][5] + " " + confusionScale[3][6] + " " + confusionScale[3][7] + " " + confusionScale[3][8]);
                    System.out.println("Est =  0   " + confusionScale[4][0] + " " + confusionScale[4][1] + " " + confusionScale[4][2] + " " + confusionScale[4][3] + " " + confusionScale[4][4] + " " + confusionScale[4][5] + " " + confusionScale[4][6] + " " + confusionScale[4][7] + " " + confusionScale[4][8]);
                    System.out.println("Est =  1   " + confusionScale[5][0] + " " + confusionScale[5][1] + " " + confusionScale[5][2] + " " + confusionScale[5][3] + " " + confusionScale[5][4] + " " + confusionScale[5][5] + " " + confusionScale[5][6] + " " + confusionScale[5][7] + " " + confusionScale[5][8]);
                    System.out.println("Est =  2   " + confusionScale[6][0] + " " + confusionScale[6][1] + " " + confusionScale[6][2] + " " + confusionScale[6][3] + " " + confusionScale[6][4] + " " + confusionScale[6][5] + " " + confusionScale[6][6] + " " + confusionScale[6][7] + " " + confusionScale[6][8]);
                    System.out.println("Est =  3   " + confusionScale[7][0] + " " + confusionScale[7][1] + " " + confusionScale[7][2] + " " + confusionScale[7][3] + " " + confusionScale[7][4] + " " + confusionScale[7][5] + " " + confusionScale[7][6] + " " + confusionScale[7][7] + " " + confusionScale[7][8]);
                    System.out.println("Est =  4   " + confusionScale[8][0] + " " + confusionScale[8][1] + " " + confusionScale[8][2] + " " + confusionScale[8][3] + " " + confusionScale[8][4] + " " + confusionScale[8][5] + " " + confusionScale[8][6] + " " + confusionScale[8][7] + " " + confusionScale[8][8]);
                } else {
                    System.out.print(String.valueOf(this.options.sgProgramPos) + " correct: " + iCorrectPosCount + " (" + (float)iCorrectPosCount / (float)iClassified * 100.0f + "%).");
                    System.out.println(" Mean abs diff: " + (float)iPosAbsDiff / (float)iClassified);
                    System.out.println(" Correlation: " + ClassificationStatistics.correlationConfusion(confusionPos, 4));
                    int corrWithin1 = ClassificationStatistics.accuracyWithin1Confusion(confusionPos, 4);
                    System.out.println(" Correct +/- 1: " + corrWithin1 + " (" + (float)(100 * corrWithin1) / (float)iClassified + "%)");
                    System.out.print(String.valueOf(this.options.sgProgramNeg) + " correct: " + iCorrectNegCount + " (" + (float)iCorrectNegCount / (float)iClassified * 100.0f + "%).");
                    System.out.println(" Mean abs diff: " + (float)iNegAbsDiff / (float)iClassified);
                    System.out.println(" Correlation: " + ClassificationStatistics.correlationConfusion(confusionNeg, 4));
                    corrWithin1 = ClassificationStatistics.accuracyWithin1Confusion(confusionNeg, 4);
                    System.out.println(" Correct +/- 1: " + corrWithin1 + " (" + (float)(100 * corrWithin1) / (float)iClassified + "%)");
                }
                if (sStatsFile != "") {
                    File f = new File(sStatsFile);
                    Boolean bFileExists = false;
                    if (f.exists()) {
                        bFileExists = true;
                    }
                    wWriter = new BufferedWriter(new FileWriter(sStatsFile, true));
                    if (this.options.bgTrinaryMode) {
                        if (!bFileExists.booleanValue()) {
                            wWriter.write("File\tSample\tCorrect\tCorrectPc\n");
                        }
                        wWriter.write(String.valueOf(sInputFile) + "\t" + iClassified + "\t" + iCorrectTrinaryCount + "\t" + (float)iCorrectTrinaryCount / (float)iClassified * 100.0f + "\n");
                    } else if (this.options.bgScaleMode) {
                        if (!bFileExists.booleanValue()) {
                            wWriter.write("File\tSample\tCorrect\tCorrectPc\tCorrelation\tMAD\tMeanDiff\n");
                        }
                        wWriter.write(String.valueOf(sInputFile) + "\t" + iClassified + "\t" + iCorrectScaleCount + "\t" + (float)iCorrectScaleCount / (float)iClassified * 100.0f + "\t" + ClassificationStatistics.correlationConfusion(confusionScale, 8) + "\t" + (float)iScaleAbsDiff / (float)iClassified + "\t" + (float)iScaleDiff / (float)iClassified + "\n");
                    } else {
                        if (!bFileExists.booleanValue()) {
                            wWriter.write("File\tSample\tCorrectPos\tCorrectPosPc\tCorrectNeg\tCorrectNegPc\tCorrelPos\tCorrelNeg\tMADPos\tMADNeg\n");
                        }
                        wWriter.write(String.valueOf(sInputFile) + "\t" + iClassified + "\t" + iCorrectPosCount + "\t" + (float)iCorrectPosCount / (float)iClassified * 100.0f + "\t" + iCorrectNegCount + "\t" + (float)iCorrectNegCount / (float)iClassified * 100.0f + "\t" + ClassificationStatistics.correlationConfusion(confusionPos, 4) + "\t" + ClassificationStatistics.correlationConfusion(confusionNeg, 4) + "\t" + (float)iPosAbsDiff / (float)iClassified + "\t" + (float)iNegAbsDiff / (float)iClassified + "\n");
                    }
                    wWriter.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find input file: " + sInputFile);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Error reading from input file: " + sInputFile + " or writing to output file " + sOutputFile);
            e.printStackTrace();
        }
    }

    private void writeClassificationStatsHeadings(BufferedWriter w) throws IOException {
        if (this.options.bgTrinaryMode) {
            w.write("\tCorrectTrinary\tCorrectTrinary/TotalClassified\tCorrectWithin1Trinary\tCorrectWithin1Trinary/TotalClassified\test-1corr-1\test-1corr0\test-1corr1\test0corr-1\test0corr0\test0corr1\test1corr-1\test1corr0\test1corr1\tTotalClassified\n");
        } else if (this.options.bgScaleMode) {
            w.write("\tCorrelScale\tMADScale\tSentiStrengthMinusHumanScale\tCorrectScale\tCorrectScale/TotalClassified\tCorrectWithin1Scale\tCorrectWithin1Scale/TotalClassified\tTotalClassified\n");
        } else {
            w.write("\tCorrectPos\tCorrectPos/Total\tCorrectNeg\tCorrectNeg/Total\tWithin1Pos\tWithin1Pos/Total\tWithin1Neg\tWithin1Neg/Total\tCorrelPos\tCorrelNeg\tMPEPos\tMPENeg\tMADPos\tMADNeg\tTotalClassified\n");
        }
    }

    public void run10FoldCrossValidationForAllOptionVariations(int iMinImprovement, boolean bUseTotalDifference, int iReplications, int iMultiOptimisations, String sOutFileName) {
        try {
            BufferedWriter wResultsWriter = new BufferedWriter(new FileWriter(sOutFileName));
            BufferedWriter wTermStrengthWriter = new BufferedWriter(new FileWriter(String.valueOf(FileOps.s_ChopFileNameExtension(sOutFileName)) + "_termStrVars.txt"));
            if (this.igPosClass == null || this.igPosClass.length < this.igPosCorrect.length) {
                this.igPosClass = new int[this.igParagraphCount + 1];
                this.igNegClass = new int[this.igParagraphCount + 1];
                this.igTrinaryClass = new int[this.igParagraphCount + 1];
            }
            this.options.printClassificationOptionsHeadings(wResultsWriter);
            this.writeClassificationStatsHeadings(wResultsWriter);
            this.options.printClassificationOptionsHeadings(wTermStrengthWriter);
            this.resources.sentimentWords.printSentimentTermsInSingleHeaderRow(wTermStrengthWriter);
            System.out.println("About to start classifications for 20 different option variations");
            if (this.options.bgTrinaryMode) {
                ClassificationStatistics.baselineAccuracyMakeLargestClassPrediction(this.igTrinaryCorrect, this.igTrinaryClass, this.igParagraphCount, false);
            } else if (this.options.bgScaleMode) {
                ClassificationStatistics.baselineAccuracyMakeLargestClassPrediction(this.igScaleCorrect, this.igScaleClass, this.igParagraphCount, false);
            } else {
                ClassificationStatistics.baselineAccuracyMakeLargestClassPrediction(this.igPosCorrect, this.igPosClass, this.igParagraphCount, false);
                ClassificationStatistics.baselineAccuracyMakeLargestClassPrediction(this.igNegCorrect, this.igNegClass, this.igParagraphCount, true);
            }
            this.options.printBlankClassificationOptions(wResultsWriter);
            if (this.options.bgTrinaryMode) {
                this.printClassificationResultsRow(this.igPosClass, this.igNegClass, this.igTrinaryClass, wResultsWriter);
            } else {
                this.printClassificationResultsRow(this.igPosClass, this.igNegClass, this.igScaleClass, wResultsWriter);
            }
            this.options.printClassificationOptions(wResultsWriter, this.igParagraphCount, bUseTotalDifference, iMultiOptimisations);
            this.calculateCorpusSentimentScores();
            if (this.options.bgTrinaryMode) {
                this.printClassificationResultsRow(this.igPosClass, this.igNegClass, this.igTrinaryClass, wResultsWriter);
            } else {
                this.printClassificationResultsRow(this.igPosClass, this.igNegClass, this.igScaleClass, wResultsWriter);
            }
            this.options.printBlankClassificationOptions(wTermStrengthWriter);
            this.resources.sentimentWords.printSentimentValuesInSingleRow(wTermStrengthWriter);
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.igEmotionParagraphCombineMethod = 1 - this.options.igEmotionParagraphCombineMethod;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.igEmotionParagraphCombineMethod = 1 - this.options.igEmotionParagraphCombineMethod;
            this.options.igEmotionSentenceCombineMethod = 1 - this.options.igEmotionSentenceCombineMethod;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.igEmotionSentenceCombineMethod = 1 - this.options.igEmotionSentenceCombineMethod;
            this.options.bgReduceNegativeEmotionInQuestionSentences = !this.options.bgReduceNegativeEmotionInQuestionSentences;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.bgReduceNegativeEmotionInQuestionSentences = !this.options.bgReduceNegativeEmotionInQuestionSentences;
            this.options.bgMissCountsAsPlus2 = !this.options.bgMissCountsAsPlus2;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.bgMissCountsAsPlus2 = !this.options.bgMissCountsAsPlus2;
            this.options.bgYouOrYourIsPlus2UnlessSentenceNegative = !this.options.bgYouOrYourIsPlus2UnlessSentenceNegative;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.bgYouOrYourIsPlus2UnlessSentenceNegative = !this.options.bgYouOrYourIsPlus2UnlessSentenceNegative;
            this.options.bgExclamationInNeutralSentenceCountsAsPlus2 = !this.options.bgExclamationInNeutralSentenceCountsAsPlus2;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.bgExclamationInNeutralSentenceCountsAsPlus2 = !this.options.bgExclamationInNeutralSentenceCountsAsPlus2;
            this.options.bgUseIdiomLookupTable = !this.options.bgUseIdiomLookupTable;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.bgUseIdiomLookupTable = !this.options.bgUseIdiomLookupTable;
            int iTemp = this.options.igMoodToInterpretNeutralEmphasis;
            this.options.igMoodToInterpretNeutralEmphasis = -this.options.igMoodToInterpretNeutralEmphasis;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.igMoodToInterpretNeutralEmphasis = 0;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.igMoodToInterpretNeutralEmphasis = iTemp;
            System.out.println("About to start 10th option variation classification");
            this.options.bgAllowMultiplePositiveWordsToIncreasePositiveEmotion = !this.options.bgAllowMultiplePositiveWordsToIncreasePositiveEmotion;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.bgAllowMultiplePositiveWordsToIncreasePositiveEmotion = !this.options.bgAllowMultiplePositiveWordsToIncreasePositiveEmotion;
            this.options.bgAllowMultipleNegativeWordsToIncreaseNegativeEmotion = !this.options.bgAllowMultipleNegativeWordsToIncreaseNegativeEmotion;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.bgAllowMultipleNegativeWordsToIncreaseNegativeEmotion = !this.options.bgAllowMultipleNegativeWordsToIncreaseNegativeEmotion;
            this.options.bgIgnoreBoosterWordsAfterNegatives = !this.options.bgIgnoreBoosterWordsAfterNegatives;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.bgIgnoreBoosterWordsAfterNegatives = !this.options.bgIgnoreBoosterWordsAfterNegatives;
            this.options.bgMultipleLettersBoostSentiment = !this.options.bgMultipleLettersBoostSentiment;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.bgMultipleLettersBoostSentiment = !this.options.bgMultipleLettersBoostSentiment;
            this.options.bgBoosterWordsChangeEmotion = !this.options.bgBoosterWordsChangeEmotion;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            boolean bl = this.options.bgBoosterWordsChangeEmotion = !this.options.bgBoosterWordsChangeEmotion;
            if (this.options.bgNegatingWordsFlipEmotion) {
                this.options.bgNegatingWordsFlipEmotion = !this.options.bgNegatingWordsFlipEmotion;
                this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
                this.options.bgNegatingWordsFlipEmotion = !this.options.bgNegatingWordsFlipEmotion;
            } else {
                this.options.bgNegatingPositiveFlipsEmotion = !this.options.bgNegatingPositiveFlipsEmotion;
                this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
                this.options.bgNegatingPositiveFlipsEmotion = !this.options.bgNegatingPositiveFlipsEmotion;
                this.options.bgNegatingNegativeNeutralisesEmotion = !this.options.bgNegatingNegativeNeutralisesEmotion;
                this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
                this.options.bgNegatingNegativeNeutralisesEmotion = !this.options.bgNegatingNegativeNeutralisesEmotion;
            }
            this.options.bgCorrectSpellingsWithRepeatedLetter = !this.options.bgCorrectSpellingsWithRepeatedLetter;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.bgCorrectSpellingsWithRepeatedLetter = !this.options.bgCorrectSpellingsWithRepeatedLetter;
            this.options.bgUseEmoticons = !this.options.bgUseEmoticons;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            this.options.bgUseEmoticons = !this.options.bgUseEmoticons;
            this.options.bgCapitalsBoostTermSentiment = !this.options.bgCapitalsBoostTermSentiment;
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            boolean bl2 = this.options.bgCapitalsBoostTermSentiment = !this.options.bgCapitalsBoostTermSentiment;
            if (iMinImprovement > 1) {
                this.run10FoldCrossValidationMultipleTimes(iMinImprovement - 1, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            }
            this.run10FoldCrossValidationMultipleTimes(iMinImprovement + 1, bUseTotalDifference, iReplications, iMultiOptimisations, wResultsWriter, wTermStrengthWriter);
            wResultsWriter.close();
            wTermStrengthWriter.close();
            this.SummariseMultiple10FoldValidations(sOutFileName, String.valueOf(sOutFileName) + "_sum.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void run10FoldCrossValidationOnce(int iMinImprovement, boolean bUseTotalDifference, int iMultiOptimisations, BufferedWriter wWriter, BufferedWriter wTermStrengthWriter) {
        int iTotalSentimentWords = this.resources.sentimentWords.getSentimentWordCount();
        int[] iParagraphRand = new int[this.igParagraphCount + 1];
        int[] iPosClassAll = new int[this.igParagraphCount + 1];
        int[] iNegClassAll = new int[this.igParagraphCount + 1];
        int[] iTrinaryOrScaleClassAll = new int[this.igParagraphCount + 1];
        Sort.makeRandomOrderList(iParagraphRand);
        int[] iOriginalSentimentStrengths = new int[iTotalSentimentWords + 1];
        int i = 1;
        while (i < iTotalSentimentWords) {
            iOriginalSentimentStrengths[i] = this.resources.sentimentWords.getSentiment(i);
            ++i;
        }
        int iFold = 1;
        while (iFold <= 10) {
            this.selectDecileAsSubcorpus(iParagraphRand, iFold, true);
            this.reCalculateCorpusSentimentScores();
            this.optimiseDictionaryWeightingsForCorpusMultipleTimes(iMinImprovement, bUseTotalDifference, iMultiOptimisations);
            this.options.printClassificationOptions(wTermStrengthWriter, iMinImprovement, bUseTotalDifference, iMultiOptimisations);
            this.resources.sentimentWords.printSentimentValuesInSingleRow(wTermStrengthWriter);
            this.selectDecileAsSubcorpus(iParagraphRand, iFold, false);
            this.reCalculateCorpusSentimentScores();
            i = 1;
            while (i <= this.igParagraphCount) {
                if (this.bgSupcorpusMember[i]) {
                    iPosClassAll[i] = this.igPosClass[i];
                    iNegClassAll[i] = this.igNegClass[i];
                    iTrinaryOrScaleClassAll[i] = this.options.bgTrinaryMode ? this.igTrinaryClass[i] : this.igScaleClass[i];
                }
                ++i;
            }
            i = 1;
            while (i < iTotalSentimentWords) {
                this.resources.sentimentWords.setSentiment(i, iOriginalSentimentStrengths[i]);
                ++i;
            }
            ++iFold;
        }
        this.useWholeCorpusNotSubcorpus();
        this.options.printClassificationOptions(wWriter, iMinImprovement, bUseTotalDifference, iMultiOptimisations);
        this.printClassificationResultsRow(iPosClassAll, iNegClassAll, iTrinaryOrScaleClassAll, wWriter);
    }

    private boolean printClassificationResultsRow(int[] iPosClassAll, int[] iNegClassAll, int[] iTrinaryOrScaleClassAll, BufferedWriter wWriter) {
        int iPosCorrect = -1;
        int iNegCorrect = -1;
        int iPosWithin1 = -1;
        int iNegWithin1 = -1;
        int iTrinaryCorrect = -1;
        int iTrinaryCorrectWithin1 = -1;
        double fPosCorrectPoportion = -1.0;
        double fNegCorrectPoportion = -1.0;
        double fPosWithin1Poportion = -1.0;
        double fNegWithin1Poportion = -1.0;
        double fTrinaryCorrectPoportion = -1.0;
        double fTrinaryCorrectWithin1Poportion = -1.0;
        double fPosOrScaleCorr = 9999.0;
        double fNegCorr = 9999.0;
        double fPosMPE = 9999.0;
        double fNegMPE = 9999.0;
        double fPosMAD = 9999.0;
        double fNegMAD = 9999.0;
        int[][] estCorr = new int[][]{new int[3], new int[3], new int[3]};
        try {
            if (this.options.bgTrinaryMode) {
                iTrinaryCorrect = ClassificationStatistics.accuracy(this.igTrinaryCorrect, iTrinaryOrScaleClassAll, this.igParagraphCount, false);
                iTrinaryCorrectWithin1 = ClassificationStatistics.accuracyWithin1(this.igTrinaryCorrect, iTrinaryOrScaleClassAll, this.igParagraphCount, false);
                fTrinaryCorrectPoportion = (float)iTrinaryCorrect / (float)this.igParagraphCount;
                fTrinaryCorrectWithin1Poportion = (float)iTrinaryCorrectWithin1 / (float)this.igParagraphCount;
                ClassificationStatistics.TrinaryOrBinaryConfusionTable(iTrinaryOrScaleClassAll, this.igTrinaryCorrect, this.igParagraphCount, estCorr);
                wWriter.write("\t" + iTrinaryCorrect + "\t" + fTrinaryCorrectPoportion + "\t" + iTrinaryCorrectWithin1 + "\t" + fTrinaryCorrectWithin1Poportion + "\t" + estCorr[0][0] + "\t" + estCorr[0][1] + "\t" + estCorr[0][2] + "\t" + estCorr[1][0] + "\t" + estCorr[1][1] + "\t" + estCorr[1][2] + "\t" + estCorr[2][0] + "\t" + estCorr[2][1] + "\t" + estCorr[2][2] + "\t" + this.igParagraphCount + "\n");
            } else if (this.options.bgScaleMode) {
                iTrinaryCorrect = ClassificationStatistics.accuracy(this.igScaleCorrect, iTrinaryOrScaleClassAll, this.igParagraphCount, false);
                iTrinaryCorrectWithin1 = ClassificationStatistics.accuracyWithin1(this.igScaleCorrect, iTrinaryOrScaleClassAll, this.igParagraphCount, false);
                fTrinaryCorrectPoportion = (float)iTrinaryCorrect / (float)this.igParagraphCount;
                fTrinaryCorrectWithin1Poportion = (float)iTrinaryCorrectWithin1 / (float)this.igParagraphCount;
                fPosOrScaleCorr = ClassificationStatistics.correlation(this.igScaleCorrect, iTrinaryOrScaleClassAll, this.igParagraphCount);
                fPosMAD = ClassificationStatistics.meanAbsoluteDeviation(this.igScaleCorrect, iTrinaryOrScaleClassAll, this.igParagraphCount, false);
                fNegMAD = ClassificationStatistics.meanDeviation(this.igScaleCorrect, iTrinaryOrScaleClassAll, this.igParagraphCount, false);
                wWriter.write("\t" + fPosOrScaleCorr + "\t" + fPosMAD + "\t" + fNegMAD + "\t" + iTrinaryCorrect + "\t" + fTrinaryCorrectPoportion + "\t" + iTrinaryCorrectWithin1 + "\t" + fTrinaryCorrectWithin1Poportion + "\t" + this.igParagraphCount + "\n");
            } else {
                iPosCorrect = ClassificationStatistics.accuracy(this.igPosCorrect, iPosClassAll, this.igParagraphCount, false);
                iNegCorrect = ClassificationStatistics.accuracy(this.igNegCorrect, iNegClassAll, this.igParagraphCount, true);
                iPosWithin1 = ClassificationStatistics.accuracyWithin1(this.igPosCorrect, iPosClassAll, this.igParagraphCount, false);
                iNegWithin1 = ClassificationStatistics.accuracyWithin1(this.igNegCorrect, iNegClassAll, this.igParagraphCount, true);
                fPosOrScaleCorr = ClassificationStatistics.correlationAbs(this.igPosCorrect, iPosClassAll, this.igParagraphCount);
                fNegCorr = ClassificationStatistics.correlationAbs(this.igNegCorrect, iNegClassAll, this.igParagraphCount);
                fPosMPE = ClassificationStatistics.absoluteMeanPercentageError(this.igPosCorrect, iPosClassAll, this.igParagraphCount, false);
                fNegMPE = ClassificationStatistics.absoluteMeanPercentageError(this.igNegCorrect, iNegClassAll, this.igParagraphCount, true);
                fPosMAD = ClassificationStatistics.meanAbsoluteDeviation(this.igPosCorrect, iPosClassAll, this.igParagraphCount, false);
                fNegMAD = ClassificationStatistics.meanAbsoluteDeviation(this.igNegCorrect, iNegClassAll, this.igParagraphCount, true);
                fPosCorrectPoportion = (float)iPosCorrect / (float)this.igParagraphCount;
                fNegCorrectPoportion = (float)iNegCorrect / (float)this.igParagraphCount;
                fPosWithin1Poportion = (float)iPosWithin1 / (float)this.igParagraphCount;
                fNegWithin1Poportion = (float)iNegWithin1 / (float)this.igParagraphCount;
                wWriter.write("\t" + iPosCorrect + "\t" + fPosCorrectPoportion + "\t" + iNegCorrect + "\t" + fNegCorrectPoportion + "\t" + iPosWithin1 + "\t" + fPosWithin1Poportion + "\t" + iNegWithin1 + "\t" + fNegWithin1Poportion + "\t" + fPosOrScaleCorr + "\t" + fNegCorr + "\t" + fPosMPE + "\t" + fNegMPE + "\t" + fPosMAD + "\t" + fNegMAD + "\t" + this.igParagraphCount + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void selectDecileAsSubcorpus(int[] iParagraphRand, int iDecile, boolean bInvert) {
        if (this.igParagraphCount == 0) {
            return;
        }
        int iMin = (int)((float)this.igParagraphCount / 10.0f * (float)(iDecile - 1)) + 1;
        int iMax = (int)((float)this.igParagraphCount / 10.0f * (float)iDecile);
        if (iDecile == 10) {
            iMax = this.igParagraphCount;
        }
        if (iDecile == 0) {
            iMin = 0;
        }
        this.igSupcorpusMemberCount = 0;
        int i = 1;
        while (i <= this.igParagraphCount) {
            if (i >= iMin && i <= iMax) {
                boolean bl = this.bgSupcorpusMember[iParagraphRand[i]] = !bInvert;
                if (!bInvert) {
                    ++this.igSupcorpusMemberCount;
                }
            } else {
                this.bgSupcorpusMember[iParagraphRand[i]] = bInvert;
                if (bInvert) {
                    ++this.igSupcorpusMemberCount;
                }
            }
            ++i;
        }
    }

    public void optimiseDictionaryWeightingsForCorpusMultipleTimes(int iMinImprovement, boolean bUseTotalDifference, int iOptimisationTotal) {
        if (iOptimisationTotal < 1) {
            return;
        }
        if (iOptimisationTotal == 1) {
            this.optimiseDictionaryWeightingsForCorpus(iMinImprovement, bUseTotalDifference);
            return;
        }
        int iTotalSentimentWords = this.resources.sentimentWords.getSentimentWordCount();
        int[] iOriginalSentimentStrengths = new int[iTotalSentimentWords + 1];
        int j = 1;
        while (j <= iTotalSentimentWords) {
            iOriginalSentimentStrengths[j] = this.resources.sentimentWords.getSentiment(j);
            ++j;
        }
        int[] iTotalWeight = new int[iTotalSentimentWords + 1];
        int j2 = 1;
        while (j2 <= iTotalSentimentWords) {
            iTotalWeight[j2] = 0;
            ++j2;
        }
        int i = 0;
        while (i < iOptimisationTotal) {
            this.optimiseDictionaryWeightingsForCorpus(iMinImprovement, bUseTotalDifference);
            int j3 = 1;
            while (j3 <= iTotalSentimentWords) {
                int n = j3;
                iTotalWeight[n] = iTotalWeight[n] + this.resources.sentimentWords.getSentiment(j3);
                ++j3;
            }
            j3 = 1;
            while (j3 <= iTotalSentimentWords) {
                this.resources.sentimentWords.setSentiment(j3, iOriginalSentimentStrengths[j3]);
                ++j3;
            }
            ++i;
        }
        j2 = 1;
        while (j2 <= iTotalSentimentWords) {
            this.resources.sentimentWords.setSentiment(j2, (int)((double)((float)iTotalWeight[j2] / (float)iOptimisationTotal) + 0.5));
            ++j2;
        }
        this.optimiseDictionaryWeightingsForCorpus(iMinImprovement, bUseTotalDifference);
    }

    public void optimiseDictionaryWeightingsForCorpus(int iMinImprovement, boolean bUseTotalDifference) {
        if (this.options.bgTrinaryMode) {
            this.optimiseDictionaryWeightingsForCorpusTrinaryOrBinary(iMinImprovement);
        } else if (this.options.bgScaleMode) {
            this.optimiseDictionaryWeightingsForCorpusScale(iMinImprovement);
        } else {
            this.optimiseDictionaryWeightingsForCorpusPosNeg(iMinImprovement, bUseTotalDifference);
        }
    }

    public void optimiseDictionaryWeightingsForCorpusScale(int iMinImprovement) {
        boolean bFullListChanges = true;
        int iLastScaleNumberCorrect = this.getClassificationScaleNumberCorrect();
        int iNewScaleNumberCorrect = 0;
        int iTotalSentimentWords = this.resources.sentimentWords.getSentimentWordCount();
        int[] iWordRand = new int[iTotalSentimentWords + 1];
        while (bFullListChanges) {
            Sort.makeRandomOrderList(iWordRand);
            bFullListChanges = false;
            int i = 1;
            while (i <= iTotalSentimentWords) {
                int iOldTermSentimentStrength = this.resources.sentimentWords.getSentiment(iWordRand[i]);
                boolean bCurrentIDChange = false;
                int iAddOneImprovement = 0;
                int iSubtractOneImprovement = 0;
                if (iOldTermSentimentStrength < 4) {
                    this.resources.sentimentWords.setSentiment(iWordRand[i], iOldTermSentimentStrength + 1);
                    this.reClassifyClassifiedCorpusForSentimentChange(iWordRand[i], 1);
                    iNewScaleNumberCorrect = this.getClassificationScaleNumberCorrect();
                    iAddOneImprovement = iNewScaleNumberCorrect - iLastScaleNumberCorrect;
                    if (iAddOneImprovement >= iMinImprovement) {
                        bCurrentIDChange = true;
                        iLastScaleNumberCorrect += iAddOneImprovement;
                    }
                }
                if (iOldTermSentimentStrength > -4 && !bCurrentIDChange) {
                    this.resources.sentimentWords.setSentiment(iWordRand[i], iOldTermSentimentStrength - 1);
                    this.reClassifyClassifiedCorpusForSentimentChange(iWordRand[i], 1);
                    iNewScaleNumberCorrect = this.getClassificationScaleNumberCorrect();
                    iSubtractOneImprovement = iNewScaleNumberCorrect - iLastScaleNumberCorrect;
                    if (iSubtractOneImprovement >= iMinImprovement) {
                        bCurrentIDChange = true;
                        iLastScaleNumberCorrect += iSubtractOneImprovement;
                    }
                }
                if (bCurrentIDChange) {
                    bFullListChanges = true;
                } else {
                    this.resources.sentimentWords.setSentiment(iWordRand[i], iOldTermSentimentStrength);
                    this.reClassifyClassifiedCorpusForSentimentChange(iWordRand[i], 1);
                }
                ++i;
            }
        }
    }

    public void optimiseDictionaryWeightingsForCorpusTrinaryOrBinary(int iMinImprovement) {
        boolean bFullListChanges = true;
        int iLastTrinaryCorrect = this.getClassificationTrinaryNumberCorrect();
        int iNewTrinary = 0;
        int iTotalSentimentWords = this.resources.sentimentWords.getSentimentWordCount();
        int[] iWordRand = new int[iTotalSentimentWords + 1];
        while (bFullListChanges) {
            Sort.makeRandomOrderList(iWordRand);
            bFullListChanges = false;
            int i = 1;
            while (i <= iTotalSentimentWords) {
                int iOldSentimentStrength = this.resources.sentimentWords.getSentiment(iWordRand[i]);
                boolean bCurrentIDChange = false;
                int iAddOneImprovement = 0;
                int iSubtractOneImprovement = 0;
                if (iOldSentimentStrength < 4) {
                    this.resources.sentimentWords.setSentiment(iWordRand[i], iOldSentimentStrength + 1);
                    this.reClassifyClassifiedCorpusForSentimentChange(iWordRand[i], 1);
                    iNewTrinary = this.getClassificationTrinaryNumberCorrect();
                    iAddOneImprovement = iNewTrinary - iLastTrinaryCorrect;
                    if (iAddOneImprovement >= iMinImprovement) {
                        bCurrentIDChange = true;
                        iLastTrinaryCorrect += iAddOneImprovement;
                    }
                }
                if (iOldSentimentStrength > -4 && !bCurrentIDChange) {
                    this.resources.sentimentWords.setSentiment(iWordRand[i], iOldSentimentStrength - 1);
                    this.reClassifyClassifiedCorpusForSentimentChange(iWordRand[i], 1);
                    iNewTrinary = this.getClassificationTrinaryNumberCorrect();
                    iSubtractOneImprovement = iNewTrinary - iLastTrinaryCorrect;
                    if (iSubtractOneImprovement >= iMinImprovement) {
                        bCurrentIDChange = true;
                        iLastTrinaryCorrect += iSubtractOneImprovement;
                    }
                }
                if (bCurrentIDChange) {
                    bFullListChanges = true;
                } else {
                    this.resources.sentimentWords.setSentiment(iWordRand[i], iOldSentimentStrength);
                    this.reClassifyClassifiedCorpusForSentimentChange(iWordRand[i], 1);
                }
                ++i;
            }
        }
    }

    public void optimiseDictionaryWeightingsForCorpusPosNeg(int iMinImprovement, boolean bUseTotalDifference) {
        boolean bFullListChanges = true;
        int iLastPos = 0;
        int iLastNeg = 0;
        int iLastPosTotalDiff = 0;
        int iLastNegTotalDiff = 0;
        if (bUseTotalDifference) {
            iLastPosTotalDiff = this.getClassificationPositiveTotalDifference();
            iLastNegTotalDiff = this.getClassificationNegativeTotalDifference();
        } else {
            iLastPos = this.getClassificationPositiveNumberCorrect();
            iLastNeg = this.getClassificationNegativeNumberCorrect();
        }
        int iNewPos = 0;
        int iNewNeg = 0;
        int iNewPosTotalDiff = 0;
        int iNewNegTotalDiff = 0;
        int iTotalSentimentWords = this.resources.sentimentWords.getSentimentWordCount();
        int[] iWordRand = new int[iTotalSentimentWords + 1];
        while (bFullListChanges) {
            Sort.makeRandomOrderList(iWordRand);
            bFullListChanges = false;
            int i = 1;
            while (i <= iTotalSentimentWords) {
                int iOldSentimentStrength = this.resources.sentimentWords.getSentiment(iWordRand[i]);
                boolean bCurrentIDChange = false;
                if (iOldSentimentStrength < 4) {
                    this.resources.sentimentWords.setSentiment(iWordRand[i], iOldSentimentStrength + 1);
                    this.reClassifyClassifiedCorpusForSentimentChange(iWordRand[i], 1);
                    if (bUseTotalDifference) {
                        iNewPosTotalDiff = this.getClassificationPositiveTotalDifference();
                        if (iNewPosTotalDiff - iLastPosTotalDiff + (iNewNegTotalDiff = this.getClassificationNegativeTotalDifference()) - iLastNegTotalDiff <= -iMinImprovement) {
                            bCurrentIDChange = true;
                        }
                    } else {
                        iNewPos = this.getClassificationPositiveNumberCorrect();
                        if (iNewPos - iLastPos + (iNewNeg = this.getClassificationNegativeNumberCorrect()) - iLastNeg >= iMinImprovement) {
                            bCurrentIDChange = true;
                        }
                    }
                }
                if (iOldSentimentStrength > -4 && !bCurrentIDChange) {
                    this.resources.sentimentWords.setSentiment(iWordRand[i], iOldSentimentStrength - 1);
                    this.reClassifyClassifiedCorpusForSentimentChange(iWordRand[i], 1);
                    if (bUseTotalDifference) {
                        iNewPosTotalDiff = this.getClassificationPositiveTotalDifference();
                        if (iNewPosTotalDiff - iLastPosTotalDiff + (iNewNegTotalDiff = this.getClassificationNegativeTotalDifference()) - iLastNegTotalDiff <= -iMinImprovement) {
                            bCurrentIDChange = true;
                        }
                    } else {
                        iNewPos = this.getClassificationPositiveNumberCorrect();
                        if (iNewPos - iLastPos + (iNewNeg = this.getClassificationNegativeNumberCorrect()) - iLastNeg >= iMinImprovement) {
                            bCurrentIDChange = true;
                        }
                    }
                }
                if (bCurrentIDChange) {
                    if (bUseTotalDifference) {
                        iLastNegTotalDiff = iNewNegTotalDiff;
                        iLastPosTotalDiff = iNewPosTotalDiff;
                        bFullListChanges = true;
                    } else {
                        iLastNeg = iNewNeg;
                        iLastPos = iNewPos;
                        bFullListChanges = true;
                    }
                } else {
                    this.resources.sentimentWords.setSentiment(iWordRand[i], iOldSentimentStrength);
                    this.reClassifyClassifiedCorpusForSentimentChange(iWordRand[i], 1);
                }
                ++i;
            }
        }
    }

    public void SummariseMultiple10FoldValidations(String sInputFile, String sOutputFile) {
        int iDataRows = 28;
        int iLastOptionCol = 24;
        BufferedReader rResults = null;
        BufferedWriter wSummary = null;
        String sLine = null;
        String[] sPrevData = null;
        String[] sData = null;
        float[] total = new float[iDataRows];
        int iRows = 0;
        int i = 0;
        try {
            rResults = new BufferedReader(new FileReader(sInputFile));
            wSummary = new BufferedWriter(new FileWriter(sOutputFile));
            sLine = rResults.readLine();
            wSummary.write(String.valueOf(sLine) + "\tNumber\n");
            while (rResults.ready()) {
                sLine = rResults.readLine();
                sData = sLine.split("\t");
                boolean bMatching = true;
                if (sPrevData != null) {
                    i = 0;
                    while (i < iLastOptionCol) {
                        if (!sData[i].equals(sPrevData[i])) {
                            bMatching = false;
                        }
                        ++i;
                    }
                }
                if (!bMatching) {
                    i = 0;
                    while (i < iLastOptionCol) {
                        wSummary.write(String.valueOf(sPrevData[i]) + "\t");
                        ++i;
                    }
                    i = 0;
                    while (i < iDataRows) {
                        wSummary.write(String.valueOf(total[i] / (float)iRows) + "\t");
                        ++i;
                    }
                    wSummary.write(String.valueOf(iRows) + "\n");
                    i = 0;
                    while (i < iDataRows) {
                        total[i] = 0.0f;
                        ++i;
                    }
                    iRows = 0;
                }
                i = iLastOptionCol;
                while (i < iLastOptionCol + iDataRows) {
                    try {
                        int n = i - iLastOptionCol;
                        total[n] = total[n] + Float.parseFloat(sData[i]);
                    }
                    catch (Exception e) {
                        int n = i - iLastOptionCol;
                        total[n] = total[n] + 9999999.0f;
                    }
                    ++i;
                }
                ++iRows;
                sPrevData = sLine.split("\t");
            }
            i = 0;
            while (i < iLastOptionCol) {
                wSummary.write(String.valueOf(sPrevData[i]) + "\t");
                ++i;
            }
            i = 0;
            while (i < iDataRows) {
                wSummary.write(String.valueOf(total[i] / (float)iRows) + "\t");
                ++i;
            }
            wSummary.write(String.valueOf(iRows) + "\n");
            wSummary.close();
            rResults.close();
        }
        catch (IOException e) {
            System.out.println("SummariseMultiple10FoldValidations: File I/O error: " + sInputFile);
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("SummariseMultiple10FoldValidations: Error at line: " + sLine);
            System.out.println("Value of i: " + i);
            e.printStackTrace();
        }
    }
}

