/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

public class ClassificationStatistics {
    public static double correlationAbs(int[] iCorrect, int[] iPredicted, int iCount) {
        double fMeanC = 0.0;
        double fMeanP = 0.0;
        double fProdCP = 0.0;
        double fSumCSq = 0.0;
        double fSumPSq = 0.0;
        int iRow = 1;
        while (iRow <= iCount) {
            fMeanC += (double)Math.abs(iCorrect[iRow]);
            fMeanP += (double)Math.abs(iPredicted[iRow]);
            ++iRow;
        }
        fMeanC /= (double)iCount;
        fMeanP /= (double)iCount;
        iRow = 1;
        while (iRow <= iCount) {
            fProdCP += ((double)Math.abs(iCorrect[iRow]) - fMeanC) * ((double)Math.abs(iPredicted[iRow]) - fMeanP);
            fSumPSq += Math.pow((double)Math.abs(iPredicted[iRow]) - fMeanP, 2.0);
            fSumCSq += Math.pow((double)Math.abs(iCorrect[iRow]) - fMeanC, 2.0);
            ++iRow;
        }
        return fProdCP / (Math.sqrt(fSumPSq) * Math.sqrt(fSumCSq));
    }

    public static double correlation(int[] iCorrect, int[] iPredicted, int iCount) {
        double fMeanC = 0.0;
        double fMeanP = 0.0;
        double fProdCP = 0.0;
        double fSumCSq = 0.0;
        double fSumPSq = 0.0;
        int iRow = 1;
        while (iRow <= iCount) {
            fMeanC += (double)iCorrect[iRow];
            fMeanP += (double)iPredicted[iRow];
            ++iRow;
        }
        fMeanC /= (double)iCount;
        fMeanP /= (double)iCount;
        iRow = 1;
        while (iRow <= iCount) {
            fProdCP += ((double)iCorrect[iRow] - fMeanC) * ((double)iPredicted[iRow] - fMeanP);
            fSumPSq += Math.pow((double)iPredicted[iRow] - fMeanP, 2.0);
            fSumCSq += Math.pow((double)iCorrect[iRow] - fMeanC, 2.0);
            ++iRow;
        }
        return fProdCP / (Math.sqrt(fSumPSq) * Math.sqrt(fSumCSq));
    }

    public static double correlationConfusion(int[][] iCorrectPredicted, int iLastRow) {
        int iCol;
        double fMeanRow = 0.0;
        double fMeanCol = 0.0;
        double fProdCP = 0.0;
        double fSumCSq = 0.0;
        double fSumPSq = 0.0;
        int iCount = 0;
        int iRow = 0;
        while (iRow <= iLastRow) {
            iCol = 0;
            while (iCol <= iLastRow) {
                fMeanRow += (double)(iCorrectPredicted[iRow][iCol] * iRow);
                fMeanCol += (double)(iCorrectPredicted[iRow][iCol] * iCol);
                iCount += iCorrectPredicted[iRow][iCol];
                ++iCol;
            }
            ++iRow;
        }
        fMeanRow /= (double)iCount;
        fMeanCol /= (double)iCount;
        iRow = 0;
        while (iRow <= iLastRow) {
            iCol = 0;
            while (iCol <= iLastRow) {
                fProdCP += (double)iCorrectPredicted[iRow][iCol] * ((double)iRow - fMeanRow) * ((double)iCol - fMeanCol);
                fSumPSq += (double)iCorrectPredicted[iRow][iCol] * Math.pow((double)iRow - fMeanRow, 2.0);
                fSumCSq += (double)iCorrectPredicted[iRow][iCol] * Math.pow((double)iCol - fMeanCol, 2.0);
                ++iCol;
            }
            ++iRow;
        }
        return fProdCP / (Math.sqrt(fSumPSq) * Math.sqrt(fSumCSq));
    }

    public static void TrinaryOrBinaryConfusionTable(int[] iTrinaryEstimate, int[] iTrinaryCorrect, int iDataCount, int[][] estCorr) {
        int i = 0;
        while (i <= 2) {
            int j = 0;
            while (j <= 2) {
                estCorr[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= iDataCount) {
            if (iTrinaryEstimate[i] > -2 && iTrinaryEstimate[i] < 2 && iTrinaryCorrect[i] > -2 && iTrinaryCorrect[i] < 2) {
                int[] nArray = estCorr[iTrinaryEstimate[i] + 1];
                int n = iTrinaryCorrect[i] + 1;
                nArray[n] = nArray[n] + 1;
            } else {
                System.out.println("Estimate or correct value " + i + " out of range -1 to +1 (data count may be wrong): " + iTrinaryEstimate[i] + " " + iTrinaryCorrect[i]);
            }
            ++i;
        }
    }

    public static double correlationAbs(int[] iCorrect, int[] iPredicted, boolean[] bSelected, boolean bInvert, int iCount) {
        double fMeanC = 0.0;
        double fMeanP = 0.0;
        double fProdCP = 0.0;
        double fSumCSq = 0.0;
        double fSumPSq = 0.0;
        int iDataCount = 0;
        int iRow = 1;
        while (iRow <= iCount) {
            if (bSelected[iRow] && !bInvert || !bSelected[iRow] && bInvert) {
                fMeanC += (double)Math.abs(iCorrect[iRow]);
                fMeanP += (double)Math.abs(iPredicted[iRow]);
                ++iDataCount;
            }
            ++iRow;
        }
        fMeanC /= (double)iDataCount;
        fMeanP /= (double)iDataCount;
        iRow = 1;
        while (iRow <= iCount) {
            if (bSelected[iRow] && !bInvert || !bSelected[iRow] && bInvert) {
                fProdCP += ((double)Math.abs(iCorrect[iRow]) - fMeanC) * ((double)Math.abs(iPredicted[iRow]) - fMeanP);
                fSumPSq += Math.pow((double)Math.abs(iPredicted[iRow]) - fMeanP, 2.0);
                fSumCSq += Math.pow((double)Math.abs(iCorrect[iRow]) - fMeanC, 2.0);
            }
            ++iRow;
        }
        return fProdCP / (Math.sqrt(fSumPSq) * Math.sqrt(fSumCSq));
    }

    public static int accuracy(int[] iCorrect, int[] iPredicted, int iCount, boolean bChangeSignOfOneArray) {
        int iCorrectCount = 0;
        if (bChangeSignOfOneArray) {
            int iRow = 1;
            while (iRow <= iCount) {
                if (iCorrect[iRow] == -iPredicted[iRow]) {
                    ++iCorrectCount;
                }
                ++iRow;
            }
        } else {
            int iRow = 1;
            while (iRow <= iCount) {
                if (iCorrect[iRow] == iPredicted[iRow]) {
                    ++iCorrectCount;
                }
                ++iRow;
            }
        }
        return iCorrectCount;
    }

    public static int accuracy(int[] iCorrect, int[] iPredicted, boolean[] bSelected, boolean bInvert, int iCount) {
        int iCorrectCount = 0;
        int iRow = 1;
        while (iRow <= iCount) {
            if ((bSelected[iRow] && !bInvert || !bSelected[iRow] && bInvert) && iCorrect[iRow] == iPredicted[iRow]) {
                ++iCorrectCount;
            }
            ++iRow;
        }
        return iCorrectCount;
    }

    public static int accuracyConfusion(int[][] iCorrectPredicted, int iRowAndColLastValue) {
        int iCorrectCount = 0;
        int iRow = 0;
        while (iRow <= iRowAndColLastValue) {
            iCorrectCount += iCorrectPredicted[iRow][iRow];
            ++iRow;
        }
        return iCorrectCount;
    }

    public static int accuracyWithin1(int[] iCorrect, int[] iPredicted, boolean[] bSelected, boolean bInvert, int iCount) {
        int iCorrectCount = 0;
        int iRow = 1;
        while (iRow <= iCount) {
            if ((bSelected[iRow] && !bInvert || !bSelected[iRow] && bInvert) && Math.abs(iCorrect[iRow] - iPredicted[iRow]) <= 1) {
                ++iCorrectCount;
            }
            ++iRow;
        }
        return iCorrectCount;
    }

    public static int accuracyWithin1(int[] iCorrect, int[] iPredicted, int iCount, boolean bChangeSignOfOneArray) {
        int iWithin1Count = 0;
        if (bChangeSignOfOneArray) {
            int iRow = 1;
            while (iRow <= iCount) {
                if (Math.abs(iCorrect[iRow] + iPredicted[iRow]) <= 1) {
                    ++iWithin1Count;
                }
                ++iRow;
            }
        } else {
            int iRow = 1;
            while (iRow <= iCount) {
                if (Math.abs(iCorrect[iRow] - iPredicted[iRow]) <= 1) {
                    ++iWithin1Count;
                }
                ++iRow;
            }
        }
        return iWithin1Count;
    }

    public static int accuracyWithin1Confusion(int[][] iCorrectPredicted, int iRowAndColLastValue) {
        int iWithin1Count = 0;
        int iRow = 0;
        while (iRow <= iRowAndColLastValue) {
            int iCol = 0;
            while (iCol <= iRowAndColLastValue) {
                if (Math.abs(iRow - iCol) <= 1) {
                    iWithin1Count += iCorrectPredicted[iRow][iCol];
                }
                ++iCol;
            }
            ++iRow;
        }
        return iWithin1Count;
    }

    public static double absoluteMeanPercentageErrorNoDivision(int[] iCorrect, int[] iPredicted, boolean[] bSelected, boolean bInvert, int iCount) {
        int iDataCount = 0;
        double fAMeanPE = 0.0;
        int iRow = 1;
        while (iRow <= iCount) {
            if (bSelected[iRow] && !bInvert || !bSelected[iRow] && bInvert) {
                fAMeanPE += (double)Math.abs(iPredicted[iRow] - iCorrect[iRow]);
                ++iDataCount;
            }
            ++iRow;
        }
        return fAMeanPE / (double)iDataCount;
    }

    public static double absoluteMeanPercentageError(int[] iCorrect, int[] iPredicted, boolean[] bSelected, boolean bInvert, int iCount) {
        int iDataCount = 0;
        double fAMeanPE = 0.0;
        int iRow = 1;
        while (iRow <= iCount) {
            if (bSelected[iRow] && !bInvert || !bSelected[iRow] && bInvert) {
                fAMeanPE += Math.abs((double)(iPredicted[iRow] - iCorrect[iRow]) / (double)iCorrect[iRow]);
                ++iDataCount;
            }
            ++iRow;
        }
        return fAMeanPE / (double)iDataCount;
    }

    public static double meanAbsoluteDeviation(int[] iCorrect, int[] iPredicted, int iCount, boolean bChangeSignOfOneArray) {
        double fAMeanPE = 0.0;
        if (bChangeSignOfOneArray) {
            int iRow = 1;
            while (iRow <= iCount) {
                fAMeanPE += (double)Math.abs(iPredicted[iRow] + iCorrect[iRow]);
                ++iRow;
            }
        } else {
            int iRow = 1;
            while (iRow <= iCount) {
                fAMeanPE += (double)Math.abs(iPredicted[iRow] - iCorrect[iRow]);
                ++iRow;
            }
        }
        return fAMeanPE / (double)iCount;
    }

    public static double meanDeviation(int[] iCorrect, int[] iPredicted, int iCount, boolean bChangeSignOfOneArray) {
        double fAMeanPE = 0.0;
        if (bChangeSignOfOneArray) {
            int iRow = 1;
            while (iRow <= iCount) {
                fAMeanPE += (double)(iPredicted[iRow] + iCorrect[iRow]);
                ++iRow;
            }
        } else {
            int iRow = 1;
            while (iRow <= iCount) {
                fAMeanPE += (double)(iPredicted[iRow] - iCorrect[iRow]);
                ++iRow;
            }
        }
        return fAMeanPE / (double)iCount;
    }

    public static double baselineAccuracyMajorityClassProportion(int[] iCorrect, int iCount) {
        if (iCount == 0) {
            return 0.0;
        }
        int[] iClassCount = new int[100];
        int iMinClass = iCorrect[1];
        int iMaxClass = iCorrect[1];
        int i = 2;
        while (i <= iCount) {
            if (iCorrect[i] < iMinClass) {
                iMinClass = iCorrect[i];
            }
            if (iCorrect[i] > iMaxClass) {
                iMaxClass = iCorrect[i];
            }
            ++i;
        }
        if (iMaxClass - iMinClass >= 100) {
            return 0.0;
        }
        i = 0;
        while (i <= iMaxClass - iMinClass) {
            iClassCount[i] = 0;
            ++i;
        }
        i = 1;
        while (i <= iCount) {
            int n = iCorrect[i] - iMinClass;
            iClassCount[n] = iClassCount[n] + 1;
            ++i;
        }
        int iMaxClassCount = 0;
        int i2 = 0;
        while (i2 <= iMaxClass - iMinClass) {
            if (iClassCount[i2] > iMaxClassCount) {
                iMaxClassCount = iClassCount[i2];
            }
            ++i2;
        }
        return (double)iMaxClassCount / (double)iCount;
    }

    public static void baselineAccuracyMakeLargestClassPrediction(int[] iCorrect, int[] iPredict, int iCount, boolean bChangeSign) {
        if (iCount == 0) {
            return;
        }
        int[] iClassCount = new int[100];
        int iMinClass = iCorrect[1];
        int iMaxClass = iCorrect[1];
        int i = 2;
        while (i <= iCount) {
            if (iCorrect[i] < iMinClass) {
                iMinClass = iCorrect[i];
            }
            if (iCorrect[i] > iMaxClass) {
                iMaxClass = iCorrect[i];
            }
            ++i;
        }
        if (iMaxClass - iMinClass >= 100) {
            return;
        }
        i = 0;
        while (i <= iMaxClass - iMinClass) {
            iClassCount[i] = 0;
            ++i;
        }
        i = 1;
        while (i <= iCount) {
            int n = iCorrect[i] - iMinClass;
            iClassCount[n] = iClassCount[n] + 1;
            ++i;
        }
        int iMaxClassCount = 0;
        int iLargestClass = 0;
        int i2 = 0;
        while (i2 <= iMaxClass - iMinClass) {
            if (iClassCount[i2] > iMaxClassCount) {
                iMaxClassCount = iClassCount[i2];
                iLargestClass = i2 + iMinClass;
            }
            ++i2;
        }
        if (bChangeSign) {
            i2 = 1;
            while (i2 <= iCount) {
                iPredict[i2] = -iLargestClass;
                ++i2;
            }
        } else {
            i2 = 1;
            while (i2 <= iCount) {
                iPredict[i2] = iLargestClass;
                ++i2;
            }
        }
    }

    public static double absoluteMeanPercentageError(int[] iCorrect, int[] iPredicted, int iCount, boolean bChangeSignOfOneArray) {
        double fAMeanPE = 0.0;
        if (bChangeSignOfOneArray) {
            int iRow = 1;
            while (iRow <= iCount) {
                fAMeanPE += Math.abs((double)(iPredicted[iRow] + iCorrect[iRow]) / (double)iCorrect[iRow]);
                ++iRow;
            }
        } else {
            int iRow = 1;
            while (iRow <= iCount) {
                fAMeanPE += Math.abs((double)(iPredicted[iRow] - iCorrect[iRow]) / (double)iCorrect[iRow]);
                ++iRow;
            }
        }
        return fAMeanPE / (double)iCount;
    }
}

