/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.File;
import uk.ac.wlv.sentistrength.BoosterWordsList;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.sentistrength.CorrectSpellingsList;
import uk.ac.wlv.sentistrength.EmoticonsList;
import uk.ac.wlv.sentistrength.EvaluativeTerms;
import uk.ac.wlv.sentistrength.IdiomList;
import uk.ac.wlv.sentistrength.IronyList;
import uk.ac.wlv.sentistrength.Lemmatiser;
import uk.ac.wlv.sentistrength.NegatingWordList;
import uk.ac.wlv.sentistrength.QuestionWords;
import uk.ac.wlv.sentistrength.SentimentWords;
import uk.ac.wlv.utilities.FileOps;

public class ClassificationResources {
    public EmoticonsList emoticons = new EmoticonsList();
    public CorrectSpellingsList correctSpellings = new CorrectSpellingsList();
    public SentimentWords sentimentWords = new SentimentWords();
    public NegatingWordList negatingWords = new NegatingWordList();
    public QuestionWords questionWords = new QuestionWords();
    public BoosterWordsList boosterWords = new BoosterWordsList();
    public IdiomList idiomList = new IdiomList();
    public EvaluativeTerms evaluativeTerms = new EvaluativeTerms();
    public IronyList ironyList = new IronyList();
    public Lemmatiser lemmatiser = new Lemmatiser();
    public String sgSentiStrengthFolder = "C:\\SentStrength_Data\\";
    public String sgSentimentWordsFile = "EmotionLookupTable.txt";
    public String sgSentimentWordsFile2 = "SentimentLookupTable.txt";
    public String sgSentimentWordsFileNameAndPath = "";
    public String sgEmoticonLookupTable = "EmoticonLookupTable.txt";
    public String sgCorrectSpellingFileName = "Dictionary.txt";
    public String sgCorrectSpellingFileName2 = "EnglishWordList.txt";
    public String sgSlangLookupTable = "SlangLookupTable_NOT_USED.txt";
    public String sgNegatingWordListFile = "NegatingWordList.txt";
    public String sgBoosterListFile = "BoosterWordList.txt";
    public String sgIdiomLookupTableFile = "IdiomLookupTable.txt";
    public String sgQuestionWordListFile = "QuestionWords.txt";
    public String sgIronyWordListFile = "IronyTerms.txt";
    public String sgAdditionalFile = "";
    public String sgLemmaFile = "";

    public boolean initialise(ClassificationOptions options) {
        int iExtraLinesToReserve = 0;
        if (this.sgAdditionalFile.compareTo("") != 0 && (iExtraLinesToReserve = FileOps.i_CountLinesInTextFile(String.valueOf(this.sgSentiStrengthFolder) + this.sgAdditionalFile)) < 0) {
            System.out.println("No lines found in additional file! Ignoring " + this.sgAdditionalFile);
            return false;
        }
        if (options.bgUseLemmatisation && !this.lemmatiser.initialise(String.valueOf(this.sgSentiStrengthFolder) + this.sgLemmaFile, false)) {
            System.out.println("Can't load lemma file! " + this.sgLemmaFile);
            return false;
        }
        File f = new File(this.sgSentimentWordsFile);
        this.sgSentimentWordsFileNameAndPath = f.exists() && !f.isDirectory() ? this.sgSentimentWordsFile : ((f = new File(String.valueOf(this.sgSentiStrengthFolder) + this.sgSentimentWordsFile)).exists() && !f.isDirectory() ? String.valueOf(this.sgSentiStrengthFolder) + this.sgSentimentWordsFile : String.valueOf(this.sgSentiStrengthFolder) + this.sgSentimentWordsFile2);
        File f2 = new File(String.valueOf(this.sgSentiStrengthFolder) + this.sgCorrectSpellingFileName);
        if (!f2.exists() || f2.isDirectory()) {
            this.sgCorrectSpellingFileName = this.sgCorrectSpellingFileName2;
        }
        if (this.emoticons.initialise(String.valueOf(this.sgSentiStrengthFolder) + this.sgEmoticonLookupTable, options) && this.correctSpellings.initialise(String.valueOf(this.sgSentiStrengthFolder) + this.sgCorrectSpellingFileName, options) && this.sentimentWords.initialise(this.sgSentimentWordsFileNameAndPath, options, iExtraLinesToReserve) && this.negatingWords.initialise(String.valueOf(this.sgSentiStrengthFolder) + this.sgNegatingWordListFile, options) && this.questionWords.initialise(String.valueOf(this.sgSentiStrengthFolder) + this.sgQuestionWordListFile, options) && this.ironyList.initialise(String.valueOf(this.sgSentiStrengthFolder) + this.sgIronyWordListFile, options) && this.boosterWords.initialise(String.valueOf(this.sgSentiStrengthFolder) + this.sgBoosterListFile, options, iExtraLinesToReserve) && this.idiomList.initialise(String.valueOf(this.sgSentiStrengthFolder) + this.sgIdiomLookupTableFile, options, iExtraLinesToReserve)) {
            if (iExtraLinesToReserve > 0) {
                return this.evaluativeTerms.initialise(String.valueOf(this.sgSentiStrengthFolder) + this.sgAdditionalFile, options, this.idiomList, this.sentimentWords);
            }
            return true;
        }
        return false;
    }
}

