/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.wlv.sentistrength;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import uk.ac.wlv.sentistrength.ClassificationOptions;
import uk.ac.wlv.utilities.FileOps;
import uk.ac.wlv.utilities.Sort;

public class BoosterWordsList {
    private String[] sgBoosterWords;
    private int[] igBoosterWordStrength;
    private int igBoosterWordsCount = 0;

    public boolean initialise(String sFilename, ClassificationOptions options, int iExtraBlankArrayEntriesToInclude) {
        int iLinesInFile = 0;
        int iWordStrength = 0;
        if (sFilename == "") {
            System.out.println("No booster words file specified");
            return false;
        }
        File f = new File(sFilename);
        if (!f.exists()) {
            System.out.println("Could not find booster words file: " + sFilename);
            return false;
        }
        iLinesInFile = FileOps.i_CountLinesInTextFile(sFilename);
        if (iLinesInFile < 1) {
            System.out.println("No booster words specified");
            return false;
        }
        this.sgBoosterWords = new String[iLinesInFile + 1 + iExtraBlankArrayEntriesToInclude];
        this.igBoosterWordStrength = new int[iLinesInFile + 1 + iExtraBlankArrayEntriesToInclude];
        this.igBoosterWordsCount = 0;
        try {
            String sLine;
            BufferedReader rReader = options.bgForceUTF8 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sFilename), "UTF8")) : new BufferedReader(new FileReader(sFilename));
            while ((sLine = rReader.readLine()) != null) {
                int iFirstTabLocation;
                if (sLine == "" || (iFirstTabLocation = sLine.indexOf("\t")) < 0) continue;
                int iSecondTabLocation = sLine.indexOf("\t", iFirstTabLocation + 1);
                try {
                    iWordStrength = iSecondTabLocation > 0 ? Integer.parseInt(sLine.substring(iFirstTabLocation + 1, iSecondTabLocation)) : Integer.parseInt(sLine.substring(iFirstTabLocation + 1).trim());
                }
                catch (NumberFormatException e) {
                    System.out.println("Failed to identify integer weight for booster word! Assuming it is zero");
                    System.out.println("Line: " + sLine);
                    iWordStrength = 0;
                }
                sLine = sLine.substring(0, iFirstTabLocation);
                if (sLine.indexOf(" ") >= 0) {
                    sLine = sLine.trim();
                }
                if (sLine == "") continue;
                ++this.igBoosterWordsCount;
                this.sgBoosterWords[this.igBoosterWordsCount] = sLine;
                this.igBoosterWordStrength[this.igBoosterWordsCount] = iWordStrength;
            }
            Sort.quickSortStringsWithInt(this.sgBoosterWords, this.igBoosterWordStrength, 1, this.igBoosterWordsCount);
            rReader.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find booster words file: " + sFilename);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Found booster words file but could not read from it: " + sFilename);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean addExtraTerm(String sText, int iWordStrength, boolean bSortBoosterListAfterAddingTerm) {
        try {
            ++this.igBoosterWordsCount;
            this.sgBoosterWords[this.igBoosterWordsCount] = sText;
            this.igBoosterWordStrength[this.igBoosterWordsCount] = iWordStrength;
            if (bSortBoosterListAfterAddingTerm) {
                Sort.quickSortStringsWithInt(this.sgBoosterWords, this.igBoosterWordStrength, 1, this.igBoosterWordsCount);
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Could not add extra booster word: " + sText);
            e.printStackTrace();
            return false;
        }
    }

    public void sortBoosterWordList() {
        Sort.quickSortStringsWithInt(this.sgBoosterWords, this.igBoosterWordStrength, 1, this.igBoosterWordsCount);
    }

    public int getBoosterStrength(String sWord) {
        int iWordID = Sort.i_FindStringPositionInSortedArray(sWord.toLowerCase(), this.sgBoosterWords, 1, this.igBoosterWordsCount);
        if (iWordID >= 0) {
            return this.igBoosterWordStrength[iWordID];
        }
        return 0;
    }
}

