import { Duration, IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IFirewallDomainList } from './firewall-domain-list';
import { FirewallRuleGroupAssociation, FirewallRuleGroupAssociationOptions } from './firewall-rule-group-association';
/**
 * (experimental) A Firewall Rule Group.
 *
 * @experimental
 */
export interface IFirewallRuleGroup extends IResource {
    /**
     * (experimental) The ID of the rule group.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupId: string;
}
/**
 * (experimental) Properties for a Firewall Rule Group.
 *
 * @experimental
 */
export interface FirewallRuleGroupProps {
    /**
     * (experimental) The name of the rule group.
     *
     * @default - a CloudFormation generated name
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) A list of rules for this group.
     *
     * @default - no rules
     * @experimental
     */
    readonly rules?: FirewallRule[];
}
/**
 * (experimental) A Firewall Rule.
 *
 * @experimental
 */
export interface FirewallRule {
    /**
     * (experimental) The action for this rule.
     *
     * @experimental
     */
    readonly action: FirewallRuleAction;
    /**
     * (experimental) The domain list for this rule.
     *
     * @experimental
     */
    readonly firewallDomainList: IFirewallDomainList;
    /**
     * (experimental) The priority of the rule in the rule group.
     *
     * This value must be unique within
     * the rule group.
     *
     * @experimental
     */
    readonly priority: number;
}
/**
 * (experimental) A Firewall Rule.
 *
 * @experimental
 */
export declare abstract class FirewallRuleAction {
    /**
     * (experimental) Permit the request to go through.
     *
     * @experimental
     */
    static allow(): FirewallRuleAction;
    /**
     * (experimental) Permit the request to go through but send an alert to the logs.
     *
     * @experimental
     */
    static alert(): FirewallRuleAction;
    /**
     * (experimental) Disallow the request.
     *
     * @param response The way that you want DNS Firewall to block the request.
     * @experimental
     */
    static block(response?: DnsBlockResponse): FirewallRuleAction;
    /**
     * (experimental) The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list.
     *
     * @experimental
     */
    abstract readonly action: string;
    /**
     * (experimental) The way that you want DNS Firewall to block the request.
     *
     * @experimental
     */
    abstract readonly blockResponse?: DnsBlockResponse;
}
/**
 * (experimental) The way that you want DNS Firewall to block the request.
 *
 * @experimental
 */
export declare abstract class DnsBlockResponse {
    /**
     * (experimental) Respond indicating that the query was successful, but no response is available for it.
     *
     * @experimental
     */
    static noData(): DnsBlockResponse;
    /**
     * (experimental) Respond indicating that the domain name that's in the query doesn't exist.
     *
     * @experimental
     */
    static nxDomain(): DnsBlockResponse;
    /**
     * (experimental) Provides a custom override response to the query.
     *
     * @param domain The custom DNS record to send back in response to the query.
     * @param ttl The recommended amount of time for the DNS resolver or web browser to cache the provided override record.
     * @experimental
     */
    static override(domain: string, ttl?: Duration): DnsBlockResponse;
    /**
     * (experimental) The DNS record's type.
     *
     * @experimental
     */
    abstract readonly blockOverrideDnsType?: string;
    /**
     * (experimental) The custom DNS record to send back in response to the query.
     *
     * @experimental
     */
    abstract readonly blockOverrideDomain?: string;
    /**
     * (experimental) The recommended amount of time for the DNS resolver or web browser to cache the provided override record.
     *
     * @experimental
     */
    abstract readonly blockOverrideTtl?: Duration;
    /**
     * (experimental) The way that you want DNS Firewall to block the request.
     *
     * @experimental
     */
    abstract readonly blockResponse?: string;
}
/**
 * (experimental) A Firewall Rule Group.
 *
 * @experimental
 */
export declare class FirewallRuleGroup extends Resource implements IFirewallRuleGroup {
    /**
     * (experimental) Import an existing Firewall Rule Group.
     *
     * @experimental
     */
    static fromFirewallRuleGroupId(scope: Construct, id: string, firewallRuleGroupId: string): IFirewallRuleGroup;
    /**
     * (experimental) The ID of the rule group.
     *
     * @experimental
     */
    readonly firewallRuleGroupId: string;
    /**
     * (experimental) The ARN (Amazon Resource Name) of the rule group.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupArn: string;
    /**
     * (experimental) The date and time that the rule group was created.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupCreationTime: string;
    /**
     * (experimental) The creator request ID.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupCreatorRequestId: string;
    /**
     * (experimental) The date and time that the rule group was last modified.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupModificationTime: string;
    /**
     * (experimental) The AWS account ID for the account that created the rule group.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupOwnerId: string;
    /**
     * (experimental) The number of rules in the rule group.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupRuleCount: number;
    /**
     * (experimental) Whether the rule group is shared with other AWS accounts, or was shared with the current account by another AWS account.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupShareStatus: string;
    /**
     * (experimental) The status of the rule group.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupStatus: string;
    /**
     * (experimental) Additional information about the status of the rule group.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupStatusMessage: string;
    private readonly rules;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: FirewallRuleGroupProps);
    /**
     * (experimental) Adds a rule to this group.
     *
     * @experimental
     */
    addRule(rule: FirewallRule): FirewallRuleGroup;
    /**
     * (experimental) Associates this Firewall Rule Group with a VPC.
     *
     * @experimental
     */
    associate(id: string, props: FirewallRuleGroupAssociationOptions): FirewallRuleGroupAssociation;
}
