"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirewallDomainList = exports.FirewallDomains = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_s3_assets_1 = require("@aws-cdk/aws-s3-assets");
const core_1 = require("@aws-cdk/core");
const route53resolver_generated_1 = require("./route53resolver.generated");
/**
 * (experimental) A list of domains.
 *
 * @experimental
 */
class FirewallDomains {
    /**
     * (experimental) Firewall domains created from a list of domains.
     *
     * @param list the list of domains.
     * @experimental
     */
    static fromList(list) {
        for (const domain of list) {
            if (!/^([\w-.]{1,255}|\*[\w-.]{1,254})$/.test(domain)) {
                throw new Error(`Invalid domain: ${domain}. Domain can optionally start with *. Max length of 255. Valid characters: A-Z, a-z, 0-9, _, -, .`);
            }
        }
        return {
            bind(_scope) {
                return { domains: list };
            },
        };
    }
    /**
     * (experimental) Firewall domains created from the URL of a file stored in Amazon S3.
     *
     * The file must be a text file and must contain a single domain per line.
     * The content type of the S3 object must be `plain/text`.
     *
     * @param url S3 bucket url (s3://bucket/prefix/objet).
     * @experimental
     */
    static fromS3Url(url) {
        if (!core_1.Token.isUnresolved(url) && !url.startsWith('s3://')) {
            throw new Error(`The S3 URL must start with s3://, got ${url}`);
        }
        return {
            bind(_scope) {
                return { domainFileUrl: url };
            },
        };
    }
    /**
     * (experimental) Firewall domains created from a file stored in Amazon S3.
     *
     * The file must be a text file and must contain a single domain per line.
     * The content type of the S3 object must be `plain/text`.
     *
     * @param bucket S3 bucket.
     * @param key S3 key.
     * @experimental
     */
    static fromS3(bucket, key) {
        return this.fromS3Url(bucket.s3UrlForObject(key));
    }
    /**
     * (experimental) Firewall domains created from a local disk path to a text file.
     *
     * The file must be a text file (`.txt` extension) and must contain a single
     * domain per line. It will be uploaded to S3.
     *
     * @param assetPath path to the text file.
     * @experimental
     */
    static fromAsset(assetPath) {
        // cdk-assets will correctly set the content type for the S3 object
        // if the file has the correct extension
        if (path.extname(assetPath) !== '.txt') {
            throw new Error(`FirewallDomains.fromAsset() expects a file with the .txt extension, got ${assetPath}`);
        }
        return {
            bind(scope) {
                const asset = new aws_s3_assets_1.Asset(scope, 'Domains', { path: assetPath });
                if (!asset.isFile) {
                    throw new Error('FirewallDomains.fromAsset() expects a file');
                }
                return { domainFileUrl: asset.s3ObjectUrl };
            },
        };
    }
}
exports.FirewallDomains = FirewallDomains;
_a = JSII_RTTI_SYMBOL_1;
FirewallDomains[_a] = { fqn: "@aws-cdk/aws-route53resolver.FirewallDomains", version: "1.129.0" };
/**
 * (experimental) A Firewall Domain List.
 *
 * @experimental
 */
class FirewallDomainList extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.name && !core_1.Token.isUnresolved(props.name) && !/^[\w-.]{1,128}$/.test(props.name)) {
            throw new Error(`Invalid domain list name: ${props.name}. The name must have 1-128 characters. Valid characters: A-Z, a-z, 0-9, _, -, .`);
        }
        const domainsConfig = props.domains.bind(this);
        const domainList = new route53resolver_generated_1.CfnFirewallDomainList(this, 'Resource', {
            name: props.name,
            domainFileUrl: domainsConfig.domainFileUrl,
            domains: domainsConfig.domains,
        });
        this.firewallDomainListId = domainList.attrId;
        this.firewallDomainListArn = domainList.attrArn;
        this.firewallDomainListCreationTime = domainList.attrCreationTime;
        this.firewallDomainListCreatorRequestId = domainList.attrCreatorRequestId;
        this.firewallDomainListDomainCount = domainList.attrDomainCount;
        this.firewallDomainListManagedOwnerName = domainList.attrManagedOwnerName;
        this.firewallDomainListModificationTime = domainList.attrModificationTime;
        this.firewallDomainListStatus = domainList.attrStatus;
        this.firewallDomainListStatusMessage = domainList.attrStatusMessage;
    }
    /**
     * (experimental) Import an existing Firewall Rule Group.
     *
     * @experimental
     */
    static fromFirewallDomainListId(scope, id, firewallDomainListId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.firewallDomainListId = firewallDomainListId;
            }
        }
        return new Import(scope, id);
    }
}
exports.FirewallDomainList = FirewallDomainList;
_b = JSII_RTTI_SYMBOL_1;
FirewallDomainList[_b] = { fqn: "@aws-cdk/aws-route53resolver.FirewallDomainList", version: "1.129.0" };
//# sourceMappingURL=data:application/json;base64,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