@structure @structure.release_flow @relates_to.strategy.subcommands
Feature: Release flow command
  As a user I want the utility to apply release tags from source control such as git
  to the artifacts generated by pipelines so that artifact packages are uniquely
  identified for any build.

  The package version of release builds must be clearly differentiated from feature
  branch builds.

  A "dryrun" pipeline/package identification is needed in order to be able to run a
  release pipeline without actually releasing artifacts, or if that fails, clearly
  marking in some way that the artifact is not a valid release artifact.

  [PEP-440](https://www.python.org/dev/peps/pep-0440/) intrinsically constrains what is
  possible for identifying non-release artifacts. A popular convention that is
  readily available from the `git describe` command output is "commit count since last
  release tag" using the PEP-440 post-release identifier for the commit count and
  using the *post identifier* to embed the commit count into the package version.

  Since the PEP-440 local identifier is by definition not publishable and public
  repositories such as PyPI deny any attempt to upload an artifact using a local
  identifier, this makes the local identifier suitable for the pipeline constructing
  "dryrun" artifacts that are intended to exercise the release pipeline without
  actually publishing the "release ready" artifacts.

  eg.
    - a version of a tagged release could look like `1!2.3a4.dev6`.
    - a version of a dryrun of the above release takes the form `1!2.3a4.dev6+dryrun`.
    - if the most recent release tag was the release tag above, then a feature branch
      version would take the form `1!2.3a4.dev6.post8`, where ".post8" indicates that
      the feature commit is 8 commits after the release tag.

  NOTE: The terminology established by PEP-440 and official packages such as
        [`packaging`](https://packaging.pypa.io/en/latest/index.html) is used here to
        try and maintain consistency with established conventions:
        - *version* is the total PEP-440 compliant version text used to identify a
          package.
        - *release* or *release identifier* is the `<N>.<N>.<N>` part of a PEP-440
          version. This is often a [Semantic Version](https://semver.org). It may be
          expressed as a regular expression thus: `(?P<release_id>(\d+\.)*(\d+))`.
        - *post identifier* is the `.post<N>` portion of a PEP-440 version. It may be
          expressed as a regular expression thus: `(\.post(?P<post_id>\d*))`.
        - *local identifier* is the `+<alphanumerics>` suffix portion of a PEP-440
          version. It may be expressed as a regular expression thus:
          `(\+(?P<local_id>[0-9a-zA-Z]+))`.
  NOTE: The tag in source source control must be PEP-440 compliant.
  NOTE: This feature package version construction implies that the post-identifier
        cannot be used in a tag; in fact it can, but will be over-written by the feature
        package version construction.
  NOTE: Using a public repository such as PyPI both release and feature branch
        packages will be uploaded. Only local identifier packages (dryrun packages
        described here) will not be uploaded.
  NOTE: A feature branch containing dryrun tags in commit history requires special
        handling. A dryrun tag is normally future facing; that is, the dryrun tag and
        subsequent package version reflects the release that is about to be
        forthcoming. Whereas normal feature branch tags are past facing; that is,
        they look into commit history for the most recent tag and use that to
        construct the commit history offset from that tag. The solution to this is to
        ensure that:
          (1) dryrun tags are only applied to feature branches, and
          (2) the tag search is constrained to only search the default branch of the
              repo (often called `master`). This is the `--first-parent` option of
              the `git describe` command.

  @structure.release_flow.s1
  Scenario: missing git installed
    Given an environment without git installed
    When release flow extracts the tag data
    Then the utility exits dirty
    And emits an install git error message to stderr

  @structure.release_flow.s2
  Scenario: invalid git repo
    Given a working directory that is not a valid git repo
    When release flow runs in a working directory that is not a valid git repo
    Then the utility exits dirty
    And emits an invalid git repo error message to stderr

  @structure.release_flow.s3
  Scenario: non-PEP-440 tag on a build commit triggering a pipeline
    Given a PEP-440 noncompliant tag is latest tag
    When release flow extracts the tag data
    Then the utility exits dirty
    And emits a bad tag error to stderr

  @structure.release_flow.s4
  Scenario: PEP-440 release tag on a build commit triggering a pipeline
    Given a PEP-440 compliant tag on default branch
    When release flow extracts the tag data
    Then the utility emits the constructed package version to stdout

  @structure.release_flow.s5
  Scenario: latest release tag excludes post identifier on feature branch build commit
    Given a PEP-440 compliant tag on default branch
    And the tag excludes a post identifier
    And HEAD commit on a feature branch
    When release flow extracts the tag data
    Then the utility emits the constructed package version to stdout

  @structure.release_flow.s6
  Scenario: latest release tag includes post identifier on feature branch build commit
    Given a PEP-440 compliant tag on default branch
    And the tag includes a post identifier
    And HEAD commit on a feature branch
    When release flow extracts the tag data
    Then the utility emits the constructed package version to stdout

  @structure.release_flow.s7
  Scenario: only tag on default branch is dryrun results in offset from root commit
    Given a dryrun tag on default branch
    When release flow extracts the tag data
    Then the utility emits the constructed package version to stdout

  @structure.release_flow.s8
  Scenario: release dryrun tag on a build commit triggering a pipeline
    Given a PEP-440 compliant release tag on default branch
    And dryrun tag in feature commit history on HEAD commit
    When release flow extracts the tag data
    Then the utility emits the constructed package version to stdout

  @structure.release_flow.s9
  Scenario: feature branch containing dryrun tags in commit history
    Given a PEP-440 compliant release tag on default branch
    And dryrun tags in feature commit history prior to HEAD commit
    When release flow extracts the tag data
    Then the utility emits the constructed package version to stdout
