"""
************************************************************
meta.py - implementation detail meta information
************************************************************

Project: HALCON/Python

Description:
Information that gets generated by the build system.
Separate file to avoid slow iteration test cycle on changes to 'main' sources.

************************************************************

(c) 1996-2020 by MVTec Software GmbH

Software by: MVTec Software GmbH, www.mvtec.com
"""

__all__ = [
    'halcon_native_lib_names',
    'hdevengine_native_lib_names',
]

halcon_native_lib_names = {
    'linux': 'libhalcon.so.20.11.0',
    'darwin': 'HALCON.framework/Versions/20.11P/HALCON',
    'win': 'halcon.dll',
}

hdevengine_native_lib_names = {
    'linux': 'libhdevenginecpp.so.20.11.0',
    'darwin': 'HDevEngineCpp.framework/Versions/'
    '20.11P/HDevEngineCpp',
    'win': 'hdevenginecpp.dll',
}
