#
# Copyright The NOMAD Authors.
#
# This file is part of NOMAD.
# See https://nomad-lab.eu for further info.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import numpy as np            # pylint: disable=unused-import
import typing                 # pylint: disable=unused-import
from nomad.metainfo import (  # pylint: disable=unused-import
    MSection, MCategory, Category, Package, Quantity, Section, SubSection, SectionProxy,
    Reference, JSON
)

from electronicparsers.siesta.metainfo import siesta_autogenerated
from nomad.datamodel.metainfo import simulation


m_package = Package()


class Run(simulation.run.Run):

    m_def = Section(validate=False, extends_base_section=True)

    x_siesta_system_label = Quantity(
        type=str,
        shape=[],
        description='''
        system label specified in siesta calculation.  This determines many of the
        filenames.
        ''')

    x_siesta_system_name = Quantity(
        type=str,
        shape=[],
        description='''
        system name specified in siesta calculation.  This is purely a description.
        ''')

    x_siesta_arch = Quantity(
        type=str,
        shape=[],
        description='''
        architecture
        ''')

    x_siesta_compiler_flags = Quantity(
        type=str,
        shape=[],
        description='''
        ''')

    x_siesta_parallel = Quantity(
        type=bool,
        shape=[],
        description='''
        ''')

    x_siesta_n_nodes = Quantity(
        type=np.dtype(np.int32),
        shape=[],
        description='''
        ''')


class x_siesta_section_input(siesta_autogenerated.x_siesta_section_input):

    m_def = Section(validate=False, extends_base_section=True)

    x_siesta_xc_authors = Quantity(
        type=str,
        shape=[],
        description='''
        XC authors (really: XC functional) in siesta calculation.
        ''')

    x_siesta_typeofrun = Quantity(
        type=str,
        shape=[],
        description='''
        type of run as categorized by Siesta (optimization/md etc.)
        ''')


class BasisSet(simulation.method.BasisSet):

    m_def = Section(validate=False, extends_base_section=True)

    x_siesta_pao_basis_type = Quantity(
        type=str,
        shape=[],
        description='''
        basis set type
        ''')


class Method(simulation.method.Method):

    m_def = Section(validate=False, extends_base_section=True)

    x_siesta_input_parameters = Quantity(
        type=JSON,
        shape=[],
        description='''
        ''')

    x_siesta_simulation_parameters = Quantity(
        type=JSON,
        shape=[],
        description='''
        ''')
