# This an autogenerated file
# 
# Generated with HorizontalAxisWindTurbineController
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.horizontalaxiswindturbinecontroller import HorizontalAxisWindTurbineControllerBlueprint
from typing import Dict
from sima.sima.librarypaths import LibraryPaths
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.windturbine.controllertype import ControllerType
from sima.windturbine.gainitem import GainItem
from sima.windturbine.powerextraction import PowerExtraction
from sima.windturbine.tableformat import TableFormat

class HorizontalAxisWindTurbineController(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    kp : float
         Proportionnal gain K that will be used for zero blade pitch angle(default 0.0)
    ki : float
         Integral gain(default 0.0)
    filterPeriod : float
         Filter period for 1st order LP filter(default 0.0)
    ratedOmega : float
         Rated electrical omega(default 0.0)
    ratedTorque : float
         Rated electrical torque(default 0.0)
    gearBoxRatio : float
         Gear box ratio(default 0.0)
    maxPitchRate : float
         Maximum pitch rate(default 0.0)
    maxPitch : float
         Maximum pitch(default 0.0)
    maxTorqueRate : float
         Maximum torque rate(default 0.0)
    maxTorque : float
         Maximum torque(default 0.0)
    gainScheduling : TableFormat
    gainItems : List[GainItem]
    external : bool
         Use external controller(default False)
    controllerFile : str
         Path to controller file(default "")
    className : str
         Class name of controller(default "")
    configuration : str
         Configuration filename(default "")
    libraryPaths : LibraryPaths
    reg3MinPitch : float
         Minimum pitch angle for which electrical torque versus generator speed will stay in region 3(default 0.0)
    transitionalSpeed15 : float
         Transitional generator speed between region 1 and 1.5(default 0.0)
    transitionalSpeed20 : float
         Transitional generator speed between region 1.5 and 2(default 0.0)
    transitionalSpeed25 : float
         Transitional generator speed between region 2 and 2.5(default 0.0)
    transitionalSpeed30 : float
         Transitional generator speed between region 2.5 and 3(default 0.0)
    reg2Torque : float
         Generator torque constant in region 2(default 0.0)
    powerExtraction : PowerExtraction
    minPitch : float
         Minimum pitch setting in pitch controller(default 0.0)
    sampleInterval : float
         Controller sample interval(default 0.0)
    controllerType : ControllerType
    """

    def __init__(self , name="", description="", _id="", kp=0.0, ki=0.0, filterPeriod=0.0, ratedOmega=0.0, ratedTorque=0.0, gearBoxRatio=0.0, maxPitchRate=0.0, maxPitch=0.0, maxTorqueRate=0.0, maxTorque=0.0, gainScheduling=TableFormat.DEFAULT, external=False, controllerFile="", className="", configuration="", reg3MinPitch=0.0, transitionalSpeed15=0.0, transitionalSpeed20=0.0, transitionalSpeed25=0.0, transitionalSpeed30=0.0, reg2Torque=0.0, powerExtraction=PowerExtraction.POWER, minPitch=0.0, sampleInterval=0.0, controllerType=ControllerType.JAR_FILE_CONTROLLER, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.kp = kp
        self.ki = ki
        self.filterPeriod = filterPeriod
        self.ratedOmega = ratedOmega
        self.ratedTorque = ratedTorque
        self.gearBoxRatio = gearBoxRatio
        self.maxPitchRate = maxPitchRate
        self.maxPitch = maxPitch
        self.maxTorqueRate = maxTorqueRate
        self.maxTorque = maxTorque
        self.gainScheduling = gainScheduling
        self.gainItems = list()
        self.external = external
        self.controllerFile = controllerFile
        self.className = className
        self.configuration = configuration
        self.libraryPaths = None
        self.reg3MinPitch = reg3MinPitch
        self.transitionalSpeed15 = transitionalSpeed15
        self.transitionalSpeed20 = transitionalSpeed20
        self.transitionalSpeed25 = transitionalSpeed25
        self.transitionalSpeed30 = transitionalSpeed30
        self.reg2Torque = reg2Torque
        self.powerExtraction = powerExtraction
        self.minPitch = minPitch
        self.sampleInterval = sampleInterval
        self.controllerType = controllerType
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return HorizontalAxisWindTurbineControllerBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def kp(self) -> float:
        """Proportionnal gain K that will be used for zero blade pitch angle"""
        return self.__kp

    @kp.setter
    def kp(self, value: float):
        """Set kp"""
        self.__kp = float(value)

    @property
    def ki(self) -> float:
        """Integral gain"""
        return self.__ki

    @ki.setter
    def ki(self, value: float):
        """Set ki"""
        self.__ki = float(value)

    @property
    def filterPeriod(self) -> float:
        """Filter period for 1st order LP filter"""
        return self.__filterPeriod

    @filterPeriod.setter
    def filterPeriod(self, value: float):
        """Set filterPeriod"""
        self.__filterPeriod = float(value)

    @property
    def ratedOmega(self) -> float:
        """Rated electrical omega"""
        return self.__ratedOmega

    @ratedOmega.setter
    def ratedOmega(self, value: float):
        """Set ratedOmega"""
        self.__ratedOmega = float(value)

    @property
    def ratedTorque(self) -> float:
        """Rated electrical torque"""
        return self.__ratedTorque

    @ratedTorque.setter
    def ratedTorque(self, value: float):
        """Set ratedTorque"""
        self.__ratedTorque = float(value)

    @property
    def gearBoxRatio(self) -> float:
        """Gear box ratio"""
        return self.__gearBoxRatio

    @gearBoxRatio.setter
    def gearBoxRatio(self, value: float):
        """Set gearBoxRatio"""
        self.__gearBoxRatio = float(value)

    @property
    def maxPitchRate(self) -> float:
        """Maximum pitch rate"""
        return self.__maxPitchRate

    @maxPitchRate.setter
    def maxPitchRate(self, value: float):
        """Set maxPitchRate"""
        self.__maxPitchRate = float(value)

    @property
    def maxPitch(self) -> float:
        """Maximum pitch"""
        return self.__maxPitch

    @maxPitch.setter
    def maxPitch(self, value: float):
        """Set maxPitch"""
        self.__maxPitch = float(value)

    @property
    def maxTorqueRate(self) -> float:
        """Maximum torque rate"""
        return self.__maxTorqueRate

    @maxTorqueRate.setter
    def maxTorqueRate(self, value: float):
        """Set maxTorqueRate"""
        self.__maxTorqueRate = float(value)

    @property
    def maxTorque(self) -> float:
        """Maximum torque"""
        return self.__maxTorque

    @maxTorque.setter
    def maxTorque(self, value: float):
        """Set maxTorque"""
        self.__maxTorque = float(value)

    @property
    def gainScheduling(self) -> TableFormat:
        """"""
        return self.__gainScheduling

    @gainScheduling.setter
    def gainScheduling(self, value: TableFormat):
        """Set gainScheduling"""
        self.__gainScheduling = value

    @property
    def gainItems(self) -> List[GainItem]:
        """"""
        return self.__gainItems

    @gainItems.setter
    def gainItems(self, value: List[GainItem]):
        """Set gainItems"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__gainItems = value

    @property
    def external(self) -> bool:
        """Use external controller"""
        return self.__external

    @external.setter
    def external(self, value: bool):
        """Set external"""
        self.__external = bool(value)

    @property
    def controllerFile(self) -> str:
        """Path to controller file"""
        return self.__controllerFile

    @controllerFile.setter
    def controllerFile(self, value: str):
        """Set controllerFile"""
        self.__controllerFile = str(value)

    @property
    def className(self) -> str:
        """Class name of controller"""
        return self.__className

    @className.setter
    def className(self, value: str):
        """Set className"""
        self.__className = str(value)

    @property
    def configuration(self) -> str:
        """Configuration filename"""
        return self.__configuration

    @configuration.setter
    def configuration(self, value: str):
        """Set configuration"""
        self.__configuration = str(value)

    @property
    def libraryPaths(self) -> LibraryPaths:
        """"""
        return self.__libraryPaths

    @libraryPaths.setter
    def libraryPaths(self, value: LibraryPaths):
        """Set libraryPaths"""
        self.__libraryPaths = value

    @property
    def reg3MinPitch(self) -> float:
        """Minimum pitch angle for which electrical torque versus generator speed will stay in region 3"""
        return self.__reg3MinPitch

    @reg3MinPitch.setter
    def reg3MinPitch(self, value: float):
        """Set reg3MinPitch"""
        self.__reg3MinPitch = float(value)

    @property
    def transitionalSpeed15(self) -> float:
        """Transitional generator speed between region 1 and 1.5"""
        return self.__transitionalSpeed15

    @transitionalSpeed15.setter
    def transitionalSpeed15(self, value: float):
        """Set transitionalSpeed15"""
        self.__transitionalSpeed15 = float(value)

    @property
    def transitionalSpeed20(self) -> float:
        """Transitional generator speed between region 1.5 and 2"""
        return self.__transitionalSpeed20

    @transitionalSpeed20.setter
    def transitionalSpeed20(self, value: float):
        """Set transitionalSpeed20"""
        self.__transitionalSpeed20 = float(value)

    @property
    def transitionalSpeed25(self) -> float:
        """Transitional generator speed between region 2 and 2.5"""
        return self.__transitionalSpeed25

    @transitionalSpeed25.setter
    def transitionalSpeed25(self, value: float):
        """Set transitionalSpeed25"""
        self.__transitionalSpeed25 = float(value)

    @property
    def transitionalSpeed30(self) -> float:
        """Transitional generator speed between region 2.5 and 3"""
        return self.__transitionalSpeed30

    @transitionalSpeed30.setter
    def transitionalSpeed30(self, value: float):
        """Set transitionalSpeed30"""
        self.__transitionalSpeed30 = float(value)

    @property
    def reg2Torque(self) -> float:
        """Generator torque constant in region 2"""
        return self.__reg2Torque

    @reg2Torque.setter
    def reg2Torque(self, value: float):
        """Set reg2Torque"""
        self.__reg2Torque = float(value)

    @property
    def powerExtraction(self) -> PowerExtraction:
        """"""
        return self.__powerExtraction

    @powerExtraction.setter
    def powerExtraction(self, value: PowerExtraction):
        """Set powerExtraction"""
        self.__powerExtraction = value

    @property
    def minPitch(self) -> float:
        """Minimum pitch setting in pitch controller"""
        return self.__minPitch

    @minPitch.setter
    def minPitch(self, value: float):
        """Set minPitch"""
        self.__minPitch = float(value)

    @property
    def sampleInterval(self) -> float:
        """Controller sample interval"""
        return self.__sampleInterval

    @sampleInterval.setter
    def sampleInterval(self, value: float):
        """Set sampleInterval"""
        self.__sampleInterval = float(value)

    @property
    def controllerType(self) -> ControllerType:
        """"""
        return self.__controllerType

    @controllerType.setter
    def controllerType(self, value: ControllerType):
        """Set controllerType"""
        self.__controllerType = value
