# This an autogenerated file
# 
# Generated with WamitWaveDriftForce
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.wamitwavedriftforce import WamitWaveDriftForceBlueprint
from numpy import ndarray,asarray
from sima.hydro.directiondependentvalues import DirectionDependentValues
from sima.hydro.directionsymmetry import DirectionSymmetry
from sima.hydro.wavedriftforce import WaveDriftForce
from sima.sima.scriptablevalue import ScriptableValue

class WamitWaveDriftForce(WaveDriftForce):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    directions : ndarray
    frequencies : ndarray
    symmetry : DirectionSymmetry
    fx : DirectionDependentValues
    fy : DirectionDependentValues
    fz : DirectionDependentValues
    mx : DirectionDependentValues
    my : DirectionDependentValues
    mz : DirectionDependentValues
    """

    def __init__(self , name="", description="", _id="", symmetry=DirectionSymmetry.NO_SYMMETRY, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.directions = ndarray(1)
        self.frequencies = ndarray(1)
        self.symmetry = symmetry
        self.fx = None
        self.fy = None
        self.fz = None
        self.mx = None
        self.my = None
        self.mz = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WamitWaveDriftForceBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def directions(self) -> ndarray:
        """"""
        return self.__directions

    @directions.setter
    def directions(self, value: ndarray):
        """Set directions"""
        self.__directions = asarray(value)

    @property
    def frequencies(self) -> ndarray:
        """"""
        return self.__frequencies

    @frequencies.setter
    def frequencies(self, value: ndarray):
        """Set frequencies"""
        self.__frequencies = asarray(value)

    @property
    def symmetry(self) -> DirectionSymmetry:
        """"""
        return self.__symmetry

    @symmetry.setter
    def symmetry(self, value: DirectionSymmetry):
        """Set symmetry"""
        self.__symmetry = value

    @property
    def fx(self) -> DirectionDependentValues:
        """"""
        return self.__fx

    @fx.setter
    def fx(self, value: DirectionDependentValues):
        """Set fx"""
        self.__fx = value

    @property
    def fy(self) -> DirectionDependentValues:
        """"""
        return self.__fy

    @fy.setter
    def fy(self, value: DirectionDependentValues):
        """Set fy"""
        self.__fy = value

    @property
    def fz(self) -> DirectionDependentValues:
        """"""
        return self.__fz

    @fz.setter
    def fz(self, value: DirectionDependentValues):
        """Set fz"""
        self.__fz = value

    @property
    def mx(self) -> DirectionDependentValues:
        """"""
        return self.__mx

    @mx.setter
    def mx(self, value: DirectionDependentValues):
        """Set mx"""
        self.__mx = value

    @property
    def my(self) -> DirectionDependentValues:
        """"""
        return self.__my

    @my.setter
    def my(self, value: DirectionDependentValues):
        """Set my"""
        self.__my = value

    @property
    def mz(self) -> DirectionDependentValues:
        """"""
        return self.__mz

    @mz.setter
    def mz(self, value: DirectionDependentValues):
        """Set mz"""
        self.__mz = value
