# This an autogenerated file
# 
# Generated with AerodynamicDescription
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.aerodynamicdescription import AerodynamicDescriptionBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.aerodynamicdescriptiontype import AerodynamicDescriptionType

class AerodynamicDescription(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    quadraticLongitudinalDrag : float
         Quadratic longitudinal drag coefficient(default 0.0)
    quadraticTransverseY : float
         Quadratic transverse (Y) drag coefficient(default 0.0)
    quadraticTransverseZ : float
         Quadratic transverse (Z) drag coefficient(default 0.0)
    aerodynamicType : AerodynamicDescriptionType
         Type of aerodynamic forces
    """

    def __init__(self , name="", description="", _id="", quadraticLongitudinalDrag=0.0, quadraticTransverseY=0.0, quadraticTransverseZ=0.0, aerodynamicType=AerodynamicDescriptionType.DRAG, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.quadraticLongitudinalDrag = quadraticLongitudinalDrag
        self.quadraticTransverseY = quadraticTransverseY
        self.quadraticTransverseZ = quadraticTransverseZ
        self.aerodynamicType = aerodynamicType
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return AerodynamicDescriptionBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def quadraticLongitudinalDrag(self) -> float:
        """Quadratic longitudinal drag coefficient"""
        return self.__quadraticLongitudinalDrag

    @quadraticLongitudinalDrag.setter
    def quadraticLongitudinalDrag(self, value: float):
        """Set quadraticLongitudinalDrag"""
        self.__quadraticLongitudinalDrag = float(value)

    @property
    def quadraticTransverseY(self) -> float:
        """Quadratic transverse (Y) drag coefficient"""
        return self.__quadraticTransverseY

    @quadraticTransverseY.setter
    def quadraticTransverseY(self, value: float):
        """Set quadraticTransverseY"""
        self.__quadraticTransverseY = float(value)

    @property
    def quadraticTransverseZ(self) -> float:
        """Quadratic transverse (Z) drag coefficient"""
        return self.__quadraticTransverseZ

    @quadraticTransverseZ.setter
    def quadraticTransverseZ(self, value: float):
        """Set quadraticTransverseZ"""
        self.__quadraticTransverseZ = float(value)

    @property
    def aerodynamicType(self) -> AerodynamicDescriptionType:
        """Type of aerodynamic forces"""
        return self.__aerodynamicType

    @aerodynamicType.setter
    def aerodynamicType(self, value: AerodynamicDescriptionType):
        """Set aerodynamicType"""
        self.__aerodynamicType = value
